from header_common import *
from header_presentations import *
from header_mission_templates import *
from ID_meshes import *
from header_operations import *
from header_triggers import *
from module_constants import *
from header_terrain_types import *
import string

## CC
from header_skills import *
from header_items import *
from module_items import *
from module_my_mod_set import *
## CC
##diplomacy start+ Import for use with terrain advantage
from header_terrain_types import *
##diplomacy end+

####################################################################################################################
#  Each presentation record contains the following fields:
#  1) Presentation id: used for referencing presentations in other files. The prefix prsnt_ is automatically added before each presentation id.
#  2) Presentation flags. See header_presentations.py for a list of available flags
#  3) Presentation background mesh: See module_meshes.py for a list of available background meshes
#  4) Triggers: Simple triggers that are associated with the presentation
####################################################################################################################

mod_version = 1153

presentations = [
  ("game_start",prsntf_read_only,0,[
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        (store_div, reg1, mod_version, 1000),
        (store_mod, reg2, mod_version, 1000),
        (try_begin),
          (eq, reg2, 0),
          (str_store_string, s1, "@{reg1}.0"),
        (else_try),
          (lt, reg2, 10),
          (str_store_string, s1, "@{reg1}.00{reg2}"),
        (else_try),
          (lt, reg2, 100),
          (try_begin),
            (store_mod, ":result", reg2, 10),
            (eq,  ":result", 0),
            (val_div, reg2, 10),
          (try_end),
          (str_store_string, s1, "@{reg1}.0{reg2}"),
        (else_try),
          (try_begin),
            (store_mod, ":result", reg2, 100),
            (eq,  ":result", 0),
            (val_div, reg2, 100),
          (else_try),
            (store_mod, ":result", reg2, 10),
            (eq,  ":result", 0),
            (val_div, reg2, 10),
          (try_end),  
          (str_store_string, s1, "@{reg1}.{reg2}"),
        (try_end),
        
      (create_mesh_overlay, reg0, "mesh_main_menu_dust"),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, 0),
      (overlay_set_position, reg0, pos1),
      (create_mesh_overlay, reg0, "mesh_main_menu_static"),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, 0),
      (overlay_set_position, reg0, pos1),
      (create_mesh_overlay, reg0, "mesh_main_menu_prs"),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, 0),
      (overlay_set_position, reg0, pos1),
      (create_mesh_overlay, reg0, "mesh_main_menu_move_1"),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, 0),
      (overlay_set_position, reg0, pos1),
      (assign, ":var0", 1400),
      (assign, ":var1", 145),
      (assign, ":var2", 452),
      (assign, ":var3", -40),
      (create_text_overlay, "$g_presentation_credits_obj_1", "str_mod_ui_new_game", tf_center_justify|tf_double_space|tf_vertical_align_center),
      (position_set_x, pos1, ":var0"),
      (position_set_y, pos1, ":var0"),
      (overlay_set_size, "$g_presentation_credits_obj_1", pos1),
      (position_set_x, pos1, ":var1"),
      (position_set_y, pos1, ":var2"),
      (overlay_set_position, "$g_presentation_credits_obj_1", pos1),
      (val_add, ":var2", ":var3"),
      (create_text_overlay, "$g_presentation_credits_obj_2", "str_mod_ui_load_saved_game", tf_center_justify|tf_double_space|tf_vertical_align_center),
      (position_set_x, pos1, ":var0"),
      (position_set_y, pos1, ":var0"),
      (overlay_set_size, "$g_presentation_credits_obj_2", pos1),
      (position_set_x, pos1, ":var1"),
      (position_set_y, pos1, ":var2"),
      (overlay_set_position, "$g_presentation_credits_obj_2", pos1),
      (val_add, ":var2", ":var3"),
      (create_text_overlay, "$g_presentation_credits_obj_3", "str_mod_ui_quick_battle", tf_center_justify|tf_double_space|tf_vertical_align_center),
      (position_set_x, pos1, ":var0"),
      (position_set_y, pos1, ":var0"),
      (overlay_set_size, "$g_presentation_credits_obj_3", pos1),
      (position_set_x, pos1, ":var1"),
      (position_set_y, pos1, ":var2"),
      (overlay_set_position, "$g_presentation_credits_obj_3", pos1),
      (val_add, ":var2", ":var3"),
      (create_text_overlay, "$g_presentation_credits_obj_4", "str_mod_ui_options", tf_center_justify|tf_double_space|tf_vertical_align_center),
      (position_set_x, pos1, ":var0"),
      (position_set_y, pos1, ":var0"),
      (overlay_set_size, "$g_presentation_credits_obj_4", pos1),
      (position_set_x, pos1, ":var1"),
      (position_set_y, pos1, ":var2"),
      (overlay_set_position, "$g_presentation_credits_obj_4", pos1),
      (val_add, ":var2", ":var3"),
      (create_text_overlay, "$g_presentation_credits_obj_5", "str_mod_ui_credits", tf_center_justify|tf_double_space|tf_vertical_align_center),
      (position_set_x, pos1, ":var0"),
      (position_set_y, pos1, ":var0"),
      (overlay_set_size, "$g_presentation_credits_obj_5", pos1),
      (position_set_x, pos1, ":var1"),
      (position_set_y, pos1, ":var2"),
      (overlay_set_position, "$g_presentation_credits_obj_5", pos1),
      (val_add, ":var2", ":var3"),
      (create_text_overlay, "$g_presentation_credits_obj_6", "str_mod_ui_exit", tf_center_justify|tf_double_space|tf_vertical_align_center),
      (position_set_x, pos1, ":var0"),
      (position_set_y, pos1, ":var0"),
      (overlay_set_size, "$g_presentation_credits_obj_6", pos1),
      (position_set_x, pos1, ":var1"),
      (position_set_y, pos1, ":var2"),
      (overlay_set_position, "$g_presentation_credits_obj_6", pos1),
    ]),
    (ti_on_presentation_mouse_enter_leave,
    [
      (store_trigger_param_1, ":var0"),
      (store_trigger_param_2, ":var1"),
      (this_or_next|eq, ":var0", "$g_presentation_credits_obj_1"),
      (this_or_next|eq, ":var0", "$g_presentation_credits_obj_2"),
      (this_or_next|eq, ":var0", "$g_presentation_credits_obj_3"),
      (this_or_next|eq, ":var0", "$g_presentation_credits_obj_4"),
      (this_or_next|eq, ":var0", "$g_presentation_credits_obj_5"),
      (eq, ":var0", "$g_presentation_credits_obj_6"),
      (try_begin),
        (eq, ":var1", 1),
        (overlay_set_color, ":var0", 0x000000),
        (assign, ":var2", 1400),
        (position_set_x, pos1, ":var2"),
        (position_set_y, pos1, ":var2"),
        (overlay_set_size, ":var0", pos1),
      (else_try),
        (overlay_set_color, ":var0", 0xAA0000),
        (assign, ":var2", 1600),
        (position_set_x, pos1, ":var2"),
        (position_set_y, pos1, ":var2"),
        (overlay_set_size, ":var0", pos1),
      (try_end),
    ]),
  ]),

  ("game_credits",prsntf_read_only,mesh_load_window,[
      (ti_on_presentation_load,
       [(assign, "$g_presentation_credits_obj_1", -1),
        (assign, "$g_presentation_credits_obj_2", -1),
        (assign, "$g_presentation_credits_obj_3", -1),
        (assign, "$g_presentation_credits_obj_4", -1),
        (assign, "$g_presentation_credits_obj_5", -1),
        (assign, "$g_presentation_credits_obj_6", -1),
        (assign, "$g_presentation_credits_obj_7", -1),
        (assign, "$g_presentation_credits_obj_8", -1),
        (assign, "$g_presentation_credits_obj_9", -1),
        (assign, "$g_presentation_credits_obj_10", -1),
        (assign, "$g_presentation_credits_obj_11", -1),
        (assign, "$g_presentation_credits_obj_12", -1),
        (assign, "$g_presentation_credits_obj_1_alpha", 0),
        (assign, "$g_presentation_credits_obj_2_alpha", 0),
        (assign, "$g_presentation_credits_obj_3_alpha", 0),
        (assign, "$g_presentation_credits_obj_4_alpha", 0),
        (assign, "$g_presentation_credits_obj_5_alpha", 0),
        (assign, "$g_presentation_credits_obj_6_alpha", 0),
        (assign, "$g_presentation_credits_obj_7_alpha", 0),
        (assign, "$g_presentation_credits_obj_8_alpha", 0),
        (assign, "$g_presentation_credits_obj_9_alpha", 0),
        ]),
      (ti_on_presentation_run,
       [
        (store_trigger_param_1, ":cur_time"),
        (set_fixed_point_multiplier, 1000),
        (presentation_set_duration, 1000000),
        (try_begin),
          (this_or_next|key_clicked, key_space),
          (this_or_next|key_clicked, key_enter),
          (this_or_next|key_clicked, key_escape),
          (this_or_next|key_clicked, key_back_space),
          (this_or_next|key_clicked, key_left_mouse_button),
          (this_or_next|key_clicked, key_right_mouse_button),
          (this_or_next|key_clicked, key_xbox_ltrigger),
		  (key_clicked, key_xbox_rtrigger),
          (presentation_set_duration, 0),
        (try_end),
        (try_begin),
          (lt, "$g_presentation_credits_obj_1", 0),
          (str_store_string, s1, "str_credits_1"),
          (create_text_overlay, "$g_presentation_credits_obj_1", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_1", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_1", 0),
          (position_set_x, pos1, 1500),
          (position_set_y, pos1, 1500),
          (overlay_set_size, "$g_presentation_credits_obj_1", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_1", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_1", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 2000),
          (eq, "$g_presentation_credits_obj_1_alpha", 0),
          (assign, "$g_presentation_credits_obj_1_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_1", 1000, 0x00),
        (else_try),
          (gt, ":cur_time", 3500),
          (lt, "$g_presentation_credits_obj_2", 0),
          (str_store_string, s1, "str_credits_2"),
          (create_text_overlay, "$g_presentation_credits_obj_2", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_2", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_2", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_2", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_2", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_2", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 5500),
          (eq, "$g_presentation_credits_obj_2_alpha", 0),
          (assign, "$g_presentation_credits_obj_2_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_2", 1000, 0x00),
        (else_try),
          (gt, ":cur_time", 7000),
          (lt, "$g_presentation_credits_obj_3", 0),
          (str_store_string, s1, "str_credits_3"),
          (create_text_overlay, "$g_presentation_credits_obj_3", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_3", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_3", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_3", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_3", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_3", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 9000),
          (eq, "$g_presentation_credits_obj_3_alpha", 0),
          (assign, "$g_presentation_credits_obj_3_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_3", 1000, 0),
        (else_try),
          (gt, ":cur_time", 10500),
          (lt, "$g_presentation_credits_obj_4", 0),
          (str_store_string, s1, "str_credits_4"),
          (create_text_overlay, "$g_presentation_credits_obj_4", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_4", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_4", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_4", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_4", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_4", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 12500),
          (eq, "$g_presentation_credits_obj_4_alpha", 0),
          (assign, "$g_presentation_credits_obj_4_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_4", 1000, 0),
        (else_try),
          (gt, ":cur_time", 14000),
          (lt, "$g_presentation_credits_obj_5", 0),
          (str_store_string, s1, "str_credits_5"),
          (create_text_overlay, "$g_presentation_credits_obj_5", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_5", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_5", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_5", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_5", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_5", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 16000),
          (eq, "$g_presentation_credits_obj_5_alpha", 0),
          (assign, "$g_presentation_credits_obj_5_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_5", 1000, 0),
        (else_try),
          (gt, ":cur_time", 17500),
          (lt, "$g_presentation_credits_obj_6", 0),
          (str_store_string, s1, "str_credits_6"),
          (create_text_overlay, "$g_presentation_credits_obj_6", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_6", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_6", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_6", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_6", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_6", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 19500),
          (eq, "$g_presentation_credits_obj_6_alpha", 0),
          (assign, "$g_presentation_credits_obj_6_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_6", 1000, 0),
        (else_try),
          (gt, ":cur_time", 21000),
          (lt, "$g_presentation_credits_obj_7", 0),
          (str_store_string, s1, "str_credits_7"),
          (create_text_overlay, "$g_presentation_credits_obj_7", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_7", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_7", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_7", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_7", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_7", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 23000),
          (eq, "$g_presentation_credits_obj_7_alpha", 0),
          (assign, "$g_presentation_credits_obj_7_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_7", 1000, 0),
        (else_try),
          (gt, ":cur_time", 24500),
          (lt, "$g_presentation_credits_obj_8", 0),
          (str_store_string, s1, "str_credits_8"),
          (create_text_overlay, "$g_presentation_credits_obj_8", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_8", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_8", 0),
          (position_set_x, pos1, 1750),
          (position_set_y, pos1, 1750),
          (overlay_set_size, "$g_presentation_credits_obj_8", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 375),
          (overlay_set_position, "$g_presentation_credits_obj_8", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_8", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 26500),
          (eq, "$g_presentation_credits_obj_8_alpha", 0),
          (assign, "$g_presentation_credits_obj_8_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_8", 1000, 0),
        (else_try),
          (gt, ":cur_time", 28000),
          (lt, "$g_presentation_credits_obj_9", 0),
          (str_store_string, s1, "str_credits_10"),
          (create_text_overlay, "$g_presentation_credits_obj_9", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_9", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_9", 0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, "$g_presentation_credits_obj_9", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 485),
          (overlay_set_position, "$g_presentation_credits_obj_9", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_9", 1000, 0xFF),

          (str_store_string, s1, "str_credits_11"),
          (create_text_overlay, "$g_presentation_credits_obj_10", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_10", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_10", 0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, "$g_presentation_credits_obj_10", pos1),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 470),
          (overlay_set_position, "$g_presentation_credits_obj_10", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_10", 1000, 0xFF),

          (str_store_string, s1, "str_credits_12"),
          (create_text_overlay, "$g_presentation_credits_obj_11", s1, tf_center_justify|tf_double_space|tf_vertical_align_center),
          (overlay_set_color, "$g_presentation_credits_obj_11", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_11", 0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, "$g_presentation_credits_obj_11", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 105),
          (overlay_set_position, "$g_presentation_credits_obj_11", pos1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_11", 1000, 0xFF),
        (else_try),
          (gt, ":cur_time", 34000),
          (eq, "$g_presentation_credits_obj_9_alpha", 0),
          (assign, "$g_presentation_credits_obj_9_alpha", 1),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_9", 1000, 0),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_10", 1000, 0),
          (overlay_animate_to_alpha, "$g_presentation_credits_obj_11", 1000, 0),
        (else_try),
          (gt, ":cur_time", 35500),
          (lt, "$g_presentation_credits_obj_12", 0),
          (str_store_string, s1, "str_credits_9"),
          (create_text_overlay, "$g_presentation_credits_obj_12", s1, tf_center_justify|tf_double_space),
          (overlay_set_color, "$g_presentation_credits_obj_12", 0),
          (overlay_set_alpha, "$g_presentation_credits_obj_12", 0xFF),
          (position_set_x, pos1, 1000),
          (position_set_y, pos1, 1000),
          (overlay_set_size, "$g_presentation_credits_obj_12", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, -4800),
          (overlay_set_position, "$g_presentation_credits_obj_12", pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 760),
          (overlay_animate_to_position, "$g_presentation_credits_obj_12", 70000, pos1),
        (else_try),
          (gt, ":cur_time", 105500),
          (presentation_set_duration, 0),
        (try_end),
        ]),
      ]),

  ("game_profile_banner_selection", 0, mesh_load_window, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (str_store_string, s1, "str_profile_banner_selection_text"),
      (create_text_overlay, reg1, s1, tf_center_justify),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 600),
      (overlay_set_position, reg1, pos1),
      (overlay_set_text, reg1, s1),
      (create_button_overlay, "$g_presentation_obj_profile_banner_selection_1", "@Next Page", tf_center_justify),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_profile_banner_selection_1", pos1),

      (create_button_overlay, "$g_presentation_obj_profile_banner_selection_2", "str_use_default_banner", tf_center_justify),
      (position_set_x, pos1, 300),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_profile_banner_selection_2", pos1),

      (assign, ":x_pos", 150),
      (assign, ":y_pos", 575),
      (store_mul, ":starting_banner", 16, "$g_presentation_page_no"),
      (store_add, ":ending_banner", ":starting_banner", 16),
      (store_add, "$g_presentation_banner_start", "$g_presentation_obj_profile_banner_selection_2", 1),
      (assign, ":num_valid_banners", 0),
      (try_for_range, ":cur_banner_mesh", banner_meshes_begin, banner_meshes_end_minus_one),
        (assign, ":already_used", 0),
        (try_for_range, ":cur_faction", npc_kingdoms_begin, npc_kingdoms_end),
          (faction_slot_eq, ":cur_faction", slot_faction_banner, ":cur_banner_mesh"),
          (assign, ":already_used", 1),
        (try_end),
        (eq, ":already_used", 0),
        (val_add, ":num_valid_banners", 1),
        (gt, ":num_valid_banners", ":starting_banner"),
        (le, ":num_valid_banners", ":ending_banner"),
        (create_image_button_overlay, reg1, ":cur_banner_mesh", ":cur_banner_mesh"),
        (position_set_x, pos1, ":x_pos"),
        (position_set_y, pos1, ":y_pos"),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, 100),
        (overlay_set_size, reg1, pos1),
        (val_add, ":x_pos", 100),
        (ge, ":x_pos", 900),
        (assign, ":x_pos", 150),
        (val_sub, ":y_pos", 250),
      (try_end),
      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_event_state_change, [
      (store_trigger_param_1, ":object"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_profile_banner_selection_1"),
        (val_add, "$g_presentation_page_no", 1),
        (val_mod, "$g_presentation_page_no", 8),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_profile_banner_selection"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_profile_banner_selection_2"),
        (profile_set_banner_id, -1),
        (presentation_set_duration, 0),
      (else_try),
        (store_sub, ":selected_banner", ":object", "$g_presentation_banner_start"),
        (store_mul, ":page_adder", 16, "$g_presentation_page_no"),
        (val_add, ":selected_banner", ":page_adder"),
        (assign, ":num_valid_banners", 0),
        (assign, ":end_cond", banner_meshes_end_minus_one),
        (try_for_range, ":cur_banner_mesh", banner_meshes_begin, ":end_cond"),
          (assign, ":already_used", 0),
          (try_for_range, ":cur_faction", npc_kingdoms_begin, npc_kingdoms_end),
            (faction_slot_eq, ":cur_faction", slot_faction_banner, ":cur_banner_mesh"),
            (assign, ":already_used", 1),
          (try_end),
          (eq, ":already_used", 0),
          (try_begin),
            (eq, ":selected_banner", ":num_valid_banners"),
            (store_sub, ":selected_banner_index", ":cur_banner_mesh", banner_meshes_begin),
            (profile_set_banner_id, ":selected_banner_index"),
            (assign, ":end_cond", 0), #break
          (try_end),
          (val_add, ":num_valid_banners", 1),
        (try_end),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("game_custom_battle_designer", prsntf_manual_end_only, mesh_cb_ui_main, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_text_overlay, reg0, "str_player", tf_center_justify|tf_single_line|tf_with_outline),
      (overlay_set_color, reg0, 0xFFFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, 700),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_enemy",  tf_center_justify|tf_single_line|tf_with_outline),
      (overlay_set_color, reg0, 0xFFFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, 700),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_character", tf_center_justify),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, 670),
      (overlay_set_position, reg0, pos1),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_18"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_18", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, 635),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_18", pos1),
      (try_for_range, ":cur_troop", quick_battle_troops_begin, quick_battle_troops_end),
        (str_store_troop_name, s0, ":cur_troop"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_18", s0),
      (try_end),
      (store_sub, ":cur_troop", "$g_quick_battle_troop", quick_battle_troops_begin),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_18", ":cur_troop"),

      (store_mul, ":cur_troop", "$g_quick_battle_troop", 2), #with weapons
      (create_mesh_overlay_with_tableau_material, reg0, -1, "tableau_game_party_window", ":cur_troop"),
      (position_set_x, pos1, 25),
      (position_set_y, pos1, 370),
      (overlay_set_position, reg0, pos1),

      (try_begin),
## NMC begin
        (eq, "$g_quick_battle_team_2_faction", "fac_player_supporters_faction"),
        (assign, ":cur_troop", "trp_custom_knight"),
      (else_try),
## NMC end
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_1"),
        (assign, ":cur_troop", "trp_jerusalem_knight"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_2"),
        (assign, ":cur_troop", "trp_antioch_knight"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_3"),
        (assign, ":cur_troop", "trp_seljuk_mamluk"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_4"),
        (assign, ":cur_troop", "trp_templar_knight"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_5"),
        (assign, ":cur_troop", "trp_hospitaller_knight"),
      (else_try),
        (eq, "$g_quick_battle_team_2_faction", "fac_kingdom_6"),
        (assign, ":cur_troop", "trp_ayyubid_mamluk"),
      (else_try),
        (assign, ":cur_troop", "trp_taiga_bandit"),
      (try_end),
      (val_mul, ":cur_troop", 2), #with weapons
      (create_mesh_overlay_with_tableau_material, reg0, -1, "tableau_game_party_window", ":cur_troop"),
      (position_set_x, pos1, 670),
      (position_set_y, pos1, 370),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_biography", tf_center_justify),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 700),
      (overlay_set_position, reg0, pos1),

      (store_sub, ":cur_troop_text", "$g_quick_battle_troop", quick_battle_troops_begin),
      (val_add, ":cur_troop_text", quick_battle_troop_texts_begin),
      (create_text_overlay, reg0, ":cur_troop_text", tf_scrollable),
      (position_set_x, pos1, 850),
      (position_set_y, pos1, 850),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 320),
      (position_set_y, pos1, 560),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 360),
      (position_set_y, pos1, 130),
      (overlay_set_area_size, reg0, pos1),

      (create_text_overlay, reg0, "str_map_basic", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 450),
      (overlay_set_position, reg0, pos1),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_1"),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 700),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_1", pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 415),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_1", pos1),
      (try_begin),
        (eq, "$g_quick_battle_game_type", 0), #battle
        (try_for_range, ":cur_scene", quick_battle_battle_scenes_begin, quick_battle_battle_scenes_end),
          (store_sub, ":cur_scene_name", ":cur_scene", quick_battle_scenes_begin),
          (val_add, ":cur_scene_name", quick_battle_scene_names_begin),
          (overlay_add_item, "$g_presentation_obj_custom_battle_designer_1", ":cur_scene_name"),
        (try_end),
        (try_begin),
          (is_between, "$g_quick_battle_map", quick_battle_battle_scenes_begin, quick_battle_battle_scenes_end),
          (store_sub, ":cur_map", "$g_quick_battle_map", quick_battle_battle_scenes_begin),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_1", ":cur_map"),
        (else_try),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_1", 0),
          (assign, "$g_quick_battle_map", quick_battle_battle_scenes_begin),
        (try_end),
      (else_try),
        (try_for_range, ":cur_scene", quick_battle_siege_scenes_begin, quick_battle_siege_scenes_end),
          (store_sub, ":cur_scene_name", ":cur_scene", quick_battle_scenes_begin),
          (val_add, ":cur_scene_name", quick_battle_scene_names_begin),
          (overlay_add_item, "$g_presentation_obj_custom_battle_designer_1", ":cur_scene_name"),
        (try_end),
        (try_begin),
          (is_between, "$g_quick_battle_map", quick_battle_siege_scenes_begin, quick_battle_siege_scenes_end),
          (store_sub, ":cur_map", "$g_quick_battle_map", quick_battle_siege_scenes_begin),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_1", ":cur_map"),
        (else_try),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_1", 0),
          (assign, "$g_quick_battle_map", quick_battle_siege_scenes_begin),
        (try_end),
      (try_end),

      (store_sub, ":cur_mesh", "$g_quick_battle_map", quick_battle_scenes_begin),
      (val_add, ":cur_mesh", quick_battle_scene_images_begin),
      (create_mesh_overlay, reg0, ":cur_mesh"),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 700),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 380),
      (position_set_y, pos1, 220),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_game_type_basic", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 180),
      (overlay_set_position, reg0, pos1),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_23"),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 700),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_23", pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 150),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_23", pos1),
      (overlay_add_item, "$g_presentation_obj_custom_battle_designer_23", "str_battle"),
      (overlay_add_item, "$g_presentation_obj_custom_battle_designer_23", "str_siege_offense"),
      (overlay_add_item, "$g_presentation_obj_custom_battle_designer_23", "str_siege_defense"),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_23", "$g_quick_battle_game_type"),

      (create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_24", "str_randomize"),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 60),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_24", pos1),

      (assign, ":cur_y", 330),
      (assign, ":cur_y", 350),
      (assign, ":cur_y_adder", 40),

      (create_text_overlay, reg0, "str_faction", tf_center_justify),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_faction", tf_center_justify),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_4"),
##      (position_set_x, pos1, 800),
##      (position_set_y, pos1, 800),
##      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_4", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_4", pos1),
      (try_begin),
        (is_trial_version),
        (str_store_faction_name, s0, npc_kingdoms_begin),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_4", s0),
        (store_add, ":cur_faction", npc_kingdoms_begin, 1),
        (str_store_faction_name, s0, ":cur_faction"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_4", s0),
      (else_try),
        (try_for_range, ":cur_faction", kingdoms_begin, kingdoms_end), ## NMC - was npc_kingdoms_begin, npc_kingdoms_end
          (str_store_faction_name, s0, ":cur_faction"),
          (overlay_add_item, "$g_presentation_obj_custom_battle_designer_4", s0),
        (try_end),
        (str_store_faction_name, s0, "fac_outlaws"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_4", s0),
      (try_end),
      (try_begin),
        (eq, "$g_quick_battle_team_1_faction", "fac_outlaws"),
        (store_sub, ":overlay_value", kingdoms_end, kingdoms_begin), ## NMC - was npc_kingdoms_begin, npc_kingdoms_end
        (overlay_set_val, "$g_presentation_obj_custom_battle_designer_4", ":overlay_value"),
      (else_try),
        (store_sub, ":team_1_faction", "$g_quick_battle_team_1_faction", kingdoms_begin), ## NMC - was npc_kingdoms_begin
        (overlay_set_val, "$g_presentation_obj_custom_battle_designer_4", ":team_1_faction"),
      (try_end),

      (create_combo_label_overlay, "$g_presentation_obj_custom_battle_designer_5"),
##      (position_set_x, pos1, 800),
##      (position_set_y, pos1, 800),
##      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_5", pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_5", pos1),
      (try_begin),
        (is_trial_version),
        (str_store_faction_name, s0, kingdoms_begin), ## NMC - was npc_kingdoms_begin
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_5", s0),
        (store_add, ":cur_faction", kingdoms_begin, 1), ## NMC - was npc_kingdoms_begin
        (str_store_faction_name, s0, ":cur_faction"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_5", s0),
      (else_try),
        (try_for_range, ":cur_faction", kingdoms_begin, kingdoms_end), ## NMC - was npc_kingdoms_begin, npc_kingdoms_end
          (str_store_faction_name, s0, ":cur_faction"),
          (overlay_add_item, "$g_presentation_obj_custom_battle_designer_5", s0),
        (try_end),
        (str_store_faction_name, s0, "fac_outlaws"),
        (overlay_add_item, "$g_presentation_obj_custom_battle_designer_5", s0),
      (try_end),
      (try_begin),
        (eq, "$g_quick_battle_team_2_faction", "fac_outlaws"),
        (store_sub, ":overlay_value", kingdoms_end, kingdoms_begin), ## NMC - was npc_kingdoms_begin, npc_kingdoms_end
        (overlay_set_val, "$g_presentation_obj_custom_battle_designer_5", ":overlay_value"),
      (else_try),
        (store_sub, ":team_2_faction", "$g_quick_battle_team_2_faction", kingdoms_begin), ## NMC - was npc_kingdoms_begin
        (overlay_set_val, "$g_presentation_obj_custom_battle_designer_5", ":team_2_faction"),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_army_composition", tf_center_justify),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_army_composition", tf_center_justify),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (try_begin),
        (eq, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
        (eq, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 34),
        (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 33),
        (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 33),
        (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 34),
        (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 33),
        (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 33),
        (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
        (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
      (try_end),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_infantry"),
      (position_set_x, pos1, 5),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_infantry"),
      (position_set_x, pos1, 650),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_6", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_6", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_6", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_6_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_12", "str_reg0_percent", 0),
      (position_set_x, pos1, 295),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_12", pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_9", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_9", pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_9", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_9_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_15", "str_reg0_percent", 0),
      (position_set_x, pos1, 940),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_15", pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_archer"),
      (position_set_x, pos1, 15),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_archer"),
      (position_set_x, pos1, 660),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_7", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_7", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_7", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_7_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_13", "str_reg0_percent", 0),
      (position_set_x, pos1, 295),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_13", pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_10", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_10", pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_10", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_10_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_16", "str_reg0_percent", 0),
      (position_set_x, pos1, 940),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_16", pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_horseman"),
      (position_set_x, pos1, 10),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_cb_ui_icon_horseman"),
      (position_set_x, pos1, 655),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 400),
      (position_set_y, pos1, 400),
      (overlay_set_size, reg0, pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_8", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_8", pos1),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_8", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_8_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_14", "str_reg0_percent", 0),
      (position_set_x, pos1, 295),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_14", pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_11", 0, 100),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_11", pos1),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_11", pos1),

      (assign, reg0, "$g_presentation_obj_custom_battle_designer_11_last_value"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_17", "str_reg0_percent", 0),
      (position_set_x, pos1, 940),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_17", pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_army_size", tf_center_justify),
      (position_set_x, pos1, 175),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "str_army_size", tf_center_justify),
      (position_set_x, pos1, 820),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (try_begin),
        (is_trial_version),
        (val_min, "$g_quick_battle_army_1_size", 25),
        (val_min, "$g_quick_battle_army_2_size", 25),
      (try_end),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_2", 0, 100),
      (overlay_set_boundaries, "$g_presentation_obj_custom_battle_designer_2", 1000, 75000),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_2", "$g_quick_battle_army_1_size"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_2", pos1),
      (position_set_x, pos1, 135),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_2", pos1),

      (call_script, "script_get_army_size_from_slider_value", "$g_quick_battle_army_1_size"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_21", "str_reg0_men", 0),
      (position_set_x, pos1, 255),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_21", pos1),

      (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_3", 200),
      (overlay_set_boundaries, "$g_presentation_obj_custom_battle_designer_3", 1000, 75000),
      (overlay_set_val, "$g_presentation_obj_custom_battle_designer_3", "$g_quick_battle_army_2_size"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 1000),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_3", pos1),
      (position_set_x, pos1, 780),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_3", pos1),

      (call_script, "script_get_army_size_from_slider_value", "$g_quick_battle_army_2_size"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_22", "str_reg0_men", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_22", pos1),

      (create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_19", "str_start", 0),
      (position_set_x, pos1, 415),
      (position_set_y, pos1, 10),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_19", pos1),

      (create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_20", "str_back", 0),
      (position_set_x, pos1, 585),
      (position_set_y, pos1, 10),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_20", pos1),

      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_event_state_change,
     [
       (store_trigger_param_1, ":object"),
       (store_trigger_param_2, ":value"),
       (try_begin),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_1"),
         (try_begin),
           (eq, "$g_quick_battle_game_type", 0),
           (store_add, "$g_quick_battle_map", ":value", quick_battle_battle_scenes_begin),
         (else_try),
           (store_add, "$g_quick_battle_map", ":value", quick_battle_siege_scenes_begin),
         (try_end),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_23"),
         (assign, "$g_quick_battle_game_type", ":value"),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_24"),
         (store_random_in_range, "$g_quick_battle_game_type", 0, 3),
         (store_random_in_range, "$g_quick_battle_troop", quick_battle_troops_begin, quick_battle_troops_end),
         (try_begin),
           (is_trial_version),
           (store_random_in_range, "$g_quick_battle_team_1_faction", 0, 2),
           (try_begin),
             (eq, "$g_quick_battle_team_1_faction", 0),
             (assign, "$g_quick_battle_team_2_faction", 1),
           (else_try),
             (assign, "$g_quick_battle_team_2_faction", 0),
           (try_end),
           (val_add, "$g_quick_battle_team_1_faction", npc_kingdoms_begin),
           (val_add, "$g_quick_battle_team_2_faction", npc_kingdoms_begin),
           (store_random_in_range, "$g_quick_battle_army_1_size", 10, 16),
           (store_random_in_range, ":random_army_size", 0, 6),
           (val_add, "$g_quick_battle_army_1_size", ":random_army_size"),
           (store_random_in_range, ":random_army_size", 0, 6),
           (val_add, "$g_quick_battle_army_1_size", ":random_army_size"),
         (else_try),
           (store_sub, ":num_factions", npc_kingdoms_end, npc_kingdoms_begin), ## NMC - was npc_kingdoms_begin, npc_kingdoms_end
           (val_add, ":num_factions", 1),
           (store_random_in_range, "$g_quick_battle_team_1_faction", 0, ":num_factions"),
           (try_begin),
             (eq, "$g_quick_battle_team_1_faction", 0),
             (assign, "$g_quick_battle_team_1_faction", "fac_outlaws"),
           (else_try),
             (val_add, "$g_quick_battle_team_1_faction", kingdoms_begin), ## NMC - was npc_kingdoms_begin
             (val_sub, "$g_quick_battle_team_1_faction", 1),
           (try_end),
           (assign, ":end_cond", 1000),
           (try_for_range, ":unused", 0, ":end_cond"),
             (store_random_in_range, "$g_quick_battle_team_2_faction", 0, ":num_factions"),
             (try_begin),
               (eq, "$g_quick_battle_team_2_faction", 0),
               (assign, "$g_quick_battle_team_2_faction", "fac_outlaws"),
             (else_try),
               (val_add, "$g_quick_battle_team_2_faction", kingdoms_begin), ## NMC - was npc_kingdoms_begin
               (val_sub, "$g_quick_battle_team_2_faction", 1),
             (try_end),
             (neq, "$g_quick_battle_team_1_faction", "$g_quick_battle_team_2_faction"),
             (assign, ":end_cond", 0),
           (try_end),
           (store_random_in_range, "$g_quick_battle_army_1_size", 10, 21),
           (store_random_in_range, ":random_army_size", 0, 11),
           (val_add, "$g_quick_battle_army_1_size", ":random_army_size"),
           (store_random_in_range, ":random_army_size", 0, 11),
           (val_add, "$g_quick_battle_army_1_size", ":random_army_size"),
         (try_end),
         (assign, "$g_quick_battle_army_2_size", "$g_quick_battle_army_1_size"),
         (try_begin),
           (eq, "$g_quick_battle_game_type", 0), #battle
           (store_random_in_range, "$g_quick_battle_map", quick_battle_battle_scenes_begin, quick_battle_battle_scenes_end),
           (store_random_in_range, ":random_type", 0, 3),
           (store_random_in_range, ":random_type_2", 0, 2),
           (store_random_in_range, ":random_composition", 0, 100),
           (store_sub, ":left_max", 100, ":random_composition"),
           (store_random_in_range, ":random_composition_2", 0, ":left_max"),
           (store_sub, ":random_composition_3", ":left_max", ":random_composition_2"),
           (try_begin),
             (eq, ":random_type", 0),
             (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition_3"),
             (try_end),
           (else_try),
             (eq, ":random_type", 1),
             (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition_3"),
             (try_end),
           (else_try),
             (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":random_composition_3"),
             (try_end),
           (try_end),
           (store_random_in_range, ":random_type", 0, 3),
           (store_random_in_range, ":random_type_2", 0, 2),
           (store_random_in_range, ":random_composition", 0, 100),
           (store_sub, ":left_max", 100, ":random_composition"),
           (store_random_in_range, ":random_composition_2", 0, ":left_max"),
           (store_sub, ":random_composition_3", ":left_max", ":random_composition_2"),
           (try_begin),
             (eq, ":random_type", 0),
             (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition_3"),
             (try_end),
           (else_try),
             (eq, ":random_type", 1),
             (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition_3"),
             (try_end),
           (else_try),
             (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":random_composition"),
             (try_begin),
               (eq, ":random_type_2", 0),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition_3"),
             (else_try),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":random_composition_2"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":random_composition_3"),
             (try_end),
           (try_end),
         (else_try),
           (eq, "$g_quick_battle_game_type", 1), #siege offense
           (store_random_in_range, "$g_quick_battle_map", quick_battle_siege_scenes_begin, quick_battle_siege_scenes_end),
           #defender is enemy
           (store_random_in_range, "$g_presentation_obj_custom_battle_designer_10_last_value", 30, 100), #min 30% archer
           (store_sub, "$g_presentation_obj_custom_battle_designer_9_last_value", 100, "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 0), #no cavalry
           (store_random_in_range, "$g_presentation_obj_custom_battle_designer_6_last_value", 20, 100), #min 20% infantry
           (store_sub, "$g_presentation_obj_custom_battle_designer_7_last_value", 100, "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 0), #no cavalry
         (else_try),
           #siege defense
           (store_random_in_range, "$g_quick_battle_map", quick_battle_siege_scenes_begin, quick_battle_siege_scenes_end),
           #defender is player
           (store_random_in_range, "$g_presentation_obj_custom_battle_designer_7_last_value", 30, 100), #min 30% archer
           (store_sub, "$g_presentation_obj_custom_battle_designer_6_last_value", 100, "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 0), #no cavalry
           (store_random_in_range, "$g_presentation_obj_custom_battle_designer_9_last_value", 20, 100), #min 20% infantry
           (store_sub, "$g_presentation_obj_custom_battle_designer_10_last_value", 100, "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 0), #no cavalry
         (try_end),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_2"),
         (assign, "$g_quick_battle_army_1_size", ":value"),
         (try_begin),
           (is_trial_version),
           (gt, "$g_quick_battle_army_1_size", 25),
           (assign, "$g_quick_battle_army_1_size", 25),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_2", 25),
         (try_end),
         (call_script, "script_get_army_size_from_slider_value", "$g_quick_battle_army_1_size"),
         (overlay_set_text, "$g_presentation_obj_custom_battle_designer_21", "str_reg0_men"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_3"),
         (assign, "$g_quick_battle_army_2_size", ":value"),
         (try_begin),
           (is_trial_version),
           (gt, "$g_quick_battle_army_2_size", 25),
           (assign, "$g_quick_battle_army_2_size", 25),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_3", 25),
         (try_end),
         (call_script, "script_get_army_size_from_slider_value", "$g_quick_battle_army_2_size"),
         (overlay_set_text, "$g_presentation_obj_custom_battle_designer_22", "str_reg0_men"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_4"),
         (try_begin),
           (store_sub, ":outlaw_index", kingdoms_end, kingdoms_begin), ## NMC - was npc_kingdoms_begin, npc_kingdoms_end
           (eq, ":value", ":outlaw_index"),
           (assign, "$g_quick_battle_team_1_faction", "fac_outlaws"),
         (else_try),
           (store_add, "$g_quick_battle_team_1_faction", ":value", kingdoms_begin), ## NMC - was npc_kingdoms_begin
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_5"),
         (try_begin),
           (store_sub, ":outlaw_index", kingdoms_end, kingdoms_begin), ## NMC - was npc_kingdoms_begin, npc_kingdoms_end
           (eq, ":value", ":outlaw_index"),
           (assign, "$g_quick_battle_team_2_faction", "fac_outlaws"),
         (else_try),
           (store_add, "$g_quick_battle_team_2_faction", ":value", kingdoms_begin), ## NMC - was npc_kingdoms_begin
         (try_end),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_18"),
         (store_add, "$g_quick_battle_troop", ":value", quick_battle_troops_begin),
         (presentation_set_duration, 0),
         (start_presentation, "prsnt_game_custom_battle_designer"),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_6"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_6_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_7_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_8_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_12", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_13", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_14", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_7"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_7_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_6_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_8_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_8_last_value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_12", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_13", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_14", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_8"),
           (try_begin),
             (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
             (neq, ":value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_8", "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_8_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_8_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_8_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_7_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_6_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_7_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_6_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_6_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_7", "$g_presentation_obj_custom_battle_designer_7_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_6", "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_6_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_12", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_7_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_13", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_8_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_14", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_9"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_9_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_10_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_11_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_15", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_16", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_17", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_10"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_10_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_9_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_11_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_11_last_value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_15", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_16", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_17", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_11"),
         (try_begin),
           (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
           (neq, ":value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (overlay_set_val, "$g_presentation_obj_custom_battle_designer_11", "$g_presentation_obj_custom_battle_designer_11_last_value"),
         (else_try),
           (try_begin),
             (lt, ":value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
             (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_11_last_value", ":value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":value"),
             (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", ":first_dif"),
             (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", ":second_dif"),
             (try_begin),
               (gt, "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 100),
             (else_try),
               (gt, "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
               (store_sub, ":dif", "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
               (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", ":dif"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 100),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (else_try),
             (gt, ":value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
             (store_sub, ":dif", ":value", "$g_presentation_obj_custom_battle_designer_11_last_value"),
             (try_begin),
               (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
               (assign, ":first_dif", 0),
               (assign, ":second_dif", ":dif"),
             (else_try),
               (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
               (assign, ":first_dif", ":dif"),
               (assign, ":second_dif", 0),
             (else_try),
               (store_div, ":first_dif", ":dif", 2),
               (store_sub, ":second_dif", ":dif", ":first_dif"),
               (try_begin),
                 (neq, ":first_dif", ":second_dif"),
                 (store_random_in_range, ":random_no", 0, 2),
                 (eq, ":random_no", 0),
                 (val_sub, ":second_dif", 1),
                 (val_add, ":first_dif", 1),
               (try_end),
             (try_end),
             (assign, "$g_presentation_obj_custom_battle_designer_11_last_value", ":value"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_10_last_value", ":first_dif"),
             (val_sub, "$g_presentation_obj_custom_battle_designer_9_last_value", ":second_dif"),
             (try_begin),
               (lt, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_10_last_value", 0),
             (else_try),
               (lt, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
               (val_add, "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_9_last_value"),
               (assign, "$g_presentation_obj_custom_battle_designer_9_last_value", 0),
             (try_end),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_10", "$g_presentation_obj_custom_battle_designer_10_last_value"),
             (overlay_set_val, "$g_presentation_obj_custom_battle_designer_9", "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (try_end),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_9_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_15", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_10_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_16", "str_reg0_percent"),
           (assign, reg0, "$g_presentation_obj_custom_battle_designer_11_last_value"),
           (overlay_set_text, "$g_presentation_obj_custom_battle_designer_17", "str_reg0_percent"),
         (try_end),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_19"),
         (assign, "$g_is_quick_battle", 1),
         (assign, ":cur_scene", "$g_quick_battle_map"),
         (try_begin),
           (eq, "$g_quick_battle_game_type", 0), #battle
           (assign, ":cur_mission_template", "mt_quick_battle_battle"),
           (modify_visitors_at_site, ":cur_scene"),
           (call_script, "script_spawn_quick_battle_army", 0, "$g_quick_battle_team_1_faction", "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value", 0, 1),
           (call_script, "script_spawn_quick_battle_army", 16, "$g_quick_battle_team_2_faction", "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value", 0, 0),
         (else_try),
           (eq, "$g_quick_battle_game_type", 1), #siege offense
           (assign, ":cur_mission_template", "mt_quick_battle_siege"),
           (modify_visitors_at_site, ":cur_scene"),
           (call_script, "script_spawn_quick_battle_army", 16, "$g_quick_battle_team_1_faction", "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value", 0, 1),
           (call_script, "script_spawn_quick_battle_army", 0, "$g_quick_battle_team_2_faction", "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value", 1, 0),
         (else_try),
           #siege defense
           (assign, ":cur_mission_template", "mt_quick_battle_siege"),
           (modify_visitors_at_site, ":cur_scene"),
           (call_script, "script_spawn_quick_battle_army", 0, "$g_quick_battle_team_1_faction", "$g_presentation_obj_custom_battle_designer_6_last_value", "$g_presentation_obj_custom_battle_designer_7_last_value", "$g_presentation_obj_custom_battle_designer_8_last_value", 1, 1),
           (call_script, "script_spawn_quick_battle_army", 16, "$g_quick_battle_team_2_faction", "$g_presentation_obj_custom_battle_designer_9_last_value", "$g_presentation_obj_custom_battle_designer_10_last_value", "$g_presentation_obj_custom_battle_designer_11_last_value", 0, 0),
         (try_end),
         (set_jump_mission,":cur_mission_template"),
         (jump_to_menu, "mnu_custom_battle_end"),
         (jump_to_scene, ":cur_scene"),
         (change_screen_mission),
         (presentation_set_duration, 0),
       (else_try),
         (eq, ":object", "$g_presentation_obj_custom_battle_designer_20"),
         (presentation_set_duration, 0),
       (try_end),
      ]),
    (ti_on_presentation_mouse_enter_leave,
     [
       (store_trigger_param_1, ":object"),
       (store_trigger_param_2, ":enter_leave"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_6"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_7"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_8"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_9"),
       (this_or_next|eq, ":object", "$g_presentation_obj_custom_battle_designer_10"),
       (eq, ":object", "$g_presentation_obj_custom_battle_designer_11"),
       (try_begin),
         (eq, ":enter_leave", 1),
         (try_begin),
           (eq, ":object", "$g_presentation_obj_custom_battle_last_mouse_over_object"),
           (assign, "$g_presentation_obj_custom_battle_last_mouse_over_object", -1),
         (try_end),
       (else_try),
         (assign, "$g_presentation_obj_custom_battle_last_mouse_over_object", ":object"),
       (try_end),
       ]),
    (ti_on_presentation_run,
     [
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (presentation_set_duration, 0),
      (else_try),
        (key_clicked, key_right_mouse_button),
        (neq, "$g_presentation_obj_custom_battle_last_mouse_over_object", -1),
        (try_begin),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_6"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 1),
            (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_7"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 1),
            (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_8"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_6_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_7_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 1),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_8_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_9"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 1),
            (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_10"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 1),
            (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
          (try_end),
        (else_try),
          (eq, "$g_presentation_obj_custom_battle_last_mouse_over_object", "$g_presentation_obj_custom_battle_designer_11"),
          (try_begin),
            (eq, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_9_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_10_locked", 0),
            (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 1),
          (else_try),
            (assign, "$g_presentation_obj_custom_battle_designer_11_locked", 0),
          (try_end),
        (try_end),
      (try_end),
      ]),
    ]),

  ("game_multiplayer_admin_panel", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (try_begin),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_1"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_1"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_2"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_2"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_3"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_3"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_4"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_4"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_5"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_5"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_6"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_6"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_7"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_7"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_8"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_8"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_9"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_9"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_10"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_10"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_11"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_11"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_12"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_12"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_13"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_13"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_14"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_14"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_15"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_15"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_16"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_16"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_17"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_17"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_18"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_18"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_19"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_19"),
      (else_try),
        (eq, "$g_multiplayer_selected_map", "scn_multi_scene_20"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_20"),
      (else_try),
        (this_or_next|eq, "$g_multiplayer_selected_map", "scn_random_multi_plain_medium"),
        (eq, "$g_multiplayer_selected_map", "scn_random_multi_plain_large"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_randomp"),
      (else_try),
        (this_or_next|eq, "$g_multiplayer_selected_map", "scn_random_multi_steppe_medium"),
        (eq, "$g_multiplayer_selected_map", "scn_random_multi_steppe_large"),
        (assign, ":map_image", "mesh_mp_ui_host_maps_randoms"),
      (else_try),
        (assign, ":map_image", "mesh_mp_ui_host_maps_randomp"),
      (try_end),

      (create_mesh_overlay, reg0, ":map_image"),
      (position_set_x, pos1, -1),
      (position_set_y, pos1, 550),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1002),
      (position_set_y, pos1, 1002),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_mp_ui_host_main"),
      (position_set_x, pos1, -1),
      (position_set_y, pos1, -1),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1002),
      (position_set_y, pos1, 1002),
      (overlay_set_size, reg0, pos1),

      (assign, ":cur_y", 1240),
      (assign, ":cur_y_adder", 40),

      (try_begin),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_team_deathmatch),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
        (val_add, ":cur_y", ":cur_y_adder"), #two more options for these mods (friendly fire options)
        (val_add, ":cur_y", ":cur_y_adder"),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
        (val_add, ":cur_y", ":cur_y_adder"), #one more option for these mods
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
        (val_add, ":cur_y", ":cur_y_adder"), #one more option for these mods
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
        (val_add, ":cur_y", ":cur_y_adder"), #one more option for these mods
      (try_end),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_admin_panel_container", s0, tf_scrollable),
      (position_set_x, pos1, 59),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_admin_panel_container", pos1),
      (position_set_x, pos1, 640),
      (position_set_y, pos1, 520),
      (overlay_set_area_size, "$g_presentation_obj_admin_panel_container", pos1),
      (set_container_overlay, "$g_presentation_obj_admin_panel_container"),


      (create_text_overlay, reg0, "str_add_to_official_game_servers_list", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_14", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_14", pos1),
      (server_get_add_to_game_servers_list, ":add_to_servers_list"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_14", ":add_to_servers_list"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_enable_valve_anti_cheat", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_41", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_41", pos1),
      (server_get_anti_cheat, ":server_anti_cheat"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_41", ":server_anti_cheat"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_server_name", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (str_store_server_name, s0),
      (try_begin),
        (eq, "$g_multiplayer_renaming_server_allowed", 1),
        (create_simple_text_box_overlay, "$g_presentation_obj_admin_panel_20"),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_20", pos1),
        (overlay_set_text, "$g_presentation_obj_admin_panel_20", s0),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_20", -1),
        (create_text_overlay, reg0, s0, 0),
        (position_set_x, pos1, 385),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_game_password", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_simple_text_box_overlay, "$g_presentation_obj_admin_panel_9"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_9", pos1),
      (str_store_server_password, s0),
      (overlay_set_text, "$g_presentation_obj_admin_panel_9", s0),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_welcome_message", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_simple_text_box_overlay, "$g_presentation_obj_admin_panel_32"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_32", pos1),
      (str_store_welcome_message, s0),
      (overlay_set_text, "$g_presentation_obj_admin_panel_32", s0),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_map", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (call_script, "script_multiplayer_fill_map_game_types", "$g_multiplayer_game_type"),
      (assign, ":num_maps", reg0),
      (assign, ":selected_index", 0),

      (try_begin),
        (gt, ":num_maps", 12),
        (create_combo_label_overlay, "$g_presentation_obj_admin_panel_1"),
      (else_try),
        (create_combo_button_overlay, "$g_presentation_obj_admin_panel_1"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_1", pos1),
      (try_begin),
        (gt, ":num_maps", 14),
        (position_set_x, pos1, 465),
      (else_try),
        (position_set_x, pos1, 490),
      (try_end),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_1", pos1),
      (troop_get_slot, ":first_map", "trp_multiplayer_data", multi_data_maps_for_game_type_begin),
      (assign, ":selected_map_available", 0),
      (try_for_range, ":i_map", 0, ":num_maps"),
        (store_add, ":map_slot", ":i_map", multi_data_maps_for_game_type_begin),
        (troop_get_slot, ":map_no", "trp_multiplayer_data", ":map_slot"),
        (store_sub, ":string_index", ":map_no", multiplayer_scenes_begin),
        (val_add, ":string_index", multiplayer_scene_names_begin),
        (str_store_string, s0, ":string_index"),
        (overlay_add_item, "$g_presentation_obj_admin_panel_1", s0),
        (try_begin),
          (eq, ":map_no", "$g_multiplayer_selected_map"),
          (assign, ":selected_index", ":i_map"),
          (assign, ":selected_map_available", 1),
        (try_end),
      (try_end),
      (overlay_set_val, "$g_presentation_obj_admin_panel_1", ":selected_index"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_game_type", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (try_begin),
        (eq, "$g_multiplayer_changing_game_type_allowed", 1),
        (create_combo_button_overlay, "$g_presentation_obj_admin_panel_10"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, "$g_presentation_obj_admin_panel_10", pos1),
        (position_set_x, pos1, 490),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_10", pos1),
        (try_for_range, ":i_game_type", 0, multiplayer_num_game_types),
          (store_add, ":string_index", ":i_game_type", multiplayer_game_type_names_begin),
          (str_store_string, s0, ":string_index"),
          (overlay_add_item, "$g_presentation_obj_admin_panel_10", s0),
        (try_end),
        (overlay_set_val, "$g_presentation_obj_admin_panel_10", "$g_multiplayer_game_type"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_10", -1),
        (store_add, ":string_index", "$g_multiplayer_game_type", multiplayer_game_type_names_begin),
        (str_store_string, s0, ":string_index"),
        (create_text_overlay, reg0, s0, 0),
        (position_set_x, pos1, 385),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 1),
      (create_text_overlay, reg0, "str_team_reg1_faction", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_11"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_11", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_11", pos1),
      (call_script, "script_multiplayer_fill_available_factions_combo_button", "$g_presentation_obj_admin_panel_11", "$g_multiplayer_next_team_1_faction", "$g_multiplayer_next_team_2_faction"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 2),
      (create_text_overlay, reg0, "str_team_reg1_faction", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_12"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_12", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_12", pos1),
      (call_script, "script_multiplayer_fill_available_factions_combo_button", "$g_presentation_obj_admin_panel_12", "$g_multiplayer_next_team_2_faction", "$g_multiplayer_next_team_1_faction"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 1),
      (create_text_overlay, reg0, "str_max_number_of_players", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_21", 2, 201),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_21", pos1),
      (server_get_max_num_players, ":max_players"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_21", ":max_players"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 1),
      (create_text_overlay, reg0, "str_number_of_bots_in_team_reg1", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_3", 0, "$g_multiplayer_max_num_bots"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_3", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_3", "$g_multiplayer_num_bots_team_1"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (assign, reg1, 2),
      (create_text_overlay, reg0, "str_number_of_bots_in_team_reg1", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_4", 0, "$g_multiplayer_max_num_bots"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_4", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_4", "$g_multiplayer_num_bots_team_2"),

      (try_begin),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_deathmatch),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_duel),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_allow_friendly_fire", 0),
        (position_set_x, pos1, 30),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_check_box_overlay, "$g_presentation_obj_admin_panel_5", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 7),
        (store_add, ":special_cur_y", ":cur_y", 7),
        (position_set_y, pos1, ":special_cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_5", pos1),
        (server_get_friendly_fire, ":server_friendly_fire"),
        (overlay_set_val, "$g_presentation_obj_admin_panel_5", ":server_friendly_fire"),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_allow_melee_friendly_fire", 0),
        (position_set_x, pos1, 30),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_check_box_overlay, "$g_presentation_obj_admin_panel_36", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 7),
        (store_add, ":special_cur_y", ":cur_y", 7),
        (position_set_y, pos1, ":special_cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_36", pos1),
        (server_get_melee_friendly_fire, ":melee_friendly_fire"),
        (overlay_set_val, "$g_presentation_obj_admin_panel_36", ":melee_friendly_fire"),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_friendly_fire_damage_self_ratio", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_37", 0, 101),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_37", pos1),
      (server_get_friendly_fire_damage_self_ratio, ":friendly_fire_damage_self_ratio"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_37", ":friendly_fire_damage_self_ratio"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_friendly_fire_damage_friend_ratio", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_38", 0, 101),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_38", pos1),
      (server_get_friendly_fire_damage_friend_ratio, ":friendly_fire_damage_friend_ratio"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_38", ":friendly_fire_damage_friend_ratio"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_spectator_camera", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_19"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_19", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_19", pos1),
      (overlay_add_item, "$g_presentation_obj_admin_panel_19", "str_free"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_19", "str_stick_to_any_player"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_19", "str_stick_to_team_members"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_19", "str_stick_to_team_members_view"),
      (server_get_ghost_mode, ":server_ghost_mode"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_19", ":server_ghost_mode"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_control_block_direction", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_15"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_15", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_15", pos1),
      (overlay_add_item, "$g_presentation_obj_admin_panel_15", "str_automatic"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_15", "str_by_mouse_movement"),
      (server_get_control_block_dir, ":server_control_block_dir"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_15", ":server_control_block_dir"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_combat_speed", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_26"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_26", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_26", pos1),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_0"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_1"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_2"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_3"),
      (overlay_add_item, "$g_presentation_obj_admin_panel_26", "str_combat_speed_4"),
      (server_get_combat_speed, ":server_combat_speed"),
      (overlay_set_val, "$g_presentation_obj_admin_panel_26", ":server_combat_speed"),

      (try_begin),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_map_time_limit", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_7", 5, 121),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_7", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_7", "$g_multiplayer_game_max_minutes"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_7", -1),
      (try_end),

      (try_begin),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_round_time_limit", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_16", multiplayer_round_max_seconds_min, multiplayer_round_max_seconds_max),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_16", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_16", "$g_multiplayer_round_max_seconds"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_16", -1),
      (try_end),

      (try_begin),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_players_take_control_of_a_bot_after_death", 0),
        (position_set_x, pos1, 30),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_check_box_overlay, "$g_presentation_obj_admin_panel_25", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 7),
        (store_add, ":special_cur_y", ":cur_y", 7),
        (position_set_y, pos1, ":special_cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_25", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_25", "$g_multiplayer_player_respawn_as_bot"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_25", -1),
      (try_end),

      (try_begin),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_defender_spawn_count_limit", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_combo_button_overlay, "$g_presentation_obj_admin_panel_27"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, "$g_presentation_obj_admin_panel_27", pos1),
        (position_set_x, pos1, 490),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_27", pos1),
        (assign, reg0, 5),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (assign, reg0, 4),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (assign, reg0, 3),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (assign, reg0, 2),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (assign, reg0, 1),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_reg0"),
        (overlay_add_item, "$g_presentation_obj_admin_panel_27", "str_unlimited"),

        (store_sub, ":value_to_set", 5, "$g_multiplayer_number_of_respawn_count"),
        (overlay_set_val, "$g_presentation_obj_admin_panel_27", ":value_to_set"),
        #(val_sub, ":cur_y", ":cur_y_adder"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_27", -1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_team_points_limit", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_8", 3, 1001),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_8", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_8", "$g_multiplayer_game_max_points"),

      (try_begin),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_point_gained_from_flags", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_17", 25, 401),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_17", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_17", "$g_multiplayer_point_gained_from_flags"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_17", -1),
      (try_end),

      (try_begin),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_point_gained_from_capturing_flag", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_18", 0, 11),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_18", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_18", "$g_multiplayer_point_gained_from_capturing_flag"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_18", -1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_respawn_period", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_6", multiplayer_respawn_period_min, multiplayer_respawn_period_max),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_6", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_6", "$g_multiplayer_respawn_period"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_initial_gold_multiplier", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_33", 0, 1001),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_33", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_33", "$g_multiplayer_initial_gold_multiplier"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_battle_earnings_multiplier", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_34", 0, 1001),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_34", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_34", "$g_multiplayer_battle_earnings_multiplier"),

      (try_begin),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
        (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),

        (val_sub, ":cur_y", ":cur_y_adder"),

        (create_text_overlay, reg0, "str_round_earnings_multiplier", 0),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_admin_panel_35", 0, 1001),
        (position_set_x, pos1, 390),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_35", pos1),
        (overlay_set_val, "$g_presentation_obj_admin_panel_35", "$g_multiplayer_round_earnings_multiplier"),
      (else_try),
        (assign, "$g_presentation_obj_admin_panel_35", -1),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_make_kick_voteable", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_28", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_28", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_28", "$g_multiplayer_kick_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_make_ban_voteable", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_29", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_29", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_29", "$g_multiplayer_ban_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_make_maps_voteable", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_24", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_24", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_24", "$g_multiplayer_maps_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_make_factions_voteable", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_23", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_23", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_23", "$g_multiplayer_factions_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_bots_upper_limit_for_votes", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (assign, ":upper_limit", 51),
      (val_min, ":upper_limit", "$g_multiplayer_max_num_bots"),
      (create_number_box_overlay, "$g_presentation_obj_admin_panel_22", 0, ":upper_limit"),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_22", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_22", "$g_multiplayer_num_bots_voteable"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_valid_vote_ratio", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_number_box_overlay, "$g_presentation_obj_admin_panel_30", 50, 101),
      (position_set_x, pos1, 390),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_30", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_30", "$g_multiplayer_valid_vote_ratio"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_auto_team_balance_limit", 0),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_combo_button_overlay, "$g_presentation_obj_admin_panel_31"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_admin_panel_31", pos1),
      (position_set_x, pos1, 490),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_31", pos1),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_unlimited"),
      (assign, reg0, 6),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (assign, reg0, 5),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (assign, reg0, 4),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (assign, reg0, 3),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (assign, reg0, 2),
      (overlay_add_item, "$g_presentation_obj_admin_panel_31", "str_reg0"),
      (try_begin),
        (ge, "$g_multiplayer_auto_team_balance_limit", 1000),
        (overlay_set_val, "$g_presentation_obj_admin_panel_31", 0),
      (else_try),
        (store_sub, ":set_value", 7, "$g_multiplayer_auto_team_balance_limit"),
        (overlay_set_val, "$g_presentation_obj_admin_panel_31", ":set_value"),
      (try_end),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_allow_player_banners", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_39", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_39", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_39", "$g_multiplayer_allow_player_banners"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_disallow_ranged_weapons", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_42", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_42", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_42", "$g_multiplayer_disallow_ranged_weapons"),

      (val_sub, ":cur_y", ":cur_y_adder"),

      (create_text_overlay, reg0, "str_force_default_armor", 0),
      (position_set_x, pos1, 30),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),

      (create_check_box_overlay, "$g_presentation_obj_admin_panel_40", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 7),
      (store_add, ":special_cur_y", ":cur_y", 7),
      (position_set_y, pos1, ":special_cur_y"),
      (overlay_set_position, "$g_presentation_obj_admin_panel_40", pos1),
      (overlay_set_val, "$g_presentation_obj_admin_panel_40", "$g_multiplayer_force_default_armor"),

      (set_container_overlay, -1),

      (create_button_overlay, "$g_presentation_obj_admin_panel_13", "str_back", tf_center_justify),
      (position_set_x, pos1, 825),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_admin_panel_13", pos1),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, "$g_presentation_obj_admin_panel_13", pos1),

      (create_button_overlay, "$g_presentation_obj_admin_panel_2", "str_start_map", tf_center_justify),
      (position_set_x, pos1, 825),
      (position_set_y, pos1, 90),
      (overlay_set_position, "$g_presentation_obj_admin_panel_2", pos1),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, "$g_presentation_obj_admin_panel_2", pos1),

      (presentation_set_duration, 999999),

      (try_begin),
        (eq, ":selected_map_available", 0),
        (assign, "$g_multiplayer_selected_map", ":first_map"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (try_end),
      ]),

    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":value"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_admin_panel_1"),
        (store_add, ":slot_no", ":value", multi_data_maps_for_game_type_begin),
        (troop_get_slot, "$g_multiplayer_selected_map", "trp_multiplayer_data", ":slot_no"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_2"),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_start_map, "$g_multiplayer_selected_map", "$g_multiplayer_game_type"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_3"),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_set_num_bots_in_team, 1, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_4"),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_set_num_bots_in_team, 2, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_5"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_friendly_fire, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_6"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_respawn_period, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_7"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_game_max_minutes, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_8"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_game_max_points, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_9"),
        (multiplayer_send_string_to_server, multiplayer_event_admin_set_game_password, s0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_10"),
        (assign, "$g_multiplayer_game_type", ":value"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_11"),
        (store_add, "$g_multiplayer_next_team_1_faction", ":value", npc_kingdoms_begin),
##        (try_begin),
##          (ge, "$g_multiplayer_next_team_1_faction", "$g_multiplayer_next_team_2_faction"),
##          (val_add, "$g_multiplayer_next_team_1_faction", 1),
##        (try_end),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_set_team_faction, 1, "$g_multiplayer_next_team_1_faction"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_12"),
        (store_add, "$g_multiplayer_next_team_2_faction", ":value", npc_kingdoms_begin),
##        (try_begin),
##          (ge, "$g_multiplayer_next_team_2_faction", "$g_multiplayer_next_team_1_faction"),
##          (val_add, "$g_multiplayer_next_team_2_faction", 1),
##        (try_end),
        (multiplayer_send_2_int_to_server, multiplayer_event_admin_set_team_faction, 2, "$g_multiplayer_next_team_2_faction"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_game_multiplayer_admin_panel"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_13"),
        (presentation_set_duration, 0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_14"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_add_to_servers_list, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_15"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_control_block_dir, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_16"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_round_max_seconds, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_17"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_point_gained_from_flags, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_18"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_point_gained_from_capturing_flag, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_19"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_ghost_mode, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_20"),
        (multiplayer_send_string_to_server, multiplayer_event_admin_set_server_name, s0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_21"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_max_num_players, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_22"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_num_bots_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_23"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_factions_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_24"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_maps_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_25"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_player_respawn_as_bot, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_26"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_combat_speed, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_27"),
        (store_sub, ":value_to_send", 5, ":value"), #opposite index of displayed list
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_respawn_count, ":value_to_send"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_28"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_kick_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_29"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_ban_voteable, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_30"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_valid_vote_ratio, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_31"),
        (try_begin),
          (eq, ":value", 0),
          (multiplayer_send_int_to_server, multiplayer_event_admin_set_auto_team_balance_limit, 1000),
        (else_try),
          (store_sub, ":value_to_send", 7, ":value"),
          (multiplayer_send_int_to_server, multiplayer_event_admin_set_auto_team_balance_limit, ":value_to_send"),
        (try_end),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_32"),
        (server_set_welcome_message, s0),
        (multiplayer_send_string_to_server, multiplayer_event_admin_set_welcome_message, s0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_33"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_initial_gold_multiplier, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_34"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_battle_earnings_multiplier, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_35"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_round_earnings_multiplier, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_36"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_melee_friendly_fire, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_37"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_friendly_fire_damage_self_ratio, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_38"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_friendly_fire_damage_friend_ratio, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_39"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_allow_player_banners, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_40"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_force_default_armor, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_41"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_anti_cheat, ":value"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_admin_panel_42"),
        (multiplayer_send_int_to_server, multiplayer_event_admin_set_disallow_ranged_weapons, ":value"),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_welcome_message", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),
      (str_store_welcome_message, s0),
      (try_begin),
        (neg|str_is_empty, s0),
        (eq, "$g_multiplayer_welcome_message_shown", 0),
        (create_mesh_overlay, reg0, "mesh_mp_ui_welcome_panel"),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 400),
        (overlay_set_position, reg0, pos1),
        (create_text_overlay, reg0, s0, tf_scrollable),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, 230),
        (position_set_y, pos1, 425),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 540),
        (position_set_y, pos1, 150),
        (overlay_set_area_size, reg0, pos1),

        (presentation_set_duration, 999999),
      (else_try),
        (eq, "$g_multiplayer_show_server_rules", 1),
        (create_mesh_overlay, reg0, "mesh_mp_ui_welcome_panel"),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 400),
        (overlay_set_position, reg0, pos1),
        (try_begin),
          (neg|str_is_empty, s0),
          (str_clear, s3),
          (str_store_string, s2, s0),
          (str_store_string, s2, "str_s2_s3"),
          (str_store_string, s2, "str_s2_s3"),
        (else_try),
          (str_clear, s2),
        (try_end),
        (str_store_string, s3, "@Game Rules:^"),
        (str_store_string, s2, "str_s2_s3"),
        (assign, ":end_cond", 1000),
        (call_script, "script_game_multiplayer_get_game_type_mission_template", "$g_multiplayer_game_type"),
        (assign, ":cur_mt", reg0),

        (str_store_server_name, s0),
        (str_store_string, s3, "str_server_name_s0"),
        (str_store_string, s2, "str_s2_s3"),

        (try_begin),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_deathmatch),
          (str_store_string, s0, "str_multi_game_type_1"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_team_deathmatch),
          (str_store_string, s0, "str_multi_game_type_2"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
          (str_store_string, s0, "str_multi_game_type_3"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
          (str_store_string, s0, "str_multi_game_type_4"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
          (str_store_string, s0, "str_multi_game_type_5"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
          (str_store_string, s0, "str_multi_game_type_6"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
          (str_store_string, s0, "str_multi_game_type_7"),
        (else_try),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_duel),
          (str_store_string, s0, "str_multi_game_type_8"),
        (try_end),
        (str_store_string, s3, "str_game_type_s0"),
        (str_store_string, s2, "str_s2_s3"),

        (store_current_scene, ":cur_scene"),
        (val_sub, ":cur_scene", "scn_multi_scene_1"),
        (val_add, ":cur_scene", "str_multi_scene_1"),
        (str_store_string, s0, ":cur_scene"),
        (str_store_string, s3, "str_map_name_s0"),
        (str_store_string, s2, "str_s2_s3"),

        (store_mission_timer_a, ":mission_timer"),
        (val_add, ":mission_timer", "$server_mission_timer_while_player_joined"),
        (assign, reg0, ":mission_timer"),
        (store_mul, "$g_multiplayer_game_max_seconds", "$g_multiplayer_game_max_minutes", 60),
        (store_sub, ":remaining_seconds", "$g_multiplayer_game_max_seconds", ":mission_timer"),
        (store_div, reg0, ":remaining_seconds", 60),
        (store_mod, reg1, ":remaining_seconds", 60),
        (try_begin),
          (ge, reg0, 10),
          (ge, reg1, 10),
          (str_clear, s0),
          (str_clear, s1),
        (else_try),
          (ge, reg0, 10),
          (str_clear, s0),
          (str_store_string, s1, "@0"),
        (else_try),
          (ge, reg1, 10),
          (str_store_string, s0, "@0"),
          (str_clear, s1),
        (else_try),
          (str_store_string, s0, "@0"),
          (str_store_string, s1, "@0"),
        (try_end),
        (str_store_string, s3, "str_remaining_time_s0reg0_s1reg1"),

        (str_store_string, s2, "str_s2_s3"),

        (try_for_range, ":cur_option", 0, ":end_cond"),
          (assign, reg0, -12345), #magic number
          (call_script, "script_game_get_multiplayer_server_option_for_mission_template", ":cur_mt", ":cur_option"),
          (try_begin),
            (eq, reg0, -12345),
            (assign, ":end_cond", 0),
          (else_try),
            (call_script, "script_game_multiplayer_server_option_for_mission_template_to_string", ":cur_mt", ":cur_option", reg0),
            (str_store_string, s3, s0),
            (str_store_string, s2, "str_s2_s3"),
          (try_end),
        (try_end),
        (create_text_overlay, reg0, s2, tf_scrollable),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, 230),
        (position_set_y, pos1, 425),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 540),
        (position_set_y, pos1, 150),
        (overlay_set_area_size, reg0, pos1),

        (presentation_set_duration, 999999),
      (try_end),
      ]),

    (ti_on_presentation_run,
     [
       (str_store_welcome_message, s0),
       (try_begin),
         (neq, "$g_multiplayer_show_server_rules", 1),
         (this_or_next|str_is_empty, s0),
         (eq, "$g_multiplayer_welcome_message_shown", 1),
         (presentation_set_duration, 0),
         (neg|is_presentation_active, "prsnt_multiplayer_escape_menu"),
         (neg|is_presentation_active, "prsnt_multiplayer_team_select"),
         (start_presentation, "prsnt_multiplayer_team_select"),
       (else_try),
         (store_mission_timer_a, ":mission_timer"),
         (gt, ":mission_timer", 1),
         (this_or_next|key_clicked, key_escape),
         (this_or_next|key_clicked, key_space),
         (this_or_next|key_clicked, key_enter),
         (this_or_next|key_clicked, key_left_mouse_button),
         (this_or_next|key_clicked, key_right_mouse_button),
         (this_or_next|key_clicked, key_xbox_ltrigger),
         (key_clicked, key_xbox_rtrigger),
         (assign, "$g_multiplayer_welcome_message_shown", 1),
         (presentation_set_duration, 0),
         (neg|is_presentation_active, "prsnt_multiplayer_escape_menu"),
         (neg|is_presentation_active, "prsnt_multiplayer_team_select"),
         (try_begin),
           (eq, "$g_multiplayer_show_server_rules", 1),
           (assign, "$g_multiplayer_show_server_rules", 0),
           (start_presentation, "prsnt_multiplayer_escape_menu"),
         (else_try),
           (start_presentation, "prsnt_multiplayer_team_select"),
         (try_end),
       (try_end),
      ]),
    ]),

  ("multiplayer_team_select", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_team_select_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_team_select_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_team_select_container", pos1),
      (set_container_overlay, "$g_presentation_obj_team_select_container"),

      (assign, ":cur_y", 450),

      (create_text_overlay, reg0, "str_choose_a_faction", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (position_set_x, pos1, 100),

      (multiplayer_get_my_player, ":my_player_no"),
      (team_get_faction, ":faction_no", 0),
      (str_store_faction_name, s0, ":faction_no"),
      (create_button_overlay, "$g_presentation_obj_team_select_1", s0, 0),
      (try_begin),
        (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 0),
        (overlay_set_color, "$g_presentation_obj_team_select_1", 0xFFFFFF),
        (overlay_set_hilight_color, "$g_presentation_obj_team_select_1", 0x55FF50),
        (assign, "$g_multiplayer_team_select_1_available", 1),
      (else_try),
        (overlay_set_color, "$g_presentation_obj_team_select_1", 0x888888),
        (overlay_set_hilight_color, "$g_presentation_obj_team_select_1", 0x888888),
        (assign, "$g_multiplayer_team_select_1_available", 0),
      (try_end),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_team_select_1", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),

      (team_get_faction, ":faction_no", 1),
      (str_store_faction_name, s0, ":faction_no"),
      (create_button_overlay, "$g_presentation_obj_team_select_2", s0, 0),
      (try_begin),
        (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 1),
        (overlay_set_color, "$g_presentation_obj_team_select_2", 0xFFFFFF),
        (overlay_set_hilight_color, "$g_presentation_obj_team_select_2", 0x55FF50),
        (assign, "$g_multiplayer_team_select_2_available", 1),
      (else_try),
        (overlay_set_color, "$g_presentation_obj_team_select_2", 0x888888),
        (overlay_set_hilight_color, "$g_presentation_obj_team_select_2", 0x888888),
        (assign, "$g_multiplayer_team_select_2_available", 0),
      (try_end),
      (overlay_set_position, "$g_presentation_obj_team_select_2", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),

      (create_button_overlay, "$g_presentation_obj_team_select_3", "str_spectator", 0),
      (overlay_set_color, "$g_presentation_obj_team_select_3", 0xFFFFFF),
      (overlay_set_position, "$g_presentation_obj_team_select_3", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),

      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (multiplayer_get_my_player, ":my_player_no"),
      (try_begin),
        (eq, "$g_waiting_for_confirmation_to_terminate", 0),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_team_select_1"),
          (try_begin),
            (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 0),
            (try_begin),
              (player_get_team_no, ":my_team", ":my_player_no"),
              (neq, ":my_team", 0),
              (assign, "$g_confirmation_result", 0),
              (assign, "$g_waiting_for_confirmation_to_terminate", 1),
              (player_get_troop_id, "$g_confirmation_troop_backup", ":my_player_no"),
              (player_get_team_no, "$g_confirmation_team_backup", ":my_player_no"),
              (player_set_troop_id, ":my_player_no", -1),
              (multiplayer_send_int_to_server, multiplayer_event_change_team_no, 0),
              (player_set_team_no, ":my_player_no", 0),
            (else_try),
              (presentation_set_duration, 0),
              (start_presentation, "prsnt_multiplayer_troop_select"),
            (try_end),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_team_select_2"),
          (try_begin),
            (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 1),
            (try_begin),
              (player_get_team_no, ":my_team", ":my_player_no"),
              (neq, ":my_team", 1),
              (assign, "$g_confirmation_result", 0),
              (assign, "$g_waiting_for_confirmation_to_terminate", 1),
              (player_get_troop_id, "$g_confirmation_troop_backup", ":my_player_no"),
              (player_get_team_no, "$g_confirmation_team_backup", ":my_player_no"),
              (player_set_troop_id, ":my_player_no", -1),
              (multiplayer_send_int_to_server, multiplayer_event_change_team_no, 1),
              (player_set_team_no, ":my_player_no", 1),
            (else_try),
              (presentation_set_duration, 0),
              (start_presentation, "prsnt_multiplayer_troop_select"),
            (try_end),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_team_select_3"),
          (player_set_troop_id, ":my_player_no", -1),
          (multiplayer_send_int_to_server, multiplayer_event_change_team_no, multi_team_spectator),
          (player_set_team_no, ":my_player_no", multi_team_spectator),
          (presentation_set_duration, 0),
        (try_end),
      (try_end),
      ]),

    (ti_on_presentation_run,
     [
      (multiplayer_get_my_player, ":my_player_no"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (eq, "$g_waiting_for_confirmation_to_terminate", 0),
        (multiplayer_get_my_team, ":my_team"),
        (try_begin),
          (eq, ":my_team", multi_team_unassigned),
          (player_set_troop_id, ":my_player_no", -1),
          (multiplayer_send_int_to_server, multiplayer_event_change_team_no, multi_team_spectator),
          (player_set_team_no, ":my_player_no", multi_team_spectator),
        (try_end),
        (presentation_set_duration, 0),
      (else_try),
        (eq, "$g_waiting_for_confirmation_to_terminate", 1),
        (eq, "$g_confirmation_result", 1),
        (assign, "$g_waiting_for_confirmation_to_terminate", 0),
        (assign, "$g_confirmation_result", 0),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_troop_select"),
      (else_try),
        (eq, "$g_waiting_for_confirmation_to_terminate", 1),
        (eq, "$g_confirmation_result", -1),
        #return troop and team back to the old state
        (player_set_troop_id, ":my_player_no", "$g_confirmation_troop_backup"),
        (player_set_team_no, ":my_player_no", "$g_confirmation_team_backup"),
        (assign, "$g_waiting_for_confirmation_to_terminate", 0),
        (assign, "$g_confirmation_result", 0),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_team_select"),
      (else_try),
        (assign, ":do_refresh", 0),
        (try_begin),
          (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 0),
          (try_begin),
            (eq, "$g_multiplayer_team_select_1_available", 0),
            (assign, ":do_refresh", 1),
          (try_end),
        (else_try),
          #not available
          (try_begin),
            (eq, "$g_multiplayer_team_select_1_available", 1),
            (assign, ":do_refresh", 1),
          (try_end),
        (try_end),
        (try_begin),
          (call_script, "script_cf_multiplayer_team_is_available", ":my_player_no", 1),
          (try_begin),
            (eq, "$g_multiplayer_team_select_2_available", 0),
            (assign, ":do_refresh", 1),
          (try_end),
        (else_try),
          #not available
          (try_begin),
            (eq, "$g_multiplayer_team_select_2_available", 1),
            (assign, ":do_refresh", 1),
          (try_end),
        (try_end),
        (eq, ":do_refresh", 1),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_team_select"),
      (try_end),
      ]),
    ]),

  ("multiplayer_troop_select", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_troop_select_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_troop_select_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_troop_select_container", pos1),
      (set_container_overlay, "$g_presentation_obj_troop_select_container"),

      (assign, ":cur_y", 450),

      (create_text_overlay, reg0, "str_choose_a_troop", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (position_set_x, pos1, 100),

      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_team_no, ":my_team_no", ":my_player_no"),
      (team_get_faction, ":my_faction_no", ":my_team_no"),
      (try_for_range, ":i_multi", multi_data_troop_button_indices_begin, multi_data_troop_button_indices_end),
        (troop_set_slot, "trp_multiplayer_data", ":i_multi", -1),
      (try_end),

      (assign, ":cur_troop_index", 0),
      (try_for_range, ":troop_no", multiplayer_troops_begin, multiplayer_troops_end),
        (store_troop_faction, ":troop_faction", ":troop_no"),
        (eq, ":troop_faction", ":my_faction_no"),
        (str_store_troop_name, s1, ":troop_no"),
        (create_button_overlay, reg0, s1, 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":button_index_slot", ":cur_troop_index", multi_data_troop_button_indices_begin),
        (troop_set_slot, "trp_multiplayer_data", ":button_index_slot", reg0),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (val_add, ":cur_troop_index", 1),
      (try_end),
      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_team_no, ":my_team_no", ":my_player_no"),
      (team_get_faction, ":my_faction_no", ":my_team_no"),
      (assign, ":selected_troop_no", -1),
      (assign, ":end_cond", multi_data_troop_button_indices_end),
      (try_for_range, ":i_button", multi_data_troop_button_indices_begin, ":end_cond"),
        (troop_slot_eq, "trp_multiplayer_data", ":i_button", ":object"),
        (store_sub, ":selected_troop_index", ":i_button", multi_data_troop_button_indices_begin),
        (assign, ":end_cond_2", multiplayer_troops_end),
        (try_for_range, ":troop_no", multiplayer_troops_begin, ":end_cond_2"),
          (store_troop_faction, ":troop_faction", ":troop_no"),
          (eq, ":troop_faction", ":my_faction_no"),
          (val_sub, ":selected_troop_index", 1),
          (lt, ":selected_troop_index", 0),
          (assign, ":selected_troop_no", ":troop_no"),
          (assign, ":end_cond_2", 0), #break
        (try_end),
        (try_begin),
          (multiplayer_get_my_troop, ":troop_no"),
          (neq, ":troop_no", ":selected_troop_no"),
          (player_set_troop_id, ":my_player_no", ":selected_troop_no"),
          (multiplayer_send_int_to_server, multiplayer_event_change_troop_id, ":selected_troop_no"),
          (call_script, "script_multiplayer_set_default_item_selections_for_troop", ":selected_troop_no"),
          (call_script, "script_multiplayer_send_item_selections"),
        (try_end),
        (presentation_set_duration, 0),
        (assign, "$g_presentation_state", 0),
        (start_presentation, "prsnt_multiplayer_item_select"),
        (assign, ":end_cond", 0), #break
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (multiplayer_get_my_player, ":my_player_no"),
        (is_between, ":my_player_no", 0, multiplayer_max_possible_player_id),
        (multiplayer_get_my_troop, ":my_troop"),
        (try_begin),
          (neg|is_between, ":my_troop", multiplayer_troops_begin, multiplayer_troops_end),
          (player_set_troop_id, ":my_player_no", -1),
          (multiplayer_send_int_to_server, multiplayer_event_change_troop_id, -1),
          (multiplayer_send_int_to_server, multiplayer_event_change_team_no, multi_team_spectator),
          (player_set_team_no, ":my_player_no", multi_team_spectator),
        (try_end),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_item_select", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),
      (multiplayer_get_my_player, ":my_player_no"),

      (assign, "$g_presentation_obj_item_select_1", -1),
      (assign, "$g_presentation_obj_item_select_2", -1),
      (assign, "$g_presentation_obj_item_select_3", -1),
      (assign, "$g_presentation_obj_item_select_4", -1),
      (assign, "$g_presentation_obj_item_select_5", -1),
      (assign, "$g_presentation_obj_item_select_6", -1),
      (assign, "$g_presentation_obj_item_select_7", -1),
      (assign, "$g_presentation_obj_item_select_8", -1),
      (assign, "$g_presentation_obj_item_select_9", -1),
      (assign, "$g_presentation_obj_item_select_10", -1),
      (assign, "$g_presentation_obj_item_select_11", -1),
      (assign, "$g_presentation_obj_item_select_12", -1),
      (assign, "$g_presentation_obj_item_select_13", -1),
      (assign, "$g_presentation_obj_item_select_14", -1),
      (assign, "$g_presentation_obj_item_select_15", -1),
      (assign, "$g_presentation_obj_item_select_16", -1),

      (try_begin),
        (neq, "$g_current_opened_item_details", -1),
        (close_item_details),
        (assign, "$g_current_opened_item_details", -1),
      (try_end),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 0),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_1", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 526),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_1", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_1", "mesh_mp_inventory_slot_equip", "mesh_mp_inventory_slot_equip"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_1", pos1),
      (position_set_x, pos1, 899),
      (position_set_y, pos1, 475),
      (overlay_set_position, "$g_presentation_obj_item_select_1", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 1),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_2", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 426),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_2", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_2", "mesh_mp_inventory_slot_equip", "mesh_mp_inventory_slot_equip"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_2", pos1),
      (position_set_x, pos1, 899),
      (position_set_y, pos1, 375),
      (overlay_set_position, "$g_presentation_obj_item_select_2", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 2),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_3", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 326),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_3", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_3", "mesh_mp_inventory_slot_equip", "mesh_mp_inventory_slot_equip"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_3", pos1),
      (position_set_x, pos1, 899),
      (position_set_y, pos1, 275),
      (overlay_set_position, "$g_presentation_obj_item_select_3", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 3),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_4", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 226),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_4", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_4", "mesh_mp_inventory_slot_equip", "mesh_mp_inventory_slot_equip"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_4", pos1),
      (position_set_x, pos1, 899),
      (position_set_y, pos1, 175),
      (overlay_set_position, "$g_presentation_obj_item_select_4", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 4),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_5", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 576),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_5", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_5", "mesh_mp_inventory_slot_helmet", "mesh_mp_inventory_slot_helmet"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_5", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 525),
      (overlay_set_position, "$g_presentation_obj_item_select_5", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 5),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_6", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 476),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_6", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_6", "mesh_mp_inventory_slot_armor", "mesh_mp_inventory_slot_armor"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_6", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 425),
      (overlay_set_position, "$g_presentation_obj_item_select_6", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 6),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_7", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 376),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_7", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_7", "mesh_mp_inventory_slot_boot", "mesh_mp_inventory_slot_boot"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_7", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 325),
      (overlay_set_position, "$g_presentation_obj_item_select_7", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 7),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (create_image_button_overlay, "$g_presentation_obj_item_select_8", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 276),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_8", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_8", "mesh_mp_inventory_slot_glove", "mesh_mp_inventory_slot_glove"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_8", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 225),
      (overlay_set_position, "$g_presentation_obj_item_select_8", pos1),

      (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 8),
      (player_get_slot, ":selected_item_id", ":my_player_no", ":selected_item_index"),
      (try_begin),
        (ge, ":selected_item_id", 0),
        (eq, "$g_horses_are_avaliable", 1),
        (create_image_button_overlay, "$g_presentation_obj_item_select_9", "mesh_mp_inventory_slot_empty", "mesh_mp_inventory_slot_empty"),
        (create_mesh_overlay_with_item_id, reg0, ":selected_item_id"),
        (position_set_x, pos1, 53),
        (position_set_y, pos1, 176),
        (overlay_set_position, reg0, pos1),
        (assign, "$g_inside_obj_9", reg0),
      (else_try),
        (create_image_button_overlay, "$g_presentation_obj_item_select_9", "mesh_mp_inventory_slot_horse", "mesh_mp_inventory_slot_horse"),
      (try_end),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_item_select_9", pos1),
      (position_set_x, pos1, 2),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_item_select_9", pos1),

      (create_mesh_overlay, reg0, "mesh_mp_inventory_left"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, 14),
      (overlay_set_position, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_mp_inventory_right"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 894),
      (position_set_y, pos1, 65),
      (overlay_set_position, reg0, pos1),

      (create_in_game_button_overlay, "$g_presentation_obj_item_select_10", "str_reset_to_default", 0),
      (overlay_set_color, "$g_presentation_obj_item_select_10", 0xFFFFFF),
      (position_set_x, pos1, 605),
      (position_set_y, pos1, 25),
      (overlay_set_position, "$g_presentation_obj_item_select_10", pos1),

      (create_in_game_button_overlay, "$g_presentation_obj_item_select_11", "str_done", 0),
      (overlay_set_color, "$g_presentation_obj_item_select_11", 0xFFFFFF),
      (position_set_x, pos1, 395),
      (position_set_y, pos1, 25),
      (overlay_set_position, "$g_presentation_obj_item_select_11", pos1),

      (assign, ":cur_y", 725),
      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_team_no, ":my_team_no", ":my_player_no"),
      (assign, ":has_bots", 0),
      (try_begin),
        (eq, ":my_team_no", 0),
        (try_begin),
          (gt, "$g_multiplayer_num_bots_team_1", 0),
          (assign, ":has_bots", 1),
        (try_end),
      (else_try),
        (try_begin),
          (gt, "$g_multiplayer_num_bots_team_2", 0),
          (assign, ":has_bots", 1),
        (try_end),
      (try_end),
      (team_get_faction, ":my_faction_no", ":my_team_no"),

      (try_begin),
        (eq, ":has_bots", 1),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_deathmatch),
        (neq, "$g_multiplayer_game_type", multiplayer_game_type_duel),

        (assign, ":num_lines", 0),
        (try_begin),
          (eq, ":has_bots", 1),
          (try_for_range, ":ai_troop_no", multiplayer_ai_troops_begin, multiplayer_ai_troops_end),
            (store_troop_faction, ":ai_troop_faction", ":ai_troop_no"),
            (eq, ":ai_troop_faction", ":my_faction_no"),
            (val_add, ":num_lines", 1),
          (try_end),
        (try_end),

        (store_mul, ":board_height", ":num_lines", 20),
        (val_add, ":board_height", 40),

        (create_mesh_overlay, reg0, "mesh_mp_ui_command_border_r"),
        (position_set_x, pos1, 280),
        (position_set_y, pos1, 680),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 2500),
        (position_set_y, pos1, 2500),
        (overlay_set_size, reg0, pos1),

        (create_mesh_overlay, reg0, "mesh_mp_ui_command_border_l"),
        (position_set_x, pos1, 650),
        (position_set_y, pos1, 680),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 2500),
        (position_set_y, pos1, 2500),
        (overlay_set_size, reg0, pos1),

        (create_mesh_overlay, reg0, "mesh_mp_ui_command_panel"),
        (position_set_x, pos1, 350),
        (store_sub, ":board_pos_y", 750, ":board_height"),
        (position_set_y, pos1, ":board_pos_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 3000),
        (position_set_y, pos1, 3000),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_command", 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 370),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (val_sub, ":cur_y", 20),

        (assign, ":cur_ai_troop_index", 0),
        (try_for_range, ":ai_troop_no", multiplayer_ai_troops_begin, multiplayer_ai_troops_end),
          (store_troop_faction, ":ai_troop_faction", ":ai_troop_no"),
          (eq, ":ai_troop_faction", ":my_faction_no"),

          (create_check_box_overlay, reg0, "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 377),
          (store_add, ":special_cur_y", ":cur_y", 2),
          (position_set_y, pos1, ":special_cur_y"),
          (overlay_set_position, reg0, pos1),
          (try_begin),
            (eq, ":cur_ai_troop_index", 0),
            (overlay_set_val, reg0, "$g_multiplayer_bot_type_1_wanted"),
            (assign, "$g_presentation_obj_item_select_13", reg0),
          (else_try),
            (eq, ":cur_ai_troop_index", 1),
            (overlay_set_val, reg0, "$g_multiplayer_bot_type_2_wanted"),
            (assign, "$g_presentation_obj_item_select_14", reg0),
          (else_try),
            (eq, ":cur_ai_troop_index", 2),
            (overlay_set_val, reg0, "$g_multiplayer_bot_type_3_wanted"),
            (assign, "$g_presentation_obj_item_select_15", reg0),
          (else_try),
            (overlay_set_val, reg0, "$g_multiplayer_bot_type_4_wanted"),
            (assign, "$g_presentation_obj_item_select_16", reg0),
          (try_end),

          (str_store_troop_name, s0, ":ai_troop_no"),
          (create_text_overlay, reg0, "str_s0", 0),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 397),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),
          (val_add, ":cur_ai_troop_index", 1),
        (try_end),
        (val_sub, ":cur_y", 20),
      (try_end),

      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_gold, ":player_gold", ":my_player_no"),
      (call_script, "script_multiplayer_calculate_cur_selected_items_cost", ":my_player_no", 1),
      (create_text_overlay, "$g_presentation_obj_item_select_12", "str_total_item_cost_reg0", tf_left_align|tf_single_line|tf_with_outline),
      (try_begin),
        (ge, ":player_gold", reg0),
        (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFFFFFF),
      (else_try),
        (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFF0000),
      (try_end),
      (position_set_x, pos1, 680),
      (position_set_y, pos1, 652),
      (overlay_set_position, "$g_presentation_obj_item_select_12", pos1),

      (store_add, "$g_presentation_obj_item_select_next", "$g_presentation_obj_item_select_12", 1),

      (player_get_troop_id, ":my_troop_no", ":my_player_no"),
      (try_begin),
        (eq, "$g_presentation_state", 1),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_weapons_begin, multi_item_class_type_weapons_end, 781, 474),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_right_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 881),
        (position_set_y, pos1, 515),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 2),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_weapons_begin, multi_item_class_type_weapons_end, 781, 374),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_right_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 881),
        (position_set_y, pos1, 415),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 3),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_weapons_begin, multi_item_class_type_weapons_end, 781, 274),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_right_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 881),
        (position_set_y, pos1, 315),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 4),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_weapons_begin, multi_item_class_type_weapons_end, 781, 174),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_right_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 881),
        (position_set_y, pos1, 215),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 5),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_heads_begin, multi_item_class_type_heads_end, 117, 524),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 565),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 6),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_bodies_begin, multi_item_class_type_bodies_end, 117, 424),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 465),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 7),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_feet_begin, multi_item_class_type_feet_end, 117, 324),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 365),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 8),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_gloves_begin, multi_item_class_type_gloves_end, 117, 224),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 265),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (eq, "$g_presentation_state", 9),
        (eq, "$g_horses_are_avaliable", 1),
        (call_script, "script_multiplayer_display_available_items_for_troop_and_item_classes", ":my_troop_no", multi_item_class_type_horses_begin, multi_item_class_type_horses_end, 117, 124),
        (create_mesh_overlay, reg0, "mesh_mp_inventory_left_arrow"),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 106),
        (position_set_y, pos1, 165),
        (overlay_set_position, reg0, pos1),
      (try_end),
      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_mouse_enter_leave,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":enter_leave"),

        (try_begin),
          (eq, "$g_close_equipment_selection", 0),
          (try_begin),
            (eq, ":enter_leave", 0),

            (assign, ":item_no", -1),
            (try_begin),
              (ge, ":object", "$g_presentation_obj_item_select_next"),
              (store_sub, ":tested_object", ":object", "$g_presentation_obj_item_select_next"),
              (store_mod, ":mod_value", ":tested_object", 2),
              (store_sub, ":mod_value", 1, ":mod_value"),
              (val_div, ":tested_object", 2),
              (store_add, ":cur_slot", multi_data_item_button_indices_begin, ":tested_object"),
              (troop_get_slot, ":item_no", "trp_multiplayer_data", ":cur_slot"),

              (assign, ":target_obj", ":object"),
              (val_add, ":target_obj", ":mod_value"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_1"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 1),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_1"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_2"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 2),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_2"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_3"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 3),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_3"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_4"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 4),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_4"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_5"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 5),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_5"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_6"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 6),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_6"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_7"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 7),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_7"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_8"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 8),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_8"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_9"),
              (eq, "$g_horses_are_avaliable", 1),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 9),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_9"),
            (try_end),

            (try_begin),
              (ge, ":item_no", 0),
              (overlay_get_position, pos0, ":target_obj"),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_troop_id, ":my_player_troop_no", ":my_player_no"),
              (try_begin),
                (call_script, "script_cf_multiplayer_is_item_default_for_troop", ":item_no", ":my_player_troop_no"),
                (show_item_details, ":item_no", pos0, 0),
              (else_try),
                (store_troop_faction, ":my_player_faction_no", ":my_player_troop_no"),
                (store_sub, ":faction_slot", ":my_player_faction_no", npc_kingdoms_begin),
                (val_add, ":faction_slot", slot_item_multiplayer_faction_price_multipliers_begin),
                (item_get_slot, ":price_multiplier", ":item_no", ":faction_slot"),
                (show_item_details, ":item_no", pos0, ":price_multiplier"),
              (try_end),
              (assign, "$g_current_opened_item_details", ":item_no"),
            (try_end),
          (else_try),
            (assign, ":item_no", -1),
            (try_begin),
              (ge, ":object", "$g_presentation_obj_item_select_next"),
              (store_sub, ":tested_object", ":object", "$g_presentation_obj_item_select_next"),
              (val_div, ":tested_object", 2),
              (store_add, ":cur_slot", multi_data_item_button_indices_begin, ":tested_object"),
              (troop_get_slot, ":item_no", "trp_multiplayer_data", ":cur_slot"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_1"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 1),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_1"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_2"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 2),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_2"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_3"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 3),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_3"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_4"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 4),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_4"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_5"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 5),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_5"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_6"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 6),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_6"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_7"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 7),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_7"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_8"),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 8),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_8"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_9"),
              (eq, "$g_horses_are_avaliable", 1),
              (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, 9),
              (val_sub, ":player_slot_index", 1),
              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_slot, ":item_no", ":my_player_no", ":player_slot_index"),
              (assign, ":target_obj", "$g_inside_obj_9"),
            (try_end),

            (try_begin),
              (eq, "$g_current_opened_item_details", ":item_no"),
              (close_item_details),
              (assign, "$g_current_opened_item_details", -1),
            (try_end),
          (try_end),
        (else_try),
          (assign, "$g_close_equipment_selection", 0),
          (presentation_set_duration, 0),
        (try_end),
      ]),

    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":value"),
      (multiplayer_get_my_player, ":my_player_no"),
      (player_get_troop_id, ":my_troop_no", ":my_player_no"),

      (try_begin),
        (eq, "$g_close_equipment_selection", 0),
        (try_begin),
          (eq, "$g_presentation_state", 0),
          (try_begin),
            (eq, ":object", "$g_presentation_obj_item_select_1"),
            (assign, "$g_presentation_state", 1),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_2"),
            (assign, "$g_presentation_state", 2),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_3"),
            (assign, "$g_presentation_state", 3),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_4"),
            (assign, "$g_presentation_state", 4),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_5"),
            (assign, "$g_presentation_state", 5),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_6"),
            (assign, "$g_presentation_state", 6),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_7"),
            (assign, "$g_presentation_state", 7),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_8"),
            (assign, "$g_presentation_state", 8),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (else_try),
            (eq, ":object", "$g_presentation_obj_item_select_9"),
            (eq, "$g_horses_are_avaliable", 1),
            (assign, "$g_presentation_state", 9),
            (presentation_set_duration, 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (try_end),
        (else_try),
          (gt, "$g_presentation_state", 0),
          (store_sub, ":tested_object", ":object", "$g_presentation_obj_item_select_next"),
          (val_div, ":tested_object", 2),
          (assign, ":end_cond", multi_data_item_button_indices_end),
          (try_for_range, ":cur_slot", multi_data_item_button_indices_begin, ":end_cond"),
            (neg|troop_slot_eq, "trp_multiplayer_data", ":cur_slot", -1),
            (store_sub, ":button_id", ":cur_slot", multi_data_item_button_indices_begin),
            (eq, ":tested_object", ":button_id"),
            (troop_get_slot, ":item_no", "trp_multiplayer_data", ":cur_slot"),

            (store_add, ":player_slot_index", slot_player_selected_item_indices_begin, "$g_presentation_state"),
            (val_sub, ":player_slot_index", 1),
            (player_set_slot, ":my_player_no", ":player_slot_index", ":item_no"),

            (player_get_gold, ":player_gold", ":my_player_no"),
            (call_script, "script_multiplayer_calculate_cur_selected_items_cost", ":my_player_no", 1),
            (overlay_set_text, "$g_presentation_obj_item_select_12", "str_total_item_cost_reg0"),
            (try_begin),
              (ge, ":player_gold", reg0),
              (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFFFFFF),
            (else_try),
              (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFF0000),
            (try_end),

            (assign, ":end_cond", 0), #break
          (try_end),
          (presentation_set_duration, 0),
          (assign, "$g_presentation_state", 0),
          (start_presentation, "prsnt_multiplayer_item_select"),
        (try_end),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_item_select_10"),
          (call_script, "script_multiplayer_set_default_item_selections_for_troop", ":my_troop_no"),
          (presentation_set_duration, 0),
          (assign, "$g_presentation_state", 0),
          (start_presentation, "prsnt_multiplayer_item_select"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_11"),
          (call_script, "script_multiplayer_send_item_selections"),
          (presentation_set_duration, 0),

          (try_begin),
            (try_begin),
              (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
              (gt, "$g_multiplayer_number_of_respawn_count", 0),

              (ge, "$g_my_spawn_count", "$g_multiplayer_number_of_respawn_count"),

              (multiplayer_get_my_player, ":my_player_no"),
              (player_get_team_no, ":my_player_team", ":my_player_no"),

              (this_or_next|eq, ":my_player_team", 0),
              (ge, "$g_my_spawn_count", 999),

              (assign, "$g_show_no_more_respawns_remained", 1),
            (else_try),
              (assign, "$g_show_no_more_respawns_remained", 0),
            (try_end),

            (eq, "$g_show_no_more_respawns_remained", 1),

            (store_mission_timer_a, "$g_multiplayer_respawn_start_time"),
            (start_presentation, "prsnt_multiplayer_respawn_time_counter"),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_13"),
          (assign, "$g_multiplayer_bot_type_1_wanted", ":value"),
          (multiplayer_send_2_int_to_server, multiplayer_event_set_bot_selection, slot_player_bot_type_1_wanted, ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_14"),
          (assign, "$g_multiplayer_bot_type_2_wanted", ":value"),
          (multiplayer_send_2_int_to_server, multiplayer_event_set_bot_selection, slot_player_bot_type_2_wanted, ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_15"),
          (assign, "$g_multiplayer_bot_type_3_wanted", ":value"),
          (multiplayer_send_2_int_to_server, multiplayer_event_set_bot_selection, slot_player_bot_type_3_wanted, ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_item_select_16"),
          (assign, "$g_multiplayer_bot_type_4_wanted", ":value"),
          (multiplayer_send_2_int_to_server, multiplayer_event_set_bot_selection, slot_player_bot_type_4_wanted, ":value"),
        (try_end),
      (else_try),
        (assign, "$g_close_equipment_selection", 0),
        (presentation_set_duration, 0),
      (try_end),
      ]),

    (ti_on_presentation_mouse_press,
     [(store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":mouse_state"),

      (try_begin),
        (eq, "$g_close_equipment_selection", 0),
        (try_begin),
          (eq, ":mouse_state", 1), #right click (clears the item slot)
          (try_begin),
            (eq, "$g_presentation_state", 0),
            (multiplayer_get_my_player, ":my_player_no"),
            (try_begin),
              (eq, ":object", "$g_presentation_obj_item_select_1"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 0),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_2"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 1),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_3"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 2),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_4"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 3),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_5"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 4),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_6"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 5),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_7"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 6),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_8"),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 7),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (else_try),
              (eq, ":object", "$g_presentation_obj_item_select_9"),
              (eq, "$g_horses_are_avaliable", 1),
              (store_add, ":selected_item_index", slot_player_selected_item_indices_begin, 8),
              (player_set_slot, ":my_player_no", ":selected_item_index", -1),
              (presentation_set_duration, 0),
              (assign, "$g_presentation_state", 0),
              (start_presentation, "prsnt_multiplayer_item_select"),
            (try_end),
          (else_try),
            (gt, "$g_presentation_state", 0),
            (presentation_set_duration, 0),
            (assign, "$g_presentation_state", 0),
            (start_presentation, "prsnt_multiplayer_item_select"),
          (try_end),
        (try_end),
      (else_try),
        (assign, "$g_close_equipment_selection", 0),
        (presentation_set_duration, 0),
      (try_end),
      ]),

    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),

## this causes an error sometimes
##      (multiplayer_get_my_player, ":my_player_no"),
##      (player_get_gold, ":player_gold", ":my_player_no"),
##      (call_script, "script_multiplayer_calculate_cur_selected_items_cost", ":my_player_no", 1),
##      (try_begin),
##        (ge, ":player_gold", reg0),
##        (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFFFFFF),
##      (else_try),
##        (overlay_set_color, "$g_presentation_obj_item_select_12", 0xFF0000),
##      (try_end),

      (try_begin),
        (eq, "$g_close_equipment_selection", 0),
        (try_begin),
          (this_or_next|key_clicked, key_escape),
		  (key_clicked, key_xbox_start),
          (try_begin),
            (neq, "$g_current_opened_item_details", -1),
            (close_item_details),
            (assign, "$g_current_opened_item_details", -1),
          (try_end),
          (gt, ":cur_time", 200),
          (presentation_set_duration, 0),
        (try_end),
      (else_try),
        (assign, "$g_close_equipment_selection", 0),
        #daha sonra buraya siege modundaysa ve takimini yeni degistirdigi icin spawn olamiyorsa start_presentation, spawn_counter satirini ekle sdsd.
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_message_1", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_result_in_battle_mode),
        (assign, ":winner_agent_team", "$g_multiplayer_message_value_1"),

        (try_begin),
          (eq, ":winner_agent_team", -1),
          (assign, ":text_font_color", 0xFFFFFFFF),

          (str_store_string, s0, "str_round_draw_no_one_remained"),
        (else_try),
          (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
            (eq, ":winner_agent_team", 0),
            (assign, ":text_font_color", 0xFF33DD11),
          (else_try),
            (assign, ":text_font_color", 0xFFFF4422),
          (try_end), #initializing ends
          (try_begin),
            (lt, "$my_team_at_start_of_round", 2),
            (try_begin),
              (eq, "$my_team_at_start_of_round", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),

          (team_get_faction, ":faction_of_winner_team", ":winner_agent_team"),
          (str_store_faction_name, s1, ":faction_of_winner_team"),
          (str_store_string, s0, "str_s1_won_round"),
        (try_end),

        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (try_begin),
          (neq, ":winner_agent_team", -1),
          (position_set_x, pos1, 375), #375
        (else_try),
          (position_set_x, pos1, 400), #400
        (try_end),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 300),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_capture_the_flag_score),

        (agent_get_team, ":winner_agent_team", "$g_multiplayer_message_value_1"), #assign given agent's team to winner agent team.
        (team_get_faction, ":winner_agent_faction", ":winner_agent_team"),
        (str_store_faction_name, s1, ":winner_agent_faction"),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
              (play_sound, "snd_team_scored_a_point"),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
              (play_sound, "snd_enemy_scored_a_point"),
            (try_end),
          (try_end),
        (try_end),

        (str_store_string, s0, "str_s1_captured_flag"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_flag_returned_home),

        (try_begin),
          (ge, "$g_multiplayer_message_value_1", 0),
          (agent_get_team, ":returned_flag_agent_team", "$g_multiplayer_message_value_1"),
          (team_get_faction, ":returned_flag_agent_faction", ":returned_flag_agent_team"),
          (str_store_faction_name, s1, ":returned_flag_agent_faction"),
          (str_store_string, s0, "str_s1_returned_flag"),
        (else_try),
          (val_add, "$g_multiplayer_message_value_1", 1),
          (val_mul, "$g_multiplayer_message_value_1", -1),
          (assign, ":returned_flag_agent_team", "$g_multiplayer_message_value_1"),
          (team_get_faction, ":returned_flag_agent_faction", ":returned_flag_agent_team"),
          (str_store_faction_name, s1, ":returned_flag_agent_faction"),
          (str_store_string, s0, "str_s1_auto_returned_flag"),
        (try_end),

        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (play_sound, "snd_flag_returned"),
          (try_end),
        (try_end),
        (assign, ":text_font_color", 0xFFFFFFFF),

        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 325),
        (position_set_y, pos1, 400),
        (position_set_x, pos1, 500), #new
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_capture_the_flag_stole),

        (agent_get_team, ":stolen_flag_agent_team", "$g_multiplayer_message_value_1"),
        (team_get_faction, ":stolen_flag_agent_faction", ":stolen_flag_agent_team"),
        (str_store_faction_name, s1, ":stolen_flag_agent_faction"),

        (assign, ":text_font_color", 0xFFFFFFFF),

        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":stolen_flag_agent_team"),
              (play_sound, "snd_enemy_flag_taken"),
            (else_try),
              (play_sound, "snd_your_flag_taken"),
            (try_end),
          (try_end),
        (try_end),

        (str_store_string, s0, "str_s1_taken_flag"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 365),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_flag_captured),

        (store_div, ":winner_agent_team", "$g_multiplayer_message_value_1", 100),
        (store_mod, reg0, "$g_multiplayer_message_value_1", 100),
        (val_sub, ":winner_agent_team", 1),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
              (play_sound, "snd_team_scored_a_point"),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
              (play_sound, "snd_enemy_scored_a_point"),
            (try_end),
          (try_end),
        (try_end),

        (team_get_faction, ":winner_agent_faction", ":winner_agent_team"),
        (str_store_faction_name, s1, ":winner_agent_faction"),

        (str_store_string, s0, "str_s1_captured_flag_reg0"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 345),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_flag_is_pulling),

        (store_div, ":winner_agent_team", "$g_multiplayer_message_value_1", 100),
        (store_mod, reg0, "$g_multiplayer_message_value_1", 100),
        (val_sub, ":winner_agent_team", 1),

        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (play_sound, "snd_enemy_flag_taken"),
            (else_try),
              (play_sound, "snd_your_flag_taken"),
            (try_end),
          (try_end),
        (try_end),

        (assign, ":text_font_color", 0xFFFFFFFF),

        (team_get_faction, ":winner_agent_faction", ":winner_agent_team"),
        (str_store_faction_name, s1, ":winner_agent_faction"),

        (str_store_string, s0, "str_s1_pulling_flag_reg0"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 345),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_flag_neutralized),

        (store_div, ":winner_agent_team", "$g_multiplayer_message_value_1", 100),
        (store_mod, reg0, "$g_multiplayer_message_value_1", 100),
        (val_sub, ":winner_agent_team", 1),

        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (play_sound, "snd_flag_returned"),
          (try_end),
        (try_end),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),
        (try_end),

        (team_get_faction, ":winner_agent_faction", ":winner_agent_team"),
        (str_store_faction_name, s1, ":winner_agent_faction"),

        (str_store_string, s0, "str_s1_neutralized_flag_reg0"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 345),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_result_in_siege_mode),

        (assign, ":winner_agent_team", "$g_multiplayer_message_value_1"),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),
        (try_end),

        (try_begin),
          (eq, "$g_multiplayer_message_value_1", 0),
          (str_store_string, s0, "str_s1_defended_castle"),
        (else_try),
          (eq, "$g_multiplayer_message_value_1", 1),
          (str_store_string, s0, "str_s1_captured_castle"),
        (else_try),
          (str_store_string, s0, "str_round_draw"),
          (assign, ":text_font_color", 0xFFFFFFFF),
        (try_end),

        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (try_begin),
          (neq, "$g_multiplayer_message_value_1", -1),
          (position_set_x, pos1, 325),
        (else_try),
          (position_set_x, pos1, 400),
        (try_end),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_draw),

        (assign, ":text_font_color", 0xFFFFFFFF),
        (str_store_string, s0, "str_round_draw"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 375),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_start_death_mode),

        (assign, ":text_font_color", 0xFFFFFFFF),
        (str_store_string, s0, "str_death_mode_started"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_target_destroyed),

        (try_begin),
          (lt, "$g_multiplayer_message_value_1", 0),
          (val_mul, "$g_multiplayer_message_value_1", -1),
          (assign, ":scene_prop_team", 0),

          (team_get_faction, ":faction_of_winner_team", 1),
          (str_store_faction_name, s1, ":faction_of_winner_team"),
        (else_try),
          (assign, ":scene_prop_team", 1),

          (team_get_faction, ":faction_of_winner_team", 0),
          (str_store_faction_name, s1, ":faction_of_winner_team"),
        (try_end),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, "$g_multiplayer_message_value_1", 1),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (player_get_team_no, ":my_team_no", ":my_player_no"),
            (neq, ":scene_prop_team", ":my_team_no"), #if scene prop and I have different teams this means we won
            (assign, ":text_font_color", 0xFF33DD11),
          (else_try),
            (assign, ":text_font_color", 0xFFFF4422),
          (try_end),
        (try_end),

        (try_begin),
          (eq, "$g_multiplayer_message_value_1", 9),
          (str_store_string, s0, "str_s1_destroyed_all_targets"),
        (else_try),
          (eq, "$g_multiplayer_message_value_1", 1),
          (str_store_string, s0, "str_s1_destroyed_catapult"),
        (else_try),
          (eq, "$g_multiplayer_message_value_1", 2),
          (str_store_string, s0, "str_s1_destroyed_trebuchet"),
        (try_end),

        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_defenders_saved_n_targets),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, "$g_defender_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", "$g_defender_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),
        (try_end),

        (assign, ":num_targets_saved", "$g_multiplayer_message_value_1"),

        (team_get_faction, ":faction_of_winner_team", "$g_defender_team"),
        (str_store_faction_name, s1, ":faction_of_winner_team"),

        (try_begin),
          (eq, ":num_targets_saved", 1),
          (str_store_string, s0, "str_s1_saved_1_target"),
        (else_try),
          (eq, ":num_targets_saved", 2),
          (str_store_string, s0, "str_s1_saved_2_targets"),
        (try_end),

        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_attackers_won_the_round),

        (assign, ":winner_agent_team", "$g_multiplayer_message_value_1"),

        (try_begin), #for spectators initializing, we assume spectators are fan of team0 so coloring is applied as they are at team0.
          (eq, ":winner_agent_team", 0),
          (assign, ":text_font_color", 0xFF33DD11),
        (else_try),
          (assign, ":text_font_color", 0xFFFF4422),
        (try_end), #initializing ends
        (multiplayer_get_my_player, ":my_player_no"),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_agent_id, ":my_player_agent", ":my_player_no"),
          (try_begin),
            (ge, ":my_player_agent", 0),
            (agent_get_team, ":my_player_team", ":my_player_agent"),
            (try_begin),
              (eq, ":my_player_team", ":winner_agent_team"),
              (assign, ":text_font_color", 0xFF33DD11),
            (else_try),
              (assign, ":text_font_color", 0xFFFF4422),
            (try_end),
          (try_end),
        (try_end),

        (try_begin),
          (eq, "$g_defender_team", 0),
          (team_get_faction, ":faction_of_winner_team", 1),
        (else_try),
          (team_get_faction, ":faction_of_winner_team", 0),
        (try_end),
        (str_store_faction_name, s1, ":faction_of_winner_team"),

        (str_store_string, s0, "str_s1_won_round"),
        (create_text_overlay, "$g_multiplayer_message_1", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_1", ":text_font_color"),
        (position_set_x, pos1, 350),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_multiplayer_message_1", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_1", pos1),
        (presentation_set_duration, 400),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
       ]),
     ]),

  ("multiplayer_message_2", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_auto_team_balance_done),
        (assign, ":text_font_color", 0xFFFFFFFF),
        (str_store_string, s0, "str_auto_team_balance_done"),
        (create_text_overlay, "$g_multiplayer_message_2", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_2", ":text_font_color"),
        (position_set_x, pos1, 375),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 550),
        (overlay_set_position, "$g_multiplayer_message_2", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_2", pos1),
        (presentation_set_duration, 300),
      (else_try),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_auto_team_balance_next),
        (assign, ":text_font_color", 0xFFFFFFFF),

        (try_begin),
          (neq, "$g_multiplayer_game_type", multiplayer_game_type_battle),
          (neq, "$g_multiplayer_game_type", multiplayer_game_type_destroy),
          (neq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
          (str_store_string, s0, "str_auto_team_balance_in_20_seconds"),
          (position_set_x, pos1, 375),
        (else_try),
          (str_store_string, s0, "str_auto_team_balance_next_round"),
          (position_set_x, pos1, 375),
        (try_end),

        (create_text_overlay, "$g_multiplayer_message_2", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_2", ":text_font_color"),
        (position_set_y, pos1, 550),
        (position_set_x, pos1, 500), #new
        (overlay_set_position, "$g_multiplayer_message_2", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_2", pos1),
        (presentation_set_duration, 300),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
       ]),
     ]),

  ("multiplayer_message_3", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_poll_result),

        (assign, ":text_font_color", 0xFFFFFFFF),
        (try_begin),
          (eq, "$g_multiplayer_message_value_3", 1),
          (str_store_string, s0, "str_poll_result_yes"),
        (else_try),
          (str_store_string, s0, "str_poll_result_no"),
        (try_end),
        (create_text_overlay, "$g_multiplayer_message_3", s0, tf_center_justify|tf_with_outline),
        (overlay_set_color, "$g_multiplayer_message_3", ":text_font_color"),
        (position_set_x, pos1, 380),
        (position_set_x, pos1, 500), #new
        (position_set_y, pos1, 475),
        (overlay_set_position, "$g_multiplayer_message_3", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_multiplayer_message_3", pos1),
        (presentation_set_duration, 400),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [
       ]),
     ]),

  ("multiplayer_round_time_counter", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (assign, "$g_multiplayer_last_round_time_counter_value", -1),
      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_round_time_counter_overlay", s0, tf_left_align|tf_single_line|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_round_time_counter_overlay", 0xFFFFFF),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 690),
      (overlay_set_position, "$g_multiplayer_round_time_counter_overlay", pos1),
      (position_set_x, pos1, 2000),
      (position_set_y, pos1, 2000),
      (overlay_set_size, "$g_multiplayer_round_time_counter_overlay", pos1),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
     [(store_mission_timer_a, ":current_time"),
      (store_sub, ":seconds_past_in_round", ":current_time", "$g_round_start_time"),
      (store_sub, ":seconds_left_in_round", "$g_multiplayer_round_max_seconds", ":seconds_past_in_round"),
      (val_max, ":seconds_left_in_round", 0),
      (try_begin),
        (neq, "$g_multiplayer_last_round_time_counter_value", ":seconds_left_in_round"),
        (assign, "$g_multiplayer_last_round_time_counter_value", ":seconds_left_in_round"),
        (store_div, reg0, ":seconds_left_in_round", 60),
        (store_div, reg1, ":seconds_left_in_round", 10),
        (val_mod, reg1, 6),
        (assign, reg2, ":seconds_left_in_round"),
        (val_mod, reg2, 10),
        (str_store_string, s0, "str_reg0_dd_reg1reg2"),
        (overlay_set_text, "$g_multiplayer_round_time_counter_overlay", s0),
      (try_end),
      ]),
    ]),

  ("multiplayer_team_score_display", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),
      (assign, "$g_multiplayer_team_1_last_displayed_score", -1),
      (assign, "$g_multiplayer_team_2_last_displayed_score", -1),
      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_team_1_score_display_overlay", s0, tf_left_align|tf_single_line|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_team_1_score_display_overlay", 0xFFFFFF),
      (position_set_x, pos1, 40),
      (position_set_y, pos1, 700),
      (overlay_set_position, "$g_multiplayer_team_1_score_display_overlay", pos1),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, "$g_multiplayer_team_1_score_display_overlay", pos1),
      (create_text_overlay, "$g_multiplayer_team_2_score_display_overlay", s0, tf_left_align|tf_single_line|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_team_2_score_display_overlay", 0xFFFFFF),
      (position_set_x, pos1, 40),
      (position_set_y, pos1, 645),
      (overlay_set_position, "$g_multiplayer_team_2_score_display_overlay", pos1),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, "$g_multiplayer_team_2_score_display_overlay", pos1),

      (try_begin),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_4"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_1"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_2"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_2"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_3"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_3"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_5"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_4"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_6"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_5"),
      (else_try),
        (eq, "$g_multiplayer_team_1_faction", "fac_kingdom_1"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_6"),
      (try_end),

      (position_set_x, pos3, 25),
      (position_set_y, pos3, 715),
      (overlay_set_position, reg0, pos3),
      (position_set_x, pos1, 50),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1),

      (try_begin),
        (eq, "$g_multiplayer_team_1_faction", "$g_multiplayer_team_2_faction"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_7"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_4"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_1"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_2"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_2"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_3"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_3"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_5"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_4"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_6"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_5"),
      (else_try),
        (eq, "$g_multiplayer_team_2_faction", "fac_kingdom_1"),
        (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_6"),
      (try_end),

      (position_set_x, pos3, 25),
      (position_set_y, pos3, 660),
      (overlay_set_position, reg0, pos3),
      (position_set_x, pos1, 50),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run, [
      (team_get_score, ":team_1_score", 0),
      (team_get_score, ":team_2_score", 1),
      (try_begin),
        (this_or_next|neq, ":team_1_score", "$g_multiplayer_team_1_last_displayed_score"),
        (neq, ":team_2_score", "$g_multiplayer_team_2_last_displayed_score"),
        (assign, "$g_multiplayer_team_1_last_displayed_score", ":team_1_score"),
        (assign, "$g_multiplayer_team_2_last_displayed_score", ":team_2_score"),

        (str_store_faction_name, s0, "$g_multiplayer_team_1_faction"),
        (assign, reg0, ":team_1_score"),
        (overlay_set_text, "$g_multiplayer_team_1_score_display_overlay", "str_reg0"),
        (str_store_faction_name, s0, "$g_multiplayer_team_2_faction"),
        (assign, reg0, ":team_2_score"),
        (overlay_set_text, "$g_multiplayer_team_2_score_display_overlay", "str_reg0"),

##        (str_store_faction_name, s0, "$g_multiplayer_team_1_faction"),
##        (assign, reg0, ":team_1_score"),
##        (overlay_set_text, "$g_multiplayer_team_1_score_display_overlay", "str_s0_dd_reg0"),
##        (str_store_faction_name, s0, "$g_multiplayer_team_2_faction"),
##        (assign, reg0, ":team_2_score"),
##        (overlay_set_text, "$g_multiplayer_team_2_score_display_overlay", "str_s0_dd_reg0"),
      (try_end),
      ]),
    ]),


  ("multiplayer_flag_projection_display", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
    [
      (set_fixed_point_multiplier, 1000),

      (store_sub, ":flag_mesh", "$g_multiplayer_team_1_faction", npc_kingdoms_begin),
      (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_1", ":flag_mesh"),
      (val_sub, ":flag_mesh", multiplayer_flag_projections_begin),
      (val_add, ":flag_mesh", multiplayer_flag_taken_projections_begin),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_2", ":flag_mesh"),

      (try_begin),
        (neq, "$g_multiplayer_team_1_faction", "$g_multiplayer_team_2_faction"),
        (store_sub, ":flag_mesh", "$g_multiplayer_team_2_faction", npc_kingdoms_begin),
        (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
        (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_3", ":flag_mesh"),
        (val_sub, ":flag_mesh", multiplayer_flag_projections_begin),
        (val_add, ":flag_mesh", multiplayer_flag_taken_projections_begin),
        (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_4", ":flag_mesh"),
      (else_try),
        (assign, ":flag_mesh", "mesh_flag_project_rb"),
        (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_3", ":flag_mesh"),
        (assign, ":flag_mesh", "mesh_flag_project_rb_miss"),
        (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_4", ":flag_mesh"),
      (try_end),

      (position_set_x, pos1, 250),
      (position_set_y, pos1, 250),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_1", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_2", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_3", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_4", pos1),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 0),
      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_run,
    [
      (set_fixed_point_multiplier, 1000),

      (scene_prop_get_instance, ":flag_red_id", "$team_1_flag_scene_prop", 0),
      (team_get_slot, ":team_0_flag_situation", 0, slot_team_flag_situation),
      (try_begin),
        (neq, ":team_0_flag_situation", 1),
        (prop_instance_get_position, pos1, ":flag_red_id"), #hold position of flag of team 1 (red flag) at pos1
      (else_try),
        (entry_point_get_position, pos1, multi_base_point_team_1), #moved from above to here after auto-set position
      (try_end),
      (position_move_z, pos1, 200, 1),

      (scene_prop_get_instance, ":flag_blue_id", "$team_2_flag_scene_prop", 0),
      (team_get_slot, ":team_1_flag_situation", 1, slot_team_flag_situation),
      (try_begin),
        (neq, ":team_1_flag_situation", 1),
        (prop_instance_get_position, pos2, ":flag_blue_id"), #hold position of flag of team 1 (red flag) at pos1
      (else_try),
        (entry_point_get_position, pos2, multi_base_point_team_2), #moved from above to here after auto-set position
      (try_end),
      (position_move_z, pos2, 200, 1),

      (position_get_screen_projection, pos3, pos1),
      (position_get_x, ":x_pos", pos3),
      (position_get_y, ":y_pos", pos3),
      (position_set_y, pos3, ":y_pos"),
      (try_begin),
        (is_between, ":x_pos", -100, 1100),
        (is_between, ":y_pos", -100, 850),

        (multiplayer_get_my_player, ":my_player_number"),
        (try_begin),
          (ge, ":my_player_number", 0),
          (player_get_team_no, ":my_player_team", ":my_player_number"),
        (else_try),
          (assign, ":my_player_team", multi_team_spectator),
        (try_end),

        (try_begin),
          (neq, ":my_player_team", 1), #if I am at team 0 or spectator
          (try_begin),
            (neq, ":team_0_flag_situation", 1), #if our flag is not stolen
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_1", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
          (else_try), #if our flag is stolen
            (try_begin),
              (eq, ":my_player_team", 0),
              (assign, ":our_base_entry_id", multi_base_point_team_1),
            (else_try),
              (assign, ":our_base_entry_id", multi_base_point_team_2),
            (try_end),

            (entry_point_get_position, pos5, ":our_base_entry_id"), #moved from above to here after auto-set position
            (position_get_screen_projection, pos3, pos5),

            (overlay_set_position, "$g_presentation_obj_flag_projection_display_2", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
          (try_end),
        (else_try),
          (try_begin),
            (neq, ":team_0_flag_situation", 1),
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_1", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
          (try_end),
        (try_end),
      (else_try),
        (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
        (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
      (try_end),

      (position_get_screen_projection, pos3, pos2),
      (position_get_x, ":x_pos", pos3),
      (position_get_y, ":y_pos", pos3),
      (position_set_y, pos3, ":y_pos"),
      (try_begin),
        (is_between, ":x_pos", -100, 1100),
        (is_between, ":y_pos", -100, 850),

        (team_get_slot, ":team_1_flag_situation", 1, slot_team_flag_situation),

        (multiplayer_get_my_player, ":my_player_number"),
        (try_begin),
          (ge, ":my_player_number", 0),
          (player_get_team_no, ":my_player_team", ":my_player_number"),
        (else_try),
          (assign, ":my_player_team", multi_team_spectator),
        (try_end),

        (try_begin),
          (neq, ":my_player_team", 0), #if I am at team 0 or spectator
          (try_begin),
            (neq, ":team_1_flag_situation", 1), #if our flag is not stolen
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_3", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 0),
          (else_try), #if our flag is stolen
            (try_begin),
              (eq, ":my_player_team", 0),
              (assign, ":our_base_entry_id", multi_base_point_team_1),
            (else_try),
              (assign, ":our_base_entry_id", multi_base_point_team_2),
            (try_end),

            (entry_point_get_position, pos5, ":our_base_entry_id"), #moved from above to here after auto-set position
            (position_get_screen_projection, pos3, pos5),

            (overlay_set_position, "$g_presentation_obj_flag_projection_display_4", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
          (try_end),
        (else_try),
          (try_begin),
            (neq, ":team_1_flag_situation", 1),
            (overlay_set_position, "$g_presentation_obj_flag_projection_display_3", pos3),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 1),
            (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 0),
          (try_end),
        (try_end),
      (else_try),
        (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
        (overlay_set_display, "$g_presentation_obj_flag_projection_display_4", 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_flag_projection_display_bt", prsntf_read_only|prsntf_manual_end_only, 0, [ #this is for search and destroy death mode flags.
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),

      (store_sub, ":flag_mesh", "$g_multiplayer_team_1_faction", npc_kingdoms_begin),
      (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_1", ":flag_mesh"),

      (try_begin),
        (neq, "$g_multiplayer_team_1_faction", "$g_multiplayer_team_2_faction"),
        (store_sub, ":flag_mesh", "$g_multiplayer_team_2_faction", npc_kingdoms_begin),
        (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
      (else_try),
        (assign, ":flag_mesh", "mesh_flag_project_rb"),
      (try_end),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_3", ":flag_mesh"),

      (position_set_x, pos1, 250),
      (position_set_y, pos1, 250),

      (overlay_set_size, "$g_presentation_obj_flag_projection_display_1", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_3", pos1),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run, [
      (try_begin),
        (eq, "$g_round_ended", 0),
        (set_fixed_point_multiplier, 1000),
        (scene_prop_get_instance, ":flag_1_id", "$team_1_flag_scene_prop", 0),
        (prop_instance_get_position, pos1, ":flag_1_id"), #hold position of flag of team 1 at pos1
        (position_move_z, pos1, 250, 1),

        (scene_prop_get_instance, ":flag_2_id", "$team_2_flag_scene_prop", 0),
        (prop_instance_get_position, pos2, ":flag_2_id"), #hold position of flag of team 2 at pos2
        (position_move_z, pos2, 250, 1),

        (position_get_screen_projection, pos3, pos1),
        (position_get_x, ":x_pos", pos3),
        (position_get_y, ":y_pos", pos3),
        (position_set_y, pos3, ":y_pos"),
        (try_begin),
          (is_between, ":x_pos", -100, 1100),
          (is_between, ":y_pos", -100, 850),

          (overlay_set_position, "$g_presentation_obj_flag_projection_display_1", pos3),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 1),
        (else_try),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
        (try_end),

        (position_get_screen_projection, pos3, pos2),
        (position_get_x, ":x_pos", pos3),
        (position_get_y, ":y_pos", pos3),
        (position_set_y, pos3, ":y_pos"),
        (try_begin),
          (is_between, ":x_pos", -100, 1100),
          (is_between, ":y_pos", -100, 850),

          (overlay_set_position, "$g_presentation_obj_flag_projection_display_3", pos3),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 1),
        (else_try),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_3", 0),
        (try_end),
      (else_try),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_destructible_targets_display", prsntf_read_only|prsntf_manual_end_only, 0, [ #this is for search and destroy death mode flags.
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),

      (try_begin),
        (eq, "$g_defender_team", 0),
        (store_sub, ":flag_mesh", "$g_multiplayer_team_1_faction", npc_kingdoms_begin),
      (else_try),
        (store_sub, ":flag_mesh", "$g_multiplayer_team_2_faction", npc_kingdoms_begin),
      (try_end),

      (val_add, ":flag_mesh", multiplayer_flag_projections_begin),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_1", ":flag_mesh"),
      (create_mesh_overlay, "$g_presentation_obj_flag_projection_display_2", ":flag_mesh"),

      (position_set_x, pos1, 250),
      (position_set_y, pos1, 250),

      (overlay_set_size, "$g_presentation_obj_flag_projection_display_1", pos1),
      (overlay_set_size, "$g_presentation_obj_flag_projection_display_2", pos1),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
      (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run, [
      (try_begin),
        (eq, "$g_round_ended", 0),
        (set_fixed_point_multiplier, 1000),
        (scene_prop_get_instance, ":target_1_id", "$g_destructible_target_1", 0),
        (prop_instance_get_position, pos1, ":target_1_id"),
        (prop_instance_get_position, pos1, ":target_1_id"),
        (position_move_z, pos1, 250, 1),
        (scene_prop_get_instance, ":target_2_id", "$g_destructible_target_2", 0),
        (prop_instance_get_position, pos2, ":target_2_id"),
        (prop_instance_get_position, pos2, ":target_2_id"),
        (position_move_z, pos2, 250, 1),

        (position_get_screen_projection, pos3, pos1),
        (position_get_x, ":x_pos", pos3),
        (position_get_y, ":y_pos", pos3),
        (position_set_y, pos3, ":y_pos"),
        (try_begin),
          (is_between, ":x_pos", -100, 1100),
          (is_between, ":y_pos", -100, 850),

          (prop_instance_get_starting_position, pos0, ":target_1_id"),
          (prop_instance_get_position, pos1, ":target_1_id"),
          (get_sq_distance_between_positions_in_meters, ":dist", pos0, pos1),
          (le, ":dist", 2), #this can be 0 or 1 too.

          (overlay_set_position, "$g_presentation_obj_flag_projection_display_1", pos3),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 1),
        (else_try),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_1", 0),
        (try_end),

        (position_get_screen_projection, pos3, pos2),
        (position_get_x, ":x_pos", pos3),
        (position_get_y, ":y_pos", pos3),
        (position_set_y, pos3, ":y_pos"),
        (try_begin),
          (is_between, ":x_pos", -100, 1100),
          (is_between, ":y_pos", -100, 850),

          (prop_instance_get_starting_position, pos0, ":target_2_id"),
          (prop_instance_get_position, pos1, ":target_2_id"),
          (get_sq_distance_between_positions_in_meters, ":dist", pos0, pos1),
          (le, ":dist", 2), #this can be 0 or 1 too.

          (overlay_set_position, "$g_presentation_obj_flag_projection_display_2", pos3),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 1),
        (else_try),
          (overlay_set_display, "$g_presentation_obj_flag_projection_display_2", 0),
        (try_end),
      (else_try),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_respawn_time_counter", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),

      (assign, "$g_multiplayer_respawn_counter_overlay", -1),
      (assign, "$g_multiplayer_respawn_remained_overlay", -1),

      (assign, ":do_not_show_respawn_counter", 0),
      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_result_in_siege_mode),
        (this_or_next|eq, "$g_round_ended", 1),
        (eq, "$g_flag_is_not_ready", 1),
        (assign, ":do_not_show_respawn_counter", 1),
      (try_end),
      (eq, ":do_not_show_respawn_counter", 0),

      (assign, "$g_multiplayer_last_respawn_counter_value", -1),
      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_respawn_counter_overlay", s0, tf_center_justify|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_respawn_counter_overlay", 0xFFFFFF),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 600),
      (overlay_set_position, "$g_multiplayer_respawn_counter_overlay", pos1),
      (position_set_x, pos1, 2000),
      (position_set_y, pos1, 2000),
      (overlay_set_size, "$g_multiplayer_respawn_counter_overlay", pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_respawn_remained_overlay", s0, tf_center_justify|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_respawn_remained_overlay", 0xFFFFFF),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 570),
      (overlay_set_position, "$g_multiplayer_respawn_remained_overlay", pos1),
      (position_set_x, pos1, 1400),
      (position_set_y, pos1, 1400),
      (overlay_set_size, "$g_multiplayer_respawn_remained_overlay", pos1),

      #(store_mission_timer_a, "$g_multiplayer_respawn_start_time"),
      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_run, [
      (ge, "$g_multiplayer_respawn_counter_overlay", 0),
      (multiplayer_get_my_player, ":my_player_no"),
      (try_begin),
        (ge, ":my_player_no", 0),
        (player_get_team_no, ":player_team", ":my_player_no"),
        (try_begin),
          (eq, ":player_team", multi_team_spectator),
          (presentation_set_duration, 0),
        (else_try),
          (store_mission_timer_a, ":current_time"),
          (store_sub, ":seconds_past_in_respawn", ":current_time", "$g_multiplayer_respawn_start_time"),
          (try_begin),
            (eq, "$g_show_no_more_respawns_remained", 0),
            (assign, ":total_respawn_time", "$g_multiplayer_respawn_period"),
            (try_begin),
              (eq, "$g_multiplayer_game_type", multiplayer_game_type_siege),
              (player_get_team_no, ":player_team", ":my_player_no"),
              (eq, ":player_team", 0),
              (val_add, ":total_respawn_time", multiplayer_siege_mod_defender_team_extra_respawn_time),
            (try_end),
          (else_try),
            (assign, ":total_respawn_time", 6),
          (try_end),
          (store_sub, ":seconds_left_in_respawn", ":total_respawn_time", ":seconds_past_in_respawn"),
          (try_begin),
            (le, ":seconds_left_in_respawn", 0),
            (presentation_set_duration, 0),
          (else_try),
            (neq, "$g_multiplayer_last_respawn_counter_value", ":seconds_left_in_respawn"),
            (assign, "$g_multiplayer_last_respawn_counter_value", ":seconds_left_in_respawn"),
            (try_begin),
              (eq, "$g_show_no_more_respawns_remained", 0),
              (assign, reg0, ":seconds_left_in_respawn"),
              (str_store_string, s0, "str_respawning_in_reg0_seconds"),
              (try_begin),
                (gt, "$g_multiplayer_number_of_respawn_count", 0),
                (store_sub, reg0, "$g_multiplayer_number_of_respawn_count", "$g_my_spawn_count"),

                (multiplayer_get_my_player, ":my_player_no"),
                (player_get_team_no, ":my_player_team", ":my_player_no"),
                (eq, ":my_player_team", 0),

                (try_begin),
                  (gt, reg0, 1),
                  (str_store_string, s1, "str_reg0_respawns_remained"),
                (else_try),
                  (str_store_string, s1, "str_this_is_your_last_respawn"),
                (try_end),
              (else_try),
                (str_clear, s1),
              (try_end),
            (else_try),
              (eq, "$g_show_no_more_respawns_remained", 1),
              ##(assign, "$g_informed_about_no_more_respawns_remained", 1),
              (str_store_string, s0, "str_no_more_respawns_remained_this_round"),
              (str_clear, s1),
              (str_store_string, s1, "str_wait_next_round"),
            (try_end),
            (overlay_set_text, "$g_multiplayer_respawn_counter_overlay", s0),
            (overlay_set_text, "$g_multiplayer_respawn_remained_overlay", s1),
          (try_end),
        (try_end),
      (else_try),
        (presentation_set_duration, 0),
      (try_end),

      (try_begin),
        (eq, "$g_multiplayer_message_type", multiplayer_message_type_round_result_in_siege_mode),
        (this_or_next|eq, "$g_round_ended", 1),
        (eq, "$g_flag_is_not_ready", 1),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_stats_chart", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_score_b"),
      (position_set_x, pos1, 100),
      (position_set_y, pos1, 100),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (assign, ":team_1_rows", 0),
      (assign, ":team_2_rows", 0),
      (assign, ":spectator_rows", 0),
      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 0, ":num_players"),
        (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
        (try_begin),
          (player_is_active, ":player_no"),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 1),
          (player_get_team_no, ":player_team", ":player_no"),
          (try_begin),
            (eq, ":player_team", 0),
            (val_add, ":team_1_rows", 1),
          (else_try),
            (eq, ":player_team", 1),
            (val_add, ":team_2_rows", 1),
          (else_try),
            (eq, ":player_team", multi_team_spectator),
            (val_add, ":spectator_rows", 1),
          (try_end),
        (else_try),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 0),
        (try_end),
      (try_end),
      (try_begin),
        (gt, "$g_multiplayer_num_bots_team_1", 0),
        (val_add, ":team_1_rows", 1),
      (try_end),
      (try_begin),
        (gt, "$g_multiplayer_num_bots_team_2", 0),
        (val_add, ":team_2_rows", 1),
      (try_end),

      (assign, ":total_rows", ":team_1_rows"),
      (val_max, ":total_rows", ":team_2_rows"),
      (val_add, ":total_rows", ":spectator_rows"),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_stats_chart_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 100),
      (position_set_y, pos1, 120),#120
      (overlay_set_position, "$g_presentation_obj_stats_chart_container", pos1),
      (position_set_x, pos1, 746),
      (position_set_y, pos1, 530),#530
      (overlay_set_area_size, "$g_presentation_obj_stats_chart_container", pos1),
      (set_container_overlay, "$g_presentation_obj_stats_chart_container"),

      (store_mul, ":y_needed", ":total_rows", 20),
      (val_add, ":y_needed", 100),
      (try_begin),
        (gt, ":spectator_rows", 0),
        (val_add, ":y_needed", 70),
      (try_end),

      (multiplayer_get_my_player, ":my_player_no"),

      (try_begin),
        (gt, ":y_needed", 490),
        (assign, "$g_stats_chart_update_period", 8),
      (else_try),
        (assign, "$g_stats_chart_update_period", 1),
      (try_end),

      (try_begin), #counting number of flags each team has.
        (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
        (call_script, "script_get_headquarters_scores"),
        (assign, ":team_1_num_flags", reg0),
        (assign, ":team_2_num_flags", reg1),
      (try_end),

      #assuming only 2 teams in scene
      (try_for_range, ":i_team", 0, multi_team_spectator),
        (assign, ":number_of_players", 0),
        (get_max_players, ":num_players"),
        (try_for_range, ":player_no", 0, ":num_players"),
          (player_is_active, ":player_no"),
          (player_get_team_no, ":team_no", ":player_no"),
          (eq, ":team_no", ":i_team"),
          (val_add, ":number_of_players", 1),
        (try_end),
        (assign, reg0, ":number_of_players"),
        (try_begin),
          (neq, ":number_of_players", 1),
          (create_text_overlay, reg1, "str_reg0_players", 0),
        (else_try),
          (create_text_overlay, reg1, "str_reg0_player", 0),
        (try_end),

        (assign, ":cur_y", ":y_needed"),
        (team_get_faction, ":cur_faction", ":i_team"),
        (str_store_faction_name, s1, ":cur_faction"),
        (create_text_overlay, reg0, s1, 0),
        (try_begin),
          (eq, ":i_team", 0),
          (overlay_set_color, reg0, 0xFF0000),
          (overlay_set_color, reg1, 0xFF0000),
        (else_try),
          (overlay_set_color, reg0, 0x0099FF),
          (overlay_set_color, reg1, 0x0099FF),
        (try_end),
        (assign, ":distance_between_teams", 373),
        (store_mul, ":cur_x", ":distance_between_teams", ":i_team"),
        (val_add, ":cur_x", 42),
        (store_add, ":cur_x_add_15", ":cur_x", 15),
        (position_set_x, pos3, ":cur_x_add_15"),
        (position_set_y, pos3, ":cur_y"),
        (store_add, ":cur_x_add_35", ":cur_x", 35),
        (position_set_x, pos1, ":cur_x_add_35"),
        (position_set_y, pos1, ":cur_y"),
        (copy_position, pos2, pos1),
        (store_sub, ":cur_y_sub_10", ":cur_y", 10),
        (position_set_x, pos2, ":cur_x_add_35"),
        (position_set_y, pos2, ":cur_y_sub_10"),
        (overlay_set_position, reg0, pos1),
        (overlay_set_position, reg1, pos2),
        (position_set_x, pos1, 1000),
        (position_set_y, pos1, 1000),
        (position_set_x, pos2, 600),
        (position_set_y, pos2, 600),
        (overlay_set_size, reg0, pos1),
        (overlay_set_size, reg1, pos2),

        (team_get_faction, ":faction_of_team_1", 0),
        (team_get_faction, ":faction_of_team_2", 1),

        (try_begin),
          (eq, ":faction_of_team_1", ":faction_of_team_2"),
          (eq, ":i_team", 1),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_7"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_4"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_1"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_2"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_2"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_3"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_3"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_5"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_4"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_6"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_5"),
        (else_try),
          (eq, ":cur_faction", "fac_kingdom_1"),
          (create_mesh_overlay, reg0, "mesh_ui_kingdom_shield_6"),
        (try_end),

        (position_set_x, pos1, 100),
        (position_set_y, pos1, 100),
        (overlay_set_position, reg0, pos3),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 50),
        (overlay_set_size, reg0, pos1),

        (team_get_score, reg0, ":i_team"),
        (create_text_overlay, reg0, "str_score_reg0", tf_right_align),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 325), #325
        (store_add, ":sub_cur_y", ":cur_y", 0),
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":sub_cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 1200),
        (position_set_y, pos1, 1200),
        (overlay_set_size, reg0, pos1),

        (try_begin), #counting number of flags each team has only at hq mod.
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
          (try_begin),
            (eq, ":i_team", 0),
            (assign, reg0, ":team_1_num_flags"),
          (else_try),
            (eq, ":i_team", 1),
            (assign, reg0, ":team_2_num_flags"),
          (try_end),
          (create_text_overlay, reg0, "str_flags_reg0", 0),
          (overlay_set_color, reg0, 0xFFFFFF),
          (store_add, ":sub_cur_x", ":cur_x", 258),
          (store_add, ":sub_cur_y", ":cur_y", -10),
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":sub_cur_y"),
          (overlay_set_position, reg0, pos1),
          (position_set_x, pos1, 600),
          (position_set_y, pos1, 600),
          (overlay_set_size, reg0, pos1),
        (try_end),

        (val_sub, ":cur_y", 60),

        (create_text_overlay, reg0, "str_player_name", 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, ":cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        (try_begin), #at headquarters and capture the flag write score instead before kill count
          (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
          (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
          (create_text_overlay, reg0, "str_score", 0),
          (overlay_set_color, reg0, 0xFFFFFF),
          (store_add, ":sub_cur_x", ":cur_x", 138),
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
        (try_end),

        (create_text_overlay, reg0, "str_kills", tf_center_justify),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 206), #191
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_deaths", tf_center_justify),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 260), #232
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_ping", tf_center_justify),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 308), #291
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        (create_mesh_overlay, reg0, "mesh_white_plane"),
        (overlay_set_color, reg0, 0xFFFFFF),
        (overlay_set_alpha, reg0, 0xD0),
        (store_add, ":sub_cur_x", ":cur_x", 0),
        (position_set_x, pos1, ":sub_cur_x"),
        (store_add, ":sub_cur_y", ":cur_y", -10),
        (position_set_y, pos1, ":sub_cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 16500),
        (position_set_y, pos1, 50),
        (overlay_set_size, reg0, pos1),

        (val_sub, ":cur_y", 35),

        (store_add, ":end_cond", ":num_players", 1),
        (try_for_range, ":unused", 0, ":end_cond"),
          (assign, ":max_score_plus_death", -30030),
          (assign, ":max_score_plus_death_player_no", -1),
          (try_for_range, ":player_no", 0, ":num_players"),
            (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
            (troop_slot_eq, "trp_multiplayer_data", ":slot_index", 1),
            (player_get_team_no, ":player_team", ":player_no"),
            (eq, ":player_team", ":i_team"),

            (try_begin),
              (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
              (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),
              (player_get_score, ":kill_count", ":player_no"), #get score in "capture the flag" or "headquarters"
            (else_try),
              (player_get_kill_count, ":kill_count", ":player_no"), #get kill count in "siege" or "battle" or "team deathmatch" or "deathmatch"
            (try_end),

            (player_get_death_count, ":death_count", ":player_no"), #get_death_count

            (store_mul, ":player_score_plus_death", ":kill_count", 1000),
            (val_sub, ":player_score_plus_death", ":death_count"),

            (this_or_next|gt, ":player_score_plus_death", ":max_score_plus_death"),
            (eq, ":player_score_plus_death", -30030),

            (assign, ":max_score_plus_death", ":player_score_plus_death"),
            (assign, ":max_score_plus_death_player_no", ":player_no"),
          (try_end),
          (try_begin),
            (ge, ":max_score_plus_death_player_no", 0),
            (store_add, ":slot_index", ":max_score_plus_death_player_no", multi_data_player_index_list_begin),
            (troop_set_slot, "trp_multiplayer_data", ":slot_index", 0),

            (try_begin),
              (eq, ":my_player_no", ":max_score_plus_death_player_no"),
              (create_mesh_overlay, reg0, "mesh_white_plane"),
              (overlay_set_color, reg0, 0xFFFFFF),
              (overlay_set_alpha, reg0, 0x35),
              (store_add, ":sub_cur_x", ":cur_x", 0),
              (position_set_x, pos1, ":sub_cur_x"),
              (store_add, ":sub_cur_y", ":cur_y", 0),
              (position_set_y, pos1, ":sub_cur_y"),
              (overlay_set_position, reg0, pos1),
              (position_set_x, pos1, 16500),
              (position_set_y, pos1, 1000),
              (overlay_set_size, reg0, pos1),
            (try_end),

            (try_begin), #at headquarters and capture the flag write score instead dead label before kill count
              (this_or_next|eq, "$g_multiplayer_game_type", multiplayer_game_type_capture_the_flag),
              (eq, "$g_multiplayer_game_type", multiplayer_game_type_headquarters),

              (assign, ":font_color", 0xFFFFFF),
              (player_get_agent_id, ":max_score_plus_death_agent_id", ":max_score_plus_death_player_no"),
              (try_begin),
                (this_or_next|lt, ":max_score_plus_death_agent_id", 0),
                (neg|agent_is_alive, ":max_score_plus_death_agent_id"),
                (assign, ":font_color", 0xFF0000),
              (try_end),

              (player_get_score, reg0, ":max_score_plus_death_player_no"),
              (create_text_overlay, reg0, "str_reg0", tf_right_align),
              (overlay_set_color, reg0, ":font_color"),
              (position_set_x, pos1, 750),
              (position_set_y, pos1, 750),
              (overlay_set_size, reg0, pos1),
              (store_add, ":sub_cur_x", ":cur_x", 165), #150
              (position_set_x, pos1, ":sub_cur_x"),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg0, pos1),
            (else_try),
              (assign, ":font_color", 0xFFFFFF),
              (player_get_agent_id, ":max_score_plus_death_agent_id", ":max_score_plus_death_player_no"),
              (try_begin),
                (this_or_next|lt, ":max_score_plus_death_agent_id", 0),
                (neg|agent_is_alive, ":max_score_plus_death_agent_id"),
                (assign, ":font_color", 0xFF0000),
                (create_text_overlay, reg0, "str_dead", 0),
                (overlay_set_color, reg0, ":font_color"),
                (position_set_x, pos1, 750),
                (position_set_y, pos1, 750),
                (overlay_set_size, reg0, pos1),
                (store_add, ":sub_cur_x", ":cur_x", 130),
                (position_set_x, pos1, ":sub_cur_x"),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),
              (try_end),
            (try_end),

            (str_store_player_username, s1, ":max_score_plus_death_player_no"),
            (create_text_overlay, reg0, s1, 0),
            (overlay_set_color, reg0, ":font_color"),
            (position_set_x, pos1, 750),
            (position_set_y, pos1, 750),
            (overlay_set_size, reg0, pos1),
            (position_set_x, pos1, ":cur_x"),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),

            (player_get_kill_count, reg0, ":max_score_plus_death_player_no"), #get_kill_count
            (create_text_overlay, reg0, "str_reg0", tf_right_align),
            (overlay_set_color, reg0, ":font_color"),
            (position_set_x, pos1, 750),
            (position_set_y, pos1, 750),
            (overlay_set_size, reg0, pos1),
            (store_add, ":sub_cur_x", ":cur_x", 215), #200
            (position_set_x, pos1, ":sub_cur_x"),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),

            (player_get_death_count, reg0, ":max_score_plus_death_player_no"),
            (create_text_overlay, reg0, "str_reg0", tf_right_align),
            (overlay_set_color, reg0, ":font_color"),
            (position_set_x, pos1, 750),
            (position_set_y, pos1, 750),
            (overlay_set_size, reg0, pos1),
            (store_add, ":sub_cur_x", ":cur_x", 265), #250
            (position_set_x, pos1, ":sub_cur_x"),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),

            (player_get_ping, reg0, ":max_score_plus_death_player_no"),
            (create_text_overlay, reg0, "str_reg0", tf_right_align),
            (overlay_set_color, reg0, ":font_color"),
            (position_set_x, pos1, 750),
            (position_set_y, pos1, 750),
            (overlay_set_size, reg0, pos1),
            (store_add, ":sub_cur_x", ":cur_x", 315), #300
            (position_set_x, pos1, ":sub_cur_x"),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),
            (val_sub, ":cur_y", 20),
          (else_try),
            (try_begin),
              (try_begin),
                (eq, ":i_team", 0),
                (assign, ":number_of_bots_in_cur_team", "$g_multiplayer_num_bots_team_1"),
              (else_try),
                (assign, ":number_of_bots_in_cur_team", "$g_multiplayer_num_bots_team_2"),
              (try_end),

              (team_get_bot_kill_count, reg0, ":i_team"),
              (team_get_bot_death_count, reg1, ":i_team"),
              (try_begin),
                (this_or_next|neq, reg0, 0),
                (this_or_next|neq, reg1, 0),
                (neq, ":number_of_bots_in_cur_team", 0),
                (assign, ":write_bot_informations_of_team", 1),
              (else_try),
                (assign, ":write_bot_informations_of_team", 0),
              (try_end),

              (eq, ":write_bot_informations_of_team", 1),

              (assign, ":number_of_alive_bots", 0),
              (try_for_agents, ":cur_agent"),
                (agent_is_non_player, ":cur_agent"),
                (agent_is_alive, ":cur_agent"),
                (agent_get_team, ":cur_agent_team", ":cur_agent"),
                (eq, ":cur_agent_team", ":i_team"),
                (val_add, ":number_of_alive_bots", 1),
              (try_end),
              (store_sub, ":number_of_dead_bots", ":number_of_bots_in_cur_team", ":number_of_alive_bots"),
              (try_begin),
                (eq, ":number_of_alive_bots", 0),
                (assign, ":font_color", 0xFF0000),
              (else_try),
                (assign, ":font_color", 0xD0D0D0),
              (try_end),

              (try_begin),
                (gt, ":number_of_dead_bots", 0),
                (try_begin),
                  (eq, ":number_of_bots_in_cur_team", 1),
                  (create_text_overlay, reg0, "str_dead", 0),
                  (store_add, ":sub_cur_x", ":cur_x", 130),
                (else_try),
                  (assign, reg0, ":number_of_dead_bots"),
                  (create_text_overlay, reg0, "str_reg0_dead", 0),
                  (store_add, ":sub_cur_x", ":cur_x", 123),
                (try_end),
                (overlay_set_color, reg0, ":font_color"),
                (position_set_x, pos1, 750),
                (position_set_y, pos1, 750),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, ":sub_cur_x"),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),
              (try_end),

              (try_begin),
                (gt, ":number_of_bots_in_cur_team", 1),
                (assign, reg0, ":number_of_bots_in_cur_team"),
                (create_text_overlay, reg0, "str_bots_reg0_agents", 0),
              (else_try),
                (create_text_overlay, reg0, "str_bot_1_agent", 0),
              (try_end),
              (overlay_set_color, reg0, ":font_color"),
              (position_set_x, pos1, 750),
              (position_set_y, pos1, 750),
              (overlay_set_size, reg0, pos1),
              (position_set_x, pos1, ":cur_x"),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg0, pos1),

              (team_get_bot_kill_count, reg0, ":i_team"),
              (create_text_overlay, reg0, "str_reg0", tf_right_align),
              (overlay_set_color, reg0, ":font_color"),
              (position_set_x, pos1, 750),
              (position_set_y, pos1, 750),
              (overlay_set_size, reg0, pos1),
              (store_add, ":sub_cur_x", ":cur_x", 215), #200
              (position_set_x, pos1, ":sub_cur_x"),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg0, pos1),

              (team_get_bot_death_count, reg0, ":i_team"),
              (create_text_overlay, reg0, "str_reg0", tf_right_align),
              (overlay_set_color, reg0, ":font_color"),
              (position_set_x, pos1, 750),
              (position_set_y, pos1, 750),
              (overlay_set_size, reg0, pos1),
              (store_add, ":sub_cur_x", ":cur_x", 265), #250
              (position_set_x, pos1, ":sub_cur_x"),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg0, pos1),
              (val_sub, ":cur_y", 20),
            (try_end),
            (assign, ":end_cond", 0), #all players are written for this team, break
          (try_end),
        (try_end),

        (try_begin),
          (eq, ":i_team", 0),
          (assign, ":old_cur_y", ":cur_y"),
        (try_end),
      (try_end),

      (try_begin),
        (le, ":old_cur_y", ":cur_y"),
        (assign, ":cur_y", ":old_cur_y"),
      (try_end),

      (assign, ":cur_x", 42),

      #white line between playing players and spectators
      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_color, reg0, 0xFFFFFF),
      (overlay_set_alpha, reg0, 0xD0),
      (store_add, ":sub_cur_x", ":cur_x", 0),
      (position_set_x, pos1, ":sub_cur_x"),
      (store_add, ":sub_cur_y", ":cur_y", 10),
      (position_set_y, pos1, ":sub_cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 36000),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1),

      (try_begin),
        (gt, ":spectator_rows", 0),

        (assign, ":cur_x", 280),
        (val_sub, ":cur_y", 50),

        #"spectators" text
        (create_text_overlay, reg0, "str_spectators", 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, ":cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 1000),
        (position_set_y, pos1, 1000),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_ping", tf_right_align),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 215), #200
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        #white line for spectators list
        (create_mesh_overlay, reg0, "mesh_white_plane"),
        (overlay_set_color, reg0, 0xFFFFFF),
        (overlay_set_alpha, reg0, 0xD0),
        (store_add, ":sub_cur_x", ":cur_x", 0),
        (position_set_x, pos1, ":sub_cur_x"),
        (store_add, ":sub_cur_y", ":cur_y", -10),
        (position_set_y, pos1, ":sub_cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 12000),
        (position_set_y, pos1, 50),
        (overlay_set_size, reg0, pos1),

        (val_sub, ":cur_y", 30),

        (assign, ":font_color", 0xC0C0C0),

        (store_add, ":end_cond", ":num_players", 1),
        (try_for_range, ":player_no", 0, ":end_cond"),
          (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
          (troop_slot_eq, "trp_multiplayer_data", ":slot_index", 1),

          (player_get_team_no, ":player_team", ":player_no"),
          (eq, ":player_team", multi_team_spectator), #to not to allow dedicated server to pass below, dedicated servers have -1 for team_no not 2(multi_team_spectator).

          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 1),

          (try_begin),
            (eq, ":my_player_no", ":player_no"),
            (create_mesh_overlay, reg0, "mesh_white_plane"),
            (overlay_set_color, reg0, 0xFFFFFF),
            (overlay_set_alpha, reg0, 0x35),
            (store_add, ":sub_cur_x", ":cur_x", 0),
            (position_set_x, pos1, ":sub_cur_x"),
            (store_add, ":sub_cur_y", ":cur_y", 0),
            (position_set_y, pos1, ":sub_cur_y"),
            (overlay_set_position, reg0, pos1),
            (position_set_x, pos1, 12000),
            (position_set_y, pos1, 1000),
            (overlay_set_size, reg0, pos1),
          (try_end),

          (str_store_player_username, s1, ":player_no"),
          (create_text_overlay, reg0, s1, 0),
          (overlay_set_color, reg0, ":font_color"),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),

          (player_get_ping, reg0, ":player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, ":font_color"),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 215), #200
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),
        (try_end),
      (try_end),

      (omit_key_once, key_mouse_scroll_up),
      (omit_key_once, key_mouse_scroll_down),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_mouse_scroll_up),
        (key_clicked, key_mouse_scroll_down),
        (omit_key_once, key_mouse_scroll_up),
        (omit_key_once, key_mouse_scroll_down),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_stats_chart_opened_manually", 1),
        (neg|game_key_is_down, gk_leave),
        (assign, "$g_multiplayer_stats_chart_opened_manually", 0),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
      (try_end),
      (try_begin),
        (store_mul, ":update_period_time_limit", "$g_stats_chart_update_period", 1000),
        (gt, ":cur_time", ":update_period_time_limit"),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_stats_chart"),
      (try_end),
      ]),
    ]),

  #this score table is used in only deathmatch
  ("multiplayer_stats_chart_deathmatch", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_score_a"),
      (position_set_x, pos1, 295),
      (position_set_y, pos1, 115),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (assign, ":team_rows", 0),
      (assign, ":spectator_rows", 0),
      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 0, ":num_players"),
        (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
        (try_begin),
          (player_is_active, ":player_no"),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 1),
          (player_get_team_no, ":player_team", ":player_no"),
          (try_begin),
            (this_or_next|eq, ":player_team", 0),
            (eq, ":player_team", 1),
            (val_add, ":team_rows", 1),
          (else_try),
            (eq, ":player_team", multi_team_spectator),
            (val_add, ":spectator_rows", 1),
          (try_end),
        (else_try),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 0),
        (try_end),
      (try_end),
      (try_begin),
        (this_or_next|gt, "$g_multiplayer_num_bots_team_1", 0),
        (gt, "$g_multiplayer_num_bots_team_2", 0),
        (val_add, ":team_rows", 1),
      (try_end),

      (store_add, ":total_rows", ":team_rows", ":spectator_rows"),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_stats_chart_deathmatch_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 300),
      (position_set_y, pos1, 140),
      (overlay_set_position, "$g_presentation_obj_stats_chart_deathmatch_container", pos1),
      (position_set_x, pos1, 346),
      (position_set_y, pos1, 530),
      (overlay_set_area_size, "$g_presentation_obj_stats_chart_deathmatch_container", pos1),
      (set_container_overlay, "$g_presentation_obj_stats_chart_deathmatch_container"),

      (store_mul, ":y_needed", ":total_rows", 20),
      (val_add, ":y_needed", 80),
      (try_begin),
        (gt, ":spectator_rows", 0),
        (val_add, ":y_needed", 70),
      (try_end),

      (try_begin),
        (ge, ":total_rows", 17),
        (assign, "$g_stats_chart_update_period", 10),
      (else_try),
        (assign, "$g_stats_chart_update_period", 1),
      (try_end),

      (multiplayer_get_my_player, ":my_player_no"),

      #assuming only 2 teams in scene
      (assign, ":cur_y", ":y_needed"),
      (assign, ":cur_x", 42),

      (create_text_overlay, reg0, "str_player_name", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, ":cur_x"),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 750),
      (position_set_y, pos1, 750),
      (overlay_set_size, reg0, pos1),

      (create_text_overlay, reg0, "str_kills", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (store_add, ":sub_cur_x", ":cur_x", 179), #164
      (position_set_x, pos1, ":sub_cur_x"),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 750),
      (position_set_y, pos1, 750),
      (overlay_set_size, reg0, pos1),

      (create_text_overlay, reg0, "str_deaths", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (store_add, ":sub_cur_x", ":cur_x", 233), #205
      (position_set_x, pos1, ":sub_cur_x"),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 750),
      (position_set_y, pos1, 750),
      (overlay_set_size, reg0, pos1),

      (create_text_overlay, reg0, "str_ping", tf_center_justify),
      (overlay_set_color, reg0, 0xFFFFFF),
      (store_add, ":sub_cur_x", ":cur_x", 282), #264
      (position_set_x, pos1, ":sub_cur_x"),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 750),
      (position_set_y, pos1, 750),
      (overlay_set_size, reg0, pos1),

      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_color, reg0, 0xFFFFFF),
      (overlay_set_alpha, reg0, 0xD0),
      (store_add, ":sub_cur_x", ":cur_x", 0),
      (position_set_x, pos1, ":sub_cur_x"),
      (store_add, ":sub_cur_y", ":cur_y", -10),
      (position_set_y, pos1, ":sub_cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 15250),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1),

      (val_sub, ":cur_y", 35),

      (store_add, ":end_cond", ":num_players", 1),
      (try_for_range, ":unused", 0, ":end_cond"),
        (assign, ":max_score_plus_death", -30030),
        (assign, ":max_kills_player_no", -1),
        (try_for_range, ":player_no", 0, ":num_players"),
          (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
          (troop_slot_eq, "trp_multiplayer_data", ":slot_index", 1),
          (player_get_team_no, ":player_team", ":player_no"),
          (this_or_next|eq, ":player_team", 0),
          (eq, ":player_team", 1),

          (player_get_kill_count, ":kill_count", ":player_no"),
          (player_get_death_count, ":death_count", ":player_no"), #get_death_count
          (store_mul, ":player_score_plus_death", ":kill_count", 1000),
          (val_sub, ":player_score_plus_death", ":death_count"),

          (this_or_next|gt, ":player_score_plus_death", ":max_score_plus_death"),
          (eq, ":player_score_plus_death", -30030),

          (assign, ":max_score_plus_death", ":player_score_plus_death"),
          (assign, ":max_kills_player_no", ":player_no"),
        (try_end),
        (try_begin),
          (ge, ":max_kills_player_no", 0),
          (store_add, ":slot_index", ":max_kills_player_no", multi_data_player_index_list_begin),
          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 0),
          (str_store_player_username, s1, ":max_kills_player_no"),

          (try_begin),
            (eq, ":my_player_no", ":max_kills_player_no"),
            (create_mesh_overlay, reg0, "mesh_white_plane"),
            (overlay_set_color, reg0, 0xFFFFFF),
            (overlay_set_alpha, reg0, 0x35),
            (store_add, ":sub_cur_x", ":cur_x", 0),
            (position_set_x, pos1, ":sub_cur_x"),
            (store_add, ":sub_cur_y", ":cur_y", 0),
            (position_set_y, pos1, ":sub_cur_y"),
            (overlay_set_position, reg0, pos1),
            (position_set_x, pos1, 16000),
            (position_set_y, pos1, 1000),
            (overlay_set_size, reg0, pos1),
          (try_end),

          (create_text_overlay, reg0, s1, 0),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),

          (player_get_kill_count, reg0, ":max_kills_player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 188), #173
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),

          (player_get_death_count, reg0, ":max_kills_player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 238), #223
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),

          (player_get_ping, reg0, ":max_kills_player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xFFFFFF),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 288), #273
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),
        (else_try),
          (store_add, ":number_of_bots", "$g_multiplayer_num_bots_team_1", "$g_multiplayer_num_bots_team_2"),
          (ge, ":number_of_bots", 1),

          (try_begin),
            (gt, ":number_of_bots", 1),
            (assign, reg0, ":number_of_bots"),
            (create_text_overlay, reg0, "str_bots_reg0_agents", 0),
          (else_try),
            (create_text_overlay, reg0, "str_bot_1_agent", 0),
          (try_end),

          (overlay_set_color, reg0, 0xD0D0D0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),

          (team_get_bot_kill_count, reg0, 0),
          (assign, ":bot_kill_count", reg0),
          (team_get_bot_kill_count, reg0, 1),
          (val_add, ":bot_kill_count", reg0),
          (assign, reg0, ":bot_kill_count"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xD0D0D0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 188), #173
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),

          (team_get_bot_death_count, reg0, 0),
          (assign, ":bot_death_count", reg0),
          (team_get_bot_death_count, reg0, 1),
          (val_add, ":bot_death_count", reg0),
          (assign, reg0, ":bot_death_count"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, 0xD0D0D0),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 238), #223
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),

          (assign, ":end_cond", 0), #all players are written, break
        (else_try),
          (assign, ":end_cond", 0), #all players are written, break
        (try_end),
      (try_end),

      (assign, ":cur_x", 42),

      #white line between playing players and spectators
      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_color, reg0, 0xFFFFFF),
      (overlay_set_alpha, reg0, 0xD0),
      (store_add, ":sub_cur_x", ":cur_x", 0),
      (position_set_x, pos1, ":sub_cur_x"),
      (store_add, ":sub_cur_y", ":cur_y", 10),
      (position_set_y, pos1, ":sub_cur_y"),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 15250),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg0, pos1),

      (try_begin),
        (gt, ":spectator_rows", 0),

        (assign, ":cur_x", 75),
        (val_sub, ":cur_y", 50),

        #"spectators" text
        (create_text_overlay, reg0, "str_spectators", 0),
        (overlay_set_color, reg0, 0xFFFFFF),
        (position_set_x, pos1, ":cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 1000),
        (position_set_y, pos1, 1000),
        (overlay_set_size, reg0, pos1),

        (create_text_overlay, reg0, "str_ping", tf_center_justify),
        (overlay_set_color, reg0, 0xFFFFFF),
        (store_add, ":sub_cur_x", ":cur_x", 218), #200
        (position_set_x, pos1, ":sub_cur_x"),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg0, pos1),

        #white line for spectators list
        (create_mesh_overlay, reg0, "mesh_white_plane"),
        (overlay_set_color, reg0, 0xFFFFFF),
        (overlay_set_alpha, reg0, 0xD0),
        (store_add, ":sub_cur_x", ":cur_x", 0),
        (position_set_x, pos1, ":sub_cur_x"),
        (store_add, ":sub_cur_y", ":cur_y", -10),
        (position_set_y, pos1, ":sub_cur_y"),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 12000),
        (position_set_y, pos1, 50),
        (overlay_set_size, reg0, pos1),

        (val_sub, ":cur_y", 30),

        (assign, ":font_color", 0xC0C0C0),

        (store_add, ":end_cond", ":num_players", 1),
        (try_for_range, ":player_no", 0, ":end_cond"),
          (store_add, ":slot_index", ":player_no", multi_data_player_index_list_begin),
          (troop_slot_eq, "trp_multiplayer_data", ":slot_index", 1),

          (player_get_team_no, ":player_team", ":player_no"),
          (eq, ":player_team", multi_team_spectator), #to not to allow dedicated server to pass below, dedicated servers have -1 for team_no not 2(multi_team_spectator).

          (troop_set_slot, "trp_multiplayer_data", ":slot_index", 1),

          (try_begin),
            (eq, ":my_player_no", ":player_no"),
            (create_mesh_overlay, reg0, "mesh_white_plane"),
            (overlay_set_color, reg0, 0xFFFFFF),
            (overlay_set_alpha, reg0, 0x35),
            (store_add, ":sub_cur_x", ":cur_x", 0),
            (position_set_x, pos1, ":sub_cur_x"),
            (store_add, ":sub_cur_y", ":cur_y", 0),
            (position_set_y, pos1, ":sub_cur_y"),
            (overlay_set_position, reg0, pos1),
            (position_set_x, pos1, 12000), #16500
            (position_set_y, pos1, 1000),
            (overlay_set_size, reg0, pos1),
          (try_end),

          (str_store_player_username, s1, ":player_no"),
          (create_text_overlay, reg0, s1, 0),
          (overlay_set_color, reg0, ":font_color"),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),

          (player_get_ping, reg0, ":player_no"),
          (create_text_overlay, reg0, "str_reg0", tf_right_align),
          (overlay_set_color, reg0, ":font_color"),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 750),
          (overlay_set_size, reg0, pos1),
          (store_add, ":sub_cur_x", ":cur_x", 215), #200
          (position_set_x, pos1, ":sub_cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),
        (try_end),
      (try_end),

      (omit_key_once, key_mouse_scroll_up),
      (omit_key_once, key_mouse_scroll_down),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_mouse_scroll_up),
        (key_clicked, key_mouse_scroll_down),
        (omit_key_once, key_mouse_scroll_up),
        (omit_key_once, key_mouse_scroll_down),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_stats_chart_opened_manually", 1),
        (neg|game_key_is_down, gk_leave),
        (assign, "$g_multiplayer_stats_chart_opened_manually", 0),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
      (try_end),
      (try_begin),
        (store_mul, ":update_period_time_limit", "$g_stats_chart_update_period", 1000),
        (gt, ":cur_time", ":update_period_time_limit"),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_stats_chart_deathmatch"),
      (try_end),
      ]),
    ]),

  ("multiplayer_escape_menu", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_escape_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 75),
      (overlay_set_position, "$g_presentation_obj_escape_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 550),
      (overlay_set_area_size, "$g_presentation_obj_escape_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_escape_menu_container"),

      (assign, ":cur_y", 500),

      (create_text_overlay, reg0, "str_choose_an_option", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (create_button_overlay, "$g_presentation_obj_escape_menu_1", "str_choose_faction", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_1", 0xFFFFFF),
      (multiplayer_get_my_team, ":my_team"),
      (assign, "$g_presentation_obj_escape_menu_2", -1),
      (assign, "$g_presentation_obj_escape_menu_3", -1),
      (assign, "$g_presentation_obj_escape_menu_6", -1),
      (assign, "$g_presentation_obj_escape_menu_7", -1),
      (assign, "$g_presentation_obj_escape_menu_8", -1),
      (assign, "$g_presentation_obj_escape_menu_9", -1),
      (assign, "$g_presentation_obj_escape_menu_10", -1),
      (assign, "$g_presentation_obj_escape_menu_11", -1),
      (assign, "$g_presentation_obj_escape_menu_12", -1),
      (assign, "$g_presentation_obj_escape_menu_13", -1),
      (try_begin),
        (lt, ":my_team", multi_team_spectator),
        (create_button_overlay, "$g_presentation_obj_escape_menu_2", "str_choose_troop", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_2", 0xFFFFFF),
        (multiplayer_get_my_troop, ":my_troop"),
        (try_begin),
          (ge, ":my_troop", 0),
          (create_button_overlay, "$g_presentation_obj_escape_menu_3", "str_choose_items", 0),
          (overlay_set_color, "$g_presentation_obj_escape_menu_3", 0xFFFFFF),
        (try_end),
      (try_end),
      (create_button_overlay, "$g_presentation_obj_escape_menu_4", "str_options", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_4", 0xFFFFFF),
      (create_button_overlay, "$g_presentation_obj_escape_menu_5", "str_redefine_keys", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_5", 0xFFFFFF),

      (create_button_overlay, "$g_presentation_obj_escape_menu_13", "@Show game rules", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_13", 0xFFFFFF),

      (multiplayer_get_my_player, ":my_player_no"),
      (try_begin),
        (this_or_next|eq, "$g_multiplayer_maps_voteable", 1),
        (this_or_next|eq, "$g_multiplayer_factions_voteable", 1),
        (this_or_next|gt, "$g_multiplayer_num_bots_voteable", 0),
        (this_or_next|eq, "$g_multiplayer_kick_voteable", 1),
        (eq, "$g_multiplayer_ban_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_escape_menu_6", "str_submit_a_poll", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_6", 0xFFFFFF),
        (assign, "$g_presentation_obj_escape_menu_6_available", 1),
        (try_begin),
          (ge, ":my_player_no", 0),
          (player_get_slot, ":last_poll_time", ":my_player_no", slot_player_poll_disabled_until_time),
          (store_mission_timer_a, ":mission_timer"),
          (lt, ":mission_timer", ":last_poll_time"),
          (overlay_set_color, "$g_presentation_obj_escape_menu_6", 0x888888),
          (overlay_set_hilight_color, "$g_presentation_obj_escape_menu_6", 0x888888),
          (assign, "$g_presentation_obj_escape_menu_6_available", 0),
        (try_end),
      (try_end),

      (try_begin),
        (ge, ":my_player_no", 0),
        (player_is_admin, ":my_player_no"),
        (create_button_overlay, "$g_presentation_obj_escape_menu_7", "str_administrator_panel", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_7", 0xFFFFFF),
        (create_button_overlay, "$g_presentation_obj_escape_menu_8", "str_kick_player", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_8", 0xFFFFFF),
        (create_button_overlay, "$g_presentation_obj_escape_menu_9", "str_ban_player", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_9", 0xFFFFFF),
      (try_end),

      (create_button_overlay, "$g_presentation_obj_escape_menu_11", "str_mute_player", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_11", 0xFFFFFF),

      (try_begin),
        (assign, "$g_presentation_obj_escape_menu_12", -1),
        (assign, ":any_muted", 0),
        (get_max_players, ":num_players"),
        (try_for_range, ":player_no", 0, ":num_players"),
          (player_is_active, ":player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 1),
          (assign, ":any_muted", 1),
        (try_end),
        (eq, ":any_muted", 1),
        (create_button_overlay, "$g_presentation_obj_escape_menu_12", "str_unmute_player", 0),
        (overlay_set_color, "$g_presentation_obj_escape_menu_12", 0xFFFFFF),
      (try_end),

      (create_button_overlay, "$g_presentation_obj_escape_menu_10", "str_quit", 0),
      (overlay_set_color, "$g_presentation_obj_escape_menu_10", 0xFFFFFF),

      (position_set_x, pos1, 130),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_1", pos1),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_2", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_2", pos1),
      (try_end),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_3", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_3", pos1),
      (try_end),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_4", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_5", pos1),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_13", pos1),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_6", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_6", pos1),
      (try_end),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_7", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_7", pos1),
      (try_end),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_8", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_8", pos1),
      (try_end),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_9", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_9", pos1),
      (try_end),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_11", pos1),
      (try_begin),
        (ge, "$g_presentation_obj_escape_menu_12", 0),
        (val_sub, ":cur_y", escape_menu_item_height),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_escape_menu_12", pos1),
      (try_end),
      (val_sub, ":cur_y", escape_menu_item_height),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, "$g_presentation_obj_escape_menu_10", pos1),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_escape_menu_1"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_team_select"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_2"),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_troop_select"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_3"),
        (presentation_set_duration, 0),
        (assign, "$g_presentation_state", 0),
        (start_presentation, "prsnt_multiplayer_item_select"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_4"),
        (presentation_set_duration, 0),
        (change_screen_options),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_5"),
        (presentation_set_duration, 0),
        (change_screen_controls),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_6"),
        (eq, "$g_presentation_obj_escape_menu_6_available", 1),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_multiplayer_poll_menu"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_7"),
        (presentation_set_duration, 0),
        (multiplayer_send_message_to_server, multiplayer_event_open_admin_panel),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_8"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 3), #admin kick
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_9"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 4), #admin ban
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_10"),
        (presentation_set_duration, 0),
        (finish_mission, 0),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_11"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 5), #mute player
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_12"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 6), #unmute player
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_escape_menu_13"),
        (presentation_set_duration, 0),
        (multiplayer_send_message_to_server, multiplayer_event_open_game_rules),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_poll_menu", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_poll_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_poll_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_poll_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_poll_menu_container"),

      (assign, "$g_presentation_obj_poll_menu_1", -1),
      (assign, "$g_presentation_obj_poll_menu_4", -1),
      (assign, "$g_presentation_obj_poll_menu_5", -1),

      (assign, ":cur_y", 450),

      (create_text_overlay, reg0, "str_choose_a_poll_type", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (position_set_x, pos1, 60),

      (try_begin),
        (eq, "$g_multiplayer_maps_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_poll_menu_1", "str_poll_for_changing_the_map", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_1", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_1", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_factions_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_poll_menu_4", "str_poll_for_changing_the_map_and_factions", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_4", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_4", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (try_begin),
        (gt, "$g_multiplayer_num_bots_voteable", 0),
        (create_button_overlay, "$g_presentation_obj_poll_menu_5", "str_poll_for_changing_number_of_bots", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_5", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_5", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_kick_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_poll_menu_2", "str_poll_for_kicking_a_player", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_2", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_2", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (try_begin),
        (eq, "$g_multiplayer_ban_voteable", 1),
        (create_button_overlay, "$g_presentation_obj_poll_menu_3", "str_poll_for_banning_a_player", 0),
        (overlay_set_color, "$g_presentation_obj_poll_menu_3", 0xFFFFFF),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_poll_menu_3", pos1),
      (try_end),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_poll_menu_1"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_maps_list_action_type", 1), #poll map
        (start_presentation, "prsnt_multiplayer_show_maps_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_poll_menu_2"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 1), #poll kick
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_poll_menu_3"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_players_list_action_type", 2), #poll ban
        (start_presentation, "prsnt_multiplayer_show_players_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_poll_menu_4"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_maps_list_action_type", 2), #poll map and factions
        (start_presentation, "prsnt_multiplayer_show_maps_list"),
      (else_try),
        (eq, ":object", "$g_presentation_obj_poll_menu_5"),
        (presentation_set_duration, 0),
        (assign, "$g_multiplayer_number_of_bots_list_action_type", 1), #for team 1
        (start_presentation, "prsnt_multiplayer_show_number_of_bots_list"),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_show_players_list", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_show_players_1", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_show_players_1", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_show_players_1", pos1),
      (set_container_overlay, "$g_presentation_obj_show_players_1"),

      #(assign, ":cur_y", 450),
      (multiplayer_get_my_player, ":my_player_no"),

      (assign, ":cur_y", 10),
      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 1, ":num_players"), #0 is server no need to write it
        (player_is_active, ":player_no"),

        (assign, ":continue", 0),
        (try_begin),
          (neq, "$g_multiplayer_players_list_action_type", 5),
          (neq, "$g_multiplayer_players_list_action_type", 6),
          (assign, ":continue", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 5),
          (neq, ":player_no", ":my_player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 0),
          (assign, ":continue", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 6),
          (neq, ":player_no", ":my_player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 1),
          (assign, ":continue", 1),
        (try_end),
        (eq, ":continue", 1),

        (val_add, ":cur_y", escape_menu_item_height),
      (try_end),

      (create_text_overlay, reg0, "str_choose_a_player", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 1, ":num_players"), #0 is server no need to write it
        (player_is_active, ":player_no"),
        (player_set_slot, ":player_no", slot_player_button_index, -1),

        (assign, ":continue", 0),
        (try_begin),
          (neq, "$g_multiplayer_players_list_action_type", 5),
          (neq, "$g_multiplayer_players_list_action_type", 6),
          (assign, ":continue", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 5),
          (neq, ":player_no", ":my_player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 0),
          (assign, ":continue", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 6),
          (neq, ":player_no", ":my_player_no"),
          (player_get_is_muted, ":is_muted", ":player_no"),
          (eq, ":is_muted", 1),
          (assign, ":continue", 1),
        (try_end),
        (eq, ":continue", 1),
        (str_store_player_username, s0, ":player_no"),

        (create_button_overlay, ":overlay_id", s0, 0),
        (overlay_set_color, ":overlay_id", 0xFFFFFF),
        (position_set_x, pos1, 130),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, ":overlay_id", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
        (player_set_slot, ":player_no", slot_player_button_index, ":overlay_id"),
      (try_end),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (get_max_players, ":num_players"),
      (try_for_range, ":player_no", 1, ":num_players"), #0 is server no need to write it
        (player_is_active, ":player_no"),
        (player_slot_eq, ":player_no", slot_player_button_index, ":object"),
        (try_begin),
          (is_between, "$g_multiplayer_players_list_action_type", 1, 3), #poll kick or poll ban
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (ge, ":my_player_no", 0),
            (multiplayer_send_2_int_to_server, multiplayer_event_start_new_poll, "$g_multiplayer_players_list_action_type", ":player_no"),
            (store_mission_timer_a, ":mission_timer"),
            (val_add, ":mission_timer", multiplayer_poll_disable_period),
            (player_set_slot, ":my_player_no", slot_player_poll_disabled_until_time, ":mission_timer"),
          (try_end),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 3), #admin kick
          (multiplayer_send_int_to_server, multiplayer_event_admin_kick_player, ":player_no"),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 4), #admin ban
          (multiplayer_send_int_to_server, multiplayer_event_admin_ban_player, ":player_no"),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 5), #mute player
          (player_set_is_muted, ":player_no", 1),
        (else_try),
          (eq, "$g_multiplayer_players_list_action_type", 6), #unmute player
          (player_set_is_muted, ":player_no", 0),
        (try_end),
        (assign, ":num_players", 0), #break
        (presentation_set_duration, 0),
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_show_maps_list", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_show_maps_list_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_show_maps_list_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_show_maps_list_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_show_maps_list_menu_container"),

      (call_script, "script_multiplayer_fill_map_game_types", "$g_multiplayer_game_type"),
      (assign, ":num_maps", reg0),
      (store_mul, ":cur_y", ":num_maps", escape_menu_item_height),
      (val_add, ":cur_y", 10),

      (create_text_overlay, reg0, "str_choose_a_map", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (assign, ":overlay_id", -1),
      (try_for_range, ":i_map", 0, ":num_maps"),
        (store_add, ":map_slot", ":i_map", multi_data_maps_for_game_type_begin),
        (troop_get_slot, ":map_no", "trp_multiplayer_data", ":map_slot"),
        (store_sub, ":string_index", ":map_no", multiplayer_scenes_begin),
        (val_add, ":string_index", multiplayer_scene_names_begin),
        (str_store_string, s0, ":string_index"),

        (create_button_overlay, ":overlay_id", s0, 0),
        (overlay_set_color, ":overlay_id", 0xFFFFFF),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, ":overlay_id", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (store_add, "$g_show_maps_list_button_list_end_index", ":overlay_id", 1),
      (store_sub, "$g_show_maps_list_button_list_first_index", "$g_show_maps_list_button_list_end_index", ":num_maps"),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_for_range, ":i_button", "$g_show_maps_list_button_list_first_index", "$g_show_maps_list_button_list_end_index"),
        (eq, ":object", ":i_button"),
        (call_script, "script_multiplayer_fill_map_game_types", "$g_multiplayer_game_type"),
        (store_sub, ":map_slot", ":object", "$g_show_maps_list_button_list_first_index"),
        (val_add, ":map_slot", multi_data_maps_for_game_type_begin),
        (troop_get_slot, ":scene_id", "trp_multiplayer_data", ":map_slot"),
        (presentation_set_duration, 0),
        (try_begin),
          (eq, "$g_multiplayer_maps_list_action_type", 1), #vote for map
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (ge, ":my_player_no", 0),
            (multiplayer_send_2_int_to_server, multiplayer_event_start_new_poll, 0, ":scene_id"),
            (store_mission_timer_a, ":mission_timer"),
            (val_add, ":mission_timer", multiplayer_poll_disable_period),
            (player_set_slot, ":my_player_no", slot_player_poll_disabled_until_time, ":mission_timer"),
          (try_end),
        (else_try), #vote for map and factions
          (assign, "$g_multiplayer_factions_list_action_type", 1), #for team 1
          (assign, "$g_multiplayer_poll_for_map_and_faction_data_map", ":scene_id"),
          (start_presentation, "prsnt_multiplayer_show_factions_list"),
        (try_end),
        (assign, "$g_show_maps_list_button_list_end_index", 0), #break;
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_show_factions_list", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_show_factions_list_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_show_factions_list_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_show_factions_list_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_show_factions_list_menu_container"),

      (store_sub, ":num_factions", npc_kingdoms_end, npc_kingdoms_begin),
      (try_begin),
        (eq, "$g_multiplayer_factions_list_action_type", 2),
        (val_sub, ":num_factions", 1),
      (try_end),
      (store_mul, ":cur_y", ":num_factions", escape_menu_item_height),
      (val_add, ":cur_y", 10),

      (assign, reg0, "$g_multiplayer_factions_list_action_type"),
      (create_text_overlay, reg0, "str_choose_a_faction_for_team_reg0", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (assign, ":overlay_id", -1),
      (try_for_range, ":i_faction", npc_kingdoms_begin, npc_kingdoms_end),
        (this_or_next|eq, "$g_multiplayer_factions_list_action_type", 1),
        (neq, "$g_multiplayer_poll_for_map_and_faction_data_faction_1", ":i_faction"),
        (str_store_faction_name, s0, ":i_faction"),
        (create_button_overlay, ":overlay_id", s0, 0),
        (overlay_set_color, ":overlay_id", 0xFFFFFF),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, ":overlay_id", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (store_add, "$g_show_factions_list_button_list_end_index", ":overlay_id", 1),
      (store_sub, "$g_show_factions_list_button_list_first_index", "$g_show_factions_list_button_list_end_index", ":num_factions"),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_for_range, ":i_button", "$g_show_factions_list_button_list_first_index", "$g_show_factions_list_button_list_end_index"),
        (eq, ":object", ":i_button"),
        (store_sub, ":faction_no", ":object", "$g_show_factions_list_button_list_first_index"),
        (val_add, ":faction_no", npc_kingdoms_begin),
        (presentation_set_duration, 0),
        (try_begin),
          (eq, "$g_multiplayer_factions_list_action_type", 2), #vote for second team
          (try_begin),
            (ge, ":faction_no", "$g_multiplayer_poll_for_map_and_faction_data_faction_1"),
            (val_add, ":faction_no", 1),
          (try_end),
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (ge, ":my_player_no", 0),
            (multiplayer_send_4_int_to_server, multiplayer_event_start_new_poll, 3, "$g_multiplayer_poll_for_map_and_faction_data_map", "$g_multiplayer_poll_for_map_and_faction_data_faction_1", ":faction_no"),
            (store_mission_timer_a, ":mission_timer"),
            (val_add, ":mission_timer", multiplayer_poll_disable_period),
            (player_set_slot, ":my_player_no", slot_player_poll_disabled_until_time, ":mission_timer"),
          (try_end),
        (else_try), #vote for first team
          (assign, "$g_multiplayer_factions_list_action_type", 2), #for team 2
          (assign, "$g_multiplayer_poll_for_map_and_faction_data_faction_1", ":faction_no"),
          (start_presentation, "prsnt_multiplayer_show_factions_list"),
        (try_end),
        (assign, "$g_show_factions_list_button_list_end_index", 0), #break;
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_show_number_of_bots_list", prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_mp_ingame_menu"),
      (position_set_x, pos1, 250),
      (position_set_y, pos1, 80),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 1000),
      (overlay_set_size, reg0, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_show_number_of_bots_list_menu_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 285),
      (position_set_y, pos1, 125),
      (overlay_set_position, "$g_presentation_obj_show_number_of_bots_list_menu_container", pos1),
      (position_set_x, pos1, 405),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_show_number_of_bots_list_menu_container", pos1),
      (set_container_overlay, "$g_presentation_obj_show_number_of_bots_list_menu_container"),

      (assign, ":num_options", 0),
      (store_add, ":end_cond", "$g_multiplayer_num_bots_voteable", 1),
      (try_for_range, ":i_number", 0, ":end_cond"),
        (assign, ":i_number_mod_5", ":i_number"),
        (val_mod, ":i_number_mod_5", 5),
        (this_or_next|lt, ":i_number", 10),
        (eq, ":i_number_mod_5", 0),
        (val_add, ":num_options", 1),
      (try_end),

      (store_mul, ":cur_y", ":num_options", escape_menu_item_height),
      (val_add, ":cur_y", 10),

      (assign, reg0, "$g_multiplayer_number_of_bots_list_action_type"),
      (create_text_overlay, reg0, "str_choose_number_of_bots_for_team_reg0", 0),
      (overlay_set_color, reg0, 0xFFFFFF),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg0, pos1),
      (val_sub, ":cur_y", escape_menu_item_height),

      (assign, ":overlay_id", -1),
      (try_for_range, ":i_number", 0, ":end_cond"),
        (assign, ":i_number_mod_5", ":i_number"),
        (val_mod, ":i_number_mod_5", 5),
        (this_or_next|lt, ":i_number", 10),
        (eq, ":i_number_mod_5", 0),
        (assign, reg0, ":i_number"),
        (str_store_string, s0, "str_reg0"),
        (create_button_overlay, ":overlay_id", s0, 0),
        (overlay_set_color, ":overlay_id", 0xFFFFFF),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, ":overlay_id", pos1),
        (val_sub, ":cur_y", escape_menu_item_height),
      (try_end),
      (store_add, "$g_show_number_of_bots_list_button_list_end_index", ":overlay_id", 1),
      (store_sub, "$g_show_number_of_bots_list_button_list_first_index", "$g_show_number_of_bots_list_button_list_end_index", ":num_options"),

      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_for_range, ":i_button", "$g_show_number_of_bots_list_button_list_first_index", "$g_show_number_of_bots_list_button_list_end_index"),
        (eq, ":object", ":i_button"),
        (store_sub, ":value_index", ":object", "$g_show_number_of_bots_list_button_list_first_index"),
        (try_begin),
          (lt, ":value_index", 10),
          (assign, ":used_value", ":value_index"),
        (else_try),
          (store_sub, ":used_value", ":value_index", 8),
          (val_mul, ":used_value", 5),
        (try_end),
        (presentation_set_duration, 0),
        (try_begin),
          (eq, "$g_multiplayer_number_of_bots_list_action_type", 2), #vote for second team
          (try_begin),
            (multiplayer_get_my_player, ":my_player_no"),
            (ge, ":my_player_no", 0),
            (multiplayer_send_3_int_to_server, multiplayer_event_start_new_poll, 4, "$g_multiplayer_poll_number_of_bots_team_1", ":used_value"),
            (store_mission_timer_a, ":mission_timer"),
            (val_add, ":mission_timer", multiplayer_poll_disable_period),
            (player_set_slot, ":my_player_no", slot_player_poll_disabled_until_time, ":mission_timer"),
          (try_end),
        (else_try), #vote for first team
          (assign, "$g_multiplayer_number_of_bots_list_action_type", 2), #for team 2
          (assign, "$g_multiplayer_poll_number_of_bots_team_1", ":used_value"),
          (start_presentation, "prsnt_multiplayer_show_number_of_bots_list"),
        (try_end),
        (assign, "$g_show_number_of_bots_list_button_list_end_index", 0), #break;
      (try_end),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(key_clicked, key_xbox_start),
        (gt, ":cur_time", 200),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("multiplayer_poll", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_color, reg0, 0x000000),
      (overlay_set_alpha, reg0, 0x44),
      (position_set_x, pos1, 50),
      (position_set_y, pos1, 50),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos1, 37500),
      (position_set_y, pos1, 4500),
      (overlay_set_size, reg0, pos1),

      (try_begin),
        (eq, "$g_multiplayer_poll_to_show", 0),
        (store_sub, ":string_index", "$g_multiplayer_poll_value_to_show", multiplayer_scenes_begin),
        (val_add, ":string_index", multiplayer_scene_names_begin),
        (str_store_string, s0, ":string_index"),
        (create_text_overlay, reg0, "str_poll_change_map", tf_center_justify),
      (else_try),
        (eq, "$g_multiplayer_poll_to_show", 1),
        (str_store_player_username, s0, "$g_multiplayer_poll_value_to_show"),
        (create_text_overlay, reg0, "str_poll_kick_player", tf_center_justify),
      (else_try),
        (eq, "$g_multiplayer_poll_to_show", 2),
        (str_store_player_username, s0, "$g_multiplayer_poll_value_to_show"),
        (create_text_overlay, reg0, "str_poll_ban_player", tf_center_justify),
      (else_try),
        (eq, "$g_multiplayer_poll_to_show", 3),
        (store_sub, ":string_index", "$g_multiplayer_poll_value_to_show", multiplayer_scenes_begin),
        (val_add, ":string_index", multiplayer_scene_names_begin),
        (str_store_string, s0, ":string_index"),
        (str_store_faction_name, s1, "$g_multiplayer_poll_value_2_to_show"),
        (str_store_faction_name, s2, "$g_multiplayer_poll_value_3_to_show"),
        (create_text_overlay, reg0, "str_poll_change_map_with_faction", tf_center_justify|tf_scrollable_style_2),
      (else_try),
        (assign, reg0, "$g_multiplayer_poll_value_to_show"),
        (assign, reg1, "$g_multiplayer_poll_value_2_to_show"),
        (str_store_faction_name, s0, "$g_multiplayer_team_1_faction"),
        (str_store_faction_name, s1, "$g_multiplayer_team_2_faction"),
        (create_text_overlay, reg0, "str_poll_change_number_of_bots", tf_center_justify|tf_scrollable_style_2),
      (try_end),
      (overlay_set_color, reg0, 0xFFFFFF),
      (try_begin),
        (neq, "$g_multiplayer_poll_to_show", 3),
        (neq, "$g_multiplayer_poll_to_show", 4),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 100),
        (overlay_set_position, reg0, pos1),
      (else_try),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 70),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 60),
        (overlay_set_area_size, reg0, pos1),
      (try_end),

      (store_mission_timer_a, ":mission_timer"),
      (store_sub, "$g_multiplayer_poll_last_written_seconds_left", "$g_multiplayer_poll_client_end_time", ":mission_timer"),
      (assign, reg0, "$g_multiplayer_poll_last_written_seconds_left"),

      (create_text_overlay, "$g_presentation_obj_poll_1", "str_poll_time_left", tf_right_align|tf_single_line),
      (overlay_set_color, "$g_presentation_obj_poll_1", 0xFFFFFF),
      (position_set_x, pos1, 790),
      (position_set_y, pos1, 60),
      (overlay_set_position, "$g_presentation_obj_poll_1", pos1),

      (omit_key_once, key_1),
      (omit_key_once, key_2),
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
     [(store_trigger_param_1, ":cur_time"),
      (try_begin),
        (this_or_next|key_clicked, key_escape),
		(this_or_next|key_clicked, key_xbox_start),
        (key_clicked, key_2),
        (gt, ":cur_time", 500),
        (multiplayer_send_int_to_server, multiplayer_event_answer_to_poll, 0),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
      (else_try),
        (key_clicked, key_1),
        (gt, ":cur_time", 500),
        (multiplayer_send_int_to_server, multiplayer_event_answer_to_poll, 1),
        (clear_omitted_keys),
        (presentation_set_duration, 0),
      (try_end),
      (store_mission_timer_a, ":mission_timer"),
      (store_sub, ":time_left", "$g_multiplayer_poll_client_end_time", ":mission_timer"),
      (try_begin),
        (neq, ":time_left", "$g_multiplayer_poll_last_written_seconds_left"),
        (try_begin),
          (lt, ":time_left", 0),
          (clear_omitted_keys),
          (presentation_set_duration, 0),
        (else_try),
          (assign, "$g_multiplayer_poll_last_written_seconds_left", ":time_left"),
          (assign, reg0, "$g_multiplayer_poll_last_written_seconds_left"),
          (overlay_set_text, "$g_presentation_obj_poll_1", "str_poll_time_left"),
        (try_end),
      (try_end),
      ]),
    ]),

  ("tutorial_show_mouse_movement",prsntf_read_only|prsntf_manual_end_only,0,[
      (ti_on_presentation_load,
       [
         (try_begin),
           (this_or_next|eq, "$g_tutorial_mouse_dir", -1),
           (eq, "$g_tutorial_mouse_click", -1),
           (presentation_set_duration, 0),
         (else_try),
           (set_fixed_point_multiplier, 1000),
           (assign, "$g_tutorial_displayed_mouse_dir", "$g_tutorial_mouse_dir"),
           (assign, "$g_tutorial_displayed_mouse_click", "$g_tutorial_mouse_click"),
           (store_add, ":arrow_mesh", "$g_tutorial_mouse_dir", "mesh_mouse_arrow_down"),
           (create_mesh_overlay, reg0, ":arrow_mesh"),
           (position_set_x, pos1, 800),
           (position_set_y, pos1, 800),
           (overlay_set_size, reg0, pos1),
           (position_set_x, pos1, 380),
           (position_set_y, pos1, 500),
           (overlay_set_position, reg0, pos1),
           (try_begin),
             (eq, "$g_tutorial_mouse_click", 0),
             (create_mesh_overlay, reg0, "mesh_mouse_left_click"),
           (else_try),
             (create_mesh_overlay, reg0, "mesh_mouse_right_click"),
           (try_end),
           (position_set_x, pos1, 800),
           (position_set_y, pos1, 800),
           (overlay_set_size, reg0, pos1),
           (position_set_x, pos1, 540),
           (position_set_y, pos1, 500),
           (overlay_set_position, reg0, pos1),
           (create_mesh_overlay, reg0, "mesh_mouse_arrow_plus"),
           (overlay_set_color, reg0, 0xFFFFFF),
           (position_set_x, pos1, 600),
           (position_set_y, pos1, 600),
           (overlay_set_size, reg0, pos1),
           (position_set_x, pos1, 470),
           (position_set_y, pos1, 510),
           (overlay_set_position, reg0, pos1),
           (presentation_set_duration, 999999),
         (try_end),
        ]),
      (ti_on_presentation_run,
       [(try_begin),
          (this_or_next|neq, "$g_tutorial_displayed_mouse_dir", "$g_tutorial_mouse_dir"),
          (neq, "$g_tutorial_displayed_mouse_click", "$g_tutorial_mouse_click"),
          (presentation_set_duration, 0),
          (try_begin),
            (ge, "$g_tutorial_mouse_dir", 0),
            (ge, "$g_tutorial_mouse_click", 0),
            (start_presentation, "prsnt_tutorial_show_mouse_movement"),
          (try_end),
        (try_end),
        ]),
      ]),

  ("name_kingdom",0,mesh_load_window,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (str_store_string, s1, "str_name_kingdom_text"),
        (create_text_overlay, reg1, s1, tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),
        (overlay_set_text, reg1, s1),
        (create_simple_text_box_overlay, "$g_presentation_obj_name_kingdom_1"),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_name_kingdom_1", pos1),
        (try_begin),
          (eq, "$players_kingdom_name_set", 1),
          (str_store_faction_name, s7, "fac_player_supporters_faction"),
          (overlay_set_text, "$g_presentation_obj_name_kingdom_1", s7),
        (else_try),
          (str_store_troop_name, s0, "trp_player"),
          (overlay_set_text, "$g_presentation_obj_name_kingdom_1", "str_default_kingdom_name"),
          (str_store_string, s7, "str_default_kingdom_name"),
        (try_end),

        (create_button_overlay, "$g_presentation_obj_name_kingdom_2", "@Continue...", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_name_kingdom_2", pos1),
        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_name_kingdom_1"),
          (str_store_string, s7, s0),
        (else_try),
          (eq, ":object", "$g_presentation_obj_name_kingdom_2"),
          (faction_set_name, "fac_player_supporters_faction", s7),
          (faction_set_color, "fac_player_supporters_faction", 0xFFFFFF),
          (assign, "$players_kingdom_name_set", 1),
          (presentation_set_duration, 0),
        (try_end),
        ]),
      ]),

  ("banner_selection",0,mesh_load_window,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (str_store_string, s1, "str_banner_selection_text"),
        (create_text_overlay, reg1, s1, tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (overlay_set_text, reg1, s1),
        (create_button_overlay, "$g_presentation_obj_banner_selection_1", "@Next Page", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 50),
        (overlay_set_position, "$g_presentation_obj_banner_selection_1", pos1),

        (assign, ":x_pos", 150),
        (assign, ":y_pos", 575),
        (assign, ":try_end", banner_meshes_end_minus_one),
        (store_sub, ":num_npc_kingdoms", npc_kingdoms_end, npc_kingdoms_begin),
        (val_sub, ":try_end", ":num_npc_kingdoms"), #do not allow kingdom banners to be selected
        (store_mul, ":begin_mesh", 16, "$g_presentation_page_no"),
        (val_add, ":begin_mesh", banner_meshes_begin),
        (store_add, ":try_end_2", ":begin_mesh", 16),
        (val_min, ":try_end", ":try_end_2"),
        (store_add, "$g_presentation_banner_start", "$g_presentation_obj_banner_selection_1", 1),
        (try_for_range, ":cur_banner_mesh", ":begin_mesh", ":try_end"),
          (create_image_button_overlay, reg1, ":cur_banner_mesh", ":cur_banner_mesh"),
          (position_set_x, pos1, ":x_pos"),
          (position_set_y, pos1, ":y_pos"),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 100),
          (position_set_y, pos1, 100),
          (overlay_set_size, reg1, pos1),
          (val_add, ":x_pos", 100),
          (ge, ":x_pos", 900),
          (assign, ":x_pos", 150),
          (val_sub, ":y_pos", 250),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_banner_selection_1"),
          (val_add, "$g_presentation_page_no", 1),
          (val_mod, "$g_presentation_page_no", 8),
          (start_presentation, "prsnt_banner_selection"),
        (else_try),
###Floris: Removed the CC code since it only causes trouble
## CC 1.324 give back the lord's banner ($g_troop_take_back_banner)
#          (try_begin),
#            (neq, "$g_troop_take_back_banner", 0),
#            (troop_get_slot, ":player_cur_banner_spr", "trp_player", slot_troop_banner_scene_prop),
#            (troop_set_slot, "$g_troop_take_back_banner", slot_troop_banner_scene_prop, ":player_cur_banner_spr"),
#            (store_sub, ":cur_banner", ":player_cur_banner_spr", banner_scene_props_begin),
#            (val_add, ":cur_banner", banner_map_icons_begin),
#            (try_begin),
#              (troop_get_slot, ":cur_party", "$g_troop_take_back_banner", slot_troop_leaded_party),
#              (gt, ":cur_party", 0),
#              (party_set_banner_icon, ":cur_party", ":cur_banner"),
#            (try_end),
#            (try_for_range, ":cur_center", walled_centers_begin, walled_centers_end),
#              (party_slot_eq, ":cur_center", slot_town_lord, "$g_troop_take_back_banner"),
#              (party_set_banner_icon, ":cur_center", ":cur_banner"),
#            (try_end),
#          (try_end),
## CC
###
          (store_sub, ":selected_banner", ":object", "$g_presentation_banner_start"),
          (store_mul, ":page_adder", 16, "$g_presentation_page_no"),
          (val_add, ":selected_banner", ":page_adder"),
          (store_add, ":selected_banner_map_icon", ":selected_banner", banner_map_icons_begin),
          (party_set_banner_icon, "p_main_party", ":selected_banner_map_icon"),
          (store_add, ":selected_banner_spr", ":selected_banner", banner_scene_props_begin),
          (troop_set_slot, "trp_player", slot_troop_banner_scene_prop, ":selected_banner_spr"),
          (presentation_set_duration, 0),
          (assign, ":troop_to_change", 0),
          (assign, ":end_cond", active_npcs_end),
         (try_for_range, ":cur_troop", active_npcs_begin, ":end_cond"),
            (troop_slot_eq, ":cur_troop", slot_troop_banner_scene_prop, ":selected_banner_spr"),
            (assign, ":troop_to_change", ":cur_troop"),
            (assign, ":end_cond", 0),
#            (troop_set_slot, ":cur_troop", slot_troop_banner_scene_prop, banner_scene_props_end_minus_one),
            (troop_get_slot, ":cur_party", ":cur_troop", slot_troop_leaded_party),
            (gt, ":cur_party", 0),
#            (party_set_banner_icon, ":cur_party", banner_map_icons_end_minus_one),
          (try_end),
          (try_for_range, ":cur_center", walled_centers_begin, walled_centers_end),
            (try_begin),
              (party_slot_eq, ":cur_center", slot_town_lord, "trp_player"),
              (party_set_banner_icon, ":cur_center", ":selected_banner_map_icon"),
            (else_try),
              (party_slot_eq, ":cur_center", slot_town_lord, ":troop_to_change"),
#              (party_set_banner_icon, ":cur_center", banner_map_icons_end_minus_one),
            (try_end),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_run,
       [(try_begin),
          (this_or_next|key_clicked, key_space),
          (this_or_next|key_clicked, key_enter),
          (this_or_next|key_clicked, key_escape),
          (this_or_next|key_clicked, key_back_space),
		  (this_or_next|key_clicked, key_xbox_ltrigger),
          (key_clicked, key_xbox_rtrigger),
          (presentation_set_duration, 0),
        (try_end),

        ]),
      ]),

  ("custom_banner", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (troop_get_slot, ":flag_type", "trp_player", slot_troop_custom_banner_flag_type),
        (val_max, ":flag_type", 0),
        (val_add, ":flag_type", custom_banner_flag_types_begin),
        (troop_get_slot, ":map_flag_type", "trp_player", slot_troop_custom_banner_map_flag_type),
        (val_max, ":map_flag_type", 0),
        (val_add, ":map_flag_type", custom_banner_flag_map_types_begin),
##        (create_mesh_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_1", ":flag_type", "tableau_custom_banner_square", "trp_player"),
        (troop_get_slot, ":bg_color_1", "trp_player", slot_troop_custom_banner_bg_color_1),
        (troop_get_slot, ":bg_color_2", "trp_player", slot_troop_custom_banner_bg_color_2),

        (create_text_overlay, reg1, "str_color_no_1", 0),
        (position_set_x, pos1, 40),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "str_color_no_2", 0),
        (position_set_x, pos1, 40),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),

        (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_22", "mesh_color_picker", "tableau_color_picker", ":bg_color_1"),
        (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_23", "mesh_color_picker", "tableau_color_picker", ":bg_color_2"),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 565),
        (overlay_set_position, "$g_presentation_obj_custom_banner_22", pos1),
        (position_set_y, pos1, 515),
        (overlay_set_position, "$g_presentation_obj_custom_banner_23", pos1),
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 250),
        (overlay_set_size, "$g_presentation_obj_custom_banner_22", pos1),
        (overlay_set_size, "$g_presentation_obj_custom_banner_23", pos1),

        (create_button_overlay, "$g_presentation_obj_custom_banner_2", "str_change", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_3", "str_change", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_4", "str_change_background", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_5", "str_change", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_19", "str_change", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_custom_banner_20", "str_accept", tf_center_justify),
        (troop_get_slot, ":num_charges", "trp_player", slot_troop_custom_banner_num_charges),
        (create_button_overlay, "$g_presentation_obj_custom_banner_16", "str_randomize", tf_center_justify),
        (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_17", ":flag_type", "tableau_custom_banner_default", "trp_player"),
        (try_begin),
          (eq, ":map_flag_type", "mesh_custom_map_banner_01"),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_18", ":map_flag_type", "tableau_custom_banner_square", "trp_player"),
        (else_try),
          (eq, ":map_flag_type", "mesh_custom_map_banner_02"),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_18", ":map_flag_type", "tableau_custom_banner_short", "trp_player"),
        (else_try),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_18", ":map_flag_type", "tableau_custom_banner_tall", "trp_player"),
        (try_end),
        (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_1", -1, "tableau_custom_banner_square_no_mesh", "trp_player"),
        (create_text_overlay, reg1, "str_sample_banner", tf_center_justify),
        (position_set_x, pos1, 825),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "str_sample_map_banner", tf_center_justify),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),

        (position_set_x, pos1, 800),
        (position_set_y, pos1, 640),
        (overlay_set_position, "$g_presentation_obj_custom_banner_17", pos1),
        (position_set_x, pos1, 780),
        (position_set_y, pos1, 315),
        (overlay_set_position, "$g_presentation_obj_custom_banner_18", pos1),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 50),
        (overlay_set_size, "$g_presentation_obj_custom_banner_17", pos1),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 50),
        (overlay_set_size, "$g_presentation_obj_custom_banner_18", pos1),


        (create_text_overlay, reg1, "str_number_of_charges", 0),
        (position_set_x, pos1, 40),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),

        (assign, reg1, ":num_charges"),
        (create_text_overlay, reg2, "str_reg1", tf_center_justify),
        (position_set_x, pos1, 350),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg2, pos1),
        (try_begin),
          (lt, ":num_charges", 4),
          (create_button_overlay, "$g_presentation_obj_custom_banner_15", "str_plus", tf_center_justify),
          (position_set_x, pos1, 385),
          (position_set_y, pos1, 350),
          (overlay_set_position, "$g_presentation_obj_custom_banner_15", pos1),
        (else_try),
          (assign, "$g_presentation_obj_custom_banner_15", -1),
        (try_end),
        (try_begin),
          (gt, ":num_charges", 0),
          (create_button_overlay, "$g_presentation_obj_custom_banner_21", "str_minus", tf_center_justify),
          (position_set_x, pos1, 370),
          (position_set_y, pos1, 350),
          (overlay_set_position, "$g_presentation_obj_custom_banner_21", pos1),
        (else_try),
          (assign, "$g_presentation_obj_custom_banner_21", -1),
        (try_end),

        (try_begin),
          (ge, ":num_charges", 1),
          (create_text_overlay, reg1, "str_charge", tf_center_justify),
          (position_set_x, pos1, 300),
          (position_set_y, pos1, 300),
          (overlay_set_position, reg1, pos1),
          (create_text_overlay, reg1, "str_color", tf_center_justify),
          (position_set_x, pos1, 550),
          (position_set_y, pos1, 300),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_14", "str_change_charge_position", tf_center_justify),
          (position_set_y, pos1, 350),
          (position_set_x, pos1, 550),
          (overlay_set_position, "$g_presentation_obj_custom_banner_14", pos1),

          (create_text_overlay, reg1, "str_charge_no_1", 0),
          (position_set_x, pos1, 40),
          (position_set_y, pos1, 240),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_6", "str_change", 0),
          (position_set_x, pos1, 310),
          (overlay_set_position, "$g_presentation_obj_custom_banner_6", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_7", "str_change", 0),
          (position_set_x, pos1, 560),
          (overlay_set_position, "$g_presentation_obj_custom_banner_7", pos1),
          (troop_get_slot, ":cur_charge", "trp_player", slot_troop_custom_banner_charge_type_1),
          (val_mod, ":cur_charge", 256),
          (val_add, ":cur_charge", custom_banner_charges_begin),
          (create_image_button_overlay, "$g_presentation_obj_custom_banner_24", ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, 260),
          (position_set_y, pos1, 255),
          (overlay_set_position, "$g_presentation_obj_custom_banner_24", pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, 50),
          (overlay_set_size, "$g_presentation_obj_custom_banner_24", pos1),
          (troop_get_slot, ":cur_charge_color", "trp_player", slot_troop_custom_banner_charge_color_1),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_28", "mesh_color_picker", "tableau_color_picker", ":cur_charge_color"),
          (position_set_x, pos1, 530),
          (position_set_y, pos1, 255),
          (overlay_set_position, "$g_presentation_obj_custom_banner_28", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_custom_banner_28", pos1),

          (create_button_overlay, "$g_presentation_obj_custom_banner_32", "str_flip_horizontal", 0),
          (position_set_x, pos1, 700),
          (position_set_y, pos1, 240),
          (overlay_set_position, "$g_presentation_obj_custom_banner_32", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_33", "str_flip_vertical", 0),
          (position_set_x, pos1, 800),
          (overlay_set_position, "$g_presentation_obj_custom_banner_33", pos1),
        (try_end),
        (try_begin),
          (ge, ":num_charges", 2),
          (create_text_overlay, reg1, "str_charge_no_2", 0),
          (position_set_x, pos1, 40),
          (position_set_y, pos1, 180),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_8", "str_change", 0),
          (position_set_x, pos1, 310),
          (overlay_set_position, "$g_presentation_obj_custom_banner_8", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_9", "str_change", 0),
          (position_set_x, pos1, 560),
          (overlay_set_position, "$g_presentation_obj_custom_banner_9", pos1),
          (troop_get_slot, ":cur_charge", "trp_player", slot_troop_custom_banner_charge_type_2),
          (val_mod, ":cur_charge", 256),
          (val_add, ":cur_charge", custom_banner_charges_begin),
          (create_image_button_overlay, "$g_presentation_obj_custom_banner_25", ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, 260),
          (position_set_y, pos1, 195),
          (overlay_set_position, "$g_presentation_obj_custom_banner_25", pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, 50),
          (overlay_set_size, "$g_presentation_obj_custom_banner_25", pos1),
          (troop_get_slot, ":cur_charge_color", "trp_player", slot_troop_custom_banner_charge_color_2),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_29", "mesh_color_picker", "tableau_color_picker", ":cur_charge_color"),
          (position_set_x, pos1, 530),
          (position_set_y, pos1, 195),
          (overlay_set_position, "$g_presentation_obj_custom_banner_29", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_custom_banner_29", pos1),

          (create_button_overlay, "$g_presentation_obj_custom_banner_34", "str_flip_horizontal", 0),
          (position_set_x, pos1, 700),
          (position_set_y, pos1, 180),
          (overlay_set_position, "$g_presentation_obj_custom_banner_34", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_35", "str_flip_vertical", 0),
          (position_set_x, pos1, 800),
          (overlay_set_position, "$g_presentation_obj_custom_banner_35", pos1),
        (try_end),
        (try_begin),
          (ge, ":num_charges", 3),
          (create_text_overlay, reg1, "str_charge_no_3", 0),
          (position_set_x, pos1, 40),
          (position_set_y, pos1, 120),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_10", "str_change", 0),
          (position_set_x, pos1, 310),
          (overlay_set_position, "$g_presentation_obj_custom_banner_10", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_11", "str_change", 0),
          (position_set_x, pos1, 560),
          (overlay_set_position, "$g_presentation_obj_custom_banner_11", pos1),
          (troop_get_slot, ":cur_charge", "trp_player", slot_troop_custom_banner_charge_type_3),
          (val_mod, ":cur_charge", 256),
          (val_add, ":cur_charge", custom_banner_charges_begin),
          (create_image_button_overlay, "$g_presentation_obj_custom_banner_26", ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, 260),
          (position_set_y, pos1, 135),
          (overlay_set_position, "$g_presentation_obj_custom_banner_26", pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, 50),
          (overlay_set_size, "$g_presentation_obj_custom_banner_26", pos1),
          (troop_get_slot, ":cur_charge_color", "trp_player", slot_troop_custom_banner_charge_color_3),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_30", "mesh_color_picker", "tableau_color_picker", ":cur_charge_color"),
          (position_set_x, pos1, 530),
          (position_set_y, pos1, 135),
          (overlay_set_position, "$g_presentation_obj_custom_banner_30", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_custom_banner_30", pos1),

          (create_button_overlay, "$g_presentation_obj_custom_banner_36", "str_flip_horizontal", 0),
          (position_set_x, pos1, 700),
          (position_set_y, pos1, 120),
          (overlay_set_position, "$g_presentation_obj_custom_banner_36", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_37", "str_flip_vertical", 0),
          (position_set_x, pos1, 800),
          (overlay_set_position, "$g_presentation_obj_custom_banner_37", pos1),
        (try_end),
        (try_begin),
          (ge, ":num_charges", 4),
          (create_text_overlay, reg1, "str_charge_no_4", 0),
          (position_set_x, pos1, 40),
          (position_set_y, pos1, 60),
          (overlay_set_position, reg1, pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_12", "str_change", 0),
          (position_set_x, pos1, 310),
          (overlay_set_position, "$g_presentation_obj_custom_banner_12", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_13", "str_change", 0),
          (position_set_x, pos1, 560),
          (overlay_set_position, "$g_presentation_obj_custom_banner_13", pos1),
          (troop_get_slot, ":cur_charge", "trp_player", slot_troop_custom_banner_charge_type_4),
          (val_mod, ":cur_charge", 256),
          (val_add, ":cur_charge", custom_banner_charges_begin),
          (create_image_button_overlay, "$g_presentation_obj_custom_banner_27", ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, 260),
          (position_set_y, pos1, 75),
          (overlay_set_position, "$g_presentation_obj_custom_banner_27", pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, 50),
          (overlay_set_size, "$g_presentation_obj_custom_banner_27", pos1),
          (troop_get_slot, ":cur_charge_color", "trp_player", slot_troop_custom_banner_charge_color_4),
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_custom_banner_31", "mesh_color_picker", "tableau_color_picker", ":cur_charge_color"),
          (position_set_x, pos1, 530),
          (position_set_y, pos1, 75),
          (overlay_set_position, "$g_presentation_obj_custom_banner_31", pos1),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_custom_banner_31", pos1),

          (create_button_overlay, "$g_presentation_obj_custom_banner_38", "str_flip_horizontal", 0),
          (position_set_x, pos1, 700),
          (position_set_y, pos1, 60),
          (overlay_set_position, "$g_presentation_obj_custom_banner_38", pos1),
          (create_button_overlay, "$g_presentation_obj_custom_banner_39", "str_flip_vertical", 0),
          (position_set_x, pos1, 800),
          (overlay_set_position, "$g_presentation_obj_custom_banner_39", pos1),
        (try_end),

        (position_set_x, pos1, 350),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_custom_banner_1", pos1),
        (position_set_x, pos1, 275),
        (position_set_y, pos1, 550),
        (overlay_set_position, "$g_presentation_obj_custom_banner_2", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_custom_banner_3", pos1),
        (position_set_x, pos1, 175),
        (position_set_y, pos1, 600),
        (overlay_set_position, "$g_presentation_obj_custom_banner_4", pos1),
        (position_set_x, pos1, 880),
        (position_set_y, pos1, 575),
        (overlay_set_position, "$g_presentation_obj_custom_banner_5", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_custom_banner_19", pos1),
        (position_set_y, pos1, 650),
        (position_set_x, pos1, 175),
        (overlay_set_position, "$g_presentation_obj_custom_banner_16", pos1),
        (position_set_y, pos1, 150),
        (position_set_x, pos1, 850),
        (overlay_set_position, "$g_presentation_obj_custom_banner_20", pos1),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (troop_get_slot, ":num_charges", "trp_player", slot_troop_custom_banner_num_charges),
        (try_begin),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_2"),
          (eq, ":object", "$g_presentation_obj_custom_banner_22"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_bg_color_1),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_3"),
          (eq, ":object", "$g_presentation_obj_custom_banner_23"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_bg_color_2),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_4"),
          (eq, ":object", "$g_presentation_obj_custom_banner_1"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_background_selection"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_5"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_flag_type_selection"),
        (else_try),
          (ge, ":num_charges", 1),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_6"),
          (eq, ":object", "$g_presentation_obj_custom_banner_24"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_type_1),
          (start_presentation, "prsnt_banner_charge_selection"),
        (else_try),
          (ge, ":num_charges", 1),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_7"),
          (eq, ":object", "$g_presentation_obj_custom_banner_28"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_color_1),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (ge, ":num_charges", 2),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_8"),
          (eq, ":object", "$g_presentation_obj_custom_banner_25"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_type_2),
          (start_presentation, "prsnt_banner_charge_selection"),
        (else_try),
          (ge, ":num_charges", 2),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_9"),
          (eq, ":object", "$g_presentation_obj_custom_banner_29"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_color_2),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (ge, ":num_charges", 3),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_10"),
          (eq, ":object", "$g_presentation_obj_custom_banner_26"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_type_3),
          (start_presentation, "prsnt_banner_charge_selection"),
        (else_try),
          (ge, ":num_charges", 3),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_11"),
          (eq, ":object", "$g_presentation_obj_custom_banner_30"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_color_3),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (ge, ":num_charges", 4),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_12"),
          (eq, ":object", "$g_presentation_obj_custom_banner_27"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_type_4),
          (start_presentation, "prsnt_banner_charge_selection"),
        (else_try),
          (ge, ":num_charges", 4),
          (this_or_next|eq, ":object", "$g_presentation_obj_custom_banner_13"),
          (eq, ":object", "$g_presentation_obj_custom_banner_31"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (assign, "$g_presentation_output_slot", slot_troop_custom_banner_charge_color_4),
          (start_presentation, "prsnt_color_selection"),
        (else_try),
          (ge, ":num_charges", 1),
          (eq, ":object", "$g_presentation_obj_custom_banner_14"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_charge_positioning"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_15"),
          (troop_get_slot, ":num_charges", "trp_player", slot_troop_custom_banner_num_charges),
          (val_add, ":num_charges", 1),
          (val_clamp, ":num_charges", 0, 5),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_num_charges, ":num_charges"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_21"),
          (troop_get_slot, ":num_charges", "trp_player", slot_troop_custom_banner_num_charges),
          (val_sub, ":num_charges", 1),
          (val_clamp, ":num_charges", 0, 5),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_num_charges, ":num_charges"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_16"),
          (call_script, "script_get_random_custom_banner", "trp_player"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_17"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_flag_type_selection"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_18"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_flag_map_type_selection"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_19"),
          (assign, "$g_presentation_next_presentation", "prsnt_custom_banner"),
          (start_presentation, "prsnt_banner_flag_map_type_selection"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_32"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_1),
          (store_mod, ":charge_type_base", ":charge_type", 256),
          (val_div, ":charge_type", 256),
          (store_mod, ":flag", ":charge_type", 2),
          (val_div, ":charge_type", 2), #remove flag
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":charge_type", 2),
          (val_add, ":charge_type", ":flag"),
          (val_mul, ":charge_type", 256),
          (val_add, ":charge_type", ":charge_type_base"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_1, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_34"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_2),
          (store_mod, ":charge_type_base", ":charge_type", 256),
          (val_div, ":charge_type", 256),
          (store_mod, ":flag", ":charge_type", 2),
          (val_div, ":charge_type", 2), #remove flag
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":charge_type", 2),
          (val_add, ":charge_type", ":flag"),
          (val_mul, ":charge_type", 256),
          (val_add, ":charge_type", ":charge_type_base"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_2, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_36"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_3),
          (store_mod, ":charge_type_base", ":charge_type", 256),
          (val_div, ":charge_type", 256),
          (store_mod, ":flag", ":charge_type", 2),
          (val_div, ":charge_type", 2), #remove flag
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":charge_type", 2),
          (val_add, ":charge_type", ":flag"),
          (val_mul, ":charge_type", 256),
          (val_add, ":charge_type", ":charge_type_base"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_3, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_38"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_4),
          (store_mod, ":charge_type_base", ":charge_type", 256),
          (val_div, ":charge_type", 256),
          (store_mod, ":flag", ":charge_type", 2),
          (val_div, ":charge_type", 2), #remove flag
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":charge_type", 2),
          (val_add, ":charge_type", ":flag"),
          (val_mul, ":charge_type", 256),
          (val_add, ":charge_type", ":charge_type_base"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_4, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_33"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_1),
          (store_div, ":flag", ":charge_type", 512),
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":flag", 512),
          (val_mod, ":charge_type", 512), #remove flag
          (val_add, ":charge_type", ":flag"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_1, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_35"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_2),
          (store_div, ":flag", ":charge_type", 512),
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":flag", 512),
          (val_mod, ":charge_type", 512), #remove flag
          (val_add, ":charge_type", ":flag"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_2, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_37"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_3),
          (store_div, ":flag", ":charge_type", 512),
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":flag", 512),
          (val_mod, ":charge_type", 512), #remove flag
          (val_add, ":charge_type", ":flag"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_3, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_39"),
          (troop_get_slot, ":charge_type", "trp_player", slot_troop_custom_banner_charge_type_4),
          (store_div, ":flag", ":charge_type", 512),
          (val_add, ":flag", 1),
          (val_mod, ":flag", 2), #switch flag
          (val_mul, ":flag", 512),
          (val_mod, ":charge_type", 512), #remove flag
          (val_add, ":charge_type", ":flag"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_charge_type_4, ":charge_type"),
          (start_presentation, "prsnt_custom_banner"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_custom_banner_20"),
          (troop_get_slot, ":flag_icon", "trp_player", slot_troop_custom_banner_map_flag_type),
          (try_begin),
            (ge, ":flag_icon", 0),
            (val_add, ":flag_icon", custom_banner_map_icons_begin),
            (party_set_banner_icon, "p_main_party", ":flag_icon"),
          (try_end),
          (presentation_set_duration, 0),
        (try_end),
        ]),
##     (ti_on_presentation_run,
##      [(try_begin),
##         (this_or_next|key_clicked, key_space),
##         (this_or_next|key_clicked, key_enter),
##         (this_or_next|key_clicked, key_escape),
##         (key_clicked, key_back_space),
##         (presentation_set_duration, 0),
##       (try_end),
##       ]),
     ]),

  ("banner_charge_positioning", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_position", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (assign, ":pos_x", 125),
        (assign, ":pos_y", 400),
        (call_script, "script_get_troop_custom_banner_num_positionings", "trp_player"),
        (assign, ":num_positionings", reg0),
        (store_mul, ":x_needed", ":num_positionings", 125),
        (val_sub, ":x_needed", 25),
        (store_div, ":pos_x", ":x_needed", 2),
        (store_sub, ":pos_x", 500, ":pos_x"),
        (try_for_range, ":cur_positioning", 0, ":num_positionings"),
          (create_image_button_overlay_with_tableau_material, reg1, -1, "tableau_positioning_selection", ":cur_positioning"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 125),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":cur_positioning", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (call_script, "script_get_troop_custom_banner_num_positionings", "trp_player"),
        (assign, ":num_positionings", reg0),
        (try_for_range, ":trp_slot_index", 0, ":num_positionings"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_positioning, ":trp_slot_index"),
          (assign, ":num_positionings", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("banner_charge_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_charge", tf_center_justify),

        (position_set_x, pos1, 500),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        (assign, ":pos_x", 100),
        (assign, ":pos_y", 600),
        (try_for_range, ":cur_charge", custom_banner_charges_begin, custom_banner_charges_end),
          (create_image_button_overlay, reg1, ":cur_charge", ":cur_charge"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 100),
          (try_begin),
            (gt, ":pos_x", 900),
            (assign, ":pos_x", 100),
            (val_sub, ":pos_y", 100),
          (try_end),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 80),
          (position_set_y, pos1, 80),
          (overlay_set_size, reg1, pos1),
          (store_sub, ":slot_index", ":cur_charge", custom_banner_charges_begin),
          (troop_set_slot, "trp_temp_array_a", ":slot_index", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", custom_banner_charges_end),
        (val_sub, ":end_cond", custom_banner_charges_begin),
        (try_for_range, ":trp_slot_index", 0, ":end_cond"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", "$g_presentation_output_slot", ":trp_slot_index"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("banner_background_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_background", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (assign, ":pos_x", 75),
        (assign, ":pos_y", 450),
        (try_for_range, ":cur_banner", custom_banner_backgrounds_begin, custom_banner_backgrounds_end),
          (store_sub, ":slot_index", ":cur_banner", custom_banner_backgrounds_begin),
          (create_image_button_overlay_with_tableau_material, reg1, -1, "tableau_background_selection", ":slot_index"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 125),
          (try_begin),
            (gt, ":pos_x", 900),
            (assign, ":pos_x", 75),
            (val_sub, ":pos_y", 125),
          (try_end),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_index", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", custom_banner_backgrounds_end),
        (val_sub, ":end_cond", custom_banner_backgrounds_begin),
        (try_for_range, ":trp_slot_index", 0, ":end_cond"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_bg_type, ":trp_slot_index"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("banner_flag_type_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_flag_type", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),

        (assign, ":pos_x", 435),
        (assign, ":pos_y", 450),
        (try_for_range, ":cur_flag", custom_banner_flag_types_begin, custom_banner_flag_types_end),
          (store_sub, ":slot_index", ":cur_flag", custom_banner_flag_types_begin),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_flag_type, ":slot_index"),
          (create_image_button_overlay_with_tableau_material, reg1, ":cur_flag", "tableau_custom_banner_default", "trp_player"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 130),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 100),
          (position_set_y, pos1, 100),
          (overlay_set_size, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_index", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", custom_banner_flag_types_end),
        (val_sub, ":end_cond", custom_banner_flag_types_begin),
        (try_for_range, ":trp_slot_index", 0, ":end_cond"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_flag_type, ":trp_slot_index"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("banner_flag_map_type_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_map_flag_type", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (troop_get_slot, ":bg_type", "trp_player", slot_troop_custom_banner_bg_type),
        (val_add, ":bg_type", custom_banner_backgrounds_begin),
        (assign, ":pos_x", 250),
        (assign, ":pos_y", 150),
        (try_for_range, ":cur_flag", custom_banner_flag_map_types_begin, custom_banner_flag_map_types_end),
          (store_sub, ":slot_index", ":cur_flag", custom_banner_flag_map_types_begin),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_map_flag_type, ":slot_index"),
          (try_begin),
            (eq, ":cur_flag", "mesh_custom_map_banner_01"),
            (create_image_button_overlay_with_tableau_material, reg1, ":cur_flag", "tableau_custom_banner_square", "trp_player"),
          (else_try),
            (eq, ":cur_flag", "mesh_custom_map_banner_02"),
            (create_image_button_overlay_with_tableau_material, reg1, ":cur_flag", "tableau_custom_banner_short", "trp_player"),
          (else_try),
            (create_image_button_overlay_with_tableau_material, reg1, ":cur_flag", "tableau_custom_banner_tall", "trp_player"),
          (try_end),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 200),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 100),
          (position_set_y, pos1, 100),
          (overlay_set_size, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_index", reg1),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", custom_banner_flag_map_types_end),
        (val_sub, ":end_cond", custom_banner_flag_map_types_begin),
        (try_for_range, ":trp_slot_index", 0, ":end_cond"),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (troop_set_slot, "trp_player", slot_troop_custom_banner_map_flag_type, ":trp_slot_index"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

  ("color_selection", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (set_fixed_point_multiplier, 1000),
        (create_text_overlay, reg1, "str_choose_color", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),

        (assign, ":pos_x", 125),
        (assign, ":pos_y", 450),
        (try_for_range, ":i_color", 0, 42),
          (call_script, "script_get_custom_banner_color_from_index", ":i_color"),
          (assign, ":cur_color", reg0),
          (create_image_button_overlay_with_tableau_material, reg1, "mesh_color_picker", "tableau_color_picker", ":cur_color"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_add, ":pos_x", 50),
          (try_begin),
            (store_mod, ":mod_i_color", ":i_color", 7),
            (eq, ":mod_i_color", 6),
            (assign, ":pos_x", 125),
            (val_sub, ":pos_y", 50),
          (try_end),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, 500),
          (overlay_set_size, reg1, pos1),
          (store_mul, ":trp_slot_index", ":i_color", 2),
          (store_add, ":trp_slot_color", ":trp_slot_index", 1),
          (troop_set_slot, "trp_temp_array_a", ":trp_slot_index", reg1),
          (troop_set_slot, "trp_temp_array_a", ":trp_slot_color", ":cur_color"),
        (try_end),
        (presentation_set_duration, 999999),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (assign, ":end_cond", 64),
        (try_for_range, ":i_color", 0, ":end_cond"),
          (store_mul, ":trp_slot_index", ":i_color", 2),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_index", ":object"),
          (store_add, ":trp_slot_color", ":trp_slot_index", 1),
          (troop_get_slot, ":output_color", "trp_temp_array_a", ":trp_slot_color"),
          (troop_set_slot, "trp_player", "$g_presentation_output_slot", ":output_color"),
          (assign, ":end_cond", 0),
        (try_end),
        (try_begin),
          (gt, "$g_presentation_next_presentation", 0),
          (start_presentation, "$g_presentation_next_presentation"),
        (else_try),
          (presentation_set_duration, 0),
        (try_end),
        ]),
     ]),

## CC
#  ("marshall_selection", 0, mesh_load_window,
#   [
#     (ti_on_presentation_load,
#      [
#        (assign, "$g_presentation_obj_marshall_selection_1", -1),
#        (assign, "$g_presentation_obj_marshall_selection_2", -1),
#        (assign, "$g_presentation_obj_marshall_selection_3", -1),
#        (set_fixed_point_multiplier, 1000),
#        (assign, "$g_presentation_next_presentation", -1),
#
#        (store_add, ":total_renown", "$g_presentation_marshall_selection_max_renown_1", "$g_presentation_marshall_selection_max_renown_2"),
#        (faction_get_slot, ":king", "$players_kingdom", slot_faction_leader),
#
#        (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_1_troop"),
#        (create_text_overlay, reg1, "@Candidate #1: {s1}", tf_center_justify),
#        (position_set_x, pos1, 200),
#        (position_set_y, pos1, 600),
#        (overlay_set_position, reg1, pos1),
#        (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_2_troop"),
#        (create_text_overlay, reg1, "@Candidate #2: {s1}", tf_center_justify),
#        (position_set_x, pos1, 800),
#        (position_set_y, pos1, 600),
#        (overlay_set_position, reg1, pos1),
#        (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_troop_note_mesh", "$g_presentation_marshall_selection_max_renown_1_troop"),
#        (position_set_x, pos1, 500),
#        (position_set_y, pos1, 500),
#        (overlay_set_size, reg1, pos1),
#        (position_set_x, pos1, 100),
#        (position_set_y, pos1, 300),
#        (overlay_set_position, reg1, pos1),
#        (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_troop_note_mesh", "$g_presentation_marshall_selection_max_renown_2_troop"),
#        (position_set_x, pos1, 500),
#        (position_set_y, pos1, 500),
#        (overlay_set_size, reg1, pos1),
#        (position_set_x, pos1, 700),
#        (position_set_y, pos1, 300),
#        (overlay_set_position, reg1, pos1),
#
#        (assign, ":lord_index", "$g_presentation_input"),
#        (val_add, "$g_presentation_input", 1),
#
#        (try_begin),
#          (lt, ":lord_index", 0),
#          (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_1_troop"),
#          (str_store_troop_name, s2, "$g_presentation_marshall_selection_max_renown_2_troop"),
#          (str_store_troop_name, s3, ":king"),
#          (str_store_faction_name, s4, "$players_kingdom"),
#          (create_text_overlay, reg1, "@{s3} of {s4} wishes to select a new marshall and invites his vassals for a counsel. {s1} and {s2} are the likely candidates.", tf_center_justify),
#          (position_set_x, pos1, 500),
#          (position_set_y, pos1, 200),
#          (overlay_set_position, reg1, pos1),
#
#          (create_button_overlay, "$g_presentation_obj_marshall_selection_1", "@Continue...", tf_center_justify),
#          (position_set_x, pos1, 500),
#          (position_set_y, pos1, 100),
#          (overlay_set_position, "$g_presentation_obj_marshall_selection_1", pos1),
#          (assign, "$g_presentation_next_presentation", "prsnt_marshall_selection"),
#        (else_try),
#          (assign, ":cur_index", ":lord_index"),
#          (try_for_range_backwards, ":loop_var", "trp_kingdom_heroes_including_player_begin", active_npcs_end),
#            (ge, ":cur_index", 0),
#            (assign, ":cur_troop", ":loop_var"),
#            (assign, ":continue", 0),
#            (try_begin),
#              (eq, ":loop_var", "trp_kingdom_heroes_including_player_begin"),
#              (assign, ":cur_troop", "trp_player"),
#              (try_begin),
#                (eq, "$g_player_is_captive", 0),
#                (assign, ":continue", 1),
#              (try_end),
#            (else_try),
#              (store_troop_faction, ":cur_troop_faction", ":cur_troop"),
#              (eq, "$players_kingdom", ":cur_troop_faction"),
#              #(troop_slot_eq, ":cur_troop", slot_troop_is_prisoner, 0),
#              (neg|troop_slot_ge, ":cur_troop", slot_troop_prisoner_of_party, 0),
#              (troop_slot_ge, ":cur_troop", slot_troop_leaded_party, 1),
#              (troop_slot_eq, ":cur_troop", slot_troop_occupation, slto_kingdom_hero),
#              (neg|faction_slot_eq, ":cur_troop_faction", slot_faction_leader, ":cur_troop"),
#              (assign, ":continue", 1),
#            (try_end),
#            (eq, ":continue", 1),
#
#            (neq, "$g_presentation_marshall_selection_max_renown_1_troop", ":cur_troop"),
#            (neq, "$g_presentation_marshall_selection_max_renown_2_troop", ":cur_troop"),
#
#            (val_sub, ":cur_index", 1),
#            (lt, ":cur_index", 0),
#
#            (assign, "$g_presentation_next_presentation", "prsnt_marshall_selection"),
#
#            (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_troop_note_mesh", ":cur_troop"),
#            (position_set_x, pos1, 300),
#            (position_set_y, pos1, 300),
#            (overlay_set_size, reg1, pos1),
#            (position_set_x, pos1, 440),
#            (position_set_y, pos1, 400),
#            (overlay_set_position, reg1, pos1),
#
#            (try_begin),
#              (eq, ":cur_troop", "trp_player"),
#              (create_text_overlay, reg1, "@Who do you wish to support?", tf_center_justify),
#              (position_set_x, pos1, 500),
#              (position_set_y, pos1, 200),
#              (overlay_set_position, reg1, pos1),
#              (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_1_troop"),
#              (create_button_overlay, "$g_presentation_obj_marshall_selection_2", "@{!}{s1}", tf_center_justify),
#              (position_set_x, pos1, 300),
#              (position_set_y, pos1, 100),
#              (overlay_set_position, "$g_presentation_obj_marshall_selection_2", pos1),
#              (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_2_troop"),
#              (create_button_overlay, "$g_presentation_obj_marshall_selection_3", "@{!}{s1}", tf_center_justify),
#              (position_set_x, pos1, 700),
#              (position_set_y, pos1, 100),
#              (overlay_set_position, "$g_presentation_obj_marshall_selection_3", pos1),
#            (else_try),
#              (str_store_troop_name, s1, ":cur_troop"),
#              (store_random_in_range, ":random_renown", 0, ":total_renown"),
#              (val_sub, ":random_renown", "$g_presentation_marshall_selection_max_renown_1"),
#              (try_begin),
#                (lt, ":random_renown", 0),
#                (val_add, "$g_presentation_marshall_selection_1_vote", 1),
#                (str_store_troop_name, s2, "$g_presentation_marshall_selection_max_renown_1_troop"),
#              (else_try),
#                (val_add, "$g_presentation_marshall_selection_2_vote", 1),
#                (str_store_troop_name, s2, "$g_presentation_marshall_selection_max_renown_2_troop"),
#              (try_end),
#              (create_text_overlay, reg1, "@{s1} gives his support to {s2}.", tf_center_justify),
#              (position_set_x, pos1, 500),
#              (position_set_y, pos1, 200),
#              (overlay_set_position, reg1, pos1),
#
#              (create_button_overlay, "$g_presentation_obj_marshall_selection_1", "@Continue...", tf_center_justify),
#              (position_set_x, pos1, 500),
#              (position_set_y, pos1, 100),
#              (overlay_set_position, "$g_presentation_obj_marshall_selection_1", pos1),
#            (try_end),
#          (try_end),
#        (try_end),
#
#        (assign, reg0, "$g_presentation_marshall_selection_1_vote"),
#        (create_text_overlay, reg1, "@Number of Supporters: {reg0}", tf_center_justify),
#        (position_set_x, pos1, 200),
#        (position_set_y, pos1, 550),
#        (overlay_set_position, reg1, pos1),
#        (assign, reg0, "$g_presentation_marshall_selection_2_vote"),
#        (create_text_overlay, reg1, "@Number of Supporters: {reg0}", tf_center_justify),
#        (position_set_x, pos1, 800),
#        (position_set_y, pos1, 550),
#        (overlay_set_position, reg1, pos1),
#
#        (try_begin),
#          (lt, "$g_presentation_next_presentation", 0),
#          (try_begin),
#            (gt, "$g_presentation_marshall_selection_2_vote", "$g_presentation_marshall_selection_1_vote"),
#            (assign, ":local_temp", "$g_presentation_marshall_selection_max_renown_1_troop"),
#            (assign, "$g_presentation_marshall_selection_max_renown_1_troop", "$g_presentation_marshall_selection_max_renown_2_troop"),
#            (assign, "$g_presentation_marshall_selection_max_renown_2_troop", ":local_temp"),
#          (try_end),
#          #Winner is set to g_presentation_marshall_selection_max_renown_1_troop
#          (str_store_troop_name, s1, "$g_presentation_marshall_selection_max_renown_1_troop"),
#          (str_store_troop_name, s2, ":king"),
#          (str_store_faction_name, s3, "$players_kingdom"),
#          (create_text_overlay, reg1, "@{s2} has heard his vassals' counsel. He selects {s1} as the marshall of {s3}.", tf_center_justify),
#          (position_set_x, pos1, 500),
#          (position_set_y, pos1, 200),
#          (overlay_set_position, reg1, pos1),
#          (create_button_overlay, "$g_presentation_obj_marshall_selection_1", "@Continue...", tf_center_justify),
#          (position_set_x, pos1, 500),
#          (position_set_y, pos1, 100),
#          (overlay_set_position, "$g_presentation_obj_marshall_selection_1", pos1),
#        (try_end),
#
#        (presentation_set_duration, 999999),
#        ]),
#     (ti_on_presentation_event_state_change,
#      [
#        (store_trigger_param_1, ":object"),
#        (try_begin),
#          (eq, ":object", "$g_presentation_obj_marshall_selection_2"),
#          (val_add, "$g_presentation_marshall_selection_1_vote", 1),
#          (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_1_troop", 2),
#          (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_2_troop", -2),
#        (else_try),
#          (eq, ":object", "$g_presentation_obj_marshall_selection_3"),
#          (val_add, "$g_presentation_marshall_selection_2_vote", 1),
#          (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_1_troop", -2),
#          (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_2_troop", 2),
#        (try_end),
#        (try_begin),
#          (this_or_next|eq, ":object", "$g_presentation_obj_marshall_selection_1"),
#          (this_or_next|eq, ":object", "$g_presentation_obj_marshall_selection_2"),
#          (eq, ":object", "$g_presentation_obj_marshall_selection_3"),
#          (try_begin),
#            (ge, "$g_presentation_next_presentation", 0),
#            (start_presentation, "$g_presentation_next_presentation"),
#          (else_try),
#            (try_begin),
#              (neg|faction_slot_eq, "$players_kingdom", slot_faction_marshall, "$g_presentation_marshall_selection_max_renown_1_troop"),
#              (call_script, "script_check_and_finish_active_army_quests_for_faction", "$players_kingdom"),
#            (try_end),
#
#           (faction_get_slot, ":old_marshall", "$players_kingdom", slot_faction_marshall),
#           (try_begin),
#             (ge, ":old_marshall", 0),
#             (party_is_active, ":old_marshall"),
#             (party_set_marshall, ":old_marshall", 0),
#           (try_end),  
#
#            (faction_set_slot, "$players_kingdom", slot_faction_marshall, "$g_presentation_marshall_selection_max_renown_1_troop"),
#            (try_begin),
#              (eq, "$g_presentation_marshall_selection_max_renown_1_troop", "trp_player"),
#              (call_script, "script_change_player_relation_with_troop", "$g_presentation_marshall_selection_max_renown_2_troop", -3),
#            (try_end),
#            (assign, "$g_recalculate_ais", 1),
#            (assign, "$g_presentation_marshall_selection_ended", 1),
#            (presentation_set_duration, 0),
#          (try_end),
#        (try_end),
#        ]),
#     ]),
## CC

  ("battle",0,0,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (assign, "$g_formation_group0_selected", 0),
        (assign, "$g_formation_group1_selected", 0),
        (assign, "$g_formation_group2_selected", 0),
        (assign, "$g_formation_group3_selected", 0),
        (assign, "$g_formation_group4_selected", 0),
        (assign, "$g_formation_group5_selected", 0),
        (assign, "$g_formation_group6_selected", 0),
        (assign, "$g_formation_group7_selected", 0),
        (assign, "$g_formation_group8_selected", 0),
        (assign, "$g_presentation_obj_battle_but0", -1),
        (assign, "$g_presentation_obj_battle_but1", -1),
        (assign, "$g_presentation_obj_battle_but2", -1),
        (assign, "$g_presentation_obj_battle_but3", -1),
        (assign, "$g_presentation_obj_battle_but4", -1),
        (assign, "$g_presentation_obj_battle_but5", -1),
        (assign, "$g_presentation_obj_battle_but6", -1),
        (assign, "$g_presentation_obj_battle_but7", -1),
        (assign, "$g_presentation_obj_battle_but8", -1),
        (str_clear, s7),

        (try_for_agents, ":agent_no"),
          (agent_set_slot, ":agent_no", slot_agent_map_overlay_id, 0),
        (try_end),

        (get_player_agent_no, ":player_agent"),
        (agent_get_troop_id, ":player_troop_id", ":player_agent"),

        (position_set_y, pos1, 700),
        (create_text_overlay, reg1, "@Action", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, reg1, 0xFFAAAAAA),
        (position_set_x, pos1, 270),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Mount", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, reg1, 0xFFAAAAAA),
        (position_set_x, pos1, 410),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Attack Type", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, reg1, 0xFFAAAAAA),
        (position_set_x, pos1, 550),
        (overlay_set_position, reg1, pos1),

        (assign, "$group0_has_troops", 0),
        (assign, "$group1_has_troops", 0),
        (assign, "$group2_has_troops", 0),
        (assign, "$group3_has_troops", 0),
        (assign, "$group4_has_troops", 0),
        (assign, "$group5_has_troops", 0),
        (assign, "$group6_has_troops", 0),
        (assign, "$group7_has_troops", 0),
        (assign, "$group8_has_troops", 0),
        (party_get_num_companion_stacks, ":num_stacks", "p_main_party"),
        (assign, "$num_classes", 0),
        (try_for_range, ":troop_iterator", 0, ":num_stacks"),
          (party_stack_get_troop_id, ":cur_troop_id", "p_main_party", ":troop_iterator"),
          (troop_get_class, ":troop_class", ":cur_troop_id"),
          (neq, ":player_troop_id", ":cur_troop_id"),
          (try_begin),
            (eq, ":troop_class", 0),
            (try_begin),
              (neq, "$group0_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group0_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 1),
            (try_begin),
              (neq, "$group1_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group1_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 2),
            (try_begin),
              (neq, "$group2_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group2_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 3),
            (try_begin),
              (neq, "$group3_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group3_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 4),
            (try_begin),
              (neq, "$group4_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group4_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 5),
            (try_begin),
              (neq, "$group5_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group5_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 6),
            (try_begin),
              (neq, "$group6_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group6_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 7),
            (try_begin),
              (neq, "$group7_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group7_has_troops", 1),
          (else_try),
            (eq, ":troop_class", 8),
            (try_begin),
              (neq, "$group8_has_troops", 1),
              (val_add, "$num_classes", 1),
            (try_end),
            (assign, "$group8_has_troops", 1),
          (try_end),
        (try_end),

        (assign, ":stat_position_x", 0),
        (assign, ":stat_position_y", 653),
        (assign, ":stat_position_check_x", 20),
        (assign, ":stat_position_check_y", 662),
        (assign, ":stat_position_name_x", 50),
        (assign, ":stat_position_name_y", 660),
        (try_begin),
          (eq, "$group0_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but0", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but0", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but0", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but0", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but0", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check0", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check0", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name0", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name0", pos3),

          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but0_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but0_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but0_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group1_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but1", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but1", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but1", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but1", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but1", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check1", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check1", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name1", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name1", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but1_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but1_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but1_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group2_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but2", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but2", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but2", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but2", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but2", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check2", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check2", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name2", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name2", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but2_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but2_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but2_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group3_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but3", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but3", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but3", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but3", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but3", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check3", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check3", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name3", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name3", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but3_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but3_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but3_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group4_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but4", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but4", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but4", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but4", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but4", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check4", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check4", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name4", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name4", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but4_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but4_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but4_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group5_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but5", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but5", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but5", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but5", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but5", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check5", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check5", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name5", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name5", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but5_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but5_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but5_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group6_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but6", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but6", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but6", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but6", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but6", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check6", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check6", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name6", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name6", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but6_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but6_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but6_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group7_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but7", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but7", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but7", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but7", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but7", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check7", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check7", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name7", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name7", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but7_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but7_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but7_weapon_usage", s7, tf_center_justify),
        (try_end),
        (try_begin),
          (eq, "$group8_has_troops", 1),
          (create_image_button_overlay, "$g_presentation_obj_battle_but8", "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":stat_position_x"),
          (position_set_y, pos1, ":stat_position_y"),
          (overlay_set_position, "$g_presentation_obj_battle_but8", pos1),
          (val_add, ":stat_position_y", -40),

          (position_set_x, pos1, 32500),
          (position_set_y, pos1, 2000),
          (overlay_set_size, "$g_presentation_obj_battle_but8", pos1),
          (overlay_set_alpha, "$g_presentation_obj_battle_but8", 0),
          (overlay_set_color, "$g_presentation_obj_battle_but8", 0xFFFF00),

          (create_check_box_overlay, "$g_presentation_obj_battle_check8", "mesh_checkbox_off", "mesh_checkbox_on"),
          (position_set_x, pos2, ":stat_position_check_x"),
          (position_set_y, pos2, ":stat_position_check_y"),
          (overlay_set_position, "$g_presentation_obj_battle_check8", pos2),
          (val_add, ":stat_position_check_y", -40),

          (create_text_overlay, "$g_presentation_obj_battle_name8", s7, 0),
          (position_set_x, pos3, ":stat_position_name_x"),
          (position_set_y, pos3, ":stat_position_name_y"),
          (overlay_set_position, "$g_presentation_obj_battle_name8", pos3),
          (val_add, ":stat_position_name_y", -40),

          (create_text_overlay, "$g_presentation_but8_movement", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but8_riding", s7, tf_center_justify),
          (create_text_overlay, "$g_presentation_but8_weapon_usage", s7, tf_center_justify),
        (try_end),

        (get_player_agent_no, ":player_agent"),
        (agent_get_team, ":player_team", ":player_agent"),

        (call_script, "script_update_order_panel", ":player_team"),

        #(create_button_overlay, "$g_presentation_obj_battle_10", "@Hold This Position", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_11", "@Follow Me", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_12", "@Charge", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_13", "@Advance", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_14", "@Fall Back", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_15", "@Stand Closer", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_16", "@Spread Out", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_17", "@Stand Ground", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_18", "@Mount", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_19", "@Dismount", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_20", "@Use Any Weapon", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_21", "@Use Blunt Weapons", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_28", "@Hold Your Fire", tf_center_justify),
        #(create_button_overlay, "$g_presentation_obj_battle_29", "@Fire At Will", tf_center_justify),

        (assign, ":y_position_for_order_buttons", 640),
        (assign, ":addition_y_position", "$num_classes"),
        (val_mul, ":addition_y_position", -40),
        (val_add, ":y_position_for_order_buttons", ":addition_y_position"),

        (create_listbox_overlay, "$g_presentation_obj_battle_10", "str_space", 0),
        (create_listbox_overlay, "$g_presentation_obj_battle_11", "str_space", 0),
        (create_listbox_overlay, "$g_presentation_obj_battle_12", "str_space", 0),
        (create_listbox_overlay, "$g_presentation_obj_battle_13", "str_space", 0),

        (overlay_add_item, "$g_presentation_obj_battle_10", "@Stand Ground"),
        ##(overlay_add_item, "$g_presentation_obj_battle_10", "@Spread Out"),
        ##(overlay_add_item, "$g_presentation_obj_battle_10", "@Stand Closer"),
        ##(overlay_add_item, "$g_presentation_obj_battle_10", "@Fall Back"),
        ##(overlay_add_item, "$g_presentation_obj_battle_10", "@Advance"),
        (overlay_add_item, "$g_presentation_obj_battle_10", "@Charge"),
        (overlay_add_item, "$g_presentation_obj_battle_10", "@Follow Me"),
        (overlay_add_item, "$g_presentation_obj_battle_10", "@Hold This Position"),

        (create_button_overlay, "$g_presentation_obj_battle_14", "@Spread Out", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, "$g_presentation_obj_battle_14", 0xFFFFFFFF),
        (create_button_overlay, "$g_presentation_obj_battle_15", "@Stand Closer", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, "$g_presentation_obj_battle_15", 0xFFFFFFFF),
        (create_button_overlay, "$g_presentation_obj_battle_16", "@Fall Back", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, "$g_presentation_obj_battle_16", 0xFFFFFFFF),
        (create_button_overlay, "$g_presentation_obj_battle_17", "@Advance", tf_center_justify|tf_single_line|tf_with_outline),
        (overlay_set_color, "$g_presentation_obj_battle_17", 0xFFFFFFFF),

        (position_set_x, pos1, 600),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_battle_10", pos1),

        (val_add, ":y_position_for_order_buttons", -35),
        (position_set_x, pos1, 205),
        (position_set_y, pos1, ":y_position_for_order_buttons"),
        (val_add, ":y_position_for_order_buttons", 35),
        (overlay_set_position, "$g_presentation_obj_battle_10", pos1),
        (overlay_set_alpha, "$g_presentation_obj_battle_10", 0x60),
        (overlay_set_val, "$g_presentation_obj_battle_10", "$g_latest_order_1"),

        (val_add, ":y_position_for_order_buttons", -40), #new
        (position_set_x, pos1, 130), #new
        (position_set_y, pos1, ":y_position_for_order_buttons"), #new
        (val_add, ":y_position_for_order_buttons", 40), #new
        (overlay_set_position, "$g_presentation_obj_battle_14", pos1), #new
        #(overlay_set_alpha, "$g_presentation_obj_battle_14", 0x60), #new

        (val_add, ":y_position_for_order_buttons", -20), #new
        (position_set_x, pos1, 130), #new
        (position_set_y, pos1, ":y_position_for_order_buttons"), #new
        (val_add, ":y_position_for_order_buttons", 20), #new
        (overlay_set_position, "$g_presentation_obj_battle_15", pos1), #new
        #(overlay_set_alpha, "$g_presentation_obj_battle_15", 0x60), #new

        (val_add, ":y_position_for_order_buttons", -0), #new
        (position_set_x, pos1, 130), #new
        (position_set_y, pos1, ":y_position_for_order_buttons"), #new
        (val_add, ":y_position_for_order_buttons", 0), #new
        (overlay_set_position, "$g_presentation_obj_battle_16", pos1), #new
        #(overlay_set_alpha, "$g_presentation_obj_battle_16", 0x60), #new

        (val_add, ":y_position_for_order_buttons", 20), #new
        (position_set_x, pos1, 130), #new
        (position_set_y, pos1, ":y_position_for_order_buttons"), #new
        (val_add, ":y_position_for_order_buttons", -20), #new
        (overlay_set_position, "$g_presentation_obj_battle_17", pos1), #new
        #(overlay_set_alpha, "$g_presentation_obj_battle_17", 0x60), #new



        (overlay_add_item, "$g_presentation_obj_battle_11", "@Dismount"),
        (overlay_add_item, "$g_presentation_obj_battle_11", "@Mount"),

        (position_set_x, pos1, 600),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_battle_11", pos1),

        (position_set_x, pos1, 350),
        (position_set_y, pos1, ":y_position_for_order_buttons"),
        (overlay_set_position, "$g_presentation_obj_battle_11", pos1),

        (overlay_set_alpha, "$g_presentation_obj_battle_11", 0x60),
        (overlay_set_val, "$g_presentation_obj_battle_11", "$g_latest_order_2"),



        (overlay_add_item, "$g_presentation_obj_battle_12", "@Fire At Will"),
        (overlay_add_item, "$g_presentation_obj_battle_12", "@Hold Your Fire"),

        (position_set_x, pos1, 600),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_battle_12", pos1),

        (position_set_x, pos1, 495),
        (position_set_y, pos1, ":y_position_for_order_buttons"),
        (overlay_set_position, "$g_presentation_obj_battle_12", pos1),

        (overlay_set_alpha, "$g_presentation_obj_battle_12", 0x60),
        (overlay_set_val, "$g_presentation_obj_battle_12", "$g_latest_order_3"),



        (overlay_add_item, "$g_presentation_obj_battle_13", "@Use Blunt Weapons"),
        (overlay_add_item, "$g_presentation_obj_battle_13", "@Use Any Weapon"),

        (position_set_x, pos1, 600),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_battle_13", pos1),

        (val_add, ":y_position_for_order_buttons", -35),
        (position_set_x, pos1, 495),
        (position_set_y, pos1, ":y_position_for_order_buttons"),
        (val_add, ":y_position_for_order_buttons", 35),
        (overlay_set_position, "$g_presentation_obj_battle_13", pos1),

        (overlay_set_alpha, "$g_presentation_obj_battle_13", 0x60),
        (overlay_set_val, "$g_presentation_obj_battle_13", "$g_latest_order_4"),



        (create_text_overlay, "$g_presentation_obj_battle_22", "str_us_", 0),
        (create_text_overlay, "$g_presentation_obj_battle_23", "str_allies_", 0),
        (create_text_overlay, "$g_presentation_obj_battle_24", "str_enemies_", 0),
        (create_text_overlay, "$g_presentation_obj_battle_25", "@Ready", tf_center_justify),
        (create_text_overlay, "$g_presentation_obj_battle_26", "@Wounded", tf_center_justify),
        (create_text_overlay, "$g_presentation_obj_battle_28", "str_routed", tf_center_justify),
        (create_text_overlay, "$g_presentation_obj_battle_27", "@Dead", tf_center_justify),

        (create_text_overlay, "$g_battle_us_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_us_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_us_routed", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_us_dead", s7, tf_center_justify),

        (create_text_overlay, "$g_battle_enemies_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_routed", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_enemies_dead", s7, tf_center_justify),

        (create_text_overlay, "$g_battle_allies_ready", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_allies_wounded", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_allies_routed", s7, tf_center_justify),
        (create_text_overlay, "$g_battle_allies_dead", s7, tf_center_justify),


        (create_image_button_overlay, "$g_battle_report_plane", "mesh_white_plane", "mesh_white_plane"),
        (overlay_set_color, "$g_battle_report_plane", 0),
        (position_set_x, pos1, 15500),
        (position_set_y, pos1, 6000),
        (overlay_set_size, "$g_battle_report_plane", pos1),
        (position_set_x, pos1, 672),
        (position_set_y, pos1, 275),
        (overlay_set_position, "$g_battle_report_plane", pos1),
        (overlay_set_alpha, "$g_battle_report_plane", 0x44),
        (overlay_set_color, "$g_battle_report_plane", 0x1166BB),


        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),

        (overlay_set_size, "$g_presentation_obj_battle_14", pos1), #new
        (overlay_set_size, "$g_presentation_obj_battle_15", pos1), #new
        (overlay_set_size, "$g_presentation_obj_battle_16", pos1), #new
        (overlay_set_size, "$g_presentation_obj_battle_17", pos1), #new

        (overlay_set_size, "$g_presentation_obj_battle_22", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_23", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_24", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_25", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_26", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_27", pos1),
        (overlay_set_size, "$g_presentation_obj_battle_28", pos1),
        (overlay_set_size, "$g_battle_us_ready", pos1),
        (overlay_set_size, "$g_battle_us_wounded", pos1),
        (overlay_set_size, "$g_battle_us_routed", pos1),
        (overlay_set_size, "$g_battle_us_dead", pos1),
        (overlay_set_size, "$g_battle_enemies_ready", pos1),
        (overlay_set_size, "$g_battle_enemies_wounded", pos1),
        (overlay_set_size, "$g_battle_enemies_routed", pos1),
        (overlay_set_size, "$g_battle_enemies_dead", pos1),
        (overlay_set_size, "$g_battle_allies_ready", pos1),
        (overlay_set_size, "$g_battle_allies_wounded", pos1),
        (overlay_set_size, "$g_battle_allies_routed", pos1),
        (overlay_set_size, "$g_battle_allies_dead", pos1),

        (assign, ":stat_position_x", 675),
        (assign, ":stat_position_y", 280),

        (val_add, ":stat_position_x", 70),
        (val_add, ":stat_position_y", 90),
        (position_set_x, pos1, ":stat_position_x"),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_battle_25", pos1),
        (val_add, ":stat_position_x", 70),
        (position_set_x, pos1, ":stat_position_x"),
        (overlay_set_position, "$g_presentation_obj_battle_26", pos1),
        (val_add, ":stat_position_x", 70),
        (position_set_x, pos1, ":stat_position_x"),
        (overlay_set_position, "$g_presentation_obj_battle_28", pos1),
        (val_add, ":stat_position_x", 70),
        (position_set_x, pos1, ":stat_position_x"),
        (overlay_set_position, "$g_presentation_obj_battle_27", pos1),

        (val_add, ":stat_position_x", -280),
        (val_add, ":stat_position_y", -30),
        (position_set_x, pos1, ":stat_position_x"),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_battle_22", pos1),
        (val_add, ":stat_position_y", -30),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_battle_23", pos1),
        (val_add, ":stat_position_y", -30),
        (position_set_y, pos1, ":stat_position_y"),
        (overlay_set_position, "$g_presentation_obj_battle_24", pos1),

        (get_scene_boundaries, pos2, pos3),
        (position_transform_position_to_local, pos4, pos2, pos3),
        (set_fixed_point_multiplier, 1000),
        (position_get_x, ":map_width", pos4),
        (position_get_y, ":map_height", pos4),
        (set_fixed_point_multiplier, 1000),
        (store_div, ":map_ratio", ":map_height", 100),
        (store_div, ":map_ratio", ":map_width", ":map_ratio"),
        (try_begin),
          (gt, ":map_ratio", 100),
          ## CC
          #(store_mul, ":minimap_ratio", "$g_minimap_ratio", 3),
          #(assign, "$g_battle_map_width", ":minimap_ratio"),
          ## CC
          (store_div, "$g_battle_map_scale", ":map_width", "$g_battle_map_width"),
          (store_div, "$g_battle_map_height", ":map_height", "$g_battle_map_scale"),
        (else_try),
          ## CC
          #(store_mul, ":minimap_ratio", "$g_minimap_ratio", 3),
          #(assign, "$g_battle_map_height", ":minimap_ratio"),
          ## CC
          (store_div, "$g_battle_map_scale", ":map_height", "$g_battle_map_height"),
          (store_div, "$g_battle_map_width", ":map_width", "$g_battle_map_scale"),
        (try_end),

        (create_image_button_overlay, "$g_battle_map_plane", "mesh_white_plane", "mesh_white_plane"),
        (overlay_set_color, "$g_battle_map_plane", 0),
        (store_add, ":map_bordered_width", "$g_battle_map_width", 20),
        (store_add, ":map_bordered_height", "$g_battle_map_height", 20),
        (store_mul, ":map_scale_x", ":map_bordered_width", 50),
        (store_mul, ":map_scale_y", ":map_bordered_height", 50),
        (position_set_x, pos1, ":map_scale_x"),
        (position_set_y, pos1, ":map_scale_y"),
        (overlay_set_size, "$g_battle_map_plane", pos1),
        (store_sub, ":map_pos_x", 990, ":map_bordered_width"),
        (store_sub, ":map_pos_y", 740, ":map_bordered_height"),
        (position_set_x, pos1, ":map_pos_x"),
        (position_set_y, pos1, ":map_pos_y"),
        (overlay_set_position, "$g_battle_map_plane", pos1),
        (overlay_set_alpha, "$g_battle_map_plane", 0x22), ## CC

        (create_mesh_overlay, "$g_battle_map_infantry_order_flag", "mesh_flag_infantry"),
        (create_mesh_overlay, "$g_battle_map_archers_order_flag", "mesh_flag_archers"),
        (create_mesh_overlay, "$g_battle_map_cavalry_order_flag", "mesh_flag_cavalry"),
        (overlay_set_alpha, "$g_battle_map_infantry_order_flag", 0),
        (overlay_set_alpha, "$g_battle_map_archers_order_flag", 0),
        (overlay_set_alpha, "$g_battle_map_cavalry_order_flag", 0),

        (call_script, "script_update_order_panel_checked_classes"),
        (call_script, "script_update_order_panel_statistics_and_map"),

        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        (get_player_agent_no, ":player_agent"),
        (agent_get_team, ":player_team", ":player_agent"),

        (assign, ":update_listeners", 0),
        (try_begin),
          (eq, "$group0_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check0"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group0_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group1_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check1"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group1_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group2_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check2"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group2_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group3_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check3"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group3_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group4_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check4"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group4_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group5_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check5"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group5_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group6_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check6"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group6_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group7_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check7"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group7_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
        (else_try),
          (eq, "$group8_has_troops", 1),
          (eq, ":object", "$g_presentation_obj_battle_check8"),
          (assign, ":update_listeners", 1),
          (assign, "$g_formation_group8_selected", ":value"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0x44),
          (else_try),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but0"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group0_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check0", 1),

          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but1"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group1_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check1", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but2"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group2_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check2", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but3"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group3_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check3", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but4"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group4_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check4", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but5"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group5_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check5", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but6"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group6_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check6", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but7"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group7_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check7", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group8_has_troops", 1),
            (assign, "$g_formation_group8_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check8", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but8"),
          (assign, ":update_listeners", 1),

          (assign, "$g_formation_group8_selected", 1),
          (overlay_animate_to_alpha, "$g_presentation_obj_battle_but8", 250, 0x44),
          (overlay_set_val, "$g_presentation_obj_battle_check8", 1),

          (try_begin),
            (eq, "$group0_has_troops", 1),
            (assign, "$g_formation_group0_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check0", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but0", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group1_has_troops", 1),
            (assign, "$g_formation_group1_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check1", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but1", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group2_has_troops", 1),
            (assign, "$g_formation_group2_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check2", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but2", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group3_has_troops", 1),
            (assign, "$g_formation_group3_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check3", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but3", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group4_has_troops", 1),
            (assign, "$g_formation_group4_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check4", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but4", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group5_has_troops", 1),
            (assign, "$g_formation_group5_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check5", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but5", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group6_has_troops", 1),
            (assign, "$g_formation_group6_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check6", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but6", 250, 0),
          (try_end),
          (try_begin),
            (eq, "$group7_has_troops", 1),
            (assign, "$g_formation_group7_selected", 0),
            (overlay_set_val, "$g_presentation_obj_battle_check7", 0),
            (overlay_animate_to_alpha, "$g_presentation_obj_battle_but7", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_14"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_spread_out),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_15"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_stand_closer),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_16"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_fall_back),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_17"),
          (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_advance),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_10"),
          (try_begin),
            (eq, ":value", 3),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_hold),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_1", 3),
          (else_try),
            (eq, ":value", 2),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_follow),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_1", 2),
          (else_try),
            (eq, ":value", 1),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_charge),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_1", 1),
          (else_try),
            (eq, ":value", 0),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_stand_ground),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_1", 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_11"),
          (try_begin),
            (eq, ":value", 1),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_mount),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_2", 1),
          (else_try),
            (eq, ":value", 0),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_dismount),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_2", 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_12"),
          (try_begin),
            (eq, ":value", 1),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_hold_fire),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_3", 1),
          (else_try),
            (eq, ":value", 0),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_fire_at_will),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_3", 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_13"),
          (try_begin),
            (eq, ":value", 1),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_use_any_weapon),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_4", 1),
          (else_try),
            (eq, ":value", 0),
            (call_script, "script_team_give_order_from_order_panel", ":player_agent", mordr_use_blunt_weapons),
            (call_script, "script_update_order_panel", ":player_team"),
            (assign, "$g_latest_order_4", 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_battle_map_plane"),
          (get_scene_boundaries, pos2, pos3),
          (mouse_get_position, pos1),
          (set_fixed_point_multiplier, 1000),
          (position_get_x, ":mouse_x", pos1),
          (position_get_y, ":mouse_y", pos1),
          (store_sub, ":map_x", 980, "$g_battle_map_width"),
          (store_sub, ":map_y", 730, "$g_battle_map_height"),
          (val_sub, ":mouse_x", ":map_x"),
          (val_sub, ":mouse_y", ":map_y"),
          (val_clamp, ":mouse_x", 0, "$g_battle_map_width"),
          (val_clamp, ":mouse_y", 0, "$g_battle_map_height"),
          (val_mul, ":mouse_x", "$g_battle_map_scale"),
          (val_mul, ":mouse_y", "$g_battle_map_scale"),
          (set_fixed_point_multiplier, 1000),
          (position_set_x, pos1, ":mouse_x"),
          (position_set_y, pos1, ":mouse_y"),
          (position_transform_position_to_parent, pos3, pos2, pos1),
          (try_begin),
            (eq, "$g_formation_group0_selected", 1),
            (team_give_order, ":player_team", 0, mordr_hold),
            (team_set_order_position, ":player_team", 0, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group1_selected", 1),
            (team_give_order, ":player_team", 1, mordr_hold),
            (team_set_order_position, ":player_team", 1, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group2_selected", 1),
            (team_give_order, ":player_team", 2, mordr_hold),
            (team_set_order_position, ":player_team", 2, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group3_selected", 1),
            (team_give_order, ":player_team", 3, mordr_hold),
            (team_set_order_position, ":player_team", 3, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group4_selected", 1),
            (team_give_order, ":player_team", 4, mordr_hold),
            (team_set_order_position, ":player_team", 4, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group5_selected", 1),
            (team_give_order, ":player_team", 5, mordr_hold),
            (team_set_order_position, ":player_team", 5, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group6_selected", 1),
            (team_give_order, ":player_team", 6, mordr_hold),
            (team_set_order_position, ":player_team", 6, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group7_selected", 1),
            (team_give_order, ":player_team", 7, mordr_hold),
            (team_set_order_position, ":player_team", 7, pos3),
          (try_end),
          (try_begin),
            (eq, "$g_formation_group8_selected", 1),
            (team_give_order, ":player_team", 8, mordr_hold),
            (team_set_order_position, ":player_team", 8, pos3),
          (try_end),
          (call_script, "script_update_order_flags_on_map"),
          (call_script, "script_update_order_panel", ":player_team"),
        (try_end),

        (try_begin),
          (eq, ":update_listeners", 1),
          (team_set_order_listener, ":player_team", -1),
          (try_begin),
            (this_or_next|eq, "$g_formation_group0_selected", 1),
            (eq, "$group0_has_troops", 0),
            (this_or_next|eq, "$g_formation_group1_selected", 1),
            (eq, "$group1_has_troops", 0),
            (this_or_next|eq, "$g_formation_group2_selected", 1),
            (eq, "$group2_has_troops", 0),
            (this_or_next|eq, "$g_formation_group3_selected", 1),
            (eq, "$group3_has_troops", 0),
            (this_or_next|eq, "$g_formation_group4_selected", 1),
            (eq, "$group4_has_troops", 0),
            (this_or_next|eq, "$g_formation_group5_selected", 1),
            (eq, "$group5_has_troops", 0),
            (this_or_next|eq, "$g_formation_group6_selected", 1),
            (eq, "$group6_has_troops", 0),
            (this_or_next|eq, "$g_formation_group7_selected", 1),
            (eq, "$group7_has_troops", 0),
            (this_or_next|eq, "$g_formation_group8_selected", 1),
            (eq, "$group8_has_troops", 0),
            (team_set_order_listener, ":player_team", grc_everyone),
          (else_try),
            (eq, "$g_formation_group0_selected", 1),
            (team_set_order_listener, ":player_team", 0, 1),
          (else_try),
            (eq, "$g_formation_group1_selected", 1),
            (team_set_order_listener, ":player_team", 1, 1),
          (else_try),
            (eq, "$g_formation_group2_selected", 1),
            (team_set_order_listener, ":player_team", 2, 1),
          (else_try),
            (eq, "$g_formation_group3_selected", 1),
            (team_set_order_listener, ":player_team", 3, 1),
          (else_try),
            (eq, "$g_formation_group4_selected", 1),
            (team_set_order_listener, ":player_team", 4, 1),
          (else_try),
            (eq, "$g_formation_group5_selected", 1),
            (team_set_order_listener, ":player_team", 5, 1),
          (else_try),
            (eq, "$g_formation_group6_selected", 1),
            (team_set_order_listener, ":player_team", 6, 1),
          (else_try),
            (eq, "$g_formation_group7_selected", 1),
            (team_set_order_listener, ":player_team", 7, 1),
          (else_try),
            (eq, "$g_formation_group8_selected", 1),
            (team_set_order_listener, ":player_team", 8, 1),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_mouse_enter_leave,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":enter_leave"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_battle_but0"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but0_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but0_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but0_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name0", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but0_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but0_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but0_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name0", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but1"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but1_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but1_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but1_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name1", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but1_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but1_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but1_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name1", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but2"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but2_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but2_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but2_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name2", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but2_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but2_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but2_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name2", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but3"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but3_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but3_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but3_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name3", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but3_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but3_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but3_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name3", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but4"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but4_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but4_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but4_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name4", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but4_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but4_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but4_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name4", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but5"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but5_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but5_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but5_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name5", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but5_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but5_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but5_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name5", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but6"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but6_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but6_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but6_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name6", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but6_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but6_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but6_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name6", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but7"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but7_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but7_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but7_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name7", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but7_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but7_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but7_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name7", 250, 0),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_but8"),
          (try_begin),
            (eq, ":enter_leave", 0),
            (overlay_animate_to_color, "$g_presentation_but8_movement", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but8_riding", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_but8_weapon_usage", 250, 0xFFFFFF),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name8", 250, 0xFFFFFF),
          (else_try),
            (overlay_animate_to_color, "$g_presentation_but8_movement", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but8_riding", 250, 0),
            (overlay_animate_to_color, "$g_presentation_but8_weapon_usage", 250, 0),
            (overlay_animate_to_color, "$g_presentation_obj_battle_name8", 250, 0),
          (try_end),
        (try_end),
        ]),
      (ti_on_presentation_run,
       [(store_trigger_param_1, ":cur_time"),
        (try_begin),
          (this_or_next|game_key_clicked, gk_group0_hear),
          (this_or_next|game_key_clicked, gk_group1_hear),
          (this_or_next|game_key_clicked, gk_group2_hear),
          (this_or_next|game_key_clicked, gk_group3_hear),
          (this_or_next|game_key_clicked, gk_group4_hear),
          (this_or_next|game_key_clicked, gk_group5_hear),
          (this_or_next|game_key_clicked, gk_group6_hear),
          (this_or_next|game_key_clicked, gk_group7_hear),
          (this_or_next|game_key_clicked, gk_group8_hear),
          (this_or_next|game_key_clicked, gk_everyone_hear),
          (game_key_clicked, gk_reverse_order_group),
          (call_script, "script_update_order_panel_checked_classes"),
        (try_end),
        (try_begin),
          (this_or_next|game_key_clicked, gk_order_1),
          (this_or_next|game_key_clicked, gk_order_2),
          (this_or_next|game_key_clicked, gk_order_3),
          (this_or_next|game_key_clicked, gk_order_4),
          (this_or_next|game_key_clicked, gk_order_5),
          (game_key_clicked, gk_order_6),
          (get_player_agent_no, ":player_agent"),
          (agent_get_team, ":player_team", ":player_agent"),
          (call_script, "script_update_order_panel", ":player_team"),
        (try_end),
        (try_begin),
          (gt, ":cur_time", 200),
          (game_key_clicked, gk_view_orders),
          (try_for_agents, ":cur_agent"),
            (agent_set_slot, ":cur_agent", slot_agent_map_overlay_id, 0),
          (try_end),
          (presentation_set_duration, 0),
          (start_presentation, "prsnt_mini_map"), ## CC
##################################################
##### troop_ratio_bar
##################################################
          (start_presentation, "prsnt_troop_ratio_bar"),
##################################################
##### troop_ratio_bar
##################################################		  
        (try_end),
        ]),
      ]),


    ("sliders",0,0,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (create_slider_overlay, "$g_presentation_obj_sliders_1", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_sliders_2", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_sliders_3", 0, 100),
        (create_slider_overlay, "$g_presentation_obj_sliders_4", 0, 100),
        (assign, reg1, 25),
        (str_store_string, s1, "str_reg1"),
        (create_text_overlay, "$g_presentation_obj_sliders_5", s1),
        (create_text_overlay, "$g_presentation_obj_sliders_6", s1),
        (create_text_overlay, "$g_presentation_obj_sliders_7", s1),
        (create_text_overlay, "$g_presentation_obj_sliders_8", s1),
        (assign, "$g_presentation_obj_sliders_1_val", 25),
        (overlay_set_val, "$g_presentation_obj_sliders_1", 25),
        (assign, "$g_presentation_obj_sliders_2_val", 25),
        (overlay_set_val, "$g_presentation_obj_sliders_2", 25),
        (assign, "$g_presentation_obj_sliders_3_val", 25),
        (overlay_set_val, "$g_presentation_obj_sliders_3", 25),
        (assign, "$g_presentation_obj_sliders_4_val", 25),
        (overlay_set_val, "$g_presentation_obj_sliders_4", 25),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_sliders_1", pos1),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_sliders_2", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_sliders_3", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_sliders_4", pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_sliders_5", pos1),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_sliders_6", pos1),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_sliders_7", pos1),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_sliders_8", pos1),
        (position_set_x, pos1, 500),
        (overlay_set_size, "$g_presentation_obj_sliders_3", pos1),
        ]),
      (ti_on_presentation_run,
       [
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        (assign, ":val_changed", 0),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_sliders_1"),
          (try_begin),
            (neq, "$g_presentation_obj_sliders_1_val", ":value"),
            (assign, "$g_presentation_obj_sliders_1_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_2"),
          (try_begin),
            (neq, "$g_presentation_obj_sliders_2_val", ":value"),
            (assign, "$g_presentation_obj_sliders_2_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_3"),
          (try_begin),
            (neq, "$g_presentation_obj_sliders_3_val", ":value"),
            (assign, "$g_presentation_obj_sliders_3_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_4"),
          (try_begin),
            (neq, "$g_presentation_obj_sliders_4_val", ":value"),
            (assign, "$g_presentation_obj_sliders_4_val", ":value"),
            (assign, ":val_changed", 1),
          (try_end),
        (try_end),
        (try_begin),
          (eq, ":val_changed", 1),
          (assign, ":sum_values", 0),
          (val_add, ":sum_values", "$g_presentation_obj_sliders_1_val"),
          (val_add, ":sum_values", "$g_presentation_obj_sliders_2_val"),
          (val_add, ":sum_values", "$g_presentation_obj_sliders_3_val"),
          (val_add, ":sum_values", "$g_presentation_obj_sliders_4_val"),
          (store_sub, ":difference", 100, ":sum_values"),
          (assign, ":obj_1_new_val", "$g_presentation_obj_sliders_1_val"),
          (assign, ":obj_2_new_val", "$g_presentation_obj_sliders_2_val"),
          (assign, ":obj_3_new_val", "$g_presentation_obj_sliders_3_val"),
          (assign, ":obj_4_new_val", "$g_presentation_obj_sliders_4_val"),
          (assign, ":adder", 1),
          (assign, ":between_1", 0),
          (assign, ":between_2", 100),
          (try_begin),
            (lt, ":difference", 0),
            (val_mul, ":difference", -1),
            (assign, ":adder", -1),
            (assign, ":between_1", 1),
            (assign, ":between_2", 101),
          (try_end),
          (store_sub, ":sum_non_changed_values", ":sum_values", ":value"),
          (val_add, ":sum_non_changed_values", 30),
          (try_for_range, ":unused", 0, ":difference"),
            (store_random_in_range, ":random_no", 0, ":sum_non_changed_values"),
            (try_begin),
              (neq, ":object", "$g_presentation_obj_sliders_1"),
              (val_sub, ":random_no", "$g_presentation_obj_sliders_1_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_1_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_1_new_val", ":adder"),
            (else_try),
              (neq, ":object", "$g_presentation_obj_sliders_2"),
              (val_sub, ":random_no", "$g_presentation_obj_sliders_2_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_2_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_2_new_val", ":adder"),
            (else_try),
              (neq, ":object", "$g_presentation_obj_sliders_3"),
              (val_sub, ":random_no", "$g_presentation_obj_sliders_3_val"),
              (val_sub, ":random_no", 10),
              (lt, ":random_no", 0),
              (is_between, ":obj_3_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_3_new_val", ":adder"),
            (else_try),
              (is_between, ":obj_4_new_val", ":between_1", ":between_2"),
              (val_add, ":obj_4_new_val", ":adder"),
            (else_try),
              (val_add, ":difference", 1),
            (try_end),
          (try_end),
          (assign, "$g_presentation_obj_sliders_1_val", ":obj_1_new_val"),
          (assign, "$g_presentation_obj_sliders_2_val", ":obj_2_new_val"),
          (assign, "$g_presentation_obj_sliders_3_val", ":obj_3_new_val"),
          (assign, "$g_presentation_obj_sliders_4_val", ":obj_4_new_val"),
        (try_end),
        (overlay_set_val, "$g_presentation_obj_sliders_1", "$g_presentation_obj_sliders_1_val"),
        (overlay_set_val, "$g_presentation_obj_sliders_2", "$g_presentation_obj_sliders_2_val"),
        (overlay_set_val, "$g_presentation_obj_sliders_3", "$g_presentation_obj_sliders_3_val"),
        (overlay_set_val, "$g_presentation_obj_sliders_4", "$g_presentation_obj_sliders_4_val"),
        (assign, reg1, "$g_presentation_obj_sliders_1_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_sliders_5", s1),
        (assign, reg1, "$g_presentation_obj_sliders_2_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_sliders_6", s1),
        (assign, reg1, "$g_presentation_obj_sliders_3_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_sliders_7", s1),
        (assign, reg1, "$g_presentation_obj_sliders_4_val"),
        (str_store_string, s1, "str_reg1"),
        (overlay_set_text, "$g_presentation_obj_sliders_8", s1),
        ]),
      ]),

  ("arena_training", prsntf_read_only|prsntf_manual_end_only, 0, [
      (ti_on_presentation_load,
       [(presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        (get_player_agent_no, ":player_agent"),
        (agent_get_kill_count, reg1, ":player_agent", 1),
        (str_store_string, s1, "@Number of men knocked down: {reg1}"),
        (create_text_overlay, "$g_presentation_obj_arena_training_1", s1),
        (overlay_set_color, "$g_presentation_obj_arena_training_1", 0xFFFFFF),
        (position_set_x, pos1, 10),
        (position_set_y, pos1, 700),
        (overlay_set_position, "$g_presentation_obj_arena_training_1", pos1),
        (assign, reg1, 0),
        (str_store_string, s1, "@Number of men left: {reg1}"),
        (create_text_overlay, "$g_presentation_obj_arena_training_2", s1),
        (overlay_set_color, "$g_presentation_obj_arena_training_2", 0xFFFFFF),
        (position_set_x, pos1, 10),
        (position_set_y, pos1, 670),
        (overlay_set_position, "$g_presentation_obj_arena_training_2", pos1),
        ]),
      (ti_on_presentation_run,
       [(get_player_agent_no, ":player_agent"),
        (agent_get_kill_count, reg1, ":player_agent", 1),
        (str_store_string, s1, "@Opponents Beaten: {reg1}"),
        (overlay_set_text, "$g_presentation_obj_arena_training_1", s1),
        (assign, ":num_left", "$g_arena_training_max_opponents"),
        (try_for_agents, ":agent_no"),
          (agent_is_human, ":agent_no"),
          (neg|agent_is_alive, ":agent_no"),
          (neq, ":agent_no", ":player_agent"),
          (val_sub, ":num_left", 1),
        (try_end),
        (assign, reg1, ":num_left"),
        (str_store_string, s1, "@Opponents Remaining: {reg1}"),
        (overlay_set_text, "$g_presentation_obj_arena_training_2", s1),
        ]),
      ]),

  ("retirement", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        (create_button_overlay, "$g_presentation_obj_retirement_1", "@Remain in retirement.", tf_center_justify),
        (create_button_overlay, "$g_presentation_obj_retirement_2", "@Go back to the adventuring.", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 80),
        (overlay_set_position, "$g_presentation_obj_retirement_1", pos1),
        (position_set_y, pos1, 40),
        (overlay_set_position, "$g_presentation_obj_retirement_2", pos1),
        (assign, ":total_effect", 0),
        #wealth
        (store_troop_gold, ":wealth", "trp_player"),
        (store_div, ":wealth_effect", ":wealth", 200),
        (val_add, ":total_effect", ":wealth_effect"),
        #ruled centers and friendly/enemy centers
        (assign, ":num_towns", 0),
        (assign, ":num_castles", 0),
        (assign, ":num_villages", 0),
        (assign, ":num_friendly_towns", 0),
        (assign, ":num_friendly_villages", 0),
        (assign, ":num_enemy_towns", 0),
        (assign, ":num_enemy_villages", 0),
        (try_for_range, ":center_no", centers_begin, centers_end),
          (party_get_slot, ":type", ":center_no", slot_party_type),
          (try_begin),
            (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
            (try_begin),
              (eq, ":type", spt_town),
              (val_add, ":num_towns", 1),
            (else_try),
              (eq, ":type", spt_castle),
              (val_add, ":num_castles", 1),
            (else_try),
              (val_add, ":num_villages", 1),
            (try_end),
          (try_end),
          (party_get_slot, ":relation", ":center_no", slot_center_player_relation),
          (try_begin),
            (ge, ":relation", 40),
            (try_begin),
              (eq, ":type", spt_town),
              (val_add, ":num_friendly_towns", 1),
            (else_try),
              (eq, ":type", spt_village),
              (val_add, ":num_friendly_villages", 1),
            (try_end),
          (else_try),
            (le, ":relation", -40),
            (try_begin),
              (eq, ":type", spt_town),
              (val_add, ":num_enemy_towns", 1),
            (else_try),
              (eq, ":type", spt_village),
              (val_add, ":num_enemy_villages", 1),
            (try_end),
          (try_end),
        (try_end),
        (store_mul, ":num_towns_effect", ":num_towns", 100),
        (store_mul, ":num_castles_effect", ":num_castles", 50),
        (store_mul, ":num_villages_effect", ":num_villages", 20),
        (store_add, ":num_centers", ":num_towns", ":num_castles"),
        (val_add, ":num_centers", ":num_villages"),
        (store_add, ":ruled_centers_effect", ":num_towns_effect", ":num_castles_effect"),
        (val_add, ":ruled_centers_effect", ":num_villages_effect"),
        (val_add, ":total_effect", ":ruled_centers_effect"),
        (store_mul, ":num_friendly_towns_effect", ":num_friendly_towns", 20),
        (store_mul, ":num_friendly_villages_effect", ":num_friendly_villages", 4),
        (store_add, ":num_friendly_centers", ":num_friendly_towns", ":num_friendly_villages"),
        (store_add, ":friendly_centers_effect", ":num_friendly_towns_effect", ":num_friendly_villages_effect"),
        (val_add, ":total_effect", ":friendly_centers_effect"),
        (store_mul, ":num_enemy_towns_effect", ":num_enemy_towns", -40),
        (store_mul, ":num_enemy_villages_effect", ":num_enemy_villages", -8),
        (store_add, ":num_enemy_centers", ":num_enemy_towns", ":num_enemy_villages"),
        (store_add, ":enemy_centers_effect", ":num_enemy_towns_effect", ":num_enemy_villages_effect"),
        (val_add, ":total_effect", ":enemy_centers_effect"),
        #inventory
        (assign, ":total_item_value", 0),
        (troop_get_inventory_capacity, ":capacity", "trp_player"),
        (try_for_range, ":i_inv", 0, ":capacity"),
          (troop_get_inventory_slot, ":item", "trp_player", ":i_inv"),
          (ge, ":item", 0),
          (store_item_value, ":item_value", ":item"),
          (val_add, ":total_item_value", ":item_value"),
        (try_end),
        (store_div, ":total_item_value_effect", ":total_item_value", 200),
        (val_add, ":total_effect", ":total_item_value_effect"),
        #renown
        (troop_get_slot, ":renown", "trp_player", slot_troop_renown),
        (store_div, ":renown_effect", ":renown", 1),
        (val_add, ":total_effect", ":renown_effect"),
        #enemies and friends
        (assign, ":num_enemies", 0),
        (assign, ":num_friends", 0),
        (try_for_range, ":troop_no", heroes_begin, heroes_end),
          (this_or_next|troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_hero),
          (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_kingdom_lady),
          (call_script, "script_troop_get_player_relation", ":troop_no"),
          (assign, ":relation", reg0),
          #(troop_get_slot, ":relation", ":troop_no", slot_troop_player_relation),
          (try_begin),
            (ge, ":relation", 40),
            (val_add, ":num_friends", 1),
          (else_try),
            (le, ":relation", -40),
            (val_add, ":num_enemies", 1),
          (try_end),
        (try_end),
        (store_mul, ":num_friends_effect", ":num_friends", 10),
        (val_add, ":total_effect", ":num_friends_effect"),
        (store_mul, ":num_enemies_effect", ":num_enemies", -10),
        (val_add, ":total_effect", ":num_enemies_effect"),
        #current day
        (store_current_day, ":cur_day"),
        (store_div, ":cur_day_effect", ":cur_day", -1),
        (val_add, ":total_effect", ":cur_day_effect"),
        #g_total_victories
        (store_mul, ":total_victories_effect", "$g_total_victories", 2),
        (val_add, ":total_effect", ":total_victories_effect"),
        #g_total_defeats
        (store_mul, ":total_defeats_effect", "$g_total_defeats", -3),
        (val_add, ":total_effect", ":total_defeats_effect"),
        #g_total_quests_completed
        (store_mul, ":total_quests_completed_effect", "$g_total_quests_completed", 4),
        (val_add, ":total_effect", ":total_quests_completed_effect"),
        #xp
        (troop_get_xp, ":xp", "trp_player"),
        (store_div, ":xp_effect", ":xp", 5000),
        (val_add, ":total_effect", ":xp_effect"),
        #companions joined / departed
        (assign, ":num_companions_joined", 0),
        (assign, ":num_companions_departed", 0),
        (try_for_range, ":troop_no", companions_begin, companions_end),
          (try_begin),
            (troop_slot_eq, ":troop_no", slot_troop_occupation, slto_player_companion),
            (val_add, ":num_companions_joined", 1),
          (else_try),
            (troop_slot_ge, ":troop_no", slot_troop_playerparty_history, 1),
            (val_add, ":num_companions_departed", 1),
          (try_end),
        (try_end),
        (store_div, ":num_companions_joined_effect", ":num_companions_joined", 2),
        (val_add, ":total_effect", ":num_companions_joined_effect"),
        (store_div, ":num_companions_departed_effect", ":num_companions_departed", -4),
        (val_add, ":total_effect", ":num_companions_departed_effect"),
        #difficulty
        (get_average_game_difficulty, ":difficulty"),
        (assign, ":difficulty_effect", ":total_effect"),
        (val_mul, ":total_effect", ":difficulty"),
        (val_div, ":total_effect", 75),
        (val_mul, ":total_effect", ":difficulty"),
        (val_div, ":total_effect", 75),
        (store_sub, ":difficulty_effect", ":total_effect", ":difficulty_effect"),

        (assign, reg5, ":cur_day"),
        (store_character_level, reg4, "trp_player"),
        (create_text_overlay, reg1, "@You have retired at level {reg4} after {reg5} days of adventuring.", tf_center_justify),
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 700),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 950),
        (overlay_set_size, reg1, pos1),
##        (overlay_set_color, reg1, 0),
        (create_text_overlay, reg2, "@Effect on Score", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg2, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 670),
        (overlay_set_position, reg2, pos1),
        (assign, reg0, ":num_centers"),
        (create_text_overlay, reg1, "@Settlements owned by you: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":ruled_centers_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_friendly_centers"),
        (create_text_overlay, reg1, "@Friendly Settlements: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 630),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":friendly_centers_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 630),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_enemy_centers"),
        (create_text_overlay, reg1, "@Hostile Settlements: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 610),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":enemy_centers_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 610),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, ":num_friends"),
        (create_text_overlay, reg1, "@Friendly Lords: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 590),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":num_friends_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 590),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_enemies"),
        (create_text_overlay, reg1, "@Enemy Lords: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 570),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":num_enemies_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 570),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, "$g_total_victories"),
        (create_text_overlay, reg1, "@Victories: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":total_victories_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, "$g_total_defeats"),
        (create_text_overlay, reg1, "@Defeats: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 530),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":total_defeats_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 530),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, "$g_total_quests_completed"),
        (create_text_overlay, reg1, "@Quests Completed: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 510),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":total_quests_completed_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 510),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_companions_joined"),
        (create_text_overlay, reg1, "@Companions Found: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 490),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":num_companions_joined_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 490),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":num_companions_departed"),
        (create_text_overlay, reg1, "@Companions Lost/Departed: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 470),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":num_companions_departed_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 470),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, ":wealth"),
        (create_text_overlay, reg1, "@Wealth: {reg0} denars", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 450),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":wealth_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 450),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":total_item_value"),
        (create_text_overlay, reg1, "@Inventory: {reg0} denars", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 430),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":total_item_value_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 430),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":renown"),
        (create_text_overlay, reg1, "@Renown: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 410),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":renown_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 410),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":xp"),
        (create_text_overlay, reg1, "@Experience: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 390),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":xp_effect"),
        (create_text_overlay, reg1, "@{!}{reg0?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 390),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (try_end),

        (assign, reg0, ":cur_day"),
        (create_text_overlay, reg1, "@Days Passed: {reg0}", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 370),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":cur_day_effect"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 370),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, ":difficulty"),
        (create_text_overlay, reg1, "@Difficulty: {reg0}%", 0),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":difficulty_effect"),
        (assign, reg3, reg0),
        (val_max, reg3, 0),
        (create_text_overlay, reg1, "@{!}{reg3?+:}{reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 750),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, reg0, 0),
          (overlay_set_color, reg1, 0x00AA00),
        (else_try),
          (lt, reg0, 0),
          (overlay_set_color, reg1, 0xFF0000),
        (try_end),

        (assign, reg0, ":total_effect"),
        (create_text_overlay, reg1, "@TOTAL SCORE: {reg0}", tf_center_justify),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 320),
        (overlay_set_position, reg1, pos1),

        (assign, ":total_villages", 0),
        (assign, ":total_castles", 0),
        (assign, ":total_towns", 0),
        (assign, ":total_village_rels", 0),
        (assign, ":total_castle_rels", 0),
        (assign, ":total_town_rels", 0),
        (try_for_range, ":cur_center_no", centers_begin, centers_end),
          (try_begin),
            (party_slot_eq, ":cur_center_no", slot_town_lord, "trp_player"),
            (try_begin),
              (party_slot_eq, ":cur_center_no", slot_party_type, spt_town),
              (val_add, ":total_towns", 1),
            (else_try),
              (party_slot_eq, ":cur_center_no", slot_party_type, spt_castle),
              (val_add, ":total_castles", 1),
            (else_try),
              (val_add, ":total_villages", 1),
            (try_end),
          (else_try),
            (party_get_slot, ":center_relation", ":cur_center_no", slot_center_player_relation),
            (gt, ":center_relation", 0),
            (try_begin),
              (party_slot_eq, ":cur_center_no", slot_party_type, spt_town),
              (val_add, ":total_town_rels", ":center_relation"),
            (else_try),
              (party_slot_eq, ":cur_center_no", slot_party_type, spt_castle),
              (val_add, ":total_castle_rels", ":center_relation"),
            (else_try),
              (val_add, ":total_village_rels", ":center_relation"),
            (try_end),
          (try_end),
        (try_end),
        (try_begin),
          (gt, ":total_towns", 0),
          (store_random_in_range, ":random_town", 0, ":total_towns"),
          (try_for_range, ":cur_center_no", towns_begin, towns_end),
            (party_slot_eq, ":cur_center_no", slot_town_lord, "trp_player"),
            (val_sub, ":random_town", 1),
            (lt, ":random_town", 0),
            (str_store_party_name, s9, ":cur_center_no"),
          (try_end),
        (else_try),
          (gt, ":total_town_rels", 0),
          (store_random_in_range, ":random_town_rel", 0, ":total_town_rels"),
          (try_for_range, ":cur_center_no", towns_begin, towns_end),
            (party_get_slot, ":center_relation", ":cur_center_no", slot_center_player_relation),
            (gt, ":center_relation", 0),
            (val_sub, ":random_town_rel", ":center_relation"),
            (lt, ":random_town_rel", 0),
            (str_store_party_name, s9, ":cur_center_no"),
          (try_end),
        (else_try),
          (store_random_in_range, ":random_town", towns_begin, towns_end),
          (str_store_party_name, s9, ":random_town"),
        (try_end),
        (try_begin),
          (gt, ":total_castles", 0),
          (store_random_in_range, ":random_castle", 0, ":total_castles"),
          (try_for_range, ":cur_center_no", castles_begin, castles_end),
            (party_slot_eq, ":cur_center_no", slot_town_lord, "trp_player"),
            (val_sub, ":random_castle", 1),
            (lt, ":random_castle", 0),
            (str_store_party_name, s8, ":cur_center_no"),
          (try_end),
        (else_try),
          (gt, ":total_castle_rels", 0),
          (store_random_in_range, ":random_castle_rel", 0, ":total_castle_rels"),
          (try_for_range, ":cur_center_no", castles_begin, castles_end),
            (party_get_slot, ":center_relation", ":cur_center_no", slot_center_player_relation),
            (gt, ":center_relation", 0),
            (val_sub, ":random_castle_rel", ":center_relation"),
            (lt, ":random_castle_rel", 0),
            (str_store_party_name, s8, ":cur_center_no"),
          (try_end),
        (else_try),
          (store_random_in_range, ":random_castle", castles_begin, castles_end),
          (str_store_party_name, s8, ":random_castle"),
        (try_end),
        (try_begin),
          (gt, ":total_villages", 0),
          (store_random_in_range, ":random_village", 0, ":total_villages"),
          (try_for_range, ":cur_center_no", villages_begin, villages_end),
            (party_slot_eq, ":cur_center_no", slot_town_lord, "trp_player"),
            (val_sub, ":random_village", 1),
            (lt, ":random_village", 0),
            (str_store_party_name, s7, ":cur_center_no"),
          (try_end),
        (else_try),
          (gt, ":total_village_rels", 0),
          (store_random_in_range, ":random_village_rel", 0, ":total_village_rels"),
          (try_for_range, ":cur_center_no", villages_begin, villages_end),
            (party_get_slot, ":center_relation", ":cur_center_no", slot_center_player_relation),
            (gt, ":center_relation", 0),
            (val_sub, ":random_village_rel", ":center_relation"),
            (lt, ":random_village_rel", 0),
            (str_store_party_name, s7, ":cur_center_no"),
          (try_end),
        (else_try),
          (store_random_in_range, ":random_village", villages_begin, villages_end),
          (str_store_party_name, s7, ":random_village"),
        (try_end),

        (try_begin),
          (lt, ":total_effect", 100),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 0),
          (str_store_string, s0, "str_retirement_text_1"),
        (else_try),
          (lt, ":total_effect", 200),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 1),
          (str_store_string, s0, "str_retirement_text_2"),
        (else_try),
          (lt, ":total_effect", 400),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 2),
          (str_store_string, s0, "str_retirement_text_3"),
        (else_try),
          (lt, ":total_effect", 700),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 3),
          (str_store_string, s0, "str_retirement_text_4"),
        (else_try),
          (lt, ":total_effect", 1200),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 4),
          (str_store_string, s0, "str_retirement_text_5"),
        (else_try),
          (lt, ":total_effect", 1850),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 5),
          (str_store_string, s0, "str_retirement_text_6"),
        (else_try),
          (lt, ":total_effect", 2500),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 6),
          (str_store_string, s0, "str_retirement_text_7"),
        (else_try),
          (lt, ":total_effect", 3500),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 7),
          (str_store_string, s0, "str_retirement_text_8"),
        (else_try),
          (lt, ":total_effect", 5000),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 8),
          (str_store_string, s0, "str_retirement_text_9"),
        (else_try),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_retirement_troop", 9),
          (str_store_string, s0, "str_retirement_text_10"),
        (try_end),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, 120),
        (overlay_set_position, reg1, pos1),

        (create_text_overlay, reg1, s0, tf_double_space|tf_scrollable),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 120),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 360),
        (position_set_y, pos1, 190),
        (overlay_set_area_size, reg1, pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg1, pos1),
        ]),
     (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_retirement_1"),
          (jump_to_menu, "mnu_end_game"),
          (start_presentation, "prsnt_game_credits"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_retirement_2"),
          (presentation_set_duration, 0),
          (change_screen_return),
        (try_end),
        ]),
     ]),

  ("budget_report", 0, mesh_load_window,
   [(ti_on_presentation_load,
     [(presentation_set_duration, 999999),
      (set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg1, "mesh_pic_payment"),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 170),
      (position_set_y, pos1, 0),
      (overlay_set_position, reg1, pos1),

      (create_text_overlay, reg1, "str_weekly_budget", tf_center_justify),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 260),
      (position_set_y, pos1, 650),
      (overlay_set_position, reg1, pos1),

      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_bugdet_report_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 0),
      (position_set_y, pos1, 100),
      (overlay_set_position, "$g_presentation_obj_bugdet_report_container", pos1),
      (position_set_x, pos1, 505),
      (position_set_y, pos1, 500),
      (overlay_set_area_size, "$g_presentation_obj_bugdet_report_container", pos1),
      (set_container_overlay, "$g_presentation_obj_bugdet_report_container"),

      (game_get_reduce_campaign_ai, ":reduce_campaign_ai"),
      (try_begin),
        (eq, ":reduce_campaign_ai", 0), #hard
        (assign, ":num_centers_needed_for_efficiency_loss", 2),
        (assign, ":tax_efficiency_loss_ratio_per_center", 5),
      (else_try),
        (eq, ":reduce_campaign_ai", 1), #medium
        (assign, ":num_centers_needed_for_efficiency_loss", 4),
        (assign, ":tax_efficiency_loss_ratio_per_center", 4),
      (else_try),
        (eq, ":reduce_campaign_ai", 2), #easy
        (assign, ":num_centers_needed_for_efficiency_loss", 6),
        (assign, ":tax_efficiency_loss_ratio_per_center", 3),
      (try_end),
	  ##diplomacy start+ Handle player is co-ruler of NPC kingdom
	  (assign, ":alt_rule_faction", "fac_player_supporters_faction"),
	  (try_begin),
		 (is_between, "$players_kingdom", npc_kingdoms_begin, npc_kingdoms_end),
		 (call_script, "script_dplmc_get_troop_standing_in_faction", "trp_player", "$players_kingdom"),
		 (ge, reg0, DPLMC_FACTION_STANDING_LEADER_SPOUSE),
	 	 (assign, ":alt_rule_faction", "$players_kingdom"),
	  (try_end),
	  ##diplomacy end+

      (assign, ":num_lines", 0),
      (assign, ":num_owned_center_values_for_tax_efficiency", 0),
      (assign, ":all_centers_accumulated_total", 0),
      (assign, ":all_centers_accumulated_taxes_and_rents", 0),
      (try_for_range, ":center_no", centers_begin, centers_end),
	    (try_begin),
		  (party_slot_ge, ":center_no", slot_center_player_enterprise, 1),
		  (val_add, ":num_lines", 1),
	    (try_end),

        (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
        (val_add, ":num_lines", 1),
        (val_add, ":num_owned_center_values_for_tax_efficiency", 1),
        (try_begin),
          (is_between, ":center_no", towns_begin, towns_end),
          (val_add, ":num_lines", 1),
          (val_add, ":num_owned_center_values_for_tax_efficiency", 1),
        (try_end),
      (try_end),
      (try_begin),
        (gt, "$players_kingdom", 0),
        (neq, "$players_kingdom", "fac_player_supporters_faction"),
        (neq, "$players_kingdom", "fac_player_faction"),
        (eq, "$player_has_homage", 0),
        (val_add, ":num_lines", 1),
      (try_end),
      (try_begin),
        (gt, ":num_owned_center_values_for_tax_efficiency", ":num_centers_needed_for_efficiency_loss"),
      #gt accumulated total is ignored
        (val_add, ":num_lines", 1),
      (try_end),
      (try_for_parties, ":party_no"),
        (assign, ":garrison_troop", 0),
        (try_begin),
          (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_town),
			(party_slot_eq, ":party_no", slot_party_type, spt_castle),
          (party_slot_eq, ":party_no", slot_town_lord, "trp_player"),
          (assign, ":garrison_troop", 1),
        (else_try),
          (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_town),
			(party_slot_eq, ":party_no", slot_party_type, spt_castle),
          (neg|party_slot_ge, ":party_no", slot_town_lord, 1), #unassigned
		  (store_faction_of_party, ":center_faction", ":party_no"),
		  ##diplomacy start+
		  (this_or_next|eq, ":alt_rule_faction", ":center_faction"),#co-ruler of an NPC kingdom ##fixed typo 2011-06-07
		  ##diplomacy end+
		  (eq, ":center_faction", "fac_player_supporters_faction"),
		  ##diplomacy start+
		  (this_or_next|is_between, ":alt_rule_faction", npc_kingdoms_begin, npc_kingdoms_end),#co-ruler of an NPC kingdom
		  ##diplomacy end+
		  (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
          (assign, ":garrison_troop", 1),
		(try_end),

        (this_or_next|eq, ":party_no", "p_main_party"),
        ##diplomacy begin
        (assign, ":patrol_troop", 0),
        (try_begin),
          (party_slot_eq, ":party_no",slot_party_type, spt_patrol),
          (party_slot_eq, ":party_no", dplmc_slot_party_mission_diplomacy, "trp_player"),
          (assign, ":patrol_troop", 1),
        (try_end),
        (this_or_next|eq, ":patrol_troop", 1),
        ##diplomacy end
        (eq, ":garrison_troop", 1),
        (val_add, ":num_lines", 1), #include empty towns/castles
      (try_end),
      (try_begin),
        (gt, "$g_player_debt_to_party_members", 0),
        (val_add, ":num_lines", 2), #include new debt line
      (try_end),
      ##diplomacy begin
      (try_begin),
        (this_or_next|gt, "$g_player_minister", 0),
        (this_or_next|troop_slot_ge, "trp_player", slot_troop_spouse, 0),
        (this_or_next|gt, "$g_player_chamberlain", 0),
        (gt, "$g_player_constable", 0),
        (val_add, ":num_lines", 1), # staff salary
      (try_end),

      (try_begin),
        (gt, "$g_player_chamberlain", 0),
        (val_add, ":num_lines", 2), #earlier cash, new cash
      (try_end),
      ##diplomacy end
## Tocan  
	  #FLORIS BEGIN
      (try_begin),
        (faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_active),
        (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
        (val_add, ":num_lines", 1),
      (try_end),
		(try_for_parties, ":party_no"),
			(party_slot_ge,":party_no", slot_ship_center, 1), #Ships are identified by 4 states, towns/player/wilderness/wilderness w/o guard
			(assign, reg20, 2),
		(try_end),
		(try_begin),
			(eq, reg20,2),
			(val_add, ":num_lines", 1),
		(try_end),
      #FLORIS END  
## Tocan   end	  
      (val_add, ":num_lines", 3),
      (store_mul, ":cur_y", 27, ":num_lines"),
      (assign, ":net_change", 0), #this is the amount added
      (try_for_range, ":center_no", centers_begin, centers_end),
		#Enterprise
        (try_begin),
		  (party_get_slot, ":enterprise_output", ":center_no", slot_center_player_enterprise),
		  (gt, ":enterprise_output", 1),
		  (neg|party_slot_ge, ":center_no", slot_center_player_enterprise_days_until_complete, 1),

          (str_store_party_name, s0, ":center_no"),

		  (call_script, "script_process_player_enterprise", ":enterprise_output", ":center_no"),
		  (assign, ":net_profit", reg0),
		  (assign, ":price_of_single_output", reg4),
		  (assign, ":price_of_single_input", reg5),
		  (assign, ":price_of_secondary_input", reg10),

		  (store_sub, ":town_order", ":center_no", towns_begin),
		  (store_add, ":craftsman_troop", ":town_order", "trp_town_1_master_craftsman"),

		  (item_get_slot, ":outputs_added_to_market", ":enterprise_output", slot_item_output_per_run),
		  (assign, ":outputs_added_to_warehouse", 0),

		  #Enterprise impact of outputs
		  (try_begin),
		    #output placed in inventory: deduct selling price and add one good
			(party_slot_eq, ":center_no", slot_center_player_enterprise_production_order, 1),

			#Count empty slots
			(assign, ":empty_slots", 0),
			(troop_get_inventory_capacity, ":total_capacity", ":craftsman_troop"),
			(try_for_range, ":capacity_iterator", 0, ":total_capacity"),
				(troop_get_inventory_slot, ":slot", ":craftsman_troop", ":capacity_iterator"),
				(lt, ":slot", 1),
				(val_add, ":empty_slots", 1),
			(try_end),

			(assign, ":outputs_added_to_warehouse", ":outputs_added_to_market"),
			(val_min, ":outputs_added_to_warehouse",  ":empty_slots"),
			(gt, ":outputs_added_to_warehouse", 0),

			(store_mul, ":cancelled_sales", ":price_of_single_output", ":outputs_added_to_warehouse"),
			(val_sub, ":net_profit", ":cancelled_sales"),
			(val_sub, ":outputs_added_to_market", ":outputs_added_to_warehouse"),
		  (try_end),

		  #If the transaction is for real, and not just a budget check
		  (try_begin),
		    (eq, "$g_apply_budget_report_to_gold", 1),
			(troop_add_items, ":craftsman_troop", ":enterprise_output", ":outputs_added_to_warehouse"),

			#Affect prices by outputs added to market
			(store_sub, ":item_slot_no", ":enterprise_output", trade_goods_begin),
			(val_add, ":item_slot_no", slot_town_trade_good_prices_begin),
			(party_get_slot, ":current_index", ":center_no", ":item_slot_no"),
			(store_mul, ":impact_on_price", ":outputs_added_to_market", 15),
			(val_sub, ":current_index", ":impact_on_price"),
			(party_set_slot, ":center_no", ":item_slot_no",":current_index"),

			(gt, "$cheat_mode", 0),
			(str_store_troop_name, s3, ":craftsman_troop"),
			(assign, reg3, ":outputs_added_to_warehouse"),
			(display_message, "@{!}DEBUG -- Adding {reg3} items to {s3}"),
		  (try_end),

		  #Enterprise impact of outputs
		  (item_get_slot, ":inputs_taken_from_market", ":enterprise_output", slot_item_input_number),
		  (try_begin),
			(item_slot_ge, ":enterprise_output", slot_item_secondary_raw_material, 1),
		    (assign, ":2ary_inputs_taken_from_market", ":inputs_taken_from_market"),
		  (else_try),
		    (assign, ":2ary_inputs_taken_from_market", 0),
		  (try_end),

		  (assign, ":inputs_taken_from_warehouse", 0),
		  (assign, ":2ary_inputs_taken_from_warehouse", 0),

		  (try_begin),
		    #input present in inventory: reimburse for input cost and remove one good
			(troop_get_inventory_capacity, ":total_capacity", ":craftsman_troop"),
			(try_for_range, ":capacity_iterator", 0, ":total_capacity"),
				(troop_get_inventory_slot, ":item_in_slot", ":craftsman_troop", ":capacity_iterator"),

				(lt, ":inputs_taken_from_warehouse", ":inputs_taken_from_market"),
				(item_slot_eq, ":enterprise_output", slot_item_primary_raw_material, ":item_in_slot"),
                #(troop_inventory_slot_get_item_amount, ":item_ammo", ":craftsman_troop", ":capacity_iterator"),
                #(troop_inventory_slot_get_item_max_amount, ":item_max_ammo", ":craftsman_troop", ":capacity_iterator"),
                #(eq, ":item_ammo", ":item_max_ammo"),

				(val_add, ":inputs_taken_from_warehouse", 1),
			(else_try),
				(lt, ":2ary_inputs_taken_from_warehouse", ":2ary_inputs_taken_from_market"),
				(item_slot_eq, ":enterprise_output", slot_item_secondary_raw_material, ":item_in_slot"),
                #(troop_inventory_slot_get_item_amount, ":item_ammo", ":craftsman_troop", ":capacity_iterator"),
                #(troop_inventory_slot_get_item_max_amount, ":item_max_ammo", ":craftsman_troop", ":capacity_iterator"),
                #(eq, ":item_ammo", ":item_max_ammo"),

				(val_add, ":2ary_inputs_taken_from_warehouse", 1),
			(try_end),

		    (try_begin),
				(gt, ":inputs_taken_from_warehouse", 0),
				(val_sub, ":inputs_taken_from_market", ":inputs_taken_from_warehouse"),
				(store_mul, ":savings_from_warehoused_inputs",	":price_of_single_input", ":inputs_taken_from_warehouse"),
				(val_add, ":net_profit", ":savings_from_warehoused_inputs"),
			(try_end),
		    (try_begin),
				(gt, ":2ary_inputs_taken_from_warehouse", 0),
				(val_sub, ":2ary_inputs_taken_from_market", ":2ary_inputs_taken_from_warehouse"),
				(assign, ":savings_from_warehoused_inputs",	":price_of_secondary_input"),
				(val_add, ":net_profit", ":savings_from_warehoused_inputs"),
			(try_end),
		  (try_end),

		  #If the transaction is for real, and not just a budget check
		  (try_begin),
		    (eq, "$g_apply_budget_report_to_gold", 1),
			(item_get_slot, ":raw_material", ":enterprise_output", slot_item_primary_raw_material),
			(troop_remove_items, ":craftsman_troop", ":raw_material", ":inputs_taken_from_warehouse"),
			(item_get_slot, ":secondary_raw_material", ":enterprise_output", slot_item_secondary_raw_material),
			(troop_remove_items, ":craftsman_troop", ":secondary_raw_material", ":2ary_inputs_taken_from_warehouse"),

			#Affect prices by intputs added to market
			(store_sub, ":item_slot_no", ":raw_material", trade_goods_begin),
			(val_add, ":item_slot_no", slot_town_trade_good_prices_begin),
			(party_get_slot, ":current_index", ":center_no", ":item_slot_no"),
			(store_mul, ":impact_on_price", ":outputs_added_to_market", 15),
			(val_add, ":current_index", ":impact_on_price"),
			(party_set_slot, ":center_no", ":item_slot_no",":current_index"),

			(try_begin),
				(gt, ":2ary_inputs_taken_from_market", 0),
				(store_sub, ":item_slot_no", ":secondary_raw_material", trade_goods_begin),
				(val_add, ":item_slot_no", slot_town_trade_good_prices_begin),
				(party_get_slot, ":current_index", ":center_no", ":item_slot_no"),
				(val_add, ":current_index", 15),
				(party_set_slot, ":center_no", ":item_slot_no",":current_index"),
			(try_end),
		  (try_end),

		  (call_script, "script_get_enterprise_name", ":enterprise_output"),
		  (str_store_string, s5, reg0),

          (create_text_overlay, reg1, "str_enterprise_s5_at_s0", 0),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 25),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),

          (assign, reg0, ":net_profit"),

		  #Enterprise revenue strings
          (try_begin),
     	    (store_faction_of_party, ":faction_no", ":center_no"),
		    (store_relation, ":relation", ":faction_no", "$players_kingdom"),
		    (lt, ":relation", 0),
		    (assign, reg0, 0),
		    (assign, ":net_profit", 0),

            (create_text_overlay, reg1, "str_under_sequestration", tf_right_align|tf_single_line),
            (overlay_set_color, reg1, 0xFF0000),
		  (else_try),
		    (ge, reg0, 0),
            (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
            (overlay_set_color, reg1, 0x00AA00),
          (else_try),
            (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
            (overlay_set_color, reg1, 0xFF0000),
          (try_end),

          (val_add, ":all_centers_accumulated_total", ":net_profit"),
          (val_add, ":net_change", ":net_profit"),

          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (val_sub, ":cur_y", 27),
        (try_end),

		#Enterprise ends, taxes begin
        (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
        (party_get_slot, ":accumulated_rents", ":center_no", slot_center_accumulated_rents),
        (party_get_slot, ":accumulated_tariffs", ":center_no", slot_center_accumulated_tariffs),

### [OSP] Gold and Iron Mines (need more gold) ### [OSP] Gold and Iron Mines (need more gold) ### [OSP] Gold and Iron Mines (need more gold) ###   
        (try_begin),
            (party_slot_eq, ":center_no", slot_center_has_gold_mine, 1),
            (party_get_slot, ":goldm_rent", ":center_no", slot_village_give_goldcoin),
            (val_add, ":accumulated_tariffs", ":goldm_rent"),   
        (try_end),      
### [OSP] Gold and Iron Mines (need more gold) ### [OSP] Gold and Iron Mines (need more gold) ### [OSP] Gold and Iron Mines (need more gold) ###   		
		
        (store_add, ":accumulated_total", ":accumulated_rents", ":accumulated_tariffs"),
        (val_add, ":all_centers_accumulated_total", ":accumulated_total"),
        (val_add, ":all_centers_accumulated_taxes_and_rents", ":accumulated_total"),
        (val_add, ":net_change", ":accumulated_total"),
        (str_store_party_name, s0, ":center_no"),
        ##diplomacy begin
        (try_begin),
          (neg|is_between, ":center_no", castles_begin, castles_end),
          (party_get_slot, ":tax_rate", ":center_no", dplmc_slot_center_taxation),
          (neq, ":tax_rate", 0),
          (call_script, "script_dplmc_describe_tax_rate_to_s50", ":tax_rate"),
          (str_store_string, s0, "@{s0} ({s50})"),
        (try_end),
        ##diplomacy end
        (create_text_overlay, reg1, "str_rents_from_s0", 0),
        ##diplomacy begin
        (str_store_party_name, s0, ":center_no"),
        ##diplomacy end
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (gt, ":accumulated_rents", 0),
          (assign, reg0, ":accumulated_rents"),
          (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
          (overlay_set_color, reg1, 0x00AA00),
        (else_try),
          (create_text_overlay, reg1, "@None", tf_right_align|tf_single_line),
        (try_end),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),

### [OSP] Gold and Iron Mines (need more gold) ### [OSP] Gold and Iron Mines (need more gold) ### [OSP] Gold and Iron Mines (need more gold) ###   
      (try_begin),
           (is_between, ":center_no", villages_begin, villages_end),
                 (party_slot_eq, ":center_no", slot_center_has_gold_mine, 1),
      (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
      (str_store_party_name, s0, ":center_no"),
      (create_text_overlay, reg1, "@Rents from gold mine in {s0}: ", 0),
      (position_set_x, pos1, 900),
                 (position_set_y, pos1, 900),
                 (overlay_set_size, reg1, pos1),
                 (position_set_x, pos1, 25),
                 (position_set_y, pos1, ":cur_y"),
                 (overlay_set_position, reg1, pos1),
                 (party_get_slot, ":goldm_rent", ":center_no", slot_village_give_goldcoin),
             (try_begin),
                      (gt, ":goldm_rent", 0),
                      (assign, reg0, ":goldm_rent"),
                      (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
                      (overlay_set_color, reg1, 0x00AA00),
            (else_try),
                    (create_text_overlay, reg1, "@None", tf_right_align|tf_single_line),
           (try_end),
              (position_set_x, pos1, 900),
              (position_set_y, pos1, 900),
              (overlay_set_size, reg1, pos1),
              (position_set_x, pos1, 500),
              (position_set_y, pos1, ":cur_y"),
              (overlay_set_position, reg1, pos1),
              (val_sub, ":cur_y", 27),         
        (try_end),
### [OSP] Gold and Iron Mines (need more gold) ### [OSP] Gold and Iron Mines (need more gold) ### [OSP] Gold and Iron Mines (need more gold) ### 		
		
        (try_begin),
          (is_between, ":center_no", towns_begin, towns_end),
          (create_text_overlay, reg1, "str_tariffs_from_s0", 0),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 25),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (try_begin),
            (gt, ":accumulated_tariffs", 0),
            (assign, reg0, ":accumulated_tariffs"),
            (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
            (overlay_set_color, reg1, 0x00AA00),
          (else_try),
            (create_text_overlay, reg1, "@None", tf_right_align|tf_single_line),
          (try_end),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 500),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (val_sub, ":cur_y", 27),
        (try_end),
      (try_end),

      (try_begin),
        (gt, "$players_kingdom", 0),
        (neq, "$players_kingdom", "fac_player_supporters_faction"),
        (neq, "$players_kingdom", "fac_player_faction"),
        (eq, "$player_has_homage", 0),
        (str_store_faction_name, s0, "$players_kingdom"),
        (create_text_overlay, reg1, "str_mercenary_payment_from_s0", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (call_script, "script_party_calculate_strength", "p_main_party", 0),
        (assign, ":offer_value", reg0),
        (val_div, ":offer_value", 2),
        (val_add, ":offer_value", 30),
        (call_script, "script_round_value", ":offer_value"),
        (val_add, ":net_change", reg0),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (overlay_set_color, reg1, 0x00AA00),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),

      (try_begin),
        (gt, ":num_owned_center_values_for_tax_efficiency", ":num_centers_needed_for_efficiency_loss"),
        (gt, ":all_centers_accumulated_total", 0),
        (store_sub, ":ratio_lost", ":num_owned_center_values_for_tax_efficiency", ":num_centers_needed_for_efficiency_loss"),
        (val_mul, ":ratio_lost", ":tax_efficiency_loss_ratio_per_center"),
        (val_min, ":ratio_lost", 65),

        #(store_mul, ":tax_lost", ":all_centers_accumulated_total", ":ratio_lost"),
        (store_mul, ":tax_lost", ":all_centers_accumulated_taxes_and_rents", ":ratio_lost"),
        (val_div, ":tax_lost", 100),
        ##diplomacy begin
        (assign, ":percent", 0),
        (try_begin),
          (gt, "$g_player_chamberlain", 0),
          (val_add, ":percent", 10),
        (try_end),
        (try_begin),
		  ##diplomacy start+ Handle player is co-ruler of NPC kingdom
		  (try_begin),
			#Copy slot values
		    (is_between, ":alt_rule_faction", npc_kingdoms_begin, npc_kingdoms_end),
			(neg|faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_active),

			(faction_get_slot, reg0, ":alt_rule_faction", dplmc_slot_faction_serfdom),
			(faction_set_slot, "fac_player_supporters_faction", dplmc_slot_faction_serfdom,  reg0),

			(faction_get_slot, reg0, ":alt_rule_faction", dplmc_slot_faction_centralization),
			(faction_set_slot, "fac_player_supporters_faction", dplmc_slot_faction_centralization,  reg0),

			(faction_get_slot, reg0, ":alt_rule_faction", dplmc_slot_faction_quality),
			(faction_set_slot, "fac_player_supporters_faction", dplmc_slot_faction_quality,  reg0),

			(faction_get_slot, reg0, ":alt_rule_faction", dplmc_slot_faction_aristocracy),
			(faction_set_slot, "fac_player_supporters_faction", dplmc_slot_faction_aristocracy,  reg0),

			(faction_get_slot, reg0, ":alt_rule_faction", dplmc_slot_faction_mercantilism),
			(faction_set_slot, "fac_player_supporters_faction", dplmc_slot_faction_mercantilism,  reg0),
		  (try_end),

		  (this_or_next|is_between, ":alt_rule_faction", npc_kingdoms_begin, npc_kingdoms_end),
		  ##diplomacy end+
          (faction_slot_eq, "fac_player_supporters_faction", slot_faction_state, sfs_active),
          (try_begin),
            (faction_get_slot, ":centralization", "fac_player_supporters_faction", dplmc_slot_faction_centralization),
            (neq, ":centralization", 0),
            (val_mul, ":centralization", 5),
            (val_add, ":percent", ":centralization"),
          (try_end),
          (try_begin),
            (faction_get_slot, ":serfdom", "fac_player_supporters_faction", dplmc_slot_faction_serfdom),
            (neq, ":serfdom", 0),
            (val_mul, ":serfdom", 3),
            (val_add, ":percent", ":serfdom"),
          (try_end),
        (else_try),
          (gt, "$players_kingdom", 0),
          (faction_get_slot, ":centralization", "$players_kingdom", dplmc_slot_faction_centralization),
          (neq, ":centralization", 0),
          (val_mul, ":centralization", -5),
          (val_add, ":percent", ":centralization"),
        (try_end),
        (try_begin),
          (gt, ":tax_lost", 0),
          (store_mul, ":save", ":tax_lost", ":percent"),
          (val_div, ":save", 100),
          (store_mul, ":percent", ":save", 100),
          (val_div, ":percent", ":tax_lost"),
          (val_sub, ":tax_lost", ":save"),
        (try_end),
         ##diplomacy end
        (val_sub, ":net_change", ":tax_lost"),
        ##diplomacy begin
        (try_begin),
          (gt, "$g_player_chamberlain", 0),
          (str_store_string, s55, "str_loss_due_to_tax_inefficiency"),
          (assign, reg0, ":percent"),
          (val_mul, reg0, -1),
	        (str_store_string, s55, "@{s55} ({reg0}%)"),
          (create_text_overlay, reg1, "@{s55}", 0),
        (else_try),
        ##diplomacy end
          (create_text_overlay, reg1, "str_loss_due_to_tax_inefficiency", 0),
        ##diplomacy begin
        (try_end),
        ##diplomacy end
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (store_mul, reg0, ":tax_lost", -1),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (overlay_set_color, reg1, 0xFF0000),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),

      (try_for_parties, ":party_no"),
        (assign, ":garrison_troop", 0),
        (try_begin),
          (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_town),
          (party_slot_eq, ":party_no", slot_party_type, spt_castle),
          (party_slot_eq, ":party_no", slot_town_lord, "trp_player"),
          ##diplomacy begin
          (neg|party_slot_eq, ":party_no", slot_village_infested_by_bandits, "trp_peasant_woman"),
          ##diplomacy end
          (assign, ":garrison_troop", 1),
		(else_try),
          (this_or_next|party_slot_eq, ":party_no", slot_party_type, spt_town),
			(party_slot_eq, ":party_no", slot_party_type, spt_castle),
          (neg|party_slot_ge, ":party_no", slot_town_lord, 1), #unassigned
		  (store_faction_of_party, ":center_faction", ":party_no"),
		  ##diplomacy start+ Either player is co-ruler of faction, or this is fac_player_supporters_faction
		  (this_or_next|eq, ":alt_rule_faction", ":center_faction"),
		  ##diplomacy end+
		  (eq, ":center_faction", "fac_player_supporters_faction"),
		  ##diplomacy start+
		  (this_or_next|is_between, ":alt_rule_faction", npc_kingdoms_begin, npc_kingdoms_end),#Player is co-ruler of NPC faction
		  ##diplomacy end+
		  (faction_slot_eq, "fac_player_supporters_faction", slot_faction_leader, "trp_player"),
          (assign, ":garrison_troop", 1),
        (try_end),
        ##diplomacy begin
        (assign, ":patrol_troop", 0),
        (try_begin),
          (party_slot_eq, ":party_no",slot_party_type, spt_patrol),
          (party_slot_eq, ":party_no", dplmc_slot_party_mission_diplomacy, "trp_player"),
          (assign, ":patrol_troop", 1),
        (try_end),
        (this_or_next|eq, ":patrol_troop", 1),
        ##diplomacy end
        (this_or_next|eq, ":party_no", "p_main_party"),
			(eq, ":garrison_troop", 1),
        (assign, ":total_wage", 0),
        (party_get_num_companion_stacks, ":num_stacks", ":party_no"),
        (try_for_range, ":i_stack", 0, ":num_stacks"),
          (party_stack_get_troop_id, ":stack_troop", ":party_no", ":i_stack"),
          (party_stack_get_size, ":stack_size", ":party_no", ":i_stack"),
          (call_script, "script_game_get_troop_wage", ":stack_troop", ":party_no"),
          (assign, ":cur_wage", reg0),
          (val_mul, ":cur_wage", ":stack_size"),
          (val_add, ":total_wage", ":cur_wage"),
        (try_end),
        (try_begin),
          (eq, ":garrison_troop", 1),
          (val_div, ":total_wage", 2), #Half payment for garrisons
        (else_try),
          (eq, ":party_no", "p_main_party"),
          (store_sub, ":total_payment_ratio", 14, "$g_cur_week_half_daily_wage_payments"), #between 0 and 7
          (val_mul, ":total_wage", ":total_payment_ratio"),
          (val_div, ":total_wage", 14),
        (try_end),
##        (gt, ":total_wage", 0),
        (val_mul, ":total_wage", -1),
        (val_add, ":net_change", ":total_wage"),
        (str_store_party_name, s0, ":party_no"),
        (try_begin),
          (eq, ":party_no", "p_main_party"),
          (str_store_string, s0, "str_s0s_party"),
        (try_end),
        (create_text_overlay, reg1, "str_wages_for_s0", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (try_begin),
          (lt, ":total_wage", 0),
          (assign, reg0, ":total_wage"),
          (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
          (overlay_set_color, reg1, 0xFF0000),
        (else_try),
          (create_text_overlay, reg1, "@None", tf_right_align|tf_single_line),
        (try_end),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),
## Tocan  
	  #Floris Addendum / Crew Wages / Seafaring
		(assign, ":crew_wage", 0),	
		(assign, reg20, 0),
		(try_for_parties, ":party_no"),
			(party_slot_ge,":party_no", slot_ship_center, 1), #Ships are identified by 4 states, towns/player/wilderness/wilderness w/o guard
			(party_get_num_companion_stacks, ":num_stacks", ":party_no"), #Calculating Wages
			(try_for_range, ":i_stack", 0, ":num_stacks"),
				(party_stack_get_troop_id, ":stack_troop", ":party_no", ":i_stack"),
				(party_stack_get_size, ":stack_size", ":party_no", ":i_stack"),
				(call_script, "script_game_get_troop_wage", ":stack_troop", ":party_no"),
				(assign, ":cur_wage", reg0),
				(val_mul, ":cur_wage", ":stack_size"),
				(val_mul, ":cur_wage", -1),
				(val_add, ":crew_wage", ":cur_wage"),
			(try_end),
			(assign, reg20, 1),
		(try_end),
		(try_begin),
			(eq, reg20, 1),
			(assign, reg0, ":crew_wage"),
			(val_add, ":net_change", ":crew_wage"),			
			(create_text_overlay, reg1, "@Wages for your Shipcrew/s:", 0),
			(position_set_x, pos1, 900),
			(position_set_y, pos1, 900),
			(overlay_set_size, reg1, pos1),
			(position_set_x, pos1, 25),
			(position_set_y, pos1, ":cur_y"),
			(overlay_set_position, reg1, pos1),
 
			(create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line), #Display Wages
			(overlay_set_color, reg1, 0xFF0000),
			(position_set_x, pos1, 900),
			(position_set_y, pos1, 900),
			(overlay_set_size, reg1, pos1),
			(position_set_x, pos1, 500),
			(position_set_y, pos1, ":cur_y"),
			(overlay_set_position, reg1, pos1),
			(val_sub, ":cur_y", 27),
		(try_end),
 
	#Floris End
## Tocan   end
      (try_begin),
        (gt, "$g_player_debt_to_party_members", 0),
        (val_sub, ":net_change", "$g_player_debt_to_party_members"),
        (create_text_overlay, reg1, "str_earlier_debts", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (store_mul, reg0, "$g_player_debt_to_party_members", -1),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (overlay_set_color, reg1, 0xFF0000),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),
      ##diplomacy begin
      (assign, ":staff_salary", 0),
      (try_begin),
        (gt, "$g_player_minister", 0),
        (val_add, ":staff_salary", 15),
      (try_end),
      (try_begin),
        (troop_slot_ge, "trp_player", slot_troop_spouse, 0),
        (val_add, ":staff_salary", 10),
      (try_end),
      (try_begin),
        (gt, "$g_player_chamberlain", 0),
        (val_add, ":staff_salary", 15),
      (try_end),
      (try_begin),
        (gt, "$g_player_constable", 0),
        (val_add, ":staff_salary", 15),
      (try_end),
      (try_begin),
        (gt, "$g_player_chancellor", 0),
        (val_add, ":staff_salary", 20),
      (try_end),

      (try_begin),
        (gt, ":staff_salary", 0),
        (val_sub, ":net_change", ":staff_salary"),
        (create_text_overlay, reg1, "@Staff:", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (store_mul, reg0, ":staff_salary", -1),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (overlay_set_color, reg1, 0xFF0000),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),
      ##diplomacy end
      (create_mesh_overlay, reg1, "mesh_white_plane"),
      (overlay_set_color, reg1, 0x000000),
      (position_set_x, pos1, 24000),
      (position_set_y, pos1, 50),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 25),
      (store_add, ":line_y", ":cur_y", 25),
      (position_set_y, pos1, ":line_y"),
      (overlay_set_position, reg1, pos1),
      (create_text_overlay, reg1, "str_net_change", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 25),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (assign, reg0, ":net_change"),
      (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (try_begin),
        (gt, reg0, 0),
        (overlay_set_color, reg1, 0x00AA00),
      (else_try),
        (lt, reg0, 0),
        (overlay_set_color, reg1, 0xFF0000),
      (try_end),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (val_sub, ":cur_y", 27),
      (create_text_overlay, reg1, "str_earlier_wealth", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 25),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      ##diplomacy begin
      (try_begin),
        (gt, "$g_player_chamberlain", 0),
        (store_troop_gold, ":player_wealth", "trp_household_possessions"),
      (else_try),
      ##diplomacy end
      (store_troop_gold, ":player_wealth", "trp_player"),
      ##diplomacy begin
      (try_end),
      ##diplomacy end
      (assign, reg0, ":player_wealth"),
      (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (val_sub, ":cur_y", 27),
      (val_mul, ":net_change", -1),
      ##diplomacy begin
      (assign, ":cash_to_pay", 0),
      ##diplomacy end
      (try_begin),
        (ge, ":player_wealth", ":net_change"),
        (assign, ":player_wealth_dif", ":net_change"),
        (assign, ":player_new_debt_to_party_members", 0),
      (else_try),
        (assign, ":player_wealth_dif", ":player_wealth"),
        (store_sub, ":player_new_debt_to_party_members", ":net_change", ":player_wealth"),
        ##diplomacy begin
        (try_begin),
          (gt, "$g_player_chamberlain", 0),
          (store_troop_gold, ":player_inv_wealth", "trp_player"),

          (try_begin), #drawing debts from personal money
            (ge, ":player_inv_wealth", ":player_new_debt_to_party_members"),
            (assign, ":cash_to_pay", ":player_new_debt_to_party_members"),
            (assign, ":player_new_debt_to_party_members", 0),
          (else_try),
            (assign, ":cash_to_pay", ":player_inv_wealth"),
            (val_sub, ":player_new_debt_to_party_members",":player_inv_wealth"),
          (try_end),

          (try_begin),
            (eq, "$g_apply_budget_report_to_gold", 1),
            (troop_remove_gold, "trp_player", ":cash_to_pay"),
            (assign, reg0, ":cash_to_pay"),
            (display_message, "@You paid {reg0} cash to liquidate a debt"),
          (try_end),
        (try_end),
        ##diplomacy end
      (try_end),
      (create_text_overlay, reg1, "str_new_wealth", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 25),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (store_sub, reg0, ":player_wealth", ":player_wealth_dif"),
      (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg1, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, ":cur_y"),
      (overlay_set_position, reg1, pos1),
      (val_sub, ":cur_y", 27),
      ##diplomacy begin
      (try_begin),
        (gt, "$g_player_chamberlain", 0),
        (gt, ":cash_to_pay", 0),
        (create_text_overlay, reg1, "@Earlier cash:", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":player_inv_wealth"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),

        (create_text_overlay, reg1, "@New cash:", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (store_sub, reg0, ":player_inv_wealth", ":cash_to_pay"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
      (try_end),
      ##diplomacy end

      (try_begin),
        (gt, ":player_new_debt_to_party_members", 0),
        (create_text_overlay, reg1, "str_new_debts", 0),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":player_new_debt_to_party_members"),
        (create_text_overlay, reg1, "@{!}{reg0}", tf_right_align|tf_single_line),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 900),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (val_sub, ":cur_y", 27),
        (neq, "$g_apply_budget_report_to_gold", 0),
        (call_script, "script_objectionable_action", tmt_egalitarian, "str_men_unpaid"),
      (try_end),

      (set_container_overlay, -1),

      (create_button_overlay, "$g_presentation_obj_budget_report_1", "@Continue..."),
      (position_set_x, pos1, 225),
      (position_set_y, pos1, 60),
      (overlay_set_position, "$g_presentation_obj_budget_report_1", pos1),

      (try_begin),
        (eq, "$g_apply_budget_report_to_gold", 1),
        (assign, "$g_player_debt_to_party_members", ":player_new_debt_to_party_members"),
        (try_begin),
          (gt, ":player_wealth_dif", 0),
          ##diplomacy begin
          (try_begin),
            (gt, "$g_player_chamberlain", 0),
            (call_script, "script_dplmc_withdraw_from_treasury", ":player_wealth_dif"),
          (else_try),
          ##diplomacy end
          (troop_remove_gold, "trp_player", ":player_wealth_dif"),
          ##diplomacy begin
          (try_end),
          ##diplomacy end
        (else_try),
          (val_mul, ":player_wealth_dif", -1),
          ##diplomacy begin
          (try_begin),
            (gt, "$g_player_chamberlain", 0),
            (call_script, "script_dplmc_pay_into_treasury", ":player_wealth_dif"),
          (else_try),
          ##diplomacy end
          (troop_add_gold, "trp_player", ":player_wealth_dif"),
          ##diplomacy begin
          (try_end),
          ##diplomacy end
        (try_end),
        (try_for_range, ":center_no", centers_begin, centers_end),
          (party_slot_eq, ":center_no", slot_town_lord, "trp_player"),
          (party_set_slot, ":center_no", slot_center_accumulated_rents, 0),
          (party_set_slot, ":center_no", slot_center_accumulated_tariffs, 0),
        (try_end),
        (assign, "$g_cur_week_half_daily_wage_payments", 0),#Reseting the weekly half wage payments
      (try_end),
      ]),
    (ti_on_presentation_event_state_change,
     [(store_trigger_param_1, ":object"),
      (try_begin),
        (eq, ":object", "$g_presentation_obj_budget_report_1"),
        (presentation_set_duration, 0),
      (try_end),
      ]),
    ]),

  ("game_before_quit", 0, mesh_load_window,
   [
     (ti_on_presentation_load,
      [
        (try_begin),
          (is_trial_version),
          (set_fixed_point_multiplier, 1000),
          (create_mesh_overlay, reg0, "mesh_quit_adv"),
          (position_set_x, pos1, -1),
          (position_set_y, pos1, -1),
          (overlay_set_position, reg0, pos1),
          (position_set_x, pos1, 1002),
          (position_set_y, pos1, 1002),
          (overlay_set_size, reg0, pos1),
          (assign, "$g_game_before_quit_state", 0),
          (presentation_set_duration, 999999),
        (try_end),
      ]),
     (ti_on_presentation_run,
       [
        (store_trigger_param_1, ":cur_time"),
        (gt, ":cur_time", 500),
        (try_begin),
          (this_or_next|key_clicked, key_space),
          (this_or_next|key_clicked, key_enter),
          (this_or_next|key_clicked, key_escape),
          (this_or_next|key_clicked, key_back_space),
          (this_or_next|key_clicked, key_left_mouse_button),
          (this_or_next|key_clicked, key_right_mouse_button),
          (this_or_next|key_clicked, key_xbox_ltrigger),
          (key_clicked, key_xbox_rtrigger),
          (try_begin),
            (eq, "$g_game_before_quit_state", 0),
            (val_add, "$g_game_before_quit_state", 1),
            (create_mesh_overlay, reg0, "mesh_quit_adv_b"),
            (position_set_x, pos1, -1),
            (position_set_y, pos1, -1),
            (overlay_set_position, reg0, pos1),
            (position_set_x, pos1, 1002),
            (position_set_y, pos1, 1002),
            (overlay_set_size, reg0, pos1),
          (else_try),
            (presentation_set_duration, 0),
          (try_end),
        (try_end),
        ]),
     ]),
	 
# Helmet View
  ("helmet_view", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),
      
	  # 
	  (try_begin),
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm1"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm2"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_golden1"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_golden2"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_golden3"), # 	
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_ord"), # 		
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_ord_white"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_ord_black"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_ord_red"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_teu"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_teu1"), # 	
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_tem"), # 	
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_tem1"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_red"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_red1"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_black"), # 	
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_black1"), # 	
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_hos"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_hos1"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_jer"), # 
		(this_or_next|troop_has_item_equipped, "trp_player", "itm_helm_jer1"), # 		
		(troop_has_item_equipped, "trp_player", "itm_helm_jer2"), #
        (create_mesh_overlay, reg0, "mesh_helmet_inside"),	
#	  (else_try),
#        (create_mesh_overlay, reg0, "mesh_helmet_invisible"),	# 
	  (try_end),
      
      (position_set_x, pos1, 0), # 
      (position_set_y, pos1, 0),
      (overlay_set_position, reg0, pos1),
      (position_set_x, pos2, 1020), # 
      (position_set_y, pos2, 768), # 
      (overlay_set_size, reg0, pos2), # 
      
      (presentation_set_duration, 999999),
      ]),
    
    ]),	 

  ("multiplayer_duel_start_counter", prsntf_read_only|prsntf_manual_end_only, 0, [
    (ti_on_presentation_load, [
      (set_fixed_point_multiplier, 1000),

      (assign, "$g_multiplayer_duel_start_counter_overlay", -1),
      (assign, "$g_multiplayer_last_duel_start_counter_value", -1),

      (str_clear, s0),
      (create_text_overlay, "$g_multiplayer_duel_start_counter_overlay", s0, tf_center_justify|tf_with_outline),
      (overlay_set_color, "$g_multiplayer_duel_start_counter_overlay", 0xFFFFFF),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 600),
      (overlay_set_position, "$g_multiplayer_duel_start_counter_overlay", pos1),
      (position_set_x, pos1, 2000),
      (position_set_y, pos1, 2000),
      (overlay_set_size, "$g_multiplayer_duel_start_counter_overlay", pos1),

      (presentation_set_duration, 999999),
      ]),

    (ti_on_presentation_run, [
      (ge, "$g_multiplayer_duel_start_counter_overlay", 0),
      (store_mission_timer_a, ":current_time"),
      (store_sub, ":seconds_past_in_duel_start", ":current_time", "$g_multiplayer_duel_start_time"),
      (store_sub, ":seconds_left_in_duel_start", 3, ":seconds_past_in_duel_start"),
      (try_begin),
        (le, ":seconds_left_in_duel_start", 0),
        (presentation_set_duration, 0),
      (else_try),
        (neq, "$g_multiplayer_last_duel_start_counter_value", ":seconds_left_in_duel_start"),
        (assign, "$g_multiplayer_last_duel_start_counter_value", ":seconds_left_in_duel_start"),
        (assign, reg0, ":seconds_left_in_duel_start"),
        (str_store_string, s0, "str_duel_starts_in_reg0_seconds"),
        (overlay_set_text, "$g_multiplayer_duel_start_counter_overlay", s0),
      (try_end),
      ]),
    ]),
	
# Lav modifications start (custom lord notes)
    ("custom_lord_notes", prsntf_manual_end_only, 0,
        [
            (ti_on_presentation_load, [
                (call_script, "script_lco_create_container", 200, 275, 600, 201, 1),
                (call_script, "script_lco_create_mesh", "mesh_mp_ui_welcome_panel", 0, 0, 1000, 1000),
                (call_script, "script_lco_create_troop_portrait", "$g_cln_troop", 410, 12, 520, 520),
                (str_store_troop_name, s41, "$g_cln_troop"),
                (call_script, "script_lco_create_label", "str_s41", 300, 163, 1000, tf_center_justify),
                (overlay_set_color, reg0, 0x00FFFFFF),
                (call_script, "script_lco_create_label", "str_lcn_prompt", 25, 37, 750, 0),
                (overlay_set_color, reg0, 0x00FFFFFF),
                (store_troop_faction, ":faction", "$g_cln_troop"),
                (str_store_faction_name, s41, ":faction"),
                (call_script, "script_lco_create_label", "str_lcn_faction", 25, 137, 750, 0),
                (overlay_set_color, reg0, 0x00FFFFFF),
                (troop_get_slot, reg60, "$g_cln_troop", slot_troop_renown),
                (troop_get_slot, reg61, "$g_cln_troop", slot_troop_controversy),
                (call_script, "script_lco_create_label", "str_lcn_stats", 25, 112, 750, 0),
                (overlay_set_color, reg0, 0x00FFFFFF),
                (call_script, "script_lco_create_textbox", 25, 12, 400, 800),
                (assign, "$g_cln_edit", reg0),
                (overlay_obtain_focus, reg0),
                (set_container_overlay, -1),
                (presentation_set_duration, 999999),
            ]),
            (ti_on_presentation_event_state_change, [
                (store_trigger_param_1, ":overlay"),
                (store_trigger_param_2, ":value"),
                (try_begin),
                    (eq, ":overlay", "$g_cln_edit"),
                    (try_begin),
                        (neq, ":value", 0),
                        (add_troop_note_from_sreg, "$g_cln_troop", 15, "str_s0", 0),
                        (display_message, "@{!}Custom note added."),
                    (try_end),
                    (presentation_set_duration, 0),
                (try_end),
            ]),
        ]
    ),
# Lav modifications end (custom lord notes)	


## CC
  ("autoloot_upgrade_management", 0, mesh_load_window, [
    (ti_on_presentation_load,
     [
      (set_fixed_point_multiplier, 1000),
      (presentation_set_duration, 999999),

      # done
      (create_game_button_overlay, "$g_presentation_obj_10", "@Done"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 25),
      (overlay_set_position, "$g_presentation_obj_10", pos1),

      ## current hero
      # character picture
      (create_mesh_overlay_with_tableau_material, reg0, -1, "tableau_troop_note_mesh", "$temp"),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 125),
      (position_set_y, pos1, 560),
      (overlay_set_position, reg0, pos1),

      (str_store_troop_name, s1, "$temp"),
      (store_character_level, ":troop_level", "$temp"),
      (assign, reg1, ":troop_level"),
      (str_store_string, s1, "@Name: {s1}^Level: {reg1}"),

      (store_troop_health, ":cur_hp", "$temp", 1),
      (call_script, "script_get_troop_max_hp", "$temp"),
      (assign, reg1, ":cur_hp"),
      (assign, reg2, reg0),
      (str_store_string, s1, "@{s1}^HP: {reg1}/{reg2}"),

      (create_text_overlay, reg1, "@{s1}", tf_double_space),
      (position_set_x, pos1, 305),
      (position_set_y, pos1, 560),
      (overlay_set_position, reg1, pos1),

      # title
      (create_text_overlay, reg1, "@Weapon upgrade settings:", tf_center_justify|tf_vertical_align_center),
      (position_set_x, pos1, 610),
      (position_set_y, pos1, 680),
      (overlay_set_position, reg1, pos1),

      # init trp_temp_array_c 
      (assign, ":sub_overlay_id", 0),
      (try_for_range_backwards, ":item_type", 0, itp_type_animal),
        (this_or_next|is_between, ":item_type", itp_type_one_handed_wpn, itp_type_goods),
        (this_or_next|is_between, ":item_type", itp_type_pistol, itp_type_animal),
        (eq, ":item_type", 0),
        (troop_set_slot, "trp_temp_array_c", ":sub_overlay_id", ":item_type"),
        (val_add, ":sub_overlay_id", 1),
      (try_end),
      
      (position_set_x, pos1, 610),
      (position_set_y, pos1, 630),
      (create_combo_button_overlay, "$g_presentation_obj_1"),
      (overlay_set_position, "$g_presentation_obj_1", pos1),
      (assign, ":sub_overlay_id", 0),
      (call_script, "script_get_current_item_for_autoloot", 0),
      (try_for_range_backwards, ":item_type", 0, itp_type_animal),
        (this_or_next|is_between, ":item_type", itp_type_one_handed_wpn, itp_type_goods),
        (this_or_next|is_between, ":item_type", itp_type_pistol, itp_type_animal),
        (eq, ":item_type", 0),
        (store_add, ":out_string", "str_hero_wpn_slot_none", ":item_type"),
        (str_store_string, s0, ":out_string"),
        (overlay_add_item, "$g_presentation_obj_1", s0),
        (try_begin),
          (troop_slot_eq, "$temp", slot_upgrade_wpn_0, ":item_type"),
          (overlay_set_val, "$g_presentation_obj_1", ":sub_overlay_id"),
        (try_end),
        (val_add, ":sub_overlay_id", 1),
      (try_end),
 
      (position_set_y, pos1, 600),
      (create_combo_button_overlay, "$g_presentation_obj_2"),
      (overlay_set_position, "$g_presentation_obj_2", pos1),
      (assign, ":sub_overlay_id", 0),
      (call_script, "script_get_current_item_for_autoloot", 1),
      (try_for_range_backwards, ":item_type", 0, itp_type_animal),
        (this_or_next|is_between, ":item_type", itp_type_one_handed_wpn, itp_type_goods),
        (this_or_next|is_between, ":item_type", itp_type_pistol, itp_type_animal),
        (eq, ":item_type", 0),
        (store_add, ":out_string", "str_hero_wpn_slot_none", ":item_type"),
        (str_store_string, s0, ":out_string"),
        (overlay_add_item, "$g_presentation_obj_2", s0),
        (try_begin),
          (troop_slot_eq, "$temp", slot_upgrade_wpn_1, ":item_type"),
          (overlay_set_val, "$g_presentation_obj_2", ":sub_overlay_id"),
        (try_end),
        (val_add, ":sub_overlay_id", 1),
      (try_end),
      
      (position_set_y, pos1, 570),
      (create_combo_button_overlay, "$g_presentation_obj_3"),
      (overlay_set_position, "$g_presentation_obj_3", pos1),
      (assign, ":sub_overlay_id", 0),
      (call_script, "script_get_current_item_for_autoloot", 2),
      (try_for_range_backwards, ":item_type", 0, itp_type_animal),
        (this_or_next|is_between, ":item_type", itp_type_one_handed_wpn, itp_type_goods),
        (this_or_next|is_between, ":item_type", itp_type_pistol, itp_type_animal),
        (eq, ":item_type", 0),
        (store_add, ":out_string", "str_hero_wpn_slot_none", ":item_type"),
        (str_store_string, s0, ":out_string"),
        (overlay_add_item, "$g_presentation_obj_3", s0),
        (try_begin),
          (troop_slot_eq, "$temp", slot_upgrade_wpn_2, ":item_type"),
          (overlay_set_val, "$g_presentation_obj_3", ":sub_overlay_id"),
        (try_end),
        (val_add, ":sub_overlay_id", 1),
      (try_end),
      
      (position_set_y, pos1, 540),
      (create_combo_button_overlay, "$g_presentation_obj_4"),
      (overlay_set_position, "$g_presentation_obj_4", pos1),
      (assign, ":sub_overlay_id", 0),
      (call_script, "script_get_current_item_for_autoloot", 3),
      (try_for_range_backwards, ":item_type", 0, itp_type_animal),
        (this_or_next|is_between, ":item_type", itp_type_one_handed_wpn, itp_type_goods),
        (this_or_next|is_between, ":item_type", itp_type_pistol, itp_type_animal),
        (eq, ":item_type", 0),
        (store_add, ":out_string", "str_hero_wpn_slot_none", ":item_type"),
        (str_store_string, s0, ":out_string"),
        (overlay_add_item, "$g_presentation_obj_4", s0),
        (try_begin),
          (troop_slot_eq, "$temp", slot_upgrade_wpn_3, ":item_type"),
          (overlay_set_val, "$g_presentation_obj_4", ":sub_overlay_id"),
        (try_end),
        (val_add, ":sub_overlay_id", 1),
      (try_end),
      
      (position_set_x, pos1, 1000),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_1", pos1),
      (overlay_set_size, "$g_presentation_obj_2", pos1),
      (overlay_set_size, "$g_presentation_obj_3", pos1),
      (overlay_set_size, "$g_presentation_obj_4", pos1),
      # set 1: apply to all
      (create_in_game_button_overlay, "$g_presentation_obj_11", "@Apply to everyone"),
      (position_set_x, pos1, 610),
      (position_set_y, pos1, 480),
      (overlay_set_position, "$g_presentation_obj_11", pos1),
      (overlay_set_color, "$g_presentation_obj_11", 0xFFFFFF),
      (create_in_game_button_overlay, "$g_presentation_obj_23", "@Apply to whom selected"),
      (position_set_x, pos1, 610),
      (position_set_y, pos1, 435),
      (overlay_set_position, "$g_presentation_obj_23", pos1),
      (overlay_set_color, "$g_presentation_obj_23", 0xFFFFFF),
      
      # upgrade armor and horse
      # text
      (create_text_overlay, reg1, "@Upgrade armor ", tf_vertical_align_center),
      (position_set_x, pos1, 565),
      (position_set_y, pos1, 380),
      (overlay_set_position, reg1, pos1),
      (position_set_x, pos1, 565),
      (position_set_y, pos1, 220),
      (create_text_overlay, reg1, "@Upgrade horse ", tf_vertical_align_center),
      (overlay_set_position, reg1, pos1),
      # checkbox
      (create_check_box_overlay, "$g_presentation_obj_13", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 545),
      (position_set_y, pos1, 373),
      (overlay_set_position, "$g_presentation_obj_13", pos1),
      (troop_get_slot,":upg_armor", "$temp",slot_upgrade_armor),
      (overlay_set_val, "$g_presentation_obj_13", ":upg_armor"),
      (create_check_box_overlay, "$g_presentation_obj_14", "mesh_checkbox_off", "mesh_checkbox_on"),
      (position_set_x, pos1, 545),
      (position_set_y, pos1, 213),
      (overlay_set_position, "$g_presentation_obj_14", pos1),
      (troop_get_slot,":upg_horse", "$temp",slot_upgrade_horse),
      (overlay_set_val, "$g_presentation_obj_14", ":upg_horse"),
      # long button
      (position_set_x, pos1, 610),
      (create_in_game_button_overlay, "$g_presentation_obj_15", "@Apply to everyone"),
      (position_set_y, pos1, 320),
      (overlay_set_position, "$g_presentation_obj_15", pos1),
      (overlay_set_color, "$g_presentation_obj_15", 0xFFFFFF),
      (create_in_game_button_overlay, "$g_presentation_obj_24", "@Apply to whom selected"),
      (position_set_y, pos1, 275),
      (overlay_set_position, "$g_presentation_obj_24", pos1),
      (overlay_set_color, "$g_presentation_obj_24", 0xFFFFFF),
      
      (position_set_x, pos1, 610),
      (create_in_game_button_overlay, "$g_presentation_obj_16", "@Apply to everyone"),
      (position_set_y, pos1, 160),
      (overlay_set_position, "$g_presentation_obj_16", pos1),
      (overlay_set_color, "$g_presentation_obj_16", 0xFFFFFF),
      (create_in_game_button_overlay, "$g_presentation_obj_25", "@Apply to whom selected"),
      (position_set_y, pos1, 115),
      (overlay_set_position, "$g_presentation_obj_25", pos1),
      (overlay_set_color, "$g_presentation_obj_25", 0xFFFFFF),
      
      # price_threshold_for_picking
      (position_set_x, pos1, 175),
      (position_set_y, pos1, 65),
      (create_text_overlay, reg1, "@Price threshold of items for picking:", tf_vertical_align_center),
      (overlay_set_position, reg1, pos1),
      
      (create_number_box_overlay, "$g_presentation_obj_9", 0, 1001),
      (position_set_x, pos1, 600),
      (position_set_y, pos1, 50),
      (overlay_set_position, "$g_presentation_obj_9", pos1),
      (overlay_set_val, "$g_presentation_obj_9", "$g_price_threshold_for_picking"),
      
      # lines
      (call_script, "script_prsnt_lines", 310, 2, 455, 415, 0),
      (call_script, "script_prsnt_lines", 310, 2, 455, 255, 0),
      (call_script, "script_prsnt_lines", 640, 2, 125, 95, 0),
      
      ## cur_hero equipments
      # set_container
      (str_clear, s0),
      (create_text_overlay, reg1, s0, tf_scrollable),
      (position_set_x, pos1, 170),
      (position_set_y, pos1, 135),
      (overlay_set_position, reg1, pos1),
      (position_set_x, pos1, 280),
      (position_set_y, pos1, 380),
      (overlay_set_area_size, reg1, pos1),
      (set_container_overlay, reg1), # begin
      
      (create_text_overlay, reg1, "@Arms", tf_center_justify),
      (position_set_x, pos1, 220),
      (position_set_y, pos1, 350),
      (overlay_set_position, reg1, pos1),
      (create_text_overlay, reg1, "@Outfit", tf_center_justify),
      (position_set_x, pos1, 80),
      (position_set_y, pos1, 350),
      (overlay_set_position, reg1, pos1),
      (create_text_overlay, reg1, "@Horse", tf_center_justify),
      (position_set_x, pos1, 40),
      (position_set_y, pos1, 90),
      (overlay_set_position, reg1, pos1),
      
      (assign, "$g_current_opened_item_details", -1),
      
      (assign, ":trp_obj_id", "trp_bonus_chest_1"), # array to record obj's id
      (assign, ":trp_obj_x", "trp_bonus_chest_2"),  # array to record obj's x
      (assign, ":trp_obj_y", "trp_bonus_chest_3"),  # array to record obj's y
      (assign, ":trp_obj_bg", "trp_zendar_chest"),  # array to record obj's background
      # weapons
      (troop_set_slot, ":trp_obj_x", 0, 180),
      (troop_set_slot, ":trp_obj_y", 0, 260),
      (troop_set_slot, ":trp_obj_x", 1, 180),
      (troop_set_slot, ":trp_obj_y", 1, 180),
      (troop_set_slot, ":trp_obj_x", 2, 180),
      (troop_set_slot, ":trp_obj_y", 2, 100),
      (troop_set_slot, ":trp_obj_x", 3, 180),
      (troop_set_slot, ":trp_obj_y", 3, 20),
      # armors
      (troop_set_slot, ":trp_obj_x", 4, 80),
      (troop_set_slot, ":trp_obj_y", 4, 260),
      (troop_set_slot, ":trp_obj_x", 5, 80),
      (troop_set_slot, ":trp_obj_y", 5, 180),
      (troop_set_slot, ":trp_obj_x", 6, 80),
      (troop_set_slot, ":trp_obj_y", 6, 100),
      (troop_set_slot, ":trp_obj_x", 7, 0),
      (troop_set_slot, ":trp_obj_y", 7, 180),
      # horse
      (troop_set_slot, ":trp_obj_x", 8, 0),
      (troop_set_slot, ":trp_obj_y", 8, 0),
      
      # background
      (troop_set_slot, ":trp_obj_bg", 0, "mesh_mp_inventory_slot_equip"),
      (troop_set_slot, ":trp_obj_bg", 1, "mesh_mp_inventory_slot_equip"),
      (troop_set_slot, ":trp_obj_bg", 2, "mesh_mp_inventory_slot_equip"),
      (troop_set_slot, ":trp_obj_bg", 3, "mesh_mp_inventory_slot_equip"),
      (troop_set_slot, ":trp_obj_bg", 4, "mesh_mp_inventory_slot_helmet"),
      (troop_set_slot, ":trp_obj_bg", 5, "mesh_mp_inventory_slot_armor"),
      (troop_set_slot, ":trp_obj_bg", 6, "mesh_mp_inventory_slot_boot"),
      (troop_set_slot, ":trp_obj_bg", 7, "mesh_mp_inventory_slot_glove"),
      (troop_set_slot, ":trp_obj_bg", 8, "mesh_mp_inventory_slot_horse"),
      
      # obj size
      (position_set_x, pos3, 640),
      (position_set_y, pos3, 640),
      
      (try_for_range, ":item_slot", 0, 9),
        (troop_get_inventory_slot, ":cur_item", "$temp", ":item_slot"),
      
        (troop_get_slot, ":pos_x", ":trp_obj_x", ":item_slot"),
        (troop_get_slot, ":pos_y", ":trp_obj_y", ":item_slot"),
        (troop_get_slot, ":bg_mesh", ":trp_obj_bg", ":item_slot"),
        
        (create_mesh_overlay, reg1, "mesh_mp_inventory_choose"),
        (overlay_set_size, reg1, pos3),
        (position_set_x, pos1, ":pos_x"),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg1, pos1),

        ## item
        (try_begin),
          (gt, ":cur_item", -1),
          # empty background
          (create_mesh_overlay, reg1, "mesh_mp_inventory_slot_empty"),
          (overlay_set_size, reg1, pos3),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),
          # item mesh
          (create_mesh_overlay_with_item_id, reg1, ":cur_item"),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg1, pos1),
          (store_add, ":item_x", ":pos_x", 40),
          (store_add, ":item_y", ":pos_y", 40),
          (position_set_x, pos1, ":item_x"),
          (position_set_y, pos1, ":item_y"),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, ":trp_obj_id", ":item_slot", reg1),
        (else_try),
          # default bg_mesh
          (create_mesh_overlay, reg1, ":bg_mesh"),
          (overlay_set_size, reg1, pos3),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, ":trp_obj_id", ":item_slot", -1),
        (try_end),
      (try_end),
      (set_container_overlay, -1), # end

      # hero list
      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_6", s0, tf_scrollable),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 150),
      (overlay_set_position, "$g_presentation_obj_6", pos1),
      (position_set_x, pos1, 150),
      (position_set_y, pos1, 400),
      (overlay_set_area_size, "$g_presentation_obj_6", pos1),
      (set_container_overlay, "$g_presentation_obj_6"),

      (assign, ":num_of_heros", 0),
      (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
      (try_for_range, ":i_stack", 0, ":num_stacks"),
        (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
        (is_between, ":stack_troop", companions_begin, companions_end),
        (val_add, ":num_of_heros", 1),
      (try_end),
      (try_begin),
        (le, ":num_of_heros", 10),
        (assign, ":pos_y", 400),
      (else_try),
        (store_mul, ":pos_y", ":num_of_heros", 40),
      (try_end),
      (val_sub, ":pos_y", 40),
      (assign, ":pos_x", 50),
      (assign, ":num_of_heros", 0),
      (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
      (try_for_range, ":i_stack", 0, ":num_stacks"),
        (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
        (is_between, ":stack_troop", companions_begin, companions_end),
        (assign, ":trp_slot_prsnt_no", ":num_of_heros"),
        (str_store_troop_name, s1, ":stack_troop"),
        (create_button_overlay, reg0, "@{s1}", tf_center_justify),
        (position_set_x, pos1, ":pos_x"),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (troop_set_slot, "trp_temp_array_a", ":trp_slot_prsnt_no", reg0),
        
        (create_check_box_overlay, reg0, "mesh_checkbox_off", "mesh_checkbox_on"),
        (store_add, ":pos_x_1", ":pos_x", 75),
        (store_add, ":pos_y_1", ":pos_y", 5),
        (position_set_x, pos1, ":pos_x_1"),
        (position_set_y, pos1, ":pos_y_1"),
        (overlay_set_position, reg0, pos1),
        (troop_set_slot, "trp_stack_selection_ids", ":trp_slot_prsnt_no", reg0), ## record checkbox obj
        (troop_set_slot, "trp_stack_selection_amounts", ":trp_slot_prsnt_no", 0), ## record checkbox value
        (overlay_set_val, reg0, 0),
        
        (troop_set_slot, "trp_temp_array_b", ":trp_slot_prsnt_no", ":stack_troop"),
        (val_sub, ":pos_y", 40),
        (val_add, ":num_of_heros", 1),
      (try_end),

      (set_container_overlay, -1),
      ####### mouse fix pos system #######
      #(call_script, "script_mouse_fix_pos_ready"),
      ####### mouse fix pos system #######
     ]),

    #(ti_on_presentation_run,
      #[
      ####### mouse fix pos system #######
      #(call_script, "script_mouse_fix_pos_run"),
      ####### mouse fix pos system #######
    #]),

    (ti_on_presentation_mouse_enter_leave,
      [
      (store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":enter_leave"),

      (assign, ":trp_obj_id", "trp_bonus_chest_1"), # array to record obj's id
      (try_begin),
        (eq, ":enter_leave", 0),
        (try_for_range, ":item_slot", 0, 9),
          (troop_slot_eq, ":trp_obj_id", ":item_slot", ":object"),
          (overlay_get_position, pos0, ":object"),
          (troop_get_inventory_slot, ":cur_item", "$temp", ":item_slot"),
          (troop_get_inventory_slot_modifier, ":cur_imod", "$temp", ":item_slot"),
          (try_begin),
            (gt, ":cur_imod", 0),
            (show_item_details_with_modifier, ":cur_item", ":cur_imod", pos0, 100),
          (else_try),
            (show_item_details, ":cur_item", pos0, 100),
          (try_end),
          (assign, "$g_current_opened_item_details", ":item_slot"),
        (try_end),
      (else_try),
        (try_for_range, ":item_slot", 0, 9),
          (troop_slot_eq, ":trp_obj_id", ":item_slot", ":object"),
          (try_begin),
            (eq, "$g_current_opened_item_details", ":item_slot"),
            (close_item_details),
          (try_end),
        (try_end),
      (try_end),
    ]),

    (ti_on_presentation_event_state_change,
     [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (troop_get_slot, ":item_type", "trp_temp_array_c", ":value"),
          (troop_set_slot, "$temp", slot_upgrade_wpn_0, ":item_type"),
          (start_presentation, "prsnt_autoloot_upgrade_management"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (troop_get_slot, ":item_type", "trp_temp_array_c", ":value"),
          (troop_set_slot, "$temp", slot_upgrade_wpn_1, ":item_type"),
          (start_presentation, "prsnt_autoloot_upgrade_management"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"),
          (troop_get_slot, ":item_type", "trp_temp_array_c", ":value"),
          (troop_set_slot, "$temp", slot_upgrade_wpn_2, ":item_type"),
          (start_presentation, "prsnt_autoloot_upgrade_management"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_4"),
          (troop_get_slot, ":item_type", "trp_temp_array_c", ":value"),
          (troop_set_slot, "$temp", slot_upgrade_wpn_3, ":item_type"),
          (start_presentation, "prsnt_autoloot_upgrade_management"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_9"),
          (assign, "$g_price_threshold_for_picking", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_10"),
          (presentation_set_duration, 0),
        (else_try),
          (eq, ":object", "$g_presentation_obj_11"),
          (call_script, "script_copy_upgrade_to_all_heroes", "$temp", wpn_setting),
        (else_try),
          (eq, ":object", "$g_presentation_obj_13"),
          (troop_set_slot, "$temp", slot_upgrade_armor, ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_14"),
          (troop_set_slot, "$temp", slot_upgrade_horse, ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_15"),
          (call_script, "script_copy_upgrade_to_all_heroes", "$temp", armor_setting),
        (else_try),
          (eq, ":object", "$g_presentation_obj_16"),
          (call_script, "script_copy_upgrade_to_all_heroes", "$temp", horse_setting),
        (else_try),
          (eq, ":object", "$g_presentation_obj_23"),
          (assign, ":num_of_heros", 0),
          (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
          (try_for_range, ":i_stack", 0, ":num_stacks"),
            (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
            (is_between, ":stack_troop", companions_begin, companions_end),
            (val_add, ":num_of_heros", 1),
          (try_end),
          (try_for_range, ":slot_no", 0, ":num_of_heros"),
            (troop_get_slot, ":cur_troop", "trp_temp_array_b", ":slot_no"),
            (troop_get_slot, ":value", "trp_stack_selection_amounts", ":slot_no"),
            (eq, ":value", 1),
            (troop_get_slot,":upg_wpn0", "$temp",slot_upgrade_wpn_0),
            (troop_get_slot,":upg_wpn1", "$temp",slot_upgrade_wpn_1),
            (troop_get_slot,":upg_wpn2", "$temp",slot_upgrade_wpn_2),
            (troop_get_slot,":upg_wpn3", "$temp",slot_upgrade_wpn_3),
            (troop_set_slot,":cur_troop",slot_upgrade_wpn_0,":upg_wpn0"),
            (troop_set_slot,":cur_troop",slot_upgrade_wpn_1,":upg_wpn1"),
            (troop_set_slot,":cur_troop",slot_upgrade_wpn_2,":upg_wpn2"),
            (troop_set_slot,":cur_troop",slot_upgrade_wpn_3,":upg_wpn3"),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_24"),
          (assign, ":num_of_heros", 0),
          (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
          (try_for_range, ":i_stack", 0, ":num_stacks"),
            (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
            (is_between, ":stack_troop", companions_begin, companions_end),
            (val_add, ":num_of_heros", 1),
          (try_end),
          (try_for_range, ":slot_no", 0, ":num_of_heros"),
            (troop_get_slot, ":cur_troop", "trp_temp_array_b", ":slot_no"),
            (troop_get_slot, ":value", "trp_stack_selection_amounts", ":slot_no"),
            (eq, ":value", 1),
            (troop_get_slot,":upg_armor", "$temp",slot_upgrade_armor),
            (troop_set_slot,":cur_troop",slot_upgrade_armor,":upg_armor"),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_25"),
          (assign, ":num_of_heros", 0),
          (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
          (try_for_range, ":i_stack", 0, ":num_stacks"),
            (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
            (is_between, ":stack_troop", companions_begin, companions_end),
            (val_add, ":num_of_heros", 1),
          (try_end),
          (try_for_range, ":slot_no", 0, ":num_of_heros"),
            (troop_get_slot, ":cur_troop", "trp_temp_array_b", ":slot_no"),
            (troop_get_slot, ":value", "trp_stack_selection_amounts", ":slot_no"),
            (eq, ":value", 1),
            (troop_get_slot,":upg_horse", "$temp",slot_upgrade_horse),
            (troop_set_slot,":cur_troop",slot_upgrade_horse,":upg_horse"),
          (try_end),
        (try_end),

        (assign, ":num_of_heros", 0),
        (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
        (try_for_range, ":i_stack", 0, ":num_stacks"),
          (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
          (is_between, ":stack_troop", companions_begin, companions_end),
          (assign, ":trp_slot_prsnt_no", ":num_of_heros"),
          (val_add, ":num_of_heros", 1),
          (try_begin),
            (troop_slot_eq, "trp_stack_selection_ids", ":trp_slot_prsnt_no", ":object"),
            (troop_set_slot, "trp_stack_selection_amounts", ":trp_slot_prsnt_no", ":value"),
          (else_try),
            (troop_slot_eq, "trp_temp_array_a", ":trp_slot_prsnt_no", ":object"),
            (troop_get_slot, ":cur_troop", "trp_temp_array_b", ":trp_slot_prsnt_no"),
            (assign, "$temp", ":cur_troop"),
            (start_presentation, "prsnt_autoloot_upgrade_management"),
          (try_end),
        (try_end),
    ]),
  ]),

  ("auto_sell_options", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        ## do auto-sell automaticly when leaving
        (create_text_overlay, reg0, "@Sell items automaticly when leaving:", tf_vertical_align_center),
        (position_set_x, pos1, 170),
        (position_set_y, pos1, 660),
        (overlay_set_position, reg0, pos1),

        (create_check_box_overlay, "$g_presentation_obj_1", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 150),
        (position_set_y, pos1, 652),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (overlay_set_val, "$g_presentation_obj_1", "$g_sell_items_when_leaving"),

        ## price_limit
        (create_text_overlay, reg0, "@Price limit for auto-sell:", tf_vertical_align_center),
        (position_set_x, pos1, 150),
        (position_set_y, pos1, 610),
        (overlay_set_position, reg0, pos1),

        (create_number_box_overlay, "$g_presentation_obj_2", 10, 10000),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 596),
        (overlay_set_val, "$g_presentation_obj_2", "$g_auto_sell_price_limit"),
        (overlay_set_position, "$g_presentation_obj_2", pos1),

        # done
        (create_game_button_overlay, "$g_presentation_obj_3", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_3", pos1),

        ## Item types
        (create_text_overlay, reg0, "@Item types for auto-sell:", tf_vertical_align_center),
        (position_set_x, pos1, 150),
        (position_set_y, pos1, 578),
        (overlay_set_position, reg0, pos1),

        # select all
        (create_image_button_overlay, "$g_presentation_obj_5", "mesh_drop_button_child", "mesh_drop_button_child_down"),
        (position_set_x, pos1, 160),
        (position_set_y, pos1, 528),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
        (create_text_overlay, reg1, "@Select all", tf_center_justify|tf_vertical_align_center),
        (position_set_x, pos1, 265),
        (position_set_y, pos1, 538),
        (overlay_set_position, reg1, pos1),

        # select invert
        (create_image_button_overlay, "$g_presentation_obj_6", "mesh_drop_button_child", "mesh_drop_button_child_down"),
        (position_set_x, pos1, 385),
        (position_set_y, pos1, 528),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (create_text_overlay, reg1, "@Select invert", tf_center_justify|tf_vertical_align_center),
        (position_set_x, pos1, 490),
        (position_set_y, pos1, 538),
        (overlay_set_position, reg1, pos1),

        (assign, ":pos_x", 160),
        (assign, ":pos_y", 500),
        (try_for_range, ":cur_type", 0, 20),
          (store_add, ":cur_item_type", itp_type_horse, ":cur_type"),
          (neq, ":cur_item_type", itp_type_goods),
          (neq, ":cur_item_type", itp_type_animal),
          (neq, ":cur_item_type", itp_type_book),
          # button
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (create_mesh_overlay, reg1, "mesh_drop_button_child"),
          (overlay_set_position, reg1, pos1),
          # text
          (store_add, ":text_pos_x", ":pos_x", 120),
          (store_add, ":text_pos_y", ":pos_y", 10),
          (position_set_x, pos1, ":text_pos_x"),
          (position_set_y, pos1, ":text_pos_y"),
          (store_add, ":out_string", "str_hero_wpn_slot_horse", ":cur_type"),
          (str_store_string, s1, ":out_string"),
          (create_text_overlay, reg1, "@{s1}", tf_center_justify|tf_vertical_align_center),
          (overlay_set_position, reg1, pos1),
          # checkbox
          (store_add, ":checkbox_pos_x", ":pos_x", 0),
          (store_add, ":checkbox_pos_y", ":pos_y", 4),
          (position_set_x, pos1, ":checkbox_pos_x"),
          (position_set_y, pos1, ":checkbox_pos_y"),
          (create_check_box_overlay, reg1, "mesh_checkbox_off", "mesh_checkbox_on"),
          (overlay_set_position, reg1, pos1),
          (store_add, ":item_type", itp_type_horse, ":cur_type"),
          (item_get_slot, ":for_sell", ":item_type", slot_item_type_not_for_sell),
          (store_sub, ":for_sell", 1, ":for_sell"),
          (overlay_set_val, reg1, ":for_sell"),
          (troop_set_slot, "trp_temp_array_b", ":cur_type", reg1),
          # focous
          (val_add, ":pos_x", 225),
          (try_begin),
            (eq, ":pos_x", 835),
            (assign, ":pos_x", 160),
            (val_sub, ":pos_y", 28),
          (try_end),
        (try_end),

        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),

      #(ti_on_presentation_run,
        #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
      #]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (assign, "$g_sell_items_when_leaving", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (assign, "$g_auto_sell_price_limit", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"),
          (presentation_set_duration, 0),
        (else_try),
          ## select all
          (eq, ":object", "$g_presentation_obj_5"),
          (try_for_range, ":cur_type", 0, 20),
            (store_add, ":cur_item_type", itp_type_horse, ":cur_type"),
            (neq, ":cur_item_type", itp_type_goods),
            (neq, ":cur_item_type", itp_type_animal),
            (neq, ":cur_item_type", itp_type_book),
            (item_set_slot, ":cur_item_type", slot_item_type_not_for_sell, 0),
            (troop_get_slot, ":dest_checkbox", "trp_temp_array_b", ":cur_type"),
            (overlay_set_val, ":dest_checkbox", 1),
          (try_end),
        (else_try),
          ## select invert
          (eq, ":object", "$g_presentation_obj_6"),
          (try_for_range, ":cur_type", 0, 20),
            (store_add, ":cur_item_type", itp_type_horse, ":cur_type"),
            (neq, ":cur_item_type", itp_type_goods),
            (neq, ":cur_item_type", itp_type_animal),
            (neq, ":cur_item_type", itp_type_book),
            (item_get_slot, ":for_sell", ":cur_item_type", slot_item_type_not_for_sell),
            (val_add, ":for_sell", 1),
            (val_mod, ":for_sell", 2),
            (item_set_slot, ":cur_item_type", slot_item_type_not_for_sell, ":for_sell"),
            (troop_get_slot, ":dest_checkbox", "trp_temp_array_b", ":cur_type"),
            (store_sub, ":dest_val", 1, ":for_sell"),
            (overlay_set_val, ":dest_checkbox", ":dest_val"),
          (try_end),
        (try_end),

        ## checkboxes
        (try_for_range, ":slot_item_type_checkbox", 0, 20),
          (troop_slot_eq, "trp_temp_array_b", ":slot_item_type_checkbox", ":object"),
          (store_add, ":item_type", itp_type_horse, ":slot_item_type_checkbox"),
          (store_sub, ":for_sell", 1, ":value"),
          (item_set_slot, ":item_type", slot_item_type_not_for_sell, ":for_sell"),
        (try_end),
      ]),
    ]),

  ("mini_map", prsntf_read_only, 0, [
    (ti_on_presentation_load,
     [
      (set_fixed_point_multiplier, 1000),

      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (position_set_x, pos1, 1200),
      (position_set_y, pos1, 800),
      (overlay_set_position, reg0, pos1),

      (try_begin),
        (eq, "$g_show_minimap", 1),
        (try_for_agents, ":agent_no"),
          (agent_set_slot, ":agent_no", slot_agent_map_overlay_id, 0),
        (try_end),

        (get_scene_boundaries, pos2, pos3),
        (position_transform_position_to_local, pos4, pos2, pos3),
        (set_fixed_point_multiplier, 1000),
        (position_get_x, ":map_width", pos4),
        (position_get_y, ":map_height", pos4),
        (set_fixed_point_multiplier, 1000),
        (store_div, ":map_ratio", ":map_height", 100),
        (store_div, ":map_ratio", ":map_width", ":map_ratio"),
        (try_begin),
          (gt, ":map_ratio", 100),
          (store_mul, ":minimap_ratio", "$g_minimap_ratio", 3),
          (assign, "$g_battle_map_width", ":minimap_ratio"),
          (store_div, "$g_battle_map_scale", ":map_width", "$g_battle_map_width"),
          (store_div, "$g_battle_map_height", ":map_height", "$g_battle_map_scale"),
        (else_try),
          (store_mul, ":minimap_ratio", "$g_minimap_ratio", 3),
          (assign, "$g_battle_map_height", ":minimap_ratio"),
          (store_div, "$g_battle_map_scale", ":map_height", "$g_battle_map_height"),
          (store_div, "$g_battle_map_width", ":map_width", "$g_battle_map_scale"),
        (try_end),

        (create_mesh_overlay, "$g_battle_map_plane", "mesh_white_plane"),
        (overlay_set_color, "$g_battle_map_plane", 0),
        (store_add, ":map_bordered_width", "$g_battle_map_width", 20),
        (store_add, ":map_bordered_height", "$g_battle_map_height", 20),
        (store_mul, ":map_scale_x", ":map_bordered_width", 50),
        (store_mul, ":map_scale_y", ":map_bordered_height", 50),
        (position_set_x, pos1, ":map_scale_x"),
        (position_set_y, pos1, ":map_scale_y"),
        (overlay_set_size, "$g_battle_map_plane", pos1),
        (store_sub, ":map_pos_x", 990, ":map_bordered_width"),
        (store_sub, ":map_pos_y", 740, ":map_bordered_height"),
        (position_set_x, pos1, ":map_pos_x"),
        (position_set_y, pos1, ":map_pos_y"),
        (overlay_set_position, "$g_battle_map_plane", pos1),
        (overlay_set_alpha, "$g_battle_map_plane", 0x22),

        ## show player chest
        (try_begin),
          (scene_prop_get_instance, ":player_chest", "spr_inventory", 0),
          (ge, ":player_chest", 0),
          (create_mesh_overlay, "$g_presentation_obj_39", "mesh_white_plane"),
          (overlay_set_color, "$g_presentation_obj_39", 0xFF00FF),
          (position_set_x, pos1, 250),
          (position_set_y, pos1, 250),
          (overlay_set_size, "$g_presentation_obj_39", pos1),
        (try_end),
        
        ## horse stamina
        (create_text_overlay, "$g_presentation_obj_40", "@0", tf_right_align|tf_vertical_align_center),
        (position_set_x, pos1, 990),
        (position_set_y, pos1, 735),
        (overlay_set_position, "$g_presentation_obj_40", pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 500),
        (overlay_set_size, "$g_presentation_obj_40", pos1),
        (overlay_set_color, "$g_presentation_obj_40", 0xFFFFFF),
        (overlay_set_alpha, "$g_presentation_obj_40", 0),
        
        (call_script, "script_update_order_panel_map"),
      (try_end),
      ## hp bar
      (try_for_agents, ":agent_no"),
        (agent_set_slot, ":agent_no", slot_agent_hp_bar_overlay_id, 0),
       (agent_set_slot, ":agent_no", slot_agent_hp_bar_bg_overlay_id, 0),
       (agent_set_slot, ":agent_no", slot_agent_name_overlay_id, 0),
      (try_end),
      (call_script, "script_update_agent_hp_bar"),
        
      (presentation_set_duration, 999999),
     ]),
    (ti_on_presentation_run,
     [
      (set_fixed_point_multiplier, 1000),

      (try_begin),
        (game_key_clicked, gk_view_orders),
        (presentation_set_duration, 0),
        (start_presentation, "prsnt_battle"),
      (try_end),
     ]),
  ]),

  ("faction_troop_trees", 0, 0, [         ## CC   Troop Trees Presentation
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        
        (create_mesh_overlay, reg1, "mesh_load_window"),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, 0),
        (overlay_set_position, reg1, pos1),
        
        ## combo_button
        (create_combo_button_overlay, "$g_presentation_obj_1"),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 690),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        # factions
        (store_sub, ":num_factions", npc_kingdoms_end, npc_kingdoms_begin),
        (store_add, ":num_pages", ":num_factions", 3),
        
        ## page names, from bottom to top
        (overlay_add_item, "$g_presentation_obj_1", "@Teutonic Knights"),
        (overlay_add_item, "$g_presentation_obj_1", "@Outlaws"),
        (overlay_add_item, "$g_presentation_obj_1", "@Mercenary"),
        (try_for_range_backwards, ":page_no", 0, ":num_factions"),
          (store_add, ":faction_no", ":page_no", npc_kingdoms_begin),
          (str_store_faction_name, s0, ":faction_no"),
          (overlay_add_item, "$g_presentation_obj_1", s0),
        (try_end),
        (store_sub, ":presentation_obj_val", ":num_pages", "$g_selected_page"),
        (val_sub, ":presentation_obj_val", 1),
        (overlay_set_val, "$g_presentation_obj_1", ":presentation_obj_val"),
        
        ## back
        (create_game_button_overlay, "$g_presentation_obj_2", "@Close"),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 685),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        
        ## tips
        (create_text_overlay, reg1, "@Click the center button to toggle faction^Click the avatars to view details of them", tf_left_align),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 30),
        (position_set_y, pos1, 690),
        (overlay_set_position, reg1, pos1),
        
        ## pic_arms
        (try_begin),
          (is_between, "$g_selected_page", 0, ":num_factions"), 
          (store_add, ":pic_arms", "mesh_pic_arms_swadian", "$g_selected_page"),
          (create_mesh_overlay, reg1, ":pic_arms"),
          (position_set_x, pos1, 120),
          (position_set_y, pos1, 100),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 300),
          (position_set_y, pos1, 300),
          (overlay_set_size, reg1, pos1),
        (try_end),

        # detect_total_max_tier, calculate offset_x
        (assign, ":total_max_tier", 1),
        (try_for_range, ":cur_troop", soldiers_begin, soldiers_end),
          (neg|troop_is_hero, ":cur_troop"),
          # can upgrade
          (troop_get_upgrade_troop, ":upgrade_troop", ":cur_troop", 0),
          (gt, ":upgrade_troop", 0), 
          # page_no_for_cur_troop
          (call_script, "script_get_page_no_of_troop_tree_for_troop_on", ":cur_troop"),
          (assign, ":page_no_for_cur_troop", reg0),
          # on current page_no
          (eq, ":page_no_for_cur_troop", "$g_selected_page"),
          (assign, reg0, 1), # reg0: init max_tier to 1
          (call_script, "script_troop_tree_recursive_detect_max_tier", ":cur_troop", 1),
          (assign, ":cur_max_tier", reg0),
          (try_begin),
            (gt, ":cur_max_tier", ":total_max_tier"),
            (assign, ":total_max_tier", ":cur_max_tier"),
          (try_end),
        (try_end),
        (val_sub, ":total_max_tier", 1),
        (val_max, ":total_max_tier", 1),
        (store_div, ":offset_x", 700, ":total_max_tier"),
        (val_min, ":offset_x", 120),
        
        (str_clear, s0),
        (create_text_overlay, reg1, s0, tf_scrollable),
        (position_set_x, pos1, 15),
        (position_set_y, pos1, 15),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 660),
        (overlay_set_area_size, reg1, pos1),
        (set_container_overlay, reg1),
        
        (assign, "$g_cur_slot_no", 0),
        (assign, reg2, 75),
        # find all root troops of selected faction
        (try_for_range, ":cur_troop", soldiers_begin, soldiers_end),
          (neg|troop_is_hero, ":cur_troop"),
          # can upgrade
          (troop_get_upgrade_troop, ":upgrade_troop", ":cur_troop", 0),
          (gt, ":upgrade_troop", 0), 
          # page_no_for_cur_troop
          (call_script, "script_get_page_no_of_troop_tree_for_troop_on", ":cur_troop"),
          (assign, ":page_no_for_cur_troop", reg0),
          # on current page_no
          (eq, ":page_no_for_cur_troop", "$g_selected_page"),
          # can't be upgraded from other troops of the same page
          (assign, ":is_root_troop", 1),
          (assign, ":end_cond", soldiers_end),
          (try_for_range, ":loop_troop", soldiers_begin, ":end_cond"),
            (neg|troop_is_hero, ":loop_troop"),
            # page_no_for_loop_troop
            (call_script, "script_get_page_no_of_troop_tree_for_troop_on", ":loop_troop"),
            (assign, ":page_no_for_loop_troop", reg0),
            # on current page_no
            (eq,  ":page_no_for_loop_troop", "$g_selected_page"),
            (troop_get_upgrade_troop, ":upgrade_troop_1", ":loop_troop", 0),
            (troop_get_upgrade_troop, ":upgrade_troop_2", ":loop_troop", 1),
            (this_or_next|eq, ":upgrade_troop_1", ":cur_troop"),
            (eq, ":upgrade_troop_2", ":cur_troop"),
            (assign, ":is_root_troop", 0),
            (assign, ":end_cond", 0), #break
          (try_end),
          (eq, ":is_root_troop", 1), # draw troop tree of cur root_troop
          (call_script, "script_troop_tree_recursive_backtracking", ":cur_troop", 50, reg2, ":offset_x"),
          (val_add, reg2, 160),
        (try_end),
        
        (set_container_overlay, -1),
        
        ## draw selected_troop: Attributes, Skills, Equipments,
        (try_begin),
          (gt, "$g_selected_troop", 0), 
          (store_mul, ":cur_troop", "$g_selected_troop", 2), #with weapons
          (create_image_button_overlay_with_tableau_material, reg1, -1, "tableau_game_party_window", ":cur_troop"),
          (position_set_x, pos1, 450),
          (position_set_y, pos1, 600),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, 810),
          (position_set_y, pos1, 550),
          (overlay_set_position, reg1, pos1),
          
          # pos2: text size
          (position_set_x, pos2, 750),
          (position_set_y, pos2, 750),
          # pos2: title text size
          (position_set_x, pos3, 900),
          (position_set_y, pos3, 900),
          # Name
          (str_store_troop_name, s1, "$g_selected_troop"),
          (create_text_overlay, reg1, s1, tf_center_justify),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 710),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos2),
          
          # level and HP
          (store_character_level, reg3, "$g_selected_troop"),
          (assign, ":troop_hp", 35),
          (store_skill_level, ":skill", skl_ironflesh, "$g_selected_troop"),
          (store_attribute_level, ":strength", "$g_selected_troop", ca_strength),
          (val_mul, ":skill", 2),
          (val_add, ":troop_hp", ":skill"),
          (val_add, ":troop_hp", ":strength"),
          (assign, reg4, ":troop_hp"),
          (create_text_overlay, reg1, "@Level: {reg3}^Health: {reg4}", tf_left_align),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 665),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos2),
          
          # Attributes
          (create_text_overlay, reg1, "@Attributes", tf_left_align),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 630),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos3),
          (create_text_overlay, reg1, "@STR^AGI^INT^CHA", tf_left_align),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 570),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos2),
          
          (try_for_range, ":attrib_id", 0, 4),
            (try_begin),
              (eq, ":attrib_id", 0),
              (store_attribute_level, reg2, "$g_selected_troop", ":attrib_id"),
              (str_store_string, s1, "@{reg2}"),
            (else_try),
              (store_attribute_level, reg2, "$g_selected_troop", ":attrib_id"),
              (str_store_string, s1, "@{s1}^{reg2}"),
            (try_end),
          (try_end),
          (create_text_overlay, reg1, s1, tf_right_align),
          (position_set_x, pos1, 980),
          (position_set_y, pos1, 570),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos2),
          
          # Skills
          (create_text_overlay, reg1, "@Skills", tf_left_align),
          (position_set_x, pos1, 840),
          (position_set_y, pos1, 527),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos3),
          (create_text_overlay, reg1, "@Ironflesh^Power Strike^Power Throw^Power Draw^Shield^Athletics^Riding^Horse Archery", tf_left_align),
          (position_set_x, pos1, 840),
          (position_set_y, pos1, 415),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos2),
          
          (try_for_range_backwards, ":skill_id", 0, 42),
            (try_begin),
              (eq, ":skill_id", "skl_ironflesh"),
              (store_skill_level, reg2, ":skill_id", "$g_selected_troop"),
              (str_store_string, s1, "@{reg2}"),
            (else_try),
              (this_or_next|eq, ":skill_id", "skl_power_strike"),
              (this_or_next|eq, ":skill_id", "skl_power_throw"),
              (this_or_next|eq, ":skill_id", "skl_power_draw"),
              (this_or_next|eq, ":skill_id", "skl_shield"),
              (this_or_next|eq, ":skill_id", "skl_athletics"),
              (this_or_next|eq, ":skill_id", "skl_riding"),
              (eq, ":skill_id", "skl_horse_archery"),
              (store_skill_level, reg2, ":skill_id", "$g_selected_troop"),
              (str_store_string, s1, "@{s1}^{reg2}"),
            (try_end),
          (try_end),
          (create_text_overlay, reg1, s1, tf_right_align),
          (position_set_x, pos1, 980),
          (position_set_y, pos1, 415),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos2),
          
          # Weapon Proficiencies
          (create_text_overlay, reg1, "@Proficiencies", tf_left_align),
          (position_set_x, pos1, 840),
          (position_set_y, pos1, 370),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos3),
          (create_text_overlay, reg1, "@1H Weapons^2H Weapons^Polearms^Archery^Crossbows^Throwing", tf_left_align),
          (position_set_x, pos1, 840),
          (position_set_y, pos1, 285),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos2),
          
          (try_for_range, ":wp_id", 0, 6),
            (try_begin),
              (eq, ":wp_id", wpt_one_handed_weapon),
              (store_proficiency_level, reg2, "$g_selected_troop", ":wp_id"),
              (str_store_string, s1, "@{reg2}"),
            (else_try),
              (is_between, ":wp_id", wpt_two_handed_weapon, wpt_firearm),
              (store_proficiency_level, reg2, "$g_selected_troop", ":wp_id"),
              (str_store_string, s1, "@{s1}^{reg2}"),
            (try_end),
          (try_end),
          (create_text_overlay, reg1, s1, tf_right_align),
          (position_set_x, pos1, 980),
          (position_set_y, pos1, 285),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos2),
          
          # Equipments
          (create_text_overlay, reg1, "@Equipment", tf_left_align),
          (position_set_x, pos1, 840),
          (position_set_y, pos1, 235),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos3),
          (str_clear, s0),
          (create_text_overlay, "$g_presentation_obj_3", s0, tf_scrollable),
          (position_set_x, pos1, 840),
          (position_set_y, pos1, 30),
          (overlay_set_position, "$g_presentation_obj_3", pos1),
          (position_set_x, pos1, 138),
          (position_set_y, pos1, 202),
          (overlay_set_area_size, "$g_presentation_obj_3", pos1),
          (set_container_overlay, "$g_presentation_obj_3"),
          
          (troop_clear_inventory, "trp_temp_array_a"),
          (troop_get_inventory_capacity, ":inv_cap", "$g_selected_troop"),
          (try_for_range, ":i_slot", 0, ":inv_cap"),
            (troop_get_inventory_slot, ":item", "$g_selected_troop", ":i_slot"),
            (gt, ":item", -1),
            (troop_get_inventory_slot_modifier, ":imod", "$g_selected_troop", ":i_slot"),
            (troop_add_item,"trp_temp_array_a",":item", ":imod"),
          (try_end),
          
          (assign, ":pos_x", 0),
          (assign, ":pos_y", 280),
          (assign, ":slot_no", 10),
          (try_for_range, ":unused_height", 0, 8),
            (try_for_range, ":unused_width", 0, 3),
              (create_mesh_overlay, reg1, "mesh_mp_inventory_choose"),
              (position_set_x, pos1, 320),
              (position_set_y, pos1, 320),
              (overlay_set_size, reg1, pos1),
              (position_set_x, pos1, ":pos_x"),
              (position_set_y, pos1, ":pos_y"),
              (overlay_set_position, reg1, pos1),
              (troop_set_slot, "trp_temp_array_a", ":slot_no", reg1),
              (create_mesh_overlay, reg1, "mesh_inv_slot"),
              (position_set_x, pos1, 400),
              (position_set_y, pos1, 400),
              (overlay_set_size, reg1, pos1),
              (position_set_x, pos1, ":pos_x"),
              (position_set_y, pos1, ":pos_y"),
              (overlay_set_position, reg1, pos1),
              (troop_get_inventory_slot, ":item_no", "trp_temp_array_a", ":slot_no"),
              (val_max, ":item_no", 0),
              (create_mesh_overlay_with_item_id, reg1, ":item_no"),
              (position_set_x, pos1, 400),
              (position_set_y, pos1, 400),
              (overlay_set_size, reg1, pos1),
              (store_add, ":item_x", ":pos_x", 20),
              (store_add, ":item_y", ":pos_y", 20),
              (position_set_x, pos1, ":item_x"),
              (position_set_y, pos1, ":item_y"),
              (overlay_set_position, reg1, pos1),
              (troop_set_slot, "trp_temp_array_b", ":slot_no", reg1),
              (val_add, ":pos_x", 40),
              (val_add, ":slot_no", 1),
            (try_end),
            (assign, ":pos_x", 0),
            (val_sub, ":pos_y", 40),
          (try_end),
          (set_container_overlay, -1),
        (try_end),
      ]),
      
    (ti_on_presentation_mouse_enter_leave,
      [
      (store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":enter_leave"),
      
      (try_begin),
        (gt, "$g_selected_troop", 0), 
        (try_begin),
          (eq, ":enter_leave", 0),
          (try_for_range, ":slot_no", 10, 106),
            (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
            (troop_get_inventory_slot, ":item_no", "trp_temp_array_a", ":slot_no"),
            (troop_get_inventory_slot_modifier, ":cur_imod", "trp_temp_array_a", ":slot_no"),
            (try_begin),
              (gt, ":item_no", -1),
              (troop_get_slot, ":target_obj", "trp_temp_array_b", ":slot_no"),
              (overlay_get_position, pos0, ":target_obj"),
              (show_item_details_with_modifier, ":item_no", ":cur_imod", pos0, 100),
              (assign, "$g_current_opened_item_details", ":slot_no"),
            (try_end),
          (try_end),
        (else_try),
          (try_for_range, ":slot_no", 10, 106),
            (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
            (try_begin),
              (eq, "$g_current_opened_item_details", ":slot_no"),
              (close_item_details),
            (try_end),
          (try_end),
        (try_end),
      (try_end),
    ]),
      
    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        
        (try_for_range, ":slot_no", 0, "$g_cur_slot_no"),
          (troop_slot_eq, "trp_stack_selection_amounts", ":slot_no", ":object"),
          (troop_get_slot, "$g_selected_troop", "trp_stack_selection_ids", ":slot_no"),
          (start_presentation, "prsnt_faction_troop_trees"),
        (try_end),
        
        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (store_sub, ":num_pages", npc_kingdoms_end, npc_kingdoms_begin),
          (val_add, ":num_pages", 3),
          (store_sub, "$g_selected_page", ":num_pages", ":value"),
          (val_sub, "$g_selected_page", 1),
          (assign, "$g_selected_troop", 0), 
          (start_presentation, "prsnt_faction_troop_trees"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (assign, "$g_selected_troop", 0), 
          (assign, "$g_selected_page", 0),
          (presentation_set_duration, 0),
        (try_end),
      ]),
  ]),              ## CC   Troop Trees Presentation End

  ("troop_note", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        ## init troop items
        (call_script, "script_copy_inventory", "$temp", "trp_temp_array_a"),
        (try_for_range, ":i_slot", 0, 10),
          (troop_get_inventory_slot, ":item", "trp_temp_array_a", ":i_slot"),
          (troop_get_inventory_slot_modifier, ":cur_imod", "trp_temp_array_a", ":i_slot"),
          (gt, ":item", -1),
          (troop_add_item,"trp_temp_array_a",":item", ":cur_imod"),
          (troop_set_inventory_slot, "trp_temp_array_a", ":i_slot", -1),
        (try_end),

        ## back
        (create_game_button_overlay, "$g_presentation_obj_1", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_1", pos1),

        ## previous
        (create_game_button_overlay, "$g_presentation_obj_3", "@Previous"),
        (position_set_x, pos1, 540),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        ## next
        (create_game_button_overlay, "$g_presentation_obj_4", "@Next"),
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_4", pos1),

        ## troop class
        (create_text_overlay, reg0, "@Class of troop", tf_center_justify|tf_vertical_align_center),
        (position_set_x, pos1, 875),
        (position_set_y, pos1, 340),
        (overlay_set_position, reg0, pos1),
        
        (create_combo_button_overlay, "$g_presentation_obj_5"),
        (position_set_x, pos1, 930),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_size, "$g_presentation_obj_5", pos1),
        (try_for_range_backwards, ":class_id", 0, 9),
          (str_store_class_name, s0, ":class_id"),
          (overlay_add_item, "$g_presentation_obj_5", s0),
        (try_end),
        (troop_get_class, ":troop_class", "$temp"),
        (store_sub, ":presentation_obj_val", 8, ":troop_class"),
        (overlay_set_val, "$g_presentation_obj_5", ":presentation_obj_val"),

        ################
        (store_mul, ":cur_troop", "$temp", 2), #with weapons
        (create_mesh_overlay_with_tableau_material, reg0, -1, "tableau_game_party_window", ":cur_troop"),
        (position_set_x, pos1, 750),
        (position_set_y, pos1, 1000),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 765),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg0, pos1),

        (str_store_troop_name, s1, "$temp"),
        (store_character_level, ":troop_level", "$temp"),
        (assign, reg1, ":troop_level"),
        (str_store_string, s1, "@Name: {s1}^Level: {reg1}"),
        (call_script, "script_get_troop_max_hp", "$temp"),
        (str_store_string, s1, "@{s1}^HP: {reg0}"),

        (create_text_overlay, reg0, "@{s1}", tf_double_space),
        (position_set_x, pos1, 450),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg0, pos1),

        (str_store_string, s3, "@Attributes:"),
        (store_attribute_level, reg1, "$temp", ca_strength),
        (store_attribute_level, reg2, "$temp", ca_intelligence),
        (str_store_string, s3, "@{s3}^STR: {reg1}^INT: {reg2}^^Skills:"),
        (store_skill_level, reg1, skl_power_strike, "$temp"),
        (store_skill_level, reg2, skl_power_draw, "$temp"),
        (store_skill_level, reg3, skl_power_throw, "$temp"),
        (store_skill_level, reg4, skl_horse_archery, "$temp"),
        (str_store_string, s3, "@{s3}^Power Strike: {reg1}^Power Draw: {reg2}^Power Throw: {reg3}^Horse Archery: {reg4}^^Weapon Proficiencies:"),
        (store_proficiency_level, reg1, "$temp", wpt_one_handed_weapon),
        (store_proficiency_level, reg2, "$temp", wpt_two_handed_weapon),
        (store_proficiency_level, reg3, "$temp", wpt_polearm),
        (str_store_string, s3, "@{s3}^1 Hand Wpns: {reg1}^2 Hand Wpns: {reg2}^Polearms: {reg3}"),
        (create_text_overlay, reg0, "@{s3}", tf_double_space),
        (position_set_x, pos1, 450),
        (position_set_y, pos1, 100),
        (overlay_set_position, reg0, pos1),

        (str_store_string, s4, "str_empty_string"),
        (store_attribute_level, reg1, "$temp", ca_agility),
        (store_attribute_level, reg2, "$temp", ca_charisma),
        (str_store_string, s4, "@{s4}^AGI: {reg1}^CHA: {reg2}^^"),
        (store_skill_level, reg1, skl_ironflesh, "$temp"),
        (store_skill_level, reg2, skl_athletics, "$temp"),
        (store_skill_level, reg3, skl_shield, "$temp"),
        (store_skill_level, reg4, skl_riding, "$temp"),
        (str_store_string, s4, "@{s4}^Ironflesh: {reg1}^Athletics: {reg2}^Shield: {reg3}^Riding: {reg4}^^"),
        (store_proficiency_level, reg1, "$temp", wpt_archery),
        (store_proficiency_level, reg2, "$temp", wpt_crossbow),
        (store_proficiency_level, reg3, "$temp", wpt_throwing),
        (str_store_string, s4, "@{s4}^Archery: {reg1}^Crossbows: {reg2}^Throwing: {reg3}"),
        (create_text_overlay, reg0, "@{s4}", tf_double_space),
        (position_set_x, pos1, 660),
        (position_set_y, pos1, 100),
        (overlay_set_position, reg0, pos1),
        ################

        (str_clear, s0),
        (create_text_overlay, "$g_presentation_obj_2", s0, tf_scrollable),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 50),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (position_set_x, pos1, 350),
        (position_set_y, pos1, 560),
        (overlay_set_area_size, "$g_presentation_obj_2", pos1),
        (set_container_overlay, "$g_presentation_obj_2"),

        (assign, ":pos_x", 0),
        (assign, ":pos_y", 1840),
        (assign, ":slot_no", 10),
        (try_for_range, ":unused_height", 0, 24),
          (try_for_range, ":unused_width", 0, 4),
            (create_mesh_overlay, reg1, "mesh_inv_slot"),
            (position_set_x, pos1, 800),
            (position_set_y, pos1, 800),
            (overlay_set_size, reg1, pos1),
            (position_set_x, pos1, ":pos_x"),
            (position_set_y, pos1, ":pos_y"),
            (overlay_set_position, reg1, pos1),
            (create_mesh_overlay, reg1, "mesh_mp_inventory_choose"),
            (position_set_x, pos1, 640),
            (position_set_y, pos1, 640),
            (overlay_set_size, reg1, pos1),
            (position_set_x, pos1, ":pos_x"),
            (position_set_y, pos1, ":pos_y"),
            (overlay_set_position, reg1, pos1),
            (troop_set_slot, "trp_temp_array_a", ":slot_no", reg1),
            (troop_get_inventory_slot, ":item_no", "trp_temp_array_a", ":slot_no"),
            (try_begin),
              (gt, ":item_no", -1),
              (create_mesh_overlay_with_item_id, reg1, ":item_no"),
              (position_set_x, pos1, 800),
              (position_set_y, pos1, 800),
              (overlay_set_size, reg1, pos1),
              (store_add, ":item_x", ":pos_x", 40),
              (store_add, ":item_y", ":pos_y", 40),
              (position_set_x, pos1, ":item_x"),
              (position_set_y, pos1, ":item_y"),
              (overlay_set_position, reg1, pos1),
              (troop_set_slot, "trp_temp_array_b", ":slot_no", reg1),
            (try_end),
            (val_add, ":pos_x", 80),
            (val_add, ":slot_no", 1),
          (try_end),
          (assign, ":pos_x", 0),
          (val_sub, ":pos_y", 80),
        (try_end),

        (set_container_overlay, -1),

        (create_text_overlay, reg1, "@Equipment ", tf_vertical_align_center),
        (position_set_x, pos1, 60),
        (position_set_y, pos1, 635),
        (overlay_set_position, reg1, pos1),
        ## items

        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),

    #(ti_on_presentation_run,
      #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
    #]),

    (ti_on_presentation_mouse_enter_leave,
      [
      (store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":enter_leave"),

      (try_begin),
        (eq, ":enter_leave", 0),
        (try_for_range, ":slot_no", 10, 106),
          (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
          (troop_get_inventory_slot, ":item_no", "trp_temp_array_a", ":slot_no"),
          (troop_get_inventory_slot_modifier, ":cur_imod", "trp_temp_array_a", ":slot_no"),
          (try_begin),
            (gt, ":item_no", -1),
            (troop_get_slot, ":target_obj", "trp_temp_array_b", ":slot_no"),
            (overlay_get_position, pos0, ":target_obj"),
            (show_item_details_with_modifier, ":item_no", ":cur_imod", pos0, 100),
            (assign, "$g_current_opened_item_details", ":slot_no"),
          (try_end),
        (try_end),
      (else_try),
        (try_for_range, ":slot_no", 10, 106),
          (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
          (try_begin),
            (eq, "$g_current_opened_item_details", ":slot_no"),
            (close_item_details),
          (try_end),
        (try_end),
      (try_end),
    ]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        
        (try_begin),
          (key_is_down, key_left_control),
          (assign, ":offset", 5),
        (else_try),
          (key_is_down, key_left_shift),
          (assign, ":offset", 10),
        (else_try),
          (key_is_down, key_left_alt),
          (assign, ":offset", 20),
        (else_try),
          (assign, ":offset", 1),
        (try_end),
        
        (try_begin),
          (eq, ":object", "$g_presentation_obj_3"),
          (val_sub, "$temp", ":offset"),
          (val_max, "$temp", 0),
          (start_presentation, "prsnt_troop_note"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_4"),
          (val_add, "$temp", ":offset"),
          (val_min, "$temp", "trp_relative_of_merchants_end"),
          (start_presentation, "prsnt_troop_note"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_5"),
          (store_sub, ":troop_class", 8, ":value"),
          (troop_set_class, "$temp", ":troop_class"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_1"),
          (try_begin),
            (gt, "$g_presentation_next_presentation", -1),
            (start_presentation, "$g_presentation_next_presentation"),
          (else_try),
            (presentation_set_duration, 0),
          (try_end),
        (try_end),
    ]),
  ]),

  ("all_items", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        (create_combo_label_overlay, "$g_presentation_obj_1"),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 675),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (overlay_add_item, "$g_presentation_obj_1", "@Weapons"),
        (overlay_add_item, "$g_presentation_obj_1", "@Armors"),
        (overlay_add_item, "$g_presentation_obj_1", "@Others"),
        (overlay_set_val, "$g_presentation_obj_1", "$temp"),

        ## back
        (create_game_button_overlay, "$g_presentation_obj_5", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_5", pos1),

        (str_clear, s0),
        (create_text_overlay, "$g_presentation_obj_6", s0, tf_scrollable),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 100),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (position_set_x, pos1, 890),
        (position_set_y, pos1, 560),
        (overlay_set_area_size, "$g_presentation_obj_6", pos1),
        (set_container_overlay, "$g_presentation_obj_6"),

        (assign, ":num_items", len(items)),
        (assign, "$temp_2", 0),
        ## types
        (try_begin),
          (eq, "$temp", 0), # weapons
          (try_for_range, ":item_no", 0, ":num_items"),
            (item_get_type, ":type", ":item_no"),
            (this_or_next|is_between, ":type", itp_type_one_handed_wpn, itp_type_goods),
            (is_between, ":type", itp_type_pistol, itp_type_animal),
            (val_add, "$temp_2", 1),
          (try_end),
        (else_try),
          (eq, "$temp", 1), # armors
          (try_for_range, ":item_no", 0, ":num_items"),
            (item_get_type, ":type", ":item_no"),
            (is_between, ":type", itp_type_head_armor, itp_type_pistol),
            (val_add, "$temp_2", 1),
          (try_end),
        (else_try),
          (eq, "$temp", 2), # others
          (try_for_range, ":item_no", 0, ":num_items"),
            (item_get_type, ":type", ":item_no"),
            (this_or_next|eq, ":type", itp_type_horse),
            (this_or_next|eq, ":type", itp_type_goods),
            (this_or_next|eq, ":type", itp_type_animal),
            (eq, ":type", itp_type_book),
            (val_add, "$temp_2", 1),
          (try_end),
        (try_end),

        (store_div, ":height", "$temp_2", 11),
        (store_mod, ":offset", "$temp_2", 11),
        (val_min, ":offset", 1),
        (val_add, ":height", ":offset"),
        (store_mul, ":pos_y", ":height", 80),
        (val_sub, ":pos_y", 80),
        (assign, ":pos_x", 0),
        (assign, ":slot_no", 0),
        (try_for_range, ":item_no", 0, ":num_items"),
          (item_get_type, ":type", ":item_no"),
          (try_begin),
            (eq, "$temp", 0), # weapons
            (try_begin),
              (this_or_next|is_between, ":type", itp_type_one_handed_wpn, itp_type_goods),
              (is_between, ":type", itp_type_pistol, itp_type_animal),
              (assign, ":continue", 1),
            (else_try),
              (assign, ":continue", 0),
            (try_end),
          (else_try),
            (eq, "$temp", 1), # armors
            (try_begin),
              (is_between, ":type", itp_type_head_armor, itp_type_pistol),
              (assign, ":continue", 1),
            (else_try),
              (assign, ":continue", 0),
            (try_end),
          (else_try),
            (eq, "$temp", 2), # others
            (try_begin),
              (this_or_next|eq, ":type", itp_type_horse),
              (this_or_next|eq, ":type", itp_type_goods),
              (this_or_next|eq, ":type", itp_type_animal),
              (eq, ":type", itp_type_book),
              (assign, ":continue", 1),
            (else_try),
              (assign, ":continue", 0),
            (try_end),
          (try_end),
          (eq, ":continue", 1),
          ## item slot
          (create_mesh_overlay, reg1, "mesh_inv_slot"),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),
          (create_mesh_overlay, reg1, "mesh_mp_inventory_choose"),
          (position_set_x, pos1, 640),
          (position_set_y, pos1, 640),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_no", reg1),
          ## item
          (create_mesh_overlay_with_item_id, reg1, ":item_no"),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg1, pos1),
          (store_add, ":item_x", ":pos_x", 40),
          (store_add, ":item_y", ":pos_y", 40),
          (position_set_x, pos1, ":item_x"),
          (position_set_y, pos1, ":item_y"),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_temp_array_b", ":slot_no", reg1),
          (troop_set_slot, "trp_temp_array_c", ":slot_no", ":item_no"),
          (val_add, ":pos_x", 80),
          (val_add, ":slot_no", 1),
          (try_begin),
            (ge, ":pos_x", 880),
            (assign, ":pos_x", 0),
            (val_sub, ":pos_y", 80),
          (try_end),
        (try_end),

        (set_container_overlay, -1),
        ## items

#        ####### mouse fix pos system #######
#        (call_script, "script_mouse_fix_pos_ready"),
#        ####### mouse fix pos system #######
      ]),

#    (ti_on_presentation_run,
#      [
#        ####### mouse fix pos system #######
#        (call_script, "script_mouse_fix_pos_run"),
#        ####### mouse fix pos system #######
#    ]),

    (ti_on_presentation_mouse_enter_leave,
      [
      (store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":enter_leave"),

      (try_begin),
        (eq, ":enter_leave", 0),
        (try_for_range, ":slot_no", 0, "$temp_2"),
          (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
          (troop_get_slot, ":item_no", "trp_temp_array_c", ":slot_no"),
          (troop_get_slot, ":target_obj", "trp_temp_array_b", ":slot_no"),
          (overlay_get_position, pos0, ":target_obj"),
          (show_item_details, ":item_no", pos0, 100),
          (assign, "$g_current_opened_item_details", ":slot_no"),
        (try_end),
      (else_try),
        (try_for_range, ":slot_no", 0, "$temp_2"),
          (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
          (try_begin),
            (eq, "$g_current_opened_item_details", ":slot_no"),
            (close_item_details),
          (try_end),
        (try_end),
      (try_end),
    ]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (assign, "$temp", ":value"),
          (start_presentation, "prsnt_all_items"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_5"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),

  ("change_commander", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        (position_set_x, pos1, 400),
        (position_set_y, pos1, 670),
        (str_store_troop_name, s0, "$g_player_troop"),
        (str_store_string, s1, "@Please reselect a companion as the commander for the comming battle.^^Current commander: {s0}."),

        (create_text_overlay, "$g_presentation_obj_1", "@{s1}", tf_center_justify|tf_vertical_align_center),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        
        (create_game_button_overlay, "$g_presentation_obj_2", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_2", pos1),

        (str_clear, s0),
        (create_text_overlay, "$g_presentation_obj_6", s0, tf_scrollable),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 150),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (position_set_x, pos1, 100),
        (position_set_y, pos1, 400),
        (overlay_set_area_size, "$g_presentation_obj_6", pos1),
        (set_container_overlay, "$g_presentation_obj_6"),
  
        (assign, ":num_of_heros", 0),
        (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
        (try_for_range, ":i_stack", 0, ":num_stacks"),
          (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
          (troop_is_hero, ":stack_troop"),
          (neg|troop_is_wounded, ":stack_troop"),
          (val_add, ":num_of_heros", 1),
        (try_end),
        (try_begin),
          (le, ":num_of_heros", 10),
          (assign, ":pos_y", 400),
        (else_try),
          (store_mul, ":pos_y", ":num_of_heros", 40),
        (try_end),
        (val_sub, ":pos_y", 40),
        (assign, ":pos_x", 50),
        
        (assign, ":num_of_heros", 0),
        (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
        (try_for_range, ":i_stack", 0, ":num_stacks"),
          (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
          (troop_is_hero, ":stack_troop"),
          (neg|troop_is_wounded, ":stack_troop"),
          (str_store_troop_name, s1, ":stack_troop"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (val_sub, ":pos_y", 40),
          (create_button_overlay, reg0, "@{s1}", tf_center_justify),
          (overlay_set_position, reg0, pos1),

          (assign, ":trp_slot_prsnt_no", ":num_of_heros"),
          (troop_set_slot, "trp_temp_array_a", ":trp_slot_prsnt_no", reg0),
          (troop_set_slot, "trp_temp_array_b", ":trp_slot_prsnt_no", ":stack_troop"),
          (val_add, ":num_of_heros", 1),
        (try_end),

        (set_container_overlay, -1),

        ################
        (create_mesh_overlay_with_tableau_material, reg0, -1, "tableau_troop_note_mesh", "$g_player_troop"),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 500),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 150),
        (position_set_y, pos1, 450),
        (overlay_set_position, reg0, pos1),

        (str_store_troop_name, s1, "$g_player_troop"),
        (store_character_level, ":troop_level", "$g_player_troop"),
        (assign, reg1, ":troop_level"),
        (str_store_string, s1, "@Name: {s1}^Level: {reg1}"),

        (store_troop_health, ":cur_hp", "$g_player_troop", 1),
        (call_script, "script_get_troop_max_hp", "$g_player_troop"),
        (assign, reg1, ":cur_hp"),
        (assign, reg2, reg0),
        (str_store_string, s1, "@{s1}^HP: {reg1}/{reg2}"),

        (create_text_overlay, reg0, "@{s1}", tf_double_space),
        (position_set_x, pos1, 420),
        (position_set_y, pos1, 450),
        (overlay_set_position, reg0, pos1),

        ## cur_hero equipments
        # set_container
        (str_clear, s0),
        (create_text_overlay, reg1, s0, tf_scrollable),
        (position_set_x, pos1, 100), # only need to change the 2 value
        (position_set_y, pos1, 60),
        (overlay_set_position, reg1, pos1), 
        (position_set_x, pos1, 280),
        (position_set_y, pos1, 380),
        (overlay_set_area_size, reg1, pos1),
        (set_container_overlay, reg1), # begin
        
        (create_text_overlay, reg1, "@Arms", tf_center_justify),
        (position_set_x, pos1, 220),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Outfit", tf_center_justify),
        (position_set_x, pos1, 80),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Horse", tf_center_justify),
        (position_set_x, pos1, 40),
        (position_set_y, pos1, 90),
        (overlay_set_position, reg1, pos1),
        
        (assign, "$g_current_opened_item_details", -1),
        
        (assign, ":trp_obj_id", "trp_bonus_chest_1"), # array to record obj's id
        (assign, ":trp_obj_x", "trp_bonus_chest_2"),  # array to record obj's x
        (assign, ":trp_obj_y", "trp_bonus_chest_3"),  # array to record obj's y
        (assign, ":trp_obj_bg", "trp_zendar_chest"),  # array to record obj's background
        # weapons
        (troop_set_slot, ":trp_obj_x", 0, 180),
        (troop_set_slot, ":trp_obj_y", 0, 260),
        (troop_set_slot, ":trp_obj_x", 1, 180),
        (troop_set_slot, ":trp_obj_y", 1, 180),
        (troop_set_slot, ":trp_obj_x", 2, 180),
        (troop_set_slot, ":trp_obj_y", 2, 100),
        (troop_set_slot, ":trp_obj_x", 3, 180),
        (troop_set_slot, ":trp_obj_y", 3, 20),
        # armors
        (troop_set_slot, ":trp_obj_x", 4, 80),
        (troop_set_slot, ":trp_obj_y", 4, 260),
        (troop_set_slot, ":trp_obj_x", 5, 80),
        (troop_set_slot, ":trp_obj_y", 5, 180),
        (troop_set_slot, ":trp_obj_x", 6, 80),
        (troop_set_slot, ":trp_obj_y", 6, 100),
        (troop_set_slot, ":trp_obj_x", 7, 0),
        (troop_set_slot, ":trp_obj_y", 7, 180),
        # horse
        (troop_set_slot, ":trp_obj_x", 8, 0),
        (troop_set_slot, ":trp_obj_y", 8, 0),
        
        # background
        (troop_set_slot, ":trp_obj_bg", 0, "mesh_mp_inventory_slot_equip"),
        (troop_set_slot, ":trp_obj_bg", 1, "mesh_mp_inventory_slot_equip"),
        (troop_set_slot, ":trp_obj_bg", 2, "mesh_mp_inventory_slot_equip"),
        (troop_set_slot, ":trp_obj_bg", 3, "mesh_mp_inventory_slot_equip"),
        (troop_set_slot, ":trp_obj_bg", 4, "mesh_mp_inventory_slot_helmet"),
        (troop_set_slot, ":trp_obj_bg", 5, "mesh_mp_inventory_slot_armor"),
        (troop_set_slot, ":trp_obj_bg", 6, "mesh_mp_inventory_slot_boot"),
        (troop_set_slot, ":trp_obj_bg", 7, "mesh_mp_inventory_slot_glove"),
        (troop_set_slot, ":trp_obj_bg", 8, "mesh_mp_inventory_slot_horse"),
        
        # obj size
        (position_set_x, pos3, 640),
        (position_set_y, pos3, 640),
        
        (try_for_range, ":item_slot", 0, 9),
          (troop_get_inventory_slot, ":cur_item", "$g_player_troop", ":item_slot"),
        
          (troop_get_slot, ":pos_x", ":trp_obj_x", ":item_slot"),
          (troop_get_slot, ":pos_y", ":trp_obj_y", ":item_slot"),
          (troop_get_slot, ":bg_mesh", ":trp_obj_bg", ":item_slot"),
          
          (create_mesh_overlay, reg1, "mesh_mp_inventory_choose"),
          (overlay_set_size, reg1, pos3),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),

          ## item
          (try_begin),
            (gt, ":cur_item", -1),
            # empty background
            (create_mesh_overlay, reg1, "mesh_mp_inventory_slot_empty"),
            (overlay_set_size, reg1, pos3),
            (position_set_x, pos1, ":pos_x"),
            (position_set_y, pos1, ":pos_y"),
            (overlay_set_position, reg1, pos1),
            # item mesh
            (create_mesh_overlay_with_item_id, reg1, ":cur_item"),
            (position_set_x, pos1, 800),
            (position_set_y, pos1, 800),
            (overlay_set_size, reg1, pos1),
            (store_add, ":item_x", ":pos_x", 40),
            (store_add, ":item_y", ":pos_y", 40),
            (position_set_x, pos1, ":item_x"),
            (position_set_y, pos1, ":item_y"),
            (overlay_set_position, reg1, pos1),
            (troop_set_slot, ":trp_obj_id", ":item_slot", reg1),
          (else_try),
            # default bg_mesh
            (create_mesh_overlay, reg1, ":bg_mesh"),
            (overlay_set_size, reg1, pos3),
            (position_set_x, pos1, ":pos_x"),
            (position_set_y, pos1, ":pos_y"),
            (overlay_set_position, reg1, pos1),
            (troop_set_slot, ":trp_obj_id", ":item_slot", -1),
          (try_end),
        (try_end),
        (set_container_overlay, -1), # end

        (str_store_string, s3, "@Attributes:"),
        (store_attribute_level, reg1, "$g_player_troop", ca_strength),
        (store_attribute_level, reg2, "$g_player_troop", ca_intelligence),
        (str_store_string, s3, "@{s3}^STR: {reg1}^INT: {reg2}^^Skills:"),
        (store_skill_level, reg1, skl_power_strike, "$g_player_troop"),
        (store_skill_level, reg2, skl_power_draw, "$g_player_troop"),
        (store_skill_level, reg3, skl_power_throw, "$g_player_troop"),
        (store_skill_level, reg4, skl_horse_archery, "$g_player_troop"),
        (str_store_string, s3, "@{s3}^Power Strike: {reg1}^Power Draw: {reg2}^Power Throw: {reg3}^Horse Archery: {reg4}^^Weapon Proficiencies:"),
        (store_proficiency_level, reg1, "$g_player_troop", wpt_one_handed_weapon),
        (store_proficiency_level, reg2, "$g_player_troop", wpt_two_handed_weapon),
        (store_proficiency_level, reg3, "$g_player_troop", wpt_polearm),
        (str_store_string, s3, "@{s3}^1 Hand Wpns: {reg1}^2 Hand Wpns: {reg2}^Polearms: {reg3}"),
        (create_text_overlay, reg0, "@{s3}", tf_double_space),
        (position_set_x, pos1, 420),
        (position_set_y, pos1, 50),
        (overlay_set_position, reg0, pos1),

        (str_store_string, s4, "str_empty_string"),
        (store_attribute_level, reg1, "$g_player_troop", ca_agility),
        (store_attribute_level, reg2, "$g_player_troop", ca_charisma),
        (str_store_string, s4, "@{s4}^AGI: {reg1}^CHA: {reg2}^^"),
        (store_skill_level, reg1, skl_ironflesh, "$g_player_troop"),
        (store_skill_level, reg2, skl_athletics, "$g_player_troop"),
        (store_skill_level, reg3, skl_shield, "$g_player_troop"),
        (store_skill_level, reg4, skl_riding, "$g_player_troop"),
        (str_store_string, s4, "@{s4}^Ironflesh: {reg1}^Athletics: {reg2}^Shield: {reg3}^Riding: {reg4}^^"),
        (store_proficiency_level, reg1, "$g_player_troop", wpt_archery),
        (store_proficiency_level, reg2, "$g_player_troop", wpt_crossbow),
        (store_proficiency_level, reg3, "$g_player_troop", wpt_throwing),
        (str_store_string, s4, "@{s4}^Archery: {reg1}^Crossbows: {reg2}^Throwing: {reg3}"),
        (create_text_overlay, reg0, "@{s4}", tf_double_space),
        (position_set_x, pos1, 630),
        (position_set_y, pos1, 50),
        (overlay_set_position, reg0, pos1),
        ################
        
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),

      #(ti_on_presentation_run,
        #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
      #]),

    (ti_on_presentation_mouse_enter_leave,
      [
      (store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":enter_leave"),

      (assign, ":trp_obj_id", "trp_bonus_chest_1"), # array to record obj's id
      (try_begin),
        (eq, ":enter_leave", 0),
        (try_for_range, ":item_slot", 0, 9),
          (troop_slot_eq, ":trp_obj_id", ":item_slot", ":object"),
          (overlay_get_position, pos0, ":object"),
          (troop_get_inventory_slot, ":cur_item", "$g_player_troop", ":item_slot"),
          (troop_get_inventory_slot_modifier, ":cur_imod", "$g_player_troop", ":item_slot"),
          (try_begin),
            (gt, ":cur_imod", 0),
            (show_item_details_with_modifier, ":cur_item", ":cur_imod", pos0, 100),
          (else_try),
            (show_item_details, ":cur_item", pos0, 100),
          (try_end),
          (assign, "$g_current_opened_item_details", ":item_slot"),
        (try_end),
      (else_try),
        (try_for_range, ":item_slot", 0, 9),
          (troop_slot_eq, ":trp_obj_id", ":item_slot", ":object"),
          (try_begin),
            (eq, "$g_current_opened_item_details", ":item_slot"),
            (close_item_details),
          (try_end),
        (try_end),
      (try_end),
    ]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_2"),
          (presentation_set_duration, 0),
        (try_end),

        (assign, ":num_of_heros", 0),
        (party_get_num_companion_stacks, ":num_stacks","p_main_party"),
        (try_for_range, ":i_stack", 0, ":num_stacks"),
          (party_stack_get_troop_id,":stack_troop","p_main_party",":i_stack"),
          (troop_is_hero, ":stack_troop"),
          (neg|troop_is_wounded, ":stack_troop"),
          (assign, ":trp_slot_prsnt_no", ":num_of_heros"),
          (val_add, ":num_of_heros", 1),
          (troop_slot_eq, "trp_temp_array_a", ":trp_slot_prsnt_no", ":object"),
          (troop_get_slot, ":cur_troop", "trp_temp_array_b", ":trp_slot_prsnt_no"),
          (assign, "$g_player_troop", ":cur_troop"),
          (start_presentation, "prsnt_change_commander"),
        (try_end),
      ]),
    ]),

  ("deposit_withdraw_money", 0, 0, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        (party_get_slot, ":chest_troop", "$current_town", slot_town_seneschal),
        (store_troop_gold, ":account_money", ":chest_troop"),
        (store_troop_gold, ":player_money", "trp_player"),

        (create_mesh_overlay, reg0, "mesh_message_window"),
        (position_set_x, pos1, 224),
        (position_set_y, pos1, 230),
        (overlay_set_position, reg0, pos1),
        
        (assign, reg1, ":account_money"),
        (create_text_overlay, reg0, "@{reg1}^money in the chest", tf_center_justify|tf_vertical_align_center),
        (position_set_x, pos1, 370),
        (position_set_y, pos1, 320),
        (overlay_set_position, reg0, pos1),

        (assign, reg2, ":player_money"),
        (create_text_overlay, reg0, "@{reg2}^money in your inventory", tf_center_justify|tf_vertical_align_center),
        (position_set_x, pos1, 630),
        (position_set_y, pos1, 320),
        (overlay_set_position, reg0, pos1),

        (create_combo_button_overlay, "$g_presentation_obj_1"),
        (position_set_x, pos1, 480),
        (position_set_y, pos1, 380),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, "$g_presentation_obj_1", pos1),
        (overlay_add_item, "$g_presentation_obj_1", "@Withdraw"),
        (overlay_add_item, "$g_presentation_obj_1", "@Deposit"),
        (overlay_set_val, "$g_presentation_obj_1", 1),
        
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 380),
        (val_add, ":player_money", 1),
        (create_number_box_overlay, "$g_presentation_obj_2", 0, ":player_money"),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (overlay_set_val, "$g_presentation_obj_2", 0),
        (overlay_set_display, "$g_presentation_obj_2", 1),
        (val_add, ":account_money", 1),
        (create_number_box_overlay, "$g_presentation_obj_3", 0, ":account_money"),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        (overlay_set_val, "$g_presentation_obj_3", 0),
        (overlay_set_display, "$g_presentation_obj_3", 0),
        
        (create_game_button_overlay, "$g_presentation_obj_5", "@Done"),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 250),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
      ]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_set_display, "$g_presentation_obj_2", 1),
            (overlay_set_display, "$g_presentation_obj_3", 0),
          (else_try),
            (overlay_set_display, "$g_presentation_obj_2", 0),
            (overlay_set_display, "$g_presentation_obj_3", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (party_get_slot, ":chest_troop", "$current_town", slot_town_seneschal),
          (gt, ":value", 0),
          (troop_remove_gold, "trp_player",":value"),
          (troop_add_gold, ":chest_troop", ":value"),
          (start_presentation, "prsnt_deposit_withdraw_money"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"),
          (party_get_slot, ":chest_troop", "$current_town", slot_town_seneschal),
          (gt, ":value", 0),
          (troop_remove_gold, ":chest_troop",":value"),
          (troop_add_gold, "trp_player", ":value"),
          (start_presentation, "prsnt_deposit_withdraw_money"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_5"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),

## Next new global variable for presentation object: $g_presentation_obj_31
  ("mod_option", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        (str_clear, s0),
        (create_text_overlay, "$g_presentation_obj_6", s0, tf_scrollable),
        (position_set_x, pos1, 25),
        (position_set_y, pos1, 50),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (position_set_x, pos1, 575),
        (position_set_y, pos1, 630),
        (overlay_set_area_size, "$g_presentation_obj_6", pos1),
        (set_container_overlay, "$g_presentation_obj_6"),

        (position_set_x, pos1, 25),
        (position_set_x, pos2, 475),
        
        (position_set_x, pos3, 1000),
        (position_set_y, pos3, 500),
        
        (assign, ":pos_y", 25),
        (assign, ":y_offset", 50),
        ## fog
        (create_text_overlay, reg0, "@Fog strength:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_number_box_overlay, "$g_presentation_obj_24", 0, 101),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_24", pos2),
        (get_global_haze_amount, ":cur_fog_amount"),
        (overlay_set_val, "$g_presentation_obj_24", ":cur_fog_amount"),
        
        (create_slider_overlay, "$g_presentation_obj_admin_panel_1", 0, 101),
        (overlay_set_val, "$g_presentation_obj_admin_panel_1", ":cur_fog_amount"),
        (overlay_set_size, "$g_presentation_obj_admin_panel_1", pos3),
        (position_set_x, pos4, 155),
        (store_sub, ":cur_y", ":pos_y", 15),
        (position_set_y, pos4, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_1", pos4),
        (val_add, ":pos_y", ":y_offset"),
        ## cloud
        (create_text_overlay, reg0, "@Cloud amount:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_number_box_overlay, "$g_presentation_obj_25", 0, 101),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_25", pos2),
        (get_global_cloud_amount, ":cur_cloud_amount"),
        (overlay_set_val, "$g_presentation_obj_25", ":cur_cloud_amount"),
        
        (create_slider_overlay, "$g_presentation_obj_admin_panel_2", 0, 101),
        (overlay_set_val, "$g_presentation_obj_admin_panel_2", ":cur_cloud_amount"),
        (overlay_set_size, "$g_presentation_obj_admin_panel_2", pos3),
        (position_set_x, pos4, 155),
        (store_sub, ":cur_y", ":pos_y", 15),
        (position_set_y, pos4, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_2", pos4),
        (val_add, ":pos_y", ":y_offset"),
        ## rain/snow
        (create_text_overlay, reg0, "@Probability of rain/snow (%):", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_number_box_overlay, "$g_presentation_obj_18", 0, 101),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_18", pos2),
        (overlay_set_val, "$g_presentation_obj_18", "$g_rand_rain_limit"),
        
        (create_slider_overlay, "$g_presentation_obj_admin_panel_3", 0, 101),
        (overlay_set_val, "$g_presentation_obj_admin_panel_3", "$g_rand_rain_limit"),
        (overlay_set_size, "$g_presentation_obj_admin_panel_3", pos3),
        (position_set_x, pos4, 155),
        (store_sub, ":cur_y", ":pos_y", 15),
        (position_set_y, pos4, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_3", pos4),
        (val_add, ":pos_y", ":y_offset"),
        
        # division line, offset: 25%
        (store_mul, ":line_offset", ":y_offset", -25),
        (val_div, ":line_offset", 100),
        (store_add, ":line_pos_y", ":pos_y", ":line_offset"),
        (call_script, "script_prsnt_lines", 520, 2, 25, ":line_pos_y", 0),
        
        ## shot distance
        (create_text_overlay, reg0, "@Report shot distance:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_check_box_overlay, "$g_presentation_obj_5", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_5", pos2),
        (overlay_set_val, "$g_presentation_obj_5", "$g_report_shot_distance"),
        (val_add, ":pos_y", ":y_offset"),
        
        ## size of battle minimap
        (create_text_overlay, reg0, "@Size of battle minimap (%):", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_number_box_overlay, "$g_presentation_obj_14", 60, 111),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_14", pos2),
        (overlay_set_val, "$g_presentation_obj_14", "$g_minimap_ratio"),
        
        (create_slider_overlay, "$g_presentation_obj_admin_panel_4", 60, 111),
        (overlay_set_val, "$g_presentation_obj_admin_panel_4", "$g_minimap_ratio"),
        (overlay_set_size, "$g_presentation_obj_admin_panel_4", pos3),
        (position_set_x, pos4, 155),
        (store_sub, ":cur_y", ":pos_y", 15),
        (position_set_y, pos4, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_4", pos4),
        (val_add, ":pos_y", ":y_offset"),
        ## show battle minimap
        (create_text_overlay, reg0, "@Show battle minimap:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_check_box_overlay, "$g_presentation_obj_13", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_13", pos2),
        (overlay_set_val, "$g_presentation_obj_13", "$g_show_minimap"),
        (val_add, ":pos_y", ":y_offset"),
        
        ## reinforcement waves
        (create_text_overlay, reg0, "@Reinforcement waves:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_number_box_overlay, "$g_presentation_obj_26", 2, 101),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_26", pos2),
        (overlay_set_val, "$g_presentation_obj_26", "$g_reinforcement_stage"),
        (create_slider_overlay, "$g_presentation_obj_admin_panel_5", 2, 101),
        (overlay_set_val, "$g_presentation_obj_admin_panel_5", "$g_reinforcement_stage"),
        (overlay_set_size, "$g_presentation_obj_admin_panel_5", pos3),
        (position_set_x, pos4, 155),
        (store_sub, ":cur_y", ":pos_y", 15),
        (position_set_y, pos4, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_5", pos4),
        (val_add, ":pos_y", ":y_offset"),

        # division line, offset: 25%
        #(store_mul, ":line_offset", ":y_offset", -25),
        #(val_div, ":line_offset", 100),
        #(store_add, ":line_pos_y", ":pos_y", ":line_offset"),
        #(call_script, "script_prsnt_lines", 520, 2, 25, ":line_pos_y", 0),

        ## horse charging for AI troops
#        (create_text_overlay, reg0, "@Horse charging for AI troops:", tf_left_align),
#        (position_set_y, pos1, ":pos_y"),
#        (overlay_set_position, reg0, pos1),
#        (create_check_box_overlay, "$g_presentation_obj_29", "mesh_checkbox_off", "mesh_checkbox_on"),
#        (position_set_y, pos2, ":pos_y"),
#        (overlay_set_position, "$g_presentation_obj_29", pos2),
#        (overlay_set_val, "$g_presentation_obj_29", "$g_horse_charging_for_ai"),
#        (val_add, ":pos_y", ":y_offset"),
        
        ## horse charging for player
#        (create_text_overlay, reg0, "@Horse charging for the player:", tf_left_align),
#        (position_set_y, pos1, ":pos_y"),
#        (overlay_set_position, reg0, pos1),
#        (create_check_box_overlay, "$g_presentation_obj_30", "mesh_checkbox_off", "mesh_checkbox_on"),
#        (position_set_y, pos2, ":pos_y"),
#        (overlay_set_position, "$g_presentation_obj_30", pos2),
#        (overlay_set_val, "$g_presentation_obj_30", "$g_horse_charging_for_player"),
#        (val_add, ":pos_y", ":y_offset"),
        
        ## cavalry convert to other troop class
        #(create_text_overlay, reg0, "@When cavalry is dismounted, convert to:", tf_left_align),
        #(position_set_y, pos1, ":pos_y"),
        #(overlay_set_position, reg0, pos1),
        #(position_set_x, pos5, 1000),
        #(position_set_y, pos5, 900),
        #(overlay_set_size, reg0, pos5),
        #(create_combo_button_overlay, "$g_presentation_obj_27"),
        #(position_set_x, pos2, 520),
        #(position_set_y, pos2, ":pos_y"),
        #(overlay_set_position, "$g_presentation_obj_27", pos2),
        #(position_set_x, pos5, 600),
        #(position_set_y, pos5, 600),
        #(overlay_set_size, "$g_presentation_obj_27", pos5),
        #(try_for_range_backwards, ":class_id", -1, 9),
          #(try_begin),
            #(eq, ":class_id", -1),
            #(str_store_string, s0, "@Disabled"),
          #(else_try),
            #(str_store_class_name, s0, ":class_id"),
          #(try_end),
          #(overlay_add_item, "$g_presentation_obj_27", s0),
        #(try_end),
        #(store_sub, ":presentation_obj_val", 8, "$g_cavalry_2nd_class"),
        #(overlay_set_val, "$g_presentation_obj_27", ":presentation_obj_val"),
        #(position_set_x, pos2, 475), # back to default value
        #(val_add, ":pos_y", ":y_offset"),
        
        ## archers convert to other troop class
        #(create_text_overlay, reg0, "@When archer's ammo has run out, convert to:", tf_left_align),
        #(position_set_y, pos1, ":pos_y"),
        #(overlay_set_position, reg0, pos1),
        #(position_set_x, pos5, 1000),
        #(position_set_y, pos5, 900),
        #(overlay_set_size, reg0, pos5),
        #(create_combo_button_overlay, "$g_presentation_obj_28"),
        #(position_set_x, pos2, 520),
        #(position_set_y, pos2, ":pos_y"),
        #(overlay_set_position, "$g_presentation_obj_28", pos2),
        #(position_set_x, pos5, 600),
        #(position_set_y, pos5, 600),
        #(overlay_set_size, "$g_presentation_obj_28", pos5),
        #(try_for_range_backwards, ":class_id", -1, 9),
          #(try_begin),
            #(eq, ":class_id", -1),
            #(str_store_string, s0, "@Disabled"),
          #(else_try),
            #(str_store_class_name, s0, ":class_id"),
          #(try_end),
          #(overlay_add_item, "$g_presentation_obj_28", s0),
        #(try_end),
        #(store_sub, ":presentation_obj_val", 8, "$g_archer_2nd_class"),
        #(overlay_set_val, "$g_presentation_obj_28", ":presentation_obj_val"),
        #(position_set_x, pos2, 475), # back to default value
        #(val_add, ":pos_y", ":y_offset"),
        
        # division line, offset: 25%
        (store_mul, ":line_offset", ":y_offset", -25),
        (val_div, ":line_offset", 100),
        (store_add, ":line_pos_y", ":pos_y", ":line_offset"),
        (call_script, "script_prsnt_lines", 520, 2, 25, ":line_pos_y", 0),

        ## skill penalty
        (create_text_overlay, reg0, "@Skill penalty by encumbrance:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_check_box_overlay, "$g_presentation_obj_9", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_9", pos2),
        (overlay_set_val, "$g_presentation_obj_9", "$g_encumbrance_penalty"),
        (val_add, ":pos_y", ":y_offset"),
        ## NPCs' complaints
        (create_text_overlay, reg0, "@Disable NPCs' complaints:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_check_box_overlay, "$g_presentation_obj_11", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_11", pos2),
        (overlay_set_val, "$g_presentation_obj_11", "$disable_npc_complaints"),
        (val_add, ":pos_y", ":y_offset"),
        ## morale threshold
        (create_text_overlay, reg0, "@Morale threshold on consuming food:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_number_box_overlay, "$g_presentation_obj_23", 33, 100),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_23", pos2),
        (val_clamp, "$g_morale_threshold", 33, 100),
        (overlay_set_val, "$g_presentation_obj_23", "$g_morale_threshold"),
        
        (create_slider_overlay, "$g_presentation_obj_admin_panel_6", 33, 100),
        (overlay_set_val, "$g_presentation_obj_admin_panel_6", "$g_morale_threshold"),
        (overlay_set_size, "$g_presentation_obj_admin_panel_6", pos3),
        (position_set_x, pos4, 155),
        (store_sub, ":cur_y", ":pos_y", 15),
        (position_set_y, pos4, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_6", pos4),
        (val_add, ":pos_y", ":y_offset"),
        ## speed of battles
        # (create_text_overlay, reg0, "@Speed of battles on the map:", tf_left_align),
        # (position_set_y, pos1, ":pos_y"),
        # (overlay_set_position, reg0, pos1),
        # (create_number_box_overlay, "$g_presentation_obj_15", 1, 4),
        # (position_set_y, pos2, ":pos_y"),
        # (overlay_set_position, "$g_presentation_obj_15", pos2),
        # (val_clamp, "$g_speed_ai_battles", 1, 4),
        # (overlay_set_val, "$g_presentation_obj_15", "$g_speed_ai_battles"),
        
        # (create_slider_overlay, "$g_presentation_obj_admin_panel_7", 1, 4),
        # (overlay_set_val, "$g_presentation_obj_admin_panel_7", "$g_speed_ai_battles"),
        # (overlay_set_size, "$g_presentation_obj_admin_panel_7", pos3),
        # (position_set_x, pos4, 155),
        # (store_sub, ":cur_y", ":pos_y", 15),
        # (position_set_y, pos4, ":cur_y"),
        # (overlay_set_position, "$g_presentation_obj_admin_panel_7", pos4),
        # (val_add, ":pos_y", ":y_offset"),
        ## global parties speed
        (create_text_overlay, reg0, "@Movement speed of all parties (%):", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_number_box_overlay, "$g_presentation_obj_17", 20, 151),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_17", pos2),
        (store_add, ":global_speed_ratio", "$global_speed_modifier", 100),
        (val_clamp, ":global_speed_ratio", 20, 151),
        (overlay_set_val, "$g_presentation_obj_17", ":global_speed_ratio"),
        
        (create_slider_overlay, "$g_presentation_obj_admin_panel_8", 20, 151),
        (overlay_set_val, "$g_presentation_obj_admin_panel_8", ":global_speed_ratio"),
        (overlay_set_size, "$g_presentation_obj_admin_panel_8", pos3),
        (position_set_x, pos4, 155),
        (store_sub, ":cur_y", ":pos_y", 15),
        (position_set_y, pos4, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_8", pos4),
        (val_add, ":pos_y", ":y_offset"),
        
        # division line, offset: 25%
        (store_mul, ":line_offset", ":y_offset", -25),
        (val_div, ":line_offset", 100),
        (store_add, ":line_pos_y", ":pos_y", ":line_offset"),
        (call_script, "script_prsnt_lines", 520, 2, 25, ":line_pos_y", 0),
        
         ## names of enemy
        (create_text_overlay, reg0, "@Show names of enemy troops:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_check_box_overlay, "$g_presentation_obj_22", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_22", pos2),
        (val_min, "$g_name_of_enemy", 1),
        (overlay_set_val, "$g_presentation_obj_22", "$g_name_of_enemy"),
        (val_add, ":pos_y", ":y_offset"),
        ## names of ally
        (create_text_overlay, reg0, "@Show names of ally troops:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_check_box_overlay, "$g_presentation_obj_21", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_21", pos2),
        (val_min, "$g_name_of_ally", 1),
        (overlay_set_val, "$g_presentation_obj_21", "$g_name_of_ally"),
        (val_add, ":pos_y", ":y_offset"),
        
        ## HP bars of enemy
        (create_text_overlay, reg0, "@Show HP bars of enemy troops:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_check_box_overlay, "$g_presentation_obj_8", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_8", pos2),
        (overlay_set_val, "$g_presentation_obj_8", "$g_hp_bar_enemy"),
        (val_add, ":pos_y", ":y_offset"),
        ## HP bars of ally
        (create_text_overlay, reg0, "@Show HP bars of ally troops:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_check_box_overlay, "$g_presentation_obj_7", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_7", pos2),
        (overlay_set_val, "$g_presentation_obj_7", "$g_hp_bar_ally"),
        (val_add, ":pos_y", ":y_offset"),
        ## distance limit
        (create_text_overlay, reg0, "@Distance limit for showing HP bars:", tf_left_align),
        (position_set_y, pos1, ":pos_y"),
        (overlay_set_position, reg0, pos1),
        (create_number_box_overlay, "$g_presentation_obj_10", 3, 81),
        (position_set_y, pos2, ":pos_y"),
        (overlay_set_position, "$g_presentation_obj_10", pos2),
        (val_max, "$g_hp_bar_dis_limit", 3),
        (overlay_set_val, "$g_presentation_obj_10", "$g_hp_bar_dis_limit"),
        
        (create_slider_overlay, "$g_presentation_obj_admin_panel_9", 3, 81),
        (overlay_set_val, "$g_presentation_obj_admin_panel_9", "$g_hp_bar_dis_limit"),
        (overlay_set_size, "$g_presentation_obj_admin_panel_9", pos3),
        (position_set_x, pos4, 155),
        (store_sub, ":cur_y", ":pos_y", 15),
        (position_set_y, pos4, ":cur_y"),
        (overlay_set_position, "$g_presentation_obj_admin_panel_9", pos4),
        (val_add, ":pos_y", ":y_offset"),
        
        (set_container_overlay, -1),

        (str_store_string, s0, "@About morale threshold: If your party's morale is below this value, the speed of consuming food will be twice as much as normal, and the bonus to party morale of all food will be also doubled"),
        (create_text_overlay, reg0, s0, tf_double_space|tf_scrollable),
        (position_set_x, pos1, 680),
        (position_set_y, pos1, 400),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg0, pos1),
        (position_set_x, pos1, 300),
        (position_set_y, pos1, 120),
        (overlay_set_area_size, reg0, pos1),

        ## cheat mode
#        (create_text_overlay, reg0, "@Enable cheat mode:", tf_left_align),
#        (position_set_x, pos1, 680),
#        (position_set_y, pos1, 275),
#        (overlay_set_position, reg0, pos1),
#        (create_check_box_overlay, "$g_presentation_obj_12", "mesh_checkbox_off", "mesh_checkbox_on"),
#        (position_set_x, pos1, 880),
#        (position_set_y, pos1, 280),
#        (overlay_set_position, "$g_presentation_obj_12", pos1),
#        (overlay_set_val, "$g_presentation_obj_12", "$cheat_mode"),
        
        # change damage_to_enemy
        (create_combo_button_overlay, "$g_presentation_obj_1"),
        (position_set_x, pos1, 810),
        (position_set_y, pos1, 160),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (overlay_add_item, "$g_presentation_obj_1", "@Normal"),
        (overlay_add_item, "$g_presentation_obj_1", "@Reduced to 3/4"),
        (overlay_add_item, "$g_presentation_obj_1", "@Reduced to 1/2"),
        (overlay_set_val, "$g_presentation_obj_1", "$g_damage_to_enemy"),

        (create_text_overlay, reg0, "@Damage to enemies:", tf_center_justify),
        (position_set_x, pos1, 810),
        (position_set_y, pos1, 200),
        (overlay_set_position, reg0, pos1),
        
        # done
        (create_game_button_overlay, "$g_presentation_obj_20", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_20", pos1),
        
#        # cheat: change Game difficulty
#        (create_combo_button_overlay, "$g_presentation_obj_1"),
#        (position_set_x, pos1, 850),
#        (position_set_y, pos1, 300),
#        (overlay_set_position, "$g_presentation_obj_1", pos1),
#        (overlay_add_item, "$g_presentation_obj_1", "@Hell"),
#        (overlay_add_item, "$g_presentation_obj_1", "@Nightmare"),
#        (overlay_add_item, "$g_presentation_obj_1", "@Normal"),
#        (store_sub, ":game_difficulty", 3, "$g_game_difficulty"),
#        (overlay_set_val, "$g_presentation_obj_1", ":game_difficulty"),
#
#        (create_text_overlay, "$g_presentation_obj_2", "@Game difficulty:", tf_center_justify),
#        (position_set_x, pos1, 830),
#        (position_set_y, pos1, 340),
#        (overlay_set_position, "$g_presentation_obj_2", pos1),
#
#        (position_set_x, pos1, 800),
#        (position_set_y, pos1, 800),
#        (overlay_set_size, "$g_presentation_obj_1", pos1),
#        (overlay_set_size, "$g_presentation_obj_2", pos1),
#        (overlay_set_display, "$g_presentation_obj_1", "$cheat_mode"),
#        (overlay_set_display, "$g_presentation_obj_2", "$cheat_mode"),
        
        # player carries banner
        #(create_combo_button_overlay, "$g_presentation_obj_3"),
        #(position_set_x, pos1, 850),
        #(position_set_y, pos1, 180),
        #(overlay_set_position, "$g_presentation_obj_3", pos1),
        #(overlay_add_item, "$g_presentation_obj_3", "@No"),
        #(overlay_add_item, "$g_presentation_obj_3", "@Yes"),
        #(overlay_set_val, "$g_presentation_obj_3", "$g_player_carry_banner"),

        #(create_text_overlay, reg0, "@Player carries a banner on back:", tf_center_justify),
        #(position_set_x, pos1, 830),
        #(position_set_y, pos1, 220),
        #(overlay_set_position, reg0, pos1),
        #(position_set_x, pos1, 800),
        #(position_set_y, pos1, 800),
        #(overlay_set_size, reg0, pos1),
        
        # others carry banner
        #(create_combo_button_overlay, "$g_presentation_obj_4"),
        #(position_set_x, pos1, 850),
        #(position_set_y, pos1, 100),
        #(overlay_set_position, "$g_presentation_obj_4", pos1),
        #(overlay_add_item, "$g_presentation_obj_4", "@All not"),
        #(overlay_add_item, "$g_presentation_obj_4", "@Heroes"),
        #(overlay_add_item, "$g_presentation_obj_4", "@Ally troops"),
        #(overlay_add_item, "$g_presentation_obj_4", "@All troops"),
        #(overlay_set_val, "$g_presentation_obj_4", "$g_others_carry_banner"),

        #(create_text_overlay, reg0, "@Others carries a banner on back:", tf_center_justify),
        #(position_set_x, pos1, 830),
        #(position_set_y, pos1, 140),
        #(overlay_set_position, reg0, pos1),
        #(position_set_x, pos1, 800),
        #(position_set_y, pos1, 800),
        #(overlay_set_size, reg0, pos1),
        
        #(position_set_x, pos1, 800),
        #(position_set_y, pos1, 800),
        #(overlay_set_size, "$g_presentation_obj_3", pos1),
        #(overlay_set_size, "$g_presentation_obj_4", pos1),
        
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),

      #(ti_on_presentation_run,
        #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
      #]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_admin_panel_1"),
          (set_global_haze_amount, ":value"),
          (overlay_set_val, "$g_presentation_obj_24", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_admin_panel_2"),
          (set_global_cloud_amount, ":value"),
          (overlay_set_val, "$g_presentation_obj_25", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_admin_panel_3"),
          (assign, "$g_rand_rain_limit", ":value"),
          (overlay_set_val, "$g_presentation_obj_18", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_admin_panel_4"),
          (assign, "$g_minimap_ratio", ":value"),
          (overlay_set_val, "$g_presentation_obj_14", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_admin_panel_5"),
          (assign, "$g_reinforcement_stage", ":value"),
          (overlay_set_val, "$g_presentation_obj_26", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_admin_panel_6"),
          (assign, "$g_morale_threshold", ":value"),
          (overlay_set_val, "$g_presentation_obj_23", ":value"),
        # (else_try),
          # (eq, ":object", "$g_presentation_obj_admin_panel_7"),
          # (assign, "$g_speed_ai_battles", ":value"),
          # (overlay_set_val, "$g_presentation_obj_15", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_admin_panel_8"),
          (store_sub, "$global_speed_modifier", ":value", 100),
          (overlay_set_val, "$g_presentation_obj_17", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_admin_panel_9"),
          (assign, "$g_hp_bar_dis_limit", ":value"),
          (overlay_set_val, "$g_presentation_obj_10", ":value"),
        (try_end),

        (try_begin),
#          (eq, ":object", "$g_presentation_obj_1"),
#          (store_sub, "$g_game_difficulty", 3, ":value"),
#        (else_try),
          #(eq, ":object", "$g_presentation_obj_3"),
          #(assign, "$g_player_carry_banner", ":value"),
        #(else_try),
          #(eq, ":object", "$g_presentation_obj_4"),
          #(assign, "$g_others_carry_banner", ":value"),
        #(else_try),
          (eq, ":object", "$g_presentation_obj_1"),
          (assign, "$g_damage_to_enemy", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_5"),
          (assign, "$g_report_shot_distance", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_7"),
          (assign, "$g_hp_bar_ally", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_8"),
          (assign, "$g_hp_bar_enemy", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_9"),
          (assign, "$g_encumbrance_penalty", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_10"),
          (assign, "$g_hp_bar_dis_limit", ":value"),
          (overlay_set_val, "$g_presentation_obj_admin_panel_9", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_11"),
          (assign, "$disable_npc_complaints", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_12"),
          (assign, "$cheat_mode", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_23"),
          (assign, "$g_morale_threshold", ":value"),
          (overlay_set_val, "$g_presentation_obj_admin_panel_6", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_26"),
          (assign, "$g_reinforcement_stage", ":value"),
          (overlay_set_val, "$g_presentation_obj_admin_panel_5", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_14"),
          (assign, "$g_minimap_ratio", ":value"),
          (overlay_set_val, "$g_presentation_obj_admin_panel_4", ":value"),
        # (else_try),
          # (eq, ":object", "$g_presentation_obj_15"),
          # (assign, "$g_speed_ai_battles", ":value"),
          # (overlay_set_val, "$g_presentation_obj_admin_panel_7", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_17"),
          (store_sub, "$global_speed_modifier", ":value", 100),
          (overlay_set_val, "$g_presentation_obj_admin_panel_8", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_18"),
          (assign, "$g_rand_rain_limit", ":value"),
          (overlay_set_val, "$g_presentation_obj_admin_panel_3", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_25"),
          (set_global_cloud_amount, ":value"),
          (overlay_set_val, "$g_presentation_obj_admin_panel_2", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_24"),
          (set_global_haze_amount, ":value"),
          (overlay_set_val, "$g_presentation_obj_admin_panel_1", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_13"),
          (assign, "$g_show_minimap", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_22"),
          (assign, "$g_name_of_enemy", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_21"),
          (assign, "$g_name_of_ally", ":value"),
        #(else_try),
          #(eq, ":object", "$g_presentation_obj_27"),
          #(store_sub, "$g_cavalry_2nd_class", 8, ":value"),
        #(else_try),
          #(eq, ":object", "$g_presentation_obj_28"),
          #(store_sub, "$g_archer_2nd_class", 8, ":value"),
## NMC begin
# I don't see the sense in horse_charging, so I am deactivating it.
#        (else_try),
#          (eq, ":object", "$g_presentation_obj_29"),
#          (assign, "$g_horse_charging_for_ai", ":value"),
#        (else_try),
#          (eq, ":object", "$g_presentation_obj_30"),
#          (assign, "$g_horse_charging_for_player", ":value"),
## NMC end
        (else_try),
          (eq, ":object", "$g_presentation_obj_20"),
          (presentation_set_duration, 0),
        (try_end),
      ]),
    ]),

  ("recruit_plan", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
  
        (call_script, "script_get_town_faction_for_recruiting", "$current_town"),
        (assign, ":party_faction", reg0),
        (str_store_faction_name, s1, ":party_faction"),
        
        (game_get_reduce_campaign_ai, ":reduce_campaign_ai"),
        (assign, ":reinforcement_cost", 450),
        (try_begin), 
          (eq, ":reduce_campaign_ai", 0), #hard
          (assign, ":reinforcement_cost", 600),
        (else_try), 
          (eq, ":reduce_campaign_ai", 1), #moderate
          (assign, ":reinforcement_cost", 450),
        (else_try), 
          (eq, ":reduce_campaign_ai", 2), #easy
          (assign, ":reinforcement_cost", 300),
        (try_end),
        (assign, reg4, ":reinforcement_cost"),
        
        (party_get_slot, reg1, "$current_town", slot_town_recruit_gold),
        (store_div, reg2, reg1, ":reinforcement_cost"),
        (store_sub, reg3, reg2, 1),
        (store_troop_gold, reg5, "trp_player"),
        (party_get_slot, ":party_type", "$current_town", slot_party_type),
        (assign, reg6, 0),
        (try_begin),
          (eq, ":party_type", spt_castle),
          (assign, reg6, 1),
        (try_end),
        
        #(create_text_overlay, reg0, "@In this {reg6?castle:town}, you can recruit from the {s1}. Recruiting for one day costs {reg4} denars.^^There are {reg1} denars left, so recruiting goes on for {reg2} {reg3?days:day}).^^Currently, you have {reg5} denars in your package.", tf_scrollable),
        (create_text_overlay, reg0, "@You can recruit troops of {s1} for this {reg6?castle:town}. Recruiting will costs {reg4} dinaers. You have {reg1} dinaers left here(can recruit for {reg2} {reg3?times:time}) and have {reg5} dinaers in your package.", tf_scrollable),
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 300),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 300),
        (overlay_set_area_size, reg0, pos1),
        
        (create_combo_button_overlay, "$g_presentation_obj_1"),
        (position_set_x, pos1, 380),
        (position_set_y, pos1, 280),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, "$g_presentation_obj_1", pos1),
        (overlay_add_item, "$g_presentation_obj_1", "@Decrease the expense of recruiting"),
        (overlay_add_item, "$g_presentation_obj_1", "@Increase the expense of recruiting"),
        (overlay_set_val, "$g_presentation_obj_1", 1),
        
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 280),
        # Increase
        (store_troop_gold, ":player_gold", "trp_player"),
        (val_add, ":player_gold", 1),
        (create_number_box_overlay, "$g_presentation_obj_2", 0, ":player_gold"),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (overlay_set_val, "$g_presentation_obj_2", 0),
        (overlay_set_display, "$g_presentation_obj_2", 1),
        # Decrease
        (party_get_slot, ":recruit_gold", "$current_town", slot_town_recruit_gold),
        (val_add, ":recruit_gold", 1),
        (create_number_box_overlay, "$g_presentation_obj_3", 0, ":recruit_gold"),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        (overlay_set_val, "$g_presentation_obj_3", 0),
        (overlay_set_display, "$g_presentation_obj_3", 0),
        
        (create_game_button_overlay, "$g_presentation_obj_5", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
      ]),
  
    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
  
        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (try_begin),
            (eq, ":value", 1),
            (overlay_set_display, "$g_presentation_obj_2", 1),
            (overlay_set_display, "$g_presentation_obj_3", 0),
          (else_try),
            (overlay_set_display, "$g_presentation_obj_2", 0),
            (overlay_set_display, "$g_presentation_obj_3", 1),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (gt, ":value", 0),
          (troop_remove_gold, "trp_player", ":value"),
          (party_get_slot, ":recruit_gold", "$current_town", slot_town_recruit_gold),
          (val_add, ":recruit_gold", ":value"),
          (party_set_slot, "$current_town", slot_town_recruit_gold, ":recruit_gold"),
          (start_presentation, "prsnt_recruit_plan"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"),
          (gt, ":value", 0),
          (troop_add_gold, "trp_player", ":value"),
          (party_get_slot, ":recruit_gold", "$current_town", slot_town_recruit_gold),
          (val_sub, ":recruit_gold", ":value"),
          (party_set_slot, "$current_town", slot_town_recruit_gold, ":recruit_gold"),
          (start_presentation, "prsnt_recruit_plan"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_5"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),
  
  ("change_all_factions_color", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        
        (create_combo_button_overlay, "$g_presentation_obj_1"),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 680),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        
        # faction list
        (troop_set_slot, "trp_temp_array_a", 0, "fac_deserters"),
        (troop_set_slot, "trp_temp_array_a", 1, "fac_outlaws"),
        (troop_set_slot, "trp_temp_array_a", 2, "fac_player_supporters_faction"),
        (troop_set_slot, "trp_temp_array_a", 3, "fac_kingdom_6"),
        (troop_set_slot, "trp_temp_array_a", 4, "fac_kingdom_5"),
        (troop_set_slot, "trp_temp_array_a", 5, "fac_kingdom_4"),
        (troop_set_slot, "trp_temp_array_a", 6, "fac_kingdom_3"),
        (troop_set_slot, "trp_temp_array_a", 7, "fac_kingdom_2"),
        (troop_set_slot, "trp_temp_array_a", 8, "fac_kingdom_1"),
        # default color list
        (troop_set_slot, "trp_temp_array_b", 0, 0xff8080),
        (troop_set_slot, "trp_temp_array_b", 1, 0xcc66cc),
        (troop_set_slot, "trp_temp_array_b", 2, 0xFF4433),
        (troop_set_slot, "trp_temp_array_b", 3, 0xDDDD33),
        (troop_set_slot, "trp_temp_array_b", 4, 0x33DD33),
        (troop_set_slot, "trp_temp_array_b", 5, 0x33DDDD),
        (troop_set_slot, "trp_temp_array_b", 6, 0xCC99FF),
        (troop_set_slot, "trp_temp_array_b", 7, 0x9696FF),
        (troop_set_slot, "trp_temp_array_b", 8, 0xEE7744),
        
        (try_for_range, ":cur_slot", 0, 9),
          (troop_get_slot, ":cur_faction", "trp_temp_array_a", ":cur_slot"),
          (str_store_faction_name, s0, ":cur_faction"),
          (overlay_add_item, "$g_presentation_obj_1", s0),
        (try_end),
        (overlay_set_val, "$g_presentation_obj_1", "$temp"),
        
        ## name and color
        (troop_get_slot, ":cur_faction", "trp_temp_array_a", "$temp"),
        (str_store_faction_name, s0, ":cur_faction"),
        (create_text_overlay, reg1, "@Faction color of {s0}:", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (create_mesh_overlay, "$g_presentation_obj_2", "mesh_white_plane"),
        (position_set_x, pos1, 450),
        (position_set_y, pos1, 480),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (position_set_x, pos1, 5000),
        (position_set_y, pos1, 5000),
        (overlay_set_size, "$g_presentation_obj_2", pos1),
        (faction_get_color, ":faction_color", ":cur_faction"),
        (overlay_set_color, "$g_presentation_obj_2", ":faction_color"),
        
        ## sliders
        (position_set_x, pos1, 500),
        (create_slider_overlay, "$g_presentation_obj_3", 0, 255),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        (create_slider_overlay, "$g_presentation_obj_4", 0, 255),
        (position_set_y, pos1, 350),
        (overlay_set_position, "$g_presentation_obj_4", pos1),
        (create_slider_overlay, "$g_presentation_obj_5", 0, 255),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
        (store_mod, ":blue", ":faction_color", 0x100),
        (val_div, ":faction_color", 0x100),
        (store_mod, ":green", ":faction_color", 0x100),
        (val_div, ":faction_color", 0x100),
        (store_mod, ":red", ":faction_color", 0x100),
        (overlay_set_val, "$g_presentation_obj_3", ":red"),
        (overlay_set_val, "$g_presentation_obj_4", ":green"),
        (overlay_set_val, "$g_presentation_obj_5", ":blue"),
        (position_set_x, pos1, 1000),
        (position_set_y, pos1, 500),
        (overlay_set_size, "$g_presentation_obj_3", pos1),
        (overlay_set_size, "$g_presentation_obj_4", pos1),
        (overlay_set_size, "$g_presentation_obj_5", pos1),
        ## num boxes
        (position_set_x, pos1, 650),
        (create_number_box_overlay, "$g_presentation_obj_6", 0, 256),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (create_number_box_overlay, "$g_presentation_obj_7", 0, 256),
        (position_set_y, pos1, 350),
        (overlay_set_position, "$g_presentation_obj_7", pos1),
        (create_number_box_overlay, "$g_presentation_obj_8", 0, 256),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_8", pos1),
        (overlay_set_val, "$g_presentation_obj_6", ":red"),
        (overlay_set_val, "$g_presentation_obj_7", ":green"),
        (overlay_set_val, "$g_presentation_obj_8", ":blue"),
        (assign, reg2, ":red"),
        (assign, reg3, ":green"),
        (assign, reg4, ":blue"),
        ## text: r g b
        (position_set_x, pos1, 330),
        (create_text_overlay, reg1, "@Red:", tf_center_justify),
        (position_set_y, pos1, 400),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Green:", tf_center_justify),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg1, pos1),
        (create_text_overlay, reg1, "@Blue:", tf_center_justify),
        (position_set_y, pos1, 300),
        (overlay_set_position, reg1, pos1),
        
        ## HTML code
        (create_text_overlay, "$g_presentation_obj_9", "@ ", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 450),
        (overlay_set_position, "$g_presentation_obj_9", pos1),
        (call_script, "script_convert_rgb_code_to_html_code", reg2, reg3, reg4),
        (overlay_set_text, "$g_presentation_obj_9", "@HTML code: {s0}"),
        
        ## default and random
        (create_game_button_overlay, "$g_presentation_obj_11", "@Default"),
        (position_set_x, pos1, 420),
        (position_set_y, pos1, 230),
        (overlay_set_position, "$g_presentation_obj_11", pos1),
        (create_game_button_overlay, "$g_presentation_obj_12", "@Randomize"),
        (position_set_x, pos1, 580),
        (position_set_y, pos1, 230),
        (overlay_set_position, "$g_presentation_obj_12", pos1),
        
        ## color picker
        (create_mesh_overlay, reg1, "mesh_white_plane"),
        (position_set_x, pos1, 138),
        (position_set_y, pos1, 78),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 36100),
        (position_set_y, pos1, 6100),
        (overlay_set_size, reg1, pos1),
        (overlay_set_color, reg1, 0),
        
        (assign, ":pos_x", 140),
        (assign, ":pos_y", 80),
        (try_for_range, ":cur_slot", 0, 216),
          (create_image_button_overlay, reg1, "mesh_white_plane", "mesh_white_plane"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg1, pos1),
          (assign, ":cur_color", ":cur_slot"),
          (call_script, "script_convert_slot_no_to_color", ":cur_color"),
          (assign, ":dest_color", reg0),
          (overlay_set_color, reg1, ":dest_color"),
          (val_add, ":pos_x", 20),
          (try_begin),
            (eq, ":pos_x", 860),
            (assign, ":pos_x", 140),
            (val_add, ":pos_y", 20),
          (try_end),
          (troop_set_slot, "trp_temp_array_c", ":cur_slot", reg1),
        (try_end),
        
        ## done
        (create_game_button_overlay, "$g_presentation_obj_10", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_10", pos1),
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),

      #(ti_on_presentation_run,
        #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
      #]),
  
    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        
        (try_for_range, ":cur_slot", 0, 216),
          (troop_slot_eq, "trp_temp_array_c", ":cur_slot", ":object"),
          (assign, ":cur_color", ":cur_slot"),
          (call_script, "script_convert_slot_no_to_color", ":cur_color"),
          (assign, ":dest_color", reg0),
          (troop_get_slot, ":cur_faction", "trp_temp_array_a", "$temp"),
          (faction_set_color, ":cur_faction", ":dest_color"),
          (overlay_set_color, "$g_presentation_obj_2", ":dest_color"),
          (store_mod, ":blue", ":dest_color", 0x100),
          (val_div, ":dest_color", 0x100),
          (store_mod, ":green", ":dest_color", 0x100),
          (val_div, ":dest_color", 0x100),
          (store_mod, ":red", ":dest_color", 0x100),
          (overlay_set_val, "$g_presentation_obj_3", ":red"),
          (overlay_set_val, "$g_presentation_obj_4", ":green"),
          (overlay_set_val, "$g_presentation_obj_5", ":blue"),
          (overlay_set_val, "$g_presentation_obj_6", ":red"),
          (overlay_set_val, "$g_presentation_obj_7", ":green"),
          (overlay_set_val, "$g_presentation_obj_8", ":blue"),
          (assign, reg2, ":red"),
          (assign, reg3, ":green"),
          (assign, reg4, ":blue"),
          (call_script, "script_convert_rgb_code_to_html_code", reg2, reg3, reg4),
          (overlay_set_text, "$g_presentation_obj_9", "@HTML code: {s0}"),
        (try_end),
        
        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (assign, "$temp", ":value"),
          (start_presentation, "prsnt_change_all_factions_color"),
        (else_try),
          (this_or_next|eq, ":object", "$g_presentation_obj_3"),
          (eq, ":object", "$g_presentation_obj_6"),
          (overlay_set_val, "$g_presentation_obj_3", ":value"),
          (overlay_set_val, "$g_presentation_obj_6", ":value"),
          (assign, reg2, ":value"),
          (call_script, "script_get_dest_color_from_rgb", reg2, reg3, reg4),
          (assign, ":cur_color", reg0),
          (overlay_set_color, "$g_presentation_obj_2", ":cur_color"),
          (troop_get_slot, ":cur_faction", "trp_temp_array_a", "$temp"),
          (faction_set_color, ":cur_faction", ":cur_color"),
          (call_script, "script_convert_rgb_code_to_html_code", reg2, reg3, reg4),
          (overlay_set_text, "$g_presentation_obj_9", "@HTML code: {s0}"),
        (else_try),
          (this_or_next|eq, ":object", "$g_presentation_obj_4"),
          (eq, ":object", "$g_presentation_obj_7"),
          (overlay_set_val, "$g_presentation_obj_4", ":value"),
          (overlay_set_val, "$g_presentation_obj_7", ":value"),
          (assign, reg3, ":value"),
          (call_script, "script_get_dest_color_from_rgb", reg2, reg3, reg4),
          (assign, ":cur_color", reg0),
          (overlay_set_color, "$g_presentation_obj_2", ":cur_color"),
          (troop_get_slot, ":cur_faction", "trp_temp_array_a", "$temp"),
          (faction_set_color, ":cur_faction", ":cur_color"),
          (call_script, "script_convert_rgb_code_to_html_code", reg2, reg3, reg4),
          (overlay_set_text, "$g_presentation_obj_9", "@HTML code: {s0}"),
        (else_try),
          (this_or_next|eq, ":object", "$g_presentation_obj_5"),
          (eq, ":object", "$g_presentation_obj_8"),
          (overlay_set_val, "$g_presentation_obj_5", ":value"),
          (overlay_set_val, "$g_presentation_obj_8", ":value"),
          (assign, reg4, ":value"),
          (call_script, "script_get_dest_color_from_rgb", reg2, reg3, reg4),
          (assign, ":cur_color", reg0),
          (overlay_set_color, "$g_presentation_obj_2", ":cur_color"),
          (troop_get_slot, ":cur_faction", "trp_temp_array_a", "$temp"),
          (faction_set_color, ":cur_faction", ":cur_color"),
          (call_script, "script_convert_rgb_code_to_html_code", reg2, reg3, reg4),
          (overlay_set_text, "$g_presentation_obj_9", "@HTML code: {s0}"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_11"),
          (troop_get_slot, ":cur_faction", "trp_temp_array_a", "$temp"),
          (troop_get_slot, ":default_color", "trp_temp_array_b", "$temp"),
          (faction_set_color, ":cur_faction", ":default_color"),
          (overlay_set_color, "$g_presentation_obj_2", ":default_color"),
          (store_mod, ":blue", ":default_color", 0x100),
          (val_div, ":default_color", 0x100),
          (store_mod, ":green", ":default_color", 0x100),
          (val_div, ":default_color", 0x100),
          (store_mod, ":red", ":default_color", 0x100),
          (overlay_set_val, "$g_presentation_obj_3", ":red"),
          (overlay_set_val, "$g_presentation_obj_4", ":green"),
          (overlay_set_val, "$g_presentation_obj_5", ":blue"),
          (overlay_set_val, "$g_presentation_obj_6", ":red"),
          (overlay_set_val, "$g_presentation_obj_7", ":green"),
          (overlay_set_val, "$g_presentation_obj_8", ":blue"),
          (assign, reg2, ":red"),
          (assign, reg3, ":green"),
          (assign, reg4, ":blue"),
          (call_script, "script_convert_rgb_code_to_html_code", reg2, reg3, reg4),
          (overlay_set_text, "$g_presentation_obj_9", "@HTML code: {s0}"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_12"),
          (store_random_in_range, reg2, 0, 256),
          (store_random_in_range, reg3, 0, 256),
          (store_random_in_range, reg4, 0, 256),
          (overlay_set_val, "$g_presentation_obj_3", reg2),
          (overlay_set_val, "$g_presentation_obj_4", reg3),
          (overlay_set_val, "$g_presentation_obj_5", reg4),
          (overlay_set_val, "$g_presentation_obj_6", reg2),
          (overlay_set_val, "$g_presentation_obj_7", reg3),
          (overlay_set_val, "$g_presentation_obj_8", reg4),
          (call_script, "script_get_dest_color_from_rgb", reg2, reg3, reg4),
          (assign, ":cur_color", reg0),
          (overlay_set_color, "$g_presentation_obj_2", ":cur_color"),
          (troop_get_slot, ":cur_faction", "trp_temp_array_a", "$temp"),
          (faction_set_color, ":cur_faction", ":cur_color"),
          (call_script, "script_convert_rgb_code_to_html_code", reg2, reg3, reg4),
          (overlay_set_text, "$g_presentation_obj_9", "@HTML code: {s0}"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_10"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),
  
  ("redefine_keys", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        
        (call_script, "script_init_keys_array"),
        (try_begin),
          (eq, "$g_camera_up", 0),
          (assign, "$g_camera_up", key_up),
        (try_end),
        (try_begin),
          (eq, "$g_camera_down", 0),
          (assign, "$g_camera_down", key_down),
        (try_end),
        (try_begin),
          (eq, "$g_camera_left", 0),
          (assign, "$g_camera_left", key_left),
        (try_end),
        (try_begin),
          (eq, "$g_camera_right", 0),
          (assign, "$g_camera_right", key_right),
        (try_end),
        
        (try_for_range, ":cur_slot", 0, len(keys)),
          (troop_get_slot, ":key_no", "trp_temp_array_a", ":cur_slot"),
          (try_begin),
            (eq, ":key_no", "$g_camera_up"),
            (store_add, ":dest_string", "str_key_0", ":cur_slot"),
            (str_store_string, s1, ":dest_string"),
          (else_try),
            (eq, ":key_no", "$g_camera_down"),
            (store_add, ":dest_string", "str_key_0", ":cur_slot"),
            (str_store_string, s2, ":dest_string"),
          (else_try),
            (eq, ":key_no", "$g_camera_left"),
            (store_add, ":dest_string", "str_key_0", ":cur_slot"),
            (str_store_string, s3, ":dest_string"),
          (else_try),
            (eq, ":key_no", "$g_camera_right"),
            (store_add, ":dest_string", "str_key_0", ":cur_slot"),
            (str_store_string, s4, ":dest_string"),
          (try_end),
        (try_end),
        
        (assign, "$temp", -1),
        ## buttons
        (create_text_overlay, reg1, "@Raise the camera", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),
        (create_game_button_overlay, "$g_presentation_obj_1", s1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 550),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        
        (create_text_overlay, reg1, "@Lower the camera", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 400),
        (overlay_set_position, reg1, pos1),
        (create_game_button_overlay, "$g_presentation_obj_2", s2),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 350),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        
        (create_text_overlay, reg1, "@Zoom in", tf_center_justify),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),
        (create_game_button_overlay, "$g_presentation_obj_3", s3),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 450),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        
        (create_text_overlay, reg1, "@Zoom out", tf_center_justify),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),
        (create_game_button_overlay, "$g_presentation_obj_4", s4),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 450),
        (overlay_set_position, "$g_presentation_obj_4", pos1),
        
        (create_text_overlay, "$g_presentation_obj_5", "@Press a key", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, "$g_presentation_obj_5", pos1),
        (overlay_set_color, "$g_presentation_obj_5", 0),
        (overlay_set_display, "$g_presentation_obj_5", 0),
        
        # done
        (create_game_button_overlay, "$g_presentation_obj_10", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_10", pos1),
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),

    (ti_on_presentation_run,
      [
      ####### mouse fix pos system #######
      #(call_script, "script_mouse_fix_pos_run"),
      ####### mouse fix pos system #######
      
      (try_begin),
        (gt, "$temp", -1),
        (overlay_set_display, "$g_presentation_obj_5", 1),
      (else_try),
        (overlay_set_display, "$g_presentation_obj_5", 0),
      (try_end),
      (try_for_range, ":cur_slot", 0, len(keys)),
        (troop_get_slot, ":key_no", "trp_temp_array_a", ":cur_slot"),
        (key_clicked, ":key_no"),
        (gt, "$temp", -1),
        (try_begin),
          (eq, "$temp", "$g_presentation_obj_1"),
          (assign, "$g_camera_up", ":key_no"),
        (else_try),
          (eq, "$temp", "$g_presentation_obj_2"),
          (assign, "$g_camera_down", ":key_no"),
        (else_try),
          (eq, "$temp", "$g_presentation_obj_3"),
          (assign, "$g_camera_left", ":key_no"),
        (else_try),
          (eq, "$temp", "$g_presentation_obj_4"),
          (assign, "$g_camera_right", ":key_no"),
        (try_end),
        (store_add, ":dest_string", "str_key_0", ":cur_slot"),
        (str_store_string, s1, ":dest_string"),
        (overlay_set_text, "$temp", s1),
        (overlay_set_alpha, "$temp", 0xff),
        (assign, "$temp", -1),
      (try_end),
    ]),
  
    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        
        (set_fixed_point_multiplier, 1000),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),
          (assign, "$temp", "$g_presentation_obj_1"),
          (overlay_set_alpha, "$g_presentation_obj_1", 0x80),
          (overlay_set_alpha, "$g_presentation_obj_2", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_3", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_4", 0xff),
        (else_try),
          (eq, ":object", "$g_presentation_obj_2"),
          (assign, "$temp", "$g_presentation_obj_2"),
          (overlay_set_alpha, "$g_presentation_obj_1", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_2", 0x80),
          (overlay_set_alpha, "$g_presentation_obj_3", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_4", 0xff),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"),
          (assign, "$temp", "$g_presentation_obj_3"),
          (overlay_set_alpha, "$g_presentation_obj_1", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_2", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_3", 0x80),
          (overlay_set_alpha, "$g_presentation_obj_4", 0xff),
        (else_try),
          (eq, ":object", "$g_presentation_obj_4"),
          (assign, "$temp", "$g_presentation_obj_4"),
          (overlay_set_alpha, "$g_presentation_obj_1", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_2", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_3", 0xff),
          (overlay_set_alpha, "$g_presentation_obj_4", 0x80),
        (else_try),
          (eq, ":object", "$g_presentation_obj_10"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),
  
  ("sort_the_defenders", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        
        ## next presentation
        (assign, "$g_presentation_next_presentation", -1),
      
        (str_clear, s0),
        (create_text_overlay, "$g_presentation_obj_1", s0, tf_scrollable),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 50),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (position_set_x, pos1, 350),
        (position_set_y, pos1, 600),
        (overlay_set_area_size, "$g_presentation_obj_1", pos1),
        (set_container_overlay, "$g_presentation_obj_1"),
        
        (assign, ":pos_x", 150),
        (party_get_num_companion_stacks, ":num_stacks", "$current_town"),
        (store_mul, ":pos_y", ":num_stacks", 40),
        (val_sub, ":pos_y", 40),
        (val_max, ":pos_y", 560),
        (try_for_range, ":slot_no", 0, ":num_stacks"),
          (party_stack_get_troop_id, ":troop_no", "$current_town", ":slot_no"),
          (party_stack_get_size, ":stack_size", "$current_town", ":slot_no"),
          (party_stack_get_num_wounded, ":num_wounded", "$current_town", ":slot_no"),
          (str_store_troop_name, s1, ":troop_no"),
          (assign, reg2, ":stack_size"),
          (try_begin),
            (gt, ":num_wounded", 0),
            (store_sub, reg3, ":stack_size", ":num_wounded"),
            (str_store_string, s1, "@{s1}({reg3}/{reg2})"),
          (else_try),
            (str_store_string, s1, "@{s1}({reg2})"),
          (try_end),
          (create_game_button_overlay, reg1, "@{s1}"),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),
          (position_set_x, pos1, 240),
          (position_set_y, pos1, 32),
          (overlay_set_size, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_no", reg1),
          (val_sub, ":pos_y", 40),
        (try_end),
        (try_begin),
          (gt, "$g_cur_stack", -1),
          (troop_get_slot, ":dest_obj", "trp_temp_array_a", "$g_cur_stack"),
          (overlay_set_alpha, ":dest_obj", 0x80),
        (try_end),
        (set_container_overlay, -1),
        
        # Move up - Move Down
        (position_set_x, pos1, 750),
        (create_button_overlay, "$g_presentation_obj_2", "@Move to Top", tf_center_justify),
        (position_set_y, pos1, 570),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (create_button_overlay, "$g_presentation_obj_3", "@Move Up", tf_center_justify),
        (position_set_y, pos1, 515),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        (create_button_overlay, "$g_presentation_obj_4", "@Move Down", tf_center_justify),
        (position_set_y, pos1, 460),
        (overlay_set_position, "$g_presentation_obj_4", pos1),
        (create_button_overlay, "$g_presentation_obj_5", "@Move to Bottom", tf_center_justify),
        (position_set_y, pos1, 405),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
        
        # cur troop
        (try_begin),
          (gt, "$g_cur_stack", -1),
          (party_stack_get_troop_id, ":troop_no", "$current_town", "$g_cur_stack"),
          (store_mul, ":cur_troop", ":troop_no", 2), #with weapons
          (create_image_button_overlay_with_tableau_material, "$g_presentation_obj_6", -1, "tableau_game_party_window", ":cur_troop"),
          (position_set_x, pos1, 400),
          (position_set_y, pos1, 300),
          (overlay_set_position, "$g_presentation_obj_6", pos1),
          (position_set_x, pos1, 750),
          (position_set_y, pos1, 1000),
          (overlay_set_size, "$g_presentation_obj_6", pos1),
        (else_try),
          (create_mesh_overlay, "$g_presentation_obj_6", "mesh_white_plane"),
          (overlay_set_display, "$g_presentation_obj_6", 0),
        (try_end),
        
        # done
        (create_game_button_overlay, "$g_presentation_obj_10", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_10", pos1),
        
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),
    #(ti_on_presentation_run,
      #[
      ####### mouse fix pos system #######
      #(call_script, "script_mouse_fix_pos_run"),
      ####### mouse fix pos system #######
    #]),
    
    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),

        (party_get_num_companion_stacks, ":num_stacks", "$current_town"),
        (try_for_range, ":slot_no", 0, ":num_stacks"),
          (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
          (assign, "$g_cur_stack", ":slot_no"),
          (start_presentation, "prsnt_sort_the_defenders"),
        (try_end),
        
        (try_begin),
          (eq, ":object", "$g_presentation_obj_2"), # top
          (try_begin),
            (gt, "$g_cur_stack", 0),
            (store_sub, ":times", ":num_stacks", 1),
            (call_script, "script_move_one_stack_to_the_bottom", "$current_town", "$g_cur_stack", 1),
            (call_script, "script_move_one_stack_to_the_bottom", "$current_town", 0, ":times"),
            (assign, "$g_cur_stack", 0),
            (start_presentation, "prsnt_sort_the_defenders"),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_3"), # up
          (try_begin),
            (gt, "$g_cur_stack", 0),
            (store_sub, ":pre_stack", "$g_cur_stack", 1),
            (store_sub, ":times", ":num_stacks", "$g_cur_stack"),
            (call_script, "script_move_one_stack_to_the_bottom", "$current_town", "$g_cur_stack", 1),
            (call_script, "script_move_one_stack_to_the_bottom", "$current_town", ":pre_stack", ":times"),
            (val_sub, "$g_cur_stack", 1),
            (start_presentation, "prsnt_sort_the_defenders"),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_4"), # down
          (try_begin),
            (store_sub, ":last_stack", ":num_stacks", 1),
            (lt, "$g_cur_stack", ":last_stack"),
            (gt, "$g_cur_stack", -1),
            (store_add, ":next_stack", "$g_cur_stack", 1),
            (store_sub, ":times", ":last_stack", "$g_cur_stack"),
            (call_script, "script_move_one_stack_to_the_bottom", "$current_town", ":next_stack", 1),
            (call_script, "script_move_one_stack_to_the_bottom", "$current_town", "$g_cur_stack", ":times"),
            (val_add, "$g_cur_stack", 1),
            (start_presentation, "prsnt_sort_the_defenders"),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_5"), # bottom
          (try_begin),
            (store_sub, ":last_stack", ":num_stacks", 1),
            (lt, "$g_cur_stack", ":last_stack"),
            (gt, "$g_cur_stack", -1),
            (call_script, "script_move_one_stack_to_the_bottom", "$current_town", "$g_cur_stack", 1),
            (assign, "$g_cur_stack", ":last_stack"),
            (start_presentation, "prsnt_sort_the_defenders"),
          (try_end),
        (else_try),
          (eq, ":object", "$g_presentation_obj_6"), # troop note
          (assign, "$g_presentation_next_presentation", "prsnt_sort_the_defenders"),
          (party_stack_get_troop_id, "$temp", "$current_town", "$g_cur_stack"),
          (start_presentation, "prsnt_troop_note"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_10"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),
  
  ("shopping_list_of_food", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        
        ## back
        (create_game_button_overlay, "$g_presentation_obj_1", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_1", pos1),

        ## buy foos automaticly when leaving
        (create_text_overlay, reg0, "@Buy foods automaticly when leaving:", tf_vertical_align_center),
        (position_set_x, pos1, 170),
        (position_set_y, pos1, 690),
        (overlay_set_position, reg0, pos1),

        (create_check_box_overlay, "$g_presentation_obj_2", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 150),
        (position_set_y, pos1, 682),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (overlay_set_val, "$g_presentation_obj_2", "$g_buy_foods_when_leaving"),

        ## set the portion...
        (create_text_overlay, reg0, "@Set the portion to:", tf_center_justify),
        (position_set_x, pos1, 830),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg0, pos1),

        (position_set_x, pos1, 830),
        (assign, ":pos_y", 550),
        (try_for_range, ":cur_button", 0, 7),
          (assign, reg0, ":cur_button"),
          (create_in_game_button_overlay, reg1, "@{reg0}"),
          (overlay_set_color, reg1, 0xFFFFFF),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_stack_selection_ids", ":cur_button", reg1),
          (val_sub, ":pos_y", 50),
        (try_end),

        (assign, ":base_x", 60),
        (assign, ":base_y", 550),
        (assign, ":row_adder", -150),
        (assign, ":col_adder", 140),
        (assign, ":num_cols", 5),
        (assign, ":pos_x", ":base_x"),
        (assign, ":pos_y", ":base_y"),
        (try_for_range, ":cur_food", food_begin, food_end),
          # frame
          #(create_mesh_overlay, reg1, "mesh_mp_inventory_choose"),
          #(position_set_x, pos1, 640),
          #(position_set_y, pos1, 640),
          #(overlay_set_size, reg1, pos1),
          #(position_set_x, pos1, ":pos_x"),
          #(position_set_y, pos1, ":pos_y"),
          #(overlay_set_position, reg1, pos1),
          # back ground
          (create_mesh_overlay, reg1, "mesh_inv_slot"),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, ":pos_x"),
          (position_set_y, pos1, ":pos_y"),
          (overlay_set_position, reg1, pos1),
          # item overlay
          (create_mesh_overlay_with_item_id, reg1, ":cur_food"),
          (position_set_x, pos1, 800),
          (position_set_y, pos1, 800),
          (overlay_set_size, reg1, pos1),
          (store_add, ":item_x", ":pos_x", 40),
          (store_add, ":item_y", ":pos_y", 40),
          (position_set_x, pos1, ":item_x"),
          (position_set_y, pos1, ":item_y"),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":cur_food", reg1),
          # text *
          (item_get_slot, ":food_portion", ":cur_food", slot_item_food_portion),
          (assign, reg0, ":food_portion"),
          (create_text_overlay, reg1, "@{reg0}", tf_center_justify|tf_vertical_align_center),
          (store_add, ":text_x", ":pos_x", 72),
          (store_add, ":text_y", ":pos_y", 10),
          (position_set_x, pos1, ":text_x"),
          (position_set_y, pos1, ":text_y"),
          (overlay_set_position, reg1, pos1),
          (overlay_set_color, reg1, 0xFFFFFFFF),
          # check box
          (create_check_box_overlay, reg1, "mesh_checkbox_off", "mesh_checkbox_on"),
          (store_add, ":check_box_x", ":pos_x", 65),
          (store_add, ":check_box_y", ":pos_y", 65),
          (position_set_x, pos1, ":check_box_x"),
          (position_set_y, pos1, ":check_box_y"),
          (overlay_set_position, reg1, pos1),
          (overlay_set_val, reg1, 0),
          (troop_set_slot, "trp_temp_array_b", ":cur_food", reg1),
          (troop_set_slot, "trp_temp_array_c", ":cur_food", 0),
          # next
          (val_add, ":pos_x", ":col_adder"),
          (try_begin),
            (store_mul, ":max_x", ":col_adder", ":num_cols"),
            (val_add, ":max_x", ":base_x"),
            (eq, ":pos_x", ":max_x"),
            (assign, ":pos_x", ":base_x"),
            (val_add, ":pos_y", ":row_adder"),
          (try_end),
        (try_end),

        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),

    #(ti_on_presentation_run,
      #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
    #]),

    (ti_on_presentation_mouse_enter_leave,
      [
      (store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":enter_leave"),

      (try_begin),
        (eq, ":enter_leave", 0),
        (try_for_range, ":cur_food", food_begin, food_end),
          (troop_slot_eq, "trp_temp_array_a", ":cur_food", ":object"),
          (overlay_get_position, pos0, ":object"),
          (show_item_details, ":cur_food", pos0, 100),
          (assign, "$g_current_opened_item_details", ":cur_food"),
        (try_end),
      (else_try),
        (try_for_range, ":cur_food", food_begin, food_end),
          (troop_slot_eq, "trp_temp_array_a", ":cur_food", ":object"),
          (try_begin),
            (eq, "$g_current_opened_item_details", ":cur_food"),
            (close_item_details),
          (try_end),
        (try_end),
      (try_end),
    ]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),

        (try_for_range, ":cur_food", food_begin, food_end),
          (troop_slot_eq, "trp_temp_array_b", ":cur_food", ":object"),
          (troop_set_slot, "trp_temp_array_c", ":cur_food", ":value"),
        (try_end),

        (try_for_range, ":cur_button", 0, 7),
          (troop_slot_eq, "trp_stack_selection_ids", ":cur_button", ":object"),
          (try_for_range, ":cur_food", food_begin, food_end),
            (troop_get_slot, ":checkbox_value", "trp_temp_array_c", ":cur_food"),
            (eq, ":checkbox_value", 1),
            (item_set_slot, ":cur_food", slot_item_food_portion, ":cur_button"),
          (try_end),
          (start_presentation, "prsnt_shopping_list_of_food"),
        (try_end),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_2"),
          (assign, "$g_buy_foods_when_leaving", ":value"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_1"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),
  
  
  ("character_creation", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        
        ## done
        (create_game_button_overlay, "$g_presentation_obj_1", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_1", pos1),

        (create_game_button_overlay, "$g_presentation_obj_2", "@Default"),
        (position_set_x, pos1, 730),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_2", pos1),

        (create_game_button_overlay, "$g_presentation_obj_3", "@Randomize"),
        (position_set_x, pos1, 560),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_3", pos1),

        (create_text_overlay, reg1, "@Character Background", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 630),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 2000),
        (position_set_y, pos1, 2000),
        (overlay_set_size, reg1, pos1),
        (create_text_overlay, reg1, "@Your story:", tf_left_align),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg1, pos1),

        ## options
        (position_set_x, pos1, 200),
        (position_set_y, pos1, 550),
        (create_text_overlay, reg1, "@Your Gender:", tf_center_justify),
        (overlay_set_position, reg1, pos1),
        (position_set_y, pos1, 470),
        (create_text_overlay, reg1, "@Your father was:", tf_center_justify),
        (overlay_set_position, reg1, pos1),
        (position_set_y, pos1, 390),
        (create_text_overlay, reg1, "@You spent your early life as:", tf_center_justify),
        (overlay_set_position, reg1, pos1),
        (position_set_y, pos1, 310),
        (create_text_overlay, reg1, "@Later you became:", tf_center_justify),
        (overlay_set_position, reg1, pos1),
        (position_set_y, pos1, 230),
        (create_text_overlay, reg1, "@The reason for an adventure:", tf_center_justify),
        (overlay_set_position, reg1, pos1),
        ## combo button
        # gender
        (position_set_y, pos1, 510),
        (create_combo_button_overlay, "$g_presentation_obj_11"),
        (overlay_set_position, "$g_presentation_obj_11", pos1),
        (overlay_add_item, "$g_presentation_obj_11", "@female"),
        (overlay_add_item, "$g_presentation_obj_11", "@male"),
        (try_begin),
          (eq, "$character_gender", tf_female),
          (overlay_set_val, "$g_presentation_obj_11", 0),
        (else_try),
          (eq, "$character_gender", tf_male),
          (overlay_set_val, "$g_presentation_obj_11", 1),
        (try_end),
        
        # father
        (position_set_y, pos1, 430),
        (create_combo_button_overlay, "$g_presentation_obj_12"),
        (overlay_set_position, "$g_presentation_obj_12", pos1),
        (overlay_add_item, "$g_presentation_obj_12", "@a thief"),
        (overlay_add_item, "$g_presentation_obj_12", "@a steppe nomad"),
        (overlay_add_item, "$g_presentation_obj_12", "@a hunter"),
        (overlay_add_item, "$g_presentation_obj_12", "@a veteran warrior"),
        (overlay_add_item, "$g_presentation_obj_12", "@a travelling merchant"),
        (overlay_add_item, "$g_presentation_obj_12", "@an impoverished noble"),
        (try_begin),
          (eq, "$background_type", cb_thief),
          (overlay_set_val, "$g_presentation_obj_12", 0),
        (else_try),
          (eq, "$background_type", cb_nomad),
          (overlay_set_val, "$g_presentation_obj_12", 1),
        (else_try),
          (eq, "$background_type", cb_forester),
          (overlay_set_val, "$g_presentation_obj_12", 2),
        (else_try),
          (eq, "$background_type", cb_guard),
          (overlay_set_val, "$g_presentation_obj_12", 3),
        (else_try),
          (eq, "$background_type", cb_merchant),
          (overlay_set_val, "$g_presentation_obj_12", 4),
        (else_try),
          (eq, "$background_type", cb_noble),
          (overlay_set_val, "$g_presentation_obj_12", 5),
        (try_end),
        
        # early life
        (position_set_y, pos1, 350),
        (create_combo_button_overlay, "$g_presentation_obj_13"),
        (overlay_set_position, "$g_presentation_obj_13", pos1),
        (overlay_add_item, "$g_presentation_obj_13", "@a steppe child"),
        (overlay_add_item, "$g_presentation_obj_13", "@a street urchin"),
        (overlay_add_item, "$g_presentation_obj_13", "@a shop assistant"),
        (overlay_add_item, "$g_presentation_obj_13", "@a craftsman's apprentice"),
        (overlay_add_item, "$g_presentation_obj_13", "@a page at a nobleman's court"),
        (try_begin),
          (eq, "$background_answer_2", cb2_steppe_child),
          (overlay_set_val, "$g_presentation_obj_13", 0),
        (else_try),
          (eq, "$background_answer_2", cb2_urchin),
          (overlay_set_val, "$g_presentation_obj_13", 1),
        (else_try),
          (eq, "$background_answer_2", cb2_merchants_helper),
          (overlay_set_val, "$g_presentation_obj_13", 2),
        (else_try),
          (eq, "$background_answer_2", cb2_apprentice),
          (overlay_set_val, "$g_presentation_obj_13", 3),
        (else_try),
          (eq, "$background_answer_2", cb2_page),
          (overlay_set_val, "$g_presentation_obj_13", 4),
        (try_end),
        
        # later
        (position_set_y, pos1, 270),
        (create_combo_button_overlay, "$g_presentation_obj_14"),
        (overlay_set_position, "$g_presentation_obj_14", pos1),
        (overlay_add_item, "$g_presentation_obj_14", "@a game poacher"),
        (overlay_add_item, "$g_presentation_obj_14", "@a smith"),
        (overlay_add_item, "$g_presentation_obj_14", "@a goods peddler"),
        (overlay_add_item, "$g_presentation_obj_14", "@a university student"),
        (overlay_add_item, "$g_presentation_obj_14", "@a troubadour"),
        (try_begin),
          (eq,"$character_gender",tf_male),
          (overlay_add_item, "$g_presentation_obj_14", "@a squire"),
        (else_try),
          (eq,"$character_gender",tf_female),
          (overlay_add_item, "$g_presentation_obj_14", "@a lady-in-waiting"),
        (try_end),
        (try_begin),
          (eq, "$background_answer_3", cb3_poacher),
          (overlay_set_val, "$g_presentation_obj_14", 0),
        (else_try),
          (eq, "$background_answer_3", cb3_craftsman),
          (overlay_set_val, "$g_presentation_obj_14", 1),
        (else_try),
          (eq, "$background_answer_3", cb3_peddler),
          (overlay_set_val, "$g_presentation_obj_14", 2),
        (else_try),
          (eq, "$background_answer_3", cb3_student),
          (overlay_set_val, "$g_presentation_obj_14", 3),
        (else_try),
          (eq, "$background_answer_3", cb3_troubadour),
          (overlay_set_val, "$g_presentation_obj_14", 4),
        (else_try),
          (this_or_next|eq, "$background_answer_3", cb3_squire),
          (eq, "$background_answer_3", cb3_lady_in_waiting),
          (overlay_set_val, "$g_presentation_obj_14", 5),
        (try_end),
        
        # reason
        (position_set_y, pos1, 190),
        (create_combo_button_overlay, "$g_presentation_obj_15"),
        (overlay_set_position, "$g_presentation_obj_15", pos1),
        (overlay_add_item, "$g_presentation_obj_15", "@lust for money and power"),
        (overlay_add_item, "$g_presentation_obj_15", "@being forced out of your home"),
        (overlay_add_item, "$g_presentation_obj_15", "@wanderlust"),
        (overlay_add_item, "$g_presentation_obj_15", "@the loss of a loved one"),
        (overlay_add_item, "$g_presentation_obj_15", "@personal revenge"),
        (try_begin),
          (eq, "$background_answer_4", cb4_greed),
          (overlay_set_val, "$g_presentation_obj_15", 0),
        (else_try),
          (eq, "$background_answer_4", cb4_disown),
          (overlay_set_val, "$g_presentation_obj_15", 1),
        (else_try),
          (eq, "$background_answer_4", cb4_wanderlust),
          (overlay_set_val, "$g_presentation_obj_15", 2),
        (else_try),
          (eq, "$background_answer_4", cb4_loss),
          (overlay_set_val, "$g_presentation_obj_15", 3),
        (else_try),
          (eq, "$background_answer_4", cb4_revenge),
          (overlay_set_val, "$g_presentation_obj_15", 4),
        (try_end),
        
        ## story
        (call_script, "script_get_character_background_text"),
        (create_text_overlay, reg1, "@{s1}", tf_double_space|tf_scrollable),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 80),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 450),
        (overlay_set_area_size, reg1, pos1),
        
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######
      ]),

    #(ti_on_presentation_run,
      #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
    #]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_11"),
          (try_begin),
            (eq, ":value", 0),
            (assign, "$character_gender", tf_female),
          (else_try),
            (eq, ":value", 1),
            (assign, "$character_gender", tf_male),
          (try_end),
          (start_presentation, "prsnt_character_creation"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_12"),
          (try_begin),
            (eq, ":value", 0),
            (assign, "$background_type", cb_thief),
          (else_try),
            (eq, ":value", 1),
            (assign, "$background_type", cb_nomad),
          (else_try),
            (eq, ":value", 2),
            (assign, "$background_type", cb_forester),
          (else_try),
            (eq, ":value", 3),
            (assign, "$background_type", cb_guard),
          (else_try),
            (eq, ":value", 4),
            (assign, "$background_type", cb_merchant),
          (else_try),
            (eq, ":value", 5),
            (assign, "$background_type", cb_noble),
          (try_end),
          (start_presentation, "prsnt_character_creation"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_13"),
          (try_begin),
            (eq, ":value", 0),
            (assign, "$background_answer_2", cb2_steppe_child),
          (else_try),
            (eq, ":value", 1),
            (assign, "$background_answer_2", cb2_urchin),
          (else_try),
            (eq, ":value", 2),
            (assign, "$background_answer_2", cb2_merchants_helper),
          (else_try),
            (eq, ":value", 3),
            (assign, "$background_answer_2", cb2_apprentice),
          (else_try),
            (eq, ":value", 4),
            (assign, "$background_answer_2", cb2_page),
          (try_end),
          (start_presentation, "prsnt_character_creation"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_14"),
          (try_begin),
            (eq, ":value", 0),
            (assign, "$background_answer_3", cb3_poacher),
          (else_try),
            (eq, ":value", 1),
            (assign, "$background_answer_3", cb3_craftsman),
          (else_try),
            (eq, ":value", 2),
            (assign, "$background_answer_3", cb3_peddler),
          (else_try),
            (eq, ":value", 3),
            (assign, "$background_answer_3", cb3_student),
          (else_try),
            (eq, ":value", 4),
            (assign, "$background_answer_3", cb3_troubadour),
          (else_try),
            (eq, ":value", 5),
            (try_begin),
              (eq, "$character_gender", tf_male),
              (assign, "$background_answer_3", cb3_squire),
            (else_try),
              (eq, "$character_gender", tf_female),
              (assign, "$background_answer_3", cb3_lady_in_waiting),
            (try_end),
          (try_end),
          (start_presentation, "prsnt_character_creation"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_15"),
          (try_begin),
            (eq, ":value", 0),
            (assign, "$background_answer_4", cb4_greed),
          (else_try),
            (eq, ":value", 1),
            (assign, "$background_answer_4", cb4_disown),
          (else_try),
            (eq, ":value", 2),
            (assign, "$background_answer_4", cb4_wanderlust),
          (else_try),
            (eq, ":value", 3),
            (assign, "$background_answer_4", cb4_loss),
          (else_try),
            (eq, ":value", 4),
            (assign, "$background_answer_4", cb4_revenge),
          (try_end),
          (start_presentation, "prsnt_character_creation"),
        (else_try), ## Randomize
          (eq, ":object", "$g_presentation_obj_3"),
          # gender
          (store_random_in_range, ":player_gender", 0, 2),
          (assign, "$character_gender", ":player_gender"),
          # father
          (store_random_in_range, ":r_value", 0, 6),
          (try_begin),
            (eq, ":r_value", 0),
            (assign, "$background_type", cb_thief),
          (else_try),
            (eq, ":r_value", 1),
            (assign, "$background_type", cb_nomad),
          (else_try),
            (eq, ":r_value", 2),
            (assign, "$background_type", cb_forester),
          (else_try),
            (eq, ":r_value", 3),
            (assign, "$background_type", cb_guard),
          (else_try),
            (eq, ":r_value", 4),
            (assign, "$background_type", cb_merchant),
          (else_try),
            (eq, ":r_value", 5),
            (assign, "$background_type", cb_noble),
          (try_end),
          # early life
          (store_random_in_range, ":r_value", 0, 5),
          (try_begin),
            (eq, ":r_value", 0),
            (assign, "$background_answer_2", cb2_steppe_child),
          (else_try),
            (eq, ":r_value", 1),
            (assign, "$background_answer_2", cb2_urchin),
          (else_try),
            (eq, ":r_value", 2),
            (assign, "$background_answer_2", cb2_merchants_helper),
          (else_try),
            (eq, ":r_value", 3),
            (assign, "$background_answer_2", cb2_apprentice),
          (else_try),
            (eq, ":r_value", 4),
            (assign, "$background_answer_2", cb2_page),
          (try_end),
          # later
          (store_random_in_range, ":r_value", 0, 6),
          (try_begin),
            (eq, ":r_value", 0),
            (assign, "$background_answer_3", cb3_poacher),
          (else_try),
            (eq, ":r_value", 1),
            (assign, "$background_answer_3", cb3_craftsman),
          (else_try),
            (eq, ":r_value", 2),
            (assign, "$background_answer_3", cb3_peddler),
          (else_try),
            (eq, ":r_value", 3),
            (assign, "$background_answer_3", cb3_student),
          (else_try),
            (eq, ":r_value", 4),
            (assign, "$background_answer_3", cb3_troubadour),
          (else_try),
            (eq, ":r_value", 5),
            (try_begin),
              (eq, "$character_gender", tf_male),
              (assign, "$background_answer_3", cb3_squire),
            (else_try),
              (eq, "$character_gender", tf_female),
              (assign, "$background_answer_3", cb3_lady_in_waiting),
            (try_end),
          (try_end),
          # reason
          (store_random_in_range, ":r_value", 0, 5),
          (try_begin),
            (eq, ":r_value", 0),
            (assign, "$background_answer_4", cb4_greed),
          (else_try),
            (eq, ":r_value", 1),
            (assign, "$background_answer_4", cb4_disown),
          (else_try),
            (eq, ":r_value", 2),
            (assign, "$background_answer_4", cb4_wanderlust),
          (else_try),
            (eq, ":r_value", 3),
            (assign, "$background_answer_4", cb4_loss),
          (else_try),
            (eq, ":r_value", 4),
            (assign, "$background_answer_4", cb4_revenge),
          (try_end),
          (start_presentation, "prsnt_character_creation"),
        (else_try), ## Default
          (eq, ":object", "$g_presentation_obj_2"),
          (assign, "$character_gender", tf_male),
          (assign,"$background_type",cb_noble),
          (assign,"$background_answer_2", cb2_page),
          (assign,"$background_answer_3",cb3_squire),
          (assign,"$background_answer_4", cb4_revenge),
          (start_presentation, "prsnt_character_creation"),
        (else_try),
          (eq, ":object", "$g_presentation_obj_1"),
          # gender
          (try_begin),
            (eq,"$character_gender",tf_male),
            (troop_set_type,"trp_player", 0),
          (else_try),
            (eq,"$character_gender",tf_female),
            (troop_set_type,"trp_player", 1),
          (try_end),
          #(try_begin),
            #(eq, "$background_type", cb_noble),
#normal_banner_begin
            #(start_presentation, "prsnt_banner_selection"),
#custom_banner_begin
            #(jump_to_menu, "mnu_auto_return"),
#             (start_presentation, "prsnt_custom_banner"),
          #(else_try),
            (presentation_set_duration, 0),
            (jump_to_menu, "mnu_banner_selection_for_noble"),
          #(try_end),
        (try_end),
    ]),
  ]),

  
  ("party_size_and_morale", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
  
        (create_text_overlay, reg1, "@Party Morale", tf_center_justify),
        (position_set_x, pos1, 1500),
        (position_set_y, pos1, 1500),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 260),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        
        (position_set_x, pos3, 900),
        (position_set_y, pos3, 900),
        (position_set_x, pos1, 80),
        (position_set_x, pos2, 440),
        (assign, ":cur_y", 600),
        (assign, ":y_offset", 30),
        
        (call_script, "script_get_player_party_morale_values"),
        (assign, ":ideal_morale", reg1),
        
        # Base morale
        (create_text_overlay, reg1, "@Base morale", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (create_text_overlay, reg1, "@+50", tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_color, reg1, 0x00AA00),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Party size
        (assign, reg0, "$g_player_party_morale_modifier_party_size"),
        (create_text_overlay, reg1, "@Party size", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (try_begin),
          (gt, reg0, 0),
          (str_store_string, s1, "@-{reg0}"),
          (assign, ":dest_color", 0xAA0000),
        (else_try),
          (eq, reg0, 0),
          (str_store_string, s1, "@{reg0}"),
          (assign, ":dest_color", 0x000000),
        (try_end),
        (create_text_overlay, reg1, s1, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_color, reg1, ":dest_color"),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Leadership
        (assign, reg0, "$g_player_party_morale_modifier_leadership"),
        (create_text_overlay, reg1, "@Leadership", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (try_begin),
          (gt, reg0, 0),
          (str_store_string, s1, "@+{reg0}"),
          (assign, ":dest_color", 0x00AA00),
        (else_try),
          (eq, reg0, 0),
          (str_store_string, s1, "@{reg0}"),
          (assign, ":dest_color", 0x000000),
        (try_end),
        (create_text_overlay, reg1, s1, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_color, reg1, ":dest_color"),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Player's level
        (store_character_level, ":player_level", "trp_player"),
        (val_mul, ":player_level", 3),
        (assign, reg0, ":player_level"),
        (create_text_overlay, reg1, "@Player's level", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (create_text_overlay, reg1, "@+{reg0}", tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_color, reg1, 0x00AA00),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # food or no food
        (try_begin),
          (eq, "$g_player_party_morale_modifier_food", 0),
          (str_store_string, s1, "@No food"),
          (assign, reg0, "$g_player_party_morale_modifier_no_food"),
          (str_store_string, s2, "@-{reg0}"),
          (assign, ":dest_color", 0xAA0000),
        (else_try),
          (str_store_string, s1, "@Food variety"),
          (assign, reg0, "$g_player_party_morale_modifier_food"),
          (str_store_string, s2, "@+{reg0}"),
          (assign, ":dest_color", 0x00AA00),
        (try_end),
        (create_text_overlay, reg1, s1, tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (create_text_overlay, reg1, s2, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_color, reg1, ":dest_color"),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Wage debt
        (try_begin),
          (gt, "$g_player_party_morale_modifier_debt", 0),
          (assign, reg0, "$g_player_party_morale_modifier_debt"),
          (create_text_overlay, reg1, "@Wage debt", tf_left_align),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos3),
          (create_text_overlay, reg1, "@-{reg0}", tf_right_align),
          (position_set_y, pos2, ":cur_y"),
          (overlay_set_position, reg1, pos2),
          (overlay_set_color, reg1, 0xAA0000),
          (overlay_set_size, reg1, pos3),
          (val_sub, ":cur_y", ":y_offset"),
        (try_end),
        
        # Recent events
        (create_text_overlay, reg1, "@Recent events", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (party_get_morale, ":cur_morale", "p_main_party"),
        (store_sub, reg0, ":cur_morale", ":ideal_morale"),
        (try_begin),
          (gt, reg0, 0),
          (str_store_string, s1, "@+{reg0}"),
          (assign, ":dest_color", 0x00AA00),
        (else_try),
          (eq, reg0, 0),
          (str_store_string, s1, "@{reg0}"),
          (assign, ":dest_color", 0x000000),
        (else_try),
          (str_store_string, s1, "@{reg0}"),
          (assign, ":dest_color", 0xAA0000),
        (try_end),
        (create_text_overlay, reg1, s1, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_color, reg1, ":dest_color"),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # division line, offset: +75%
        (store_mul, ":line_offset", ":y_offset", 75),
        (val_div, ":line_offset", 100),
        (store_add, ":line_pos_y", ":cur_y", ":line_offset"),
        (call_script, "script_prsnt_lines", 360, 1, 80, ":line_pos_y", 0),
        
        # Total
        (create_text_overlay, reg1, "@Total", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (party_get_morale, reg0, "p_main_party"),
        (overlay_set_size, reg1, pos3),
        (create_text_overlay, reg1, "@{reg0}", tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        ## Morale value to change and Prospective party morale
        (party_get_morale, ":cur_morale", "p_main_party"),
        (store_sub, ":dif", ":ideal_morale", ":cur_morale"),
        # leadership modifier 
        (store_skill_level, ":skill", "skl_leadership", "trp_player"),
        (try_begin),
          (gt, ":dif", 0),
          (store_add, ":morale_change_factor", 20, ":skill"),
        (else_try),
          (store_sub, ":morale_change_factor", 20, ":skill"),
        (try_end),
        (store_mul, ":dif_to_add", ":dif", ":morale_change_factor"),
        (val_div, ":dif_to_add", 100),
        (store_mul, ":dif_to_add_correction", ":dif_to_add", 100),
        (val_div, ":dif_to_add_correction", ":morale_change_factor"),
        # leadership modifier 
        (try_begin),#finding ceiling of the value
          (neq, ":dif_to_add_correction", ":dif"),
          (try_begin),
            (gt, ":dif", 0),
            (val_add, ":dif_to_add", 1),
          (else_try),
            (val_sub, ":dif_to_add", 1),
          (try_end),
        (try_end),
        (store_add, ":dest_morale", ":cur_morale", ":dif_to_add"),
        (val_clamp, ":dest_morale", 0, 100),
        (store_sub, ":morale_to_change", ":dest_morale", ":cur_morale"),
        # Morale value to change
        (create_text_overlay, reg1, "@Morale value to change", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (assign, reg0, ":morale_to_change"),
        (try_begin),
          (gt, reg0, 0),
          (str_store_string, s1, "@+{reg0}"),
          (assign, ":dest_color", 0x00AA00),
        (else_try),
          (eq, reg0, 0),
          (str_store_string, s1, "@{reg0}"),
          (assign, ":dest_color", 0x000000),
        (else_try),
          (str_store_string, s1, "@{reg0}"),
          (assign, ":dest_color", 0xAA0000),
        (try_end),
        (create_text_overlay, reg1, s1, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_color, reg1, ":dest_color"),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        # Prospective party morale
        (create_text_overlay, reg1, "@Prospective party morale", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (assign, reg0, ":dest_morale"),
        (overlay_set_size, reg1, pos3),
        (create_text_overlay, reg1, "@{reg0}", tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        (val_sub, ":cur_y", ":y_offset"),
        (val_sub, ":cur_y", ":y_offset"),
        # Extra morale for kingdom troops
        (try_for_range, ":kingdom_no", npc_kingdoms_begin, npc_kingdoms_end),
          (faction_get_slot, ":faction_morale", ":kingdom_no",  slot_faction_morale_of_player_troops),
          (val_div, ":faction_morale", 100),
          (neq, ":faction_morale", 0),
          (assign, reg0, ":faction_morale"),
          (str_store_faction_name, s1, ":kingdom_no"),
          (create_text_overlay, reg1, "@Extra morale for {s1} troops", tf_left_align),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (overlay_set_size, reg1, pos3),
          (try_begin),
            (gt, reg0, 0),
            (str_store_string, s1, "@+{reg0}"),
            (assign, ":dest_color", 0x00AA00),
          (else_try),
            (str_store_string, s1, "@{reg0}"),
            (assign, ":dest_color", 0xAA0000),
          (try_end),
          (create_text_overlay, reg1, s1, tf_right_align),
          (position_set_y, pos2, ":cur_y"),
          (overlay_set_position, reg1, pos2),
          (overlay_set_color, reg1, ":dest_color"),
          (overlay_set_size, reg1, pos3),
          (val_sub, ":cur_y", ":y_offset"),
        (try_end),
        
        ## party size report
        (create_text_overlay, reg1, "@Party Size", tf_center_justify),
        (position_set_x, pos1, 1500),
        (position_set_y, pos1, 1500),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 740),
        (position_set_y, pos1, 650),
        (overlay_set_position, reg1, pos1),
        
        (position_set_x, pos1, 560),
        (position_set_x, pos2, 920),
        (assign, ":cur_y", 600),
        (assign, ":y_offset", 30),
        
        # Base morale
        (create_text_overlay, reg1, "@Base size", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (create_text_overlay, reg1, "@+30", tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Player's level
        (create_text_overlay, reg1, "@Player's level", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (store_character_level, ":troop_level", "trp_player"),
        (store_mul, reg0, ":troop_level", 2),
        (create_text_overlay, reg1, "@+{reg0}", tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Leadership
        (create_text_overlay, reg1, "@Leadership", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (store_skill_level, ":leadership", "skl_leadership", "trp_player"),
        (store_mul, reg0, ":leadership", 10),
        (try_begin),
          (gt, reg0, 0),
          (str_store_string, s1, "@+{reg0}"),
        (else_try),
          (str_store_string, s1, "@{reg0}"),
        (try_end),
        (create_text_overlay, reg1, s1, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Charisma
        (create_text_overlay, reg1, "@Charisma", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (store_attribute_level, reg0, "trp_player", ca_charisma),
        (try_begin),
          (gt, reg0, 0),
          (str_store_string, s1, "@+{reg0}"),
        (else_try),
          (str_store_string, s1, "@{reg0}"),
        (try_end),
        (create_text_overlay, reg1, s1, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Renown
        (create_text_overlay, reg1, "@Renown", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (troop_get_slot, ":renown", "trp_player", slot_troop_renown),
        (store_div, reg0, ":renown", 25),
        (try_begin),
          (gt, reg0, 0),
          (str_store_string, s1, "@+{reg0}"),
        (else_try),
          (str_store_string, s1, "@{reg0}"),
        (try_end),
        (create_text_overlay, reg1, s1, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Castles
        (create_text_overlay, reg1, "@Castles", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (assign, ":center_bonus", 0),
        (try_for_range, ":cur_center", castles_begin, castles_end),
          (party_slot_eq, ":cur_center", slot_town_lord, "trp_player"),
          (val_add, ":center_bonus", 20),
        (try_end),
        (assign, reg0, ":center_bonus"),
        (try_begin),
          (gt, reg0, 0),
          (str_store_string, s1, "@+{reg0}"),
        (else_try),
          (str_store_string, s1, "@{reg0}"),
        (try_end),
        (create_text_overlay, reg1, s1, tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # division line, offset: +75%
        (store_mul, ":line_offset", ":y_offset", 75),
        (val_div, ":line_offset", 100),
        (store_add, ":line_pos_y", ":cur_y", ":line_offset"),
        (call_script, "script_prsnt_lines", 360, 1, 560, ":line_pos_y", 0),
        
        (create_text_overlay, reg1, "@Total", tf_left_align),
        (position_set_y, pos1, ":cur_y"),
        (overlay_set_position, reg1, pos1),
        (overlay_set_size, reg1, pos3),
        (call_script, "script_game_get_party_companion_limit"),
        (create_text_overlay, reg1, "@{reg0}", tf_right_align),
        (position_set_y, pos2, ":cur_y"),
        (overlay_set_position, reg1, pos2),
        (overlay_set_size, reg1, pos3),
        (val_sub, ":cur_y", ":y_offset"),
        
        # Done
        (create_game_button_overlay, "$g_presentation_obj_5", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
      ]),
  
    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
  
        (try_begin),
          (eq, ":object", "$g_presentation_obj_5"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),
  
  ("relations_with_factions", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        
        (create_text_overlay, reg1, "@Relation with the factions", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 670),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 1500),
        (position_set_y, pos1, 1500),
        (overlay_set_size, reg1, pos1),
        
        (create_text_overlay, reg1, "@Click the totems to view relation with the lords", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 50),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 800),
        (position_set_y, pos1, 800),
        (overlay_set_size, reg1, pos1),
        
        (str_clear, s0),
        (create_text_overlay, "$g_presentation_obj_6", s0, tf_scrollable),
        (position_set_x, pos1, 15),
        (position_set_y, pos1, 80),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 570),
        (overlay_set_area_size, "$g_presentation_obj_6", pos1),
        (set_container_overlay, "$g_presentation_obj_6"),
        
        (assign, ":num_active_factions", 0),
        (try_for_range, ":cur_kingdom", kingdoms_begin, kingdoms_end),
          (faction_slot_eq, ":cur_kingdom", slot_faction_state, sfs_active),
          (val_add, ":num_active_factions", 1),
        (try_end),
        
        (store_mod, ":mod_value", ":num_active_factions", 2),
        (try_begin),
          (eq, ":mod_value", 0),
          (assign, ":cur_x", 470),
        (else_try),
          (assign, ":cur_x", -30),
        (try_end),
        
        (try_begin),
          (is_between, ":num_active_factions", 1, 3),
          (assign, ":cur_y", 400),
        (else_try),
          (is_between, ":num_active_factions", 3, 5),
          (assign, ":cur_y", 200),
        (else_try),
          (is_between, ":num_active_factions", 5, 7),
          (assign, ":cur_y", 0),
        (else_try),
          (assign, ":cur_y", 20),
        (try_end),
        
        (assign, ":x_offset", 500),
        (assign, ":y_offset", 200),
        
        (assign, ":slot_no", 0),
        (try_for_range_backwards, ":cur_kingdom", kingdoms_begin, kingdoms_end),
          (faction_slot_eq, ":cur_kingdom", slot_faction_state, sfs_active), 
          (try_begin),
            (is_between, ":cur_kingdom", "fac_kingdom_1", kingdoms_end),
            (create_image_button_overlay_with_tableau_material, reg1, -1, "tableau_faction_note_mesh", ":cur_kingdom"),
            (assign, ":totem_x", ":cur_x"),
          (else_try), # use banner instead
            (create_image_button_overlay_with_tableau_material, reg1, -1, "tableau_faction_note_mesh_banner", ":cur_kingdom"),
            (store_add, ":totem_x", ":cur_x", 90),
          (try_end),
          (position_set_x, pos1, 600),
          (position_set_y, pos1, 600),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, ":totem_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          (troop_set_slot, "trp_temp_array_a", ":slot_no", reg1),
          (troop_set_slot, "trp_temp_array_b", ":slot_no", ":cur_kingdom"),
          (val_add, ":slot_no", 1),
          
          # bar
          (store_add, ":relation_bar_x", ":cur_x", 270),
          (store_add, ":relation_bar_y", ":cur_y", 10),
          (create_mesh_overlay, reg1, "mesh_relation_bar"),
          (position_set_x, pos1, ":relation_bar_x"),
          (position_set_y, pos1, ":relation_bar_y"),
          (overlay_set_position, reg1, pos1),
          # pointer
          (try_begin),
            (eq, ":cur_kingdom", "fac_player_supporters_faction"),
            (assign, ":cur_relation", 100),
          (else_try),
            (store_relation, ":cur_relation", "fac_player_supporters_faction", ":cur_kingdom"),
          (try_end),
          (store_sub, ":pointer_x", ":cur_relation", -100),
          (val_add, ":pointer_x", 270),
          (val_add, ":pointer_x", ":cur_x"),
          (create_mesh_overlay, reg1, "mesh_reln_pointer"),
          (position_set_x, pos1, ":pointer_x"),
          (position_set_y, pos1, ":relation_bar_y"),
          (overlay_set_position, reg1, pos1),
          # text
          (store_add, ":text_x", ":cur_x", 370),
          (store_add, ":text_y", ":relation_bar_y", 45),
          (assign, reg0, ":cur_relation"),
          (str_store_faction_name, s1, ":cur_kingdom"),
          
          (try_begin),
            (ge, ":cur_relation", 90),
            (str_store_string, s3, "@Loyal"),
          (else_try),
            (ge, ":cur_relation", 80),
            (str_store_string, s3, "@Devoted"),
          (else_try),
            (ge, ":cur_relation", 70),
            (str_store_string, s3, "@Fond"),
          (else_try),
            (ge, ":cur_relation", 60),
            (str_store_string, s3, "@Gracious"),
          (else_try),
            (ge, ":cur_relation", 50),
            (str_store_string, s3, "@Friendly"),
          (else_try),
            (ge, ":cur_relation", 40),
            (str_store_string, s3, "@Supportive"),
          (else_try),
            (ge, ":cur_relation", 30),
            (str_store_string, s3, "@Favorable"),
          (else_try),
            (ge, ":cur_relation", 20),
            (str_store_string, s3, "@Cooperative"),
          (else_try),
            (ge, ":cur_relation", 10),
            (str_store_string, s3, "@Accepting"),
          (else_try),
            (ge, ":cur_relation", 0),
            (str_store_string, s3, "@Indifferent"),
          (else_try),
            (ge, ":cur_relation", -10),
            (str_store_string, s3, "@Suspicious"),
          (else_try),
            (ge, ":cur_relation", -20),
            (str_store_string, s3, "@Grumbling"),
          (else_try),
            (ge, ":cur_relation", -30),
            (str_store_string, s3, "@Hostile"),
          (else_try),
            (ge, ":cur_relation", -40),
            (str_store_string, s3, "@Resentful"),
          (else_try),
            (ge, ":cur_relation", -50),
            (str_store_string, s3, "@Angry"),
          (else_try),
            (ge, ":cur_relation", -60),
            (str_store_string, s3, "@Hateful"),
          (else_try),
            (ge, ":cur_relation", -70),
            (str_store_string, s3, "@Revengeful"),
          (else_try),
            (str_store_string, s3, "@Vengeful"),
          (try_end),
          
          (create_text_overlay, reg1, "@{s1}^^{reg0} ({s3})", tf_center_justify),
          (position_set_x, pos1, ":text_x"),
          (position_set_y, pos1, ":text_y"),
          (overlay_set_position, reg1, pos1),
          
          (val_sub, ":cur_x", ":x_offset"),
          (try_begin),
            (eq, ":cur_x", -530),
            (assign, ":cur_x", 470),
            (val_add, ":cur_y", ":y_offset"),
          (try_end),
        (try_end),
        (set_container_overlay, -1),

        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######

        # Done
        (create_game_button_overlay, "$g_presentation_obj_5", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
      ]),
  
    #(ti_on_presentation_run,
      #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
    #]),
  
    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),

        (assign, ":num_active_factions", 0),
        (try_for_range, ":cur_kingdom", kingdoms_begin, kingdoms_end),
          (faction_slot_eq, ":cur_kingdom", slot_faction_state, sfs_active),
          (val_add, ":num_active_factions", 1),
        (try_end),
        (try_for_range, ":slot_no", 0, ":num_active_factions"),
          (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
          (troop_get_slot, "$temp", "trp_temp_array_b", ":slot_no"),
          (start_presentation, "prsnt_relations_with_lords_by_faction"),
        (try_end),
        
        (try_begin),
          (eq, ":object", "$g_presentation_obj_5"),
          (presentation_set_duration, 0),
        (try_end),
    ]),
  ]),
  
  ("relations_with_lords_by_faction", 0, mesh_load_window, [
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
        
        (assign, ":cur_faction", "$temp"),
        (str_store_faction_name, s1, ":cur_faction"),
        
        (create_text_overlay, reg1, "@Relation with the lords of {s1}", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 670),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 1500),
        (position_set_y, pos1, 1500),
        (overlay_set_size, reg1, pos1),

        (str_clear, s0),
        (create_text_overlay, "$g_presentation_obj_6", s0, tf_scrollable),
        (position_set_x, pos1, 15),
        (position_set_y, pos1, 80),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (position_set_x, pos1, 950),
        (position_set_y, pos1, 570),
        (overlay_set_area_size, "$g_presentation_obj_6", pos1),
        (set_container_overlay, "$g_presentation_obj_6"),

        (assign, ":num_fit_lords", 0),
        (try_for_range, ":active_npc", active_npcs_begin, active_npcs_end),
          (troop_slot_eq, ":active_npc", slot_troop_occupation, slto_kingdom_hero),
          (store_faction_of_troop, ":troop_faction", ":active_npc"),
          (eq, ":troop_faction", ":cur_faction"),
          (val_add, ":num_fit_lords", 1),
        (try_end),
        
        (assign, ":x_offset", 225),
        (assign, ":y_offset", 300),
        (store_mod, ":mod_value", ":num_fit_lords", 4),
        (try_begin),
          (eq, ":mod_value", 0),
          (assign, ":mod_value", 4),
        (try_end),
        (store_mul, ":cur_x", ":mod_value", ":x_offset"),
        (val_sub, ":cur_x", ":x_offset"),
        (val_add, ":cur_x", 35),
        (try_begin),
          (is_between, ":num_fit_lords", 0, 5),
          (assign, ":cur_y", 320),
        (else_try),
          (assign, ":cur_y", 20),
        (try_end),
        
        
        (try_for_range_backwards, ":active_npc", active_npcs_begin, active_npcs_end),
          (troop_slot_eq, ":active_npc", slot_troop_occupation, slto_kingdom_hero),
          (store_faction_of_troop, ":troop_faction", ":active_npc"),
          (eq, ":troop_faction", ":cur_faction"),
          (call_script, "script_troop_get_player_relation", ":active_npc"),
          (assign, ":cur_relation", reg0),
          
          # bar
          (create_mesh_overlay, reg1, "mesh_relation_bar"),
          (position_set_x, pos1, ":cur_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          # pointer
          (store_sub, ":pointer_x", ":cur_relation", -100),
          (val_add, ":pointer_x", ":cur_x"),
          (create_mesh_overlay, reg1, "mesh_reln_pointer"),
          (position_set_x, pos1, ":pointer_x"),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg1, pos1),
          # name
          (store_add, ":text_x", ":cur_x", 100),
          (store_add, ":text_y", ":cur_y", 45),
          (str_store_troop_name, s1, ":active_npc"),
          (assign, reg0, ":cur_relation"),
          (create_text_overlay, reg1, "@{s1}^Relation: {reg0}", tf_center_justify),
          (position_set_x, pos1, ":text_x"),
          (position_set_y, pos1, ":text_y"),
          (overlay_set_position, reg1, pos1),
          
          # troop
          (store_add, ":troop_x", ":cur_x", 20),
          (store_add, ":troop_y", ":cur_y", 110),
          (create_mesh_overlay_with_tableau_material, reg1, -1, "tableau_troop_note_mesh", ":active_npc"),
          (position_set_x, pos1, 400),
          (position_set_y, pos1, 400),
          (overlay_set_size, reg1, pos1),
          (position_set_x, pos1, ":troop_x"),
          (position_set_y, pos1, ":troop_y"),
          (overlay_set_position, reg1, pos1),

          (val_sub, ":cur_x", ":x_offset"),
          (try_begin),
            (eq, ":cur_x", -190),
            (assign, ":cur_x", 710),
            (val_add, ":cur_y", ":y_offset"),
          (try_end),
        (try_end),
        (set_container_overlay, -1),
        
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_ready"),
        ####### mouse fix pos system #######

        # Done
        (create_game_button_overlay, "$g_presentation_obj_5", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
      ]),
  
    #(ti_on_presentation_run,
      #[
        ####### mouse fix pos system #######
        #(call_script, "script_mouse_fix_pos_run"),
        ####### mouse fix pos system #######
    #]),

    (ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        
        (try_begin),
          (eq, ":object", "$g_presentation_obj_5"),
          (start_presentation, "prsnt_relations_with_factions"),
        (try_end),
    ]),
  ]),
## CC


##diplomacy begin
    ("dplmc_policy_management",0,mesh_load_window,[
      (ti_on_presentation_load,
       [
        (set_fixed_point_multiplier, 1000),
        (presentation_set_duration, 999999),
		##nested diplomacy start+ insert g_presentation_obj_5, g_presentation_obj_6 and increment others

		##Moved up here from below
        (faction_get_slot, ":centralization", "fac_player_supporters_faction", dplmc_slot_faction_centralization),
        (faction_get_slot, ":aristocratcy", "fac_player_supporters_faction", dplmc_slot_faction_aristocracy),
        (faction_get_slot, ":serfdom", "fac_player_supporters_faction", dplmc_slot_faction_serfdom),
        (faction_get_slot, ":quality", "fac_player_supporters_faction", dplmc_slot_faction_quality),
		(faction_get_slot, ":mercantilism", "fac_player_supporters_faction", dplmc_slot_faction_quality),#<- dplmc+ added

        # done
        (create_game_button_overlay, "$g_presentation_obj_12", "@Done"),#<- dplmc+ changed obj_10 to obj_12
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_12", pos1),#<- dplmc_ changed obj_10 to obj_12

        # title
        (create_text_overlay, reg1, "@Select your domestic policy", tf_center_justify|tf_vertical_align_center),
        (position_set_x, pos1, 445),
        (position_set_y, pos1, 700),
        (overlay_set_position, reg1, pos1),

        (create_slider_overlay, "$g_presentation_obj_sliders_1", -3, 3),
        (create_slider_overlay, "$g_presentation_obj_sliders_2", -3, 3),
        (create_slider_overlay, "$g_presentation_obj_sliders_3", -3, 3),
        (create_slider_overlay, "$g_presentation_obj_sliders_4", -3, 3),
		(create_slider_overlay, "$g_presentation_obj_sliders_5", -3, 3),#<-dplmc+ added
        (assign, reg1, 25),
		##dplmc+ start incremented sliders by 1... (and changed since things might not be at their initial values)
		(store_add, ":text", "str_dplmc_neither_centralize_nor_decentralized", ":centralization"),
        (create_text_overlay, "$g_presentation_obj_sliders_6", ":text"),
		(store_add, ":text", "str_dplmc_neither_aristocratic_nor_plutocratic", ":aristocratcy"),
        (create_text_overlay, "$g_presentation_obj_sliders_7", ":text"),
		(store_add, ":text", "str_dplmc_mixture_serfs", ":serfdom"),
        (create_text_overlay, "$g_presentation_obj_sliders_8", ":text"),
		(store_add, ":text", "str_dplmc_mediocre_quality", ":quality"),
        (create_text_overlay, "$g_presentation_obj_sliders_9", ":text"),
		##dplmc+ end incremented sliders by 1
		(store_add, ":text", "str_dplmc_neither_mercantilist_nor_laissez_faire", ":mercantilism"),
		(create_text_overlay, "$g_presentation_obj_sliders_10", ":text"),#<- dplmc+ added

        (create_text_overlay, "$g_presentation_obj_1", "@Centralization:"),
        (create_text_overlay, "$g_presentation_obj_2", "@Aristocracy:"),
        (create_text_overlay, "$g_presentation_obj_3", "@Serfdom:"),
        (create_text_overlay, "$g_presentation_obj_4", "@Troop quality:"),
		(create_text_overlay, "$g_presentation_obj_5", "@Mercantilism:"),#<-- dplmc+ added
		#dplmc+ start incremented obj by 1...
        (create_text_overlay, "$g_presentation_obj_6", "@High centralization reduces tax inefficiency for the king and raises it for vassals. This will interfere  the relations between ruler and vassals."),
        (create_text_overlay, "$g_presentation_obj_7", "@High aristocracy will improve the relations between the king and his vassals who will be able to raise bigger armies but it will decreased trade."),
        (create_text_overlay, "$g_presentation_obj_8", "@High serfdom reduces tax inefficiency for the king and his vassals and vassals can maintain bigger armies but troops loose moral."),
        (create_text_overlay, "$g_presentation_obj_9", "@High troop quality increases the strength of troops but decreases army size."),
		#dplmc+ end incremented obj by 1
		(create_text_overlay, "$g_presentation_obj_10", "@Mercantilistic policies maximize exports while minimizing imports, and increase government regulation of industry."),#<-dplmc+ added

		##Moved earlier
        #(faction_get_slot, ":centralization", "fac_player_supporters_faction", dplmc_slot_faction_centralization),
        #(faction_get_slot, ":aristocratcy", "fac_player_supporters_faction", dplmc_slot_faction_aristocracy),
        #(faction_get_slot, ":serfdom", "fac_player_supporters_faction", dplmc_slot_faction_serfdom),
        #(faction_get_slot, ":quality", "fac_player_supporters_faction", dplmc_slot_faction_quality),
		#(faction_get_slot, ":mercantilism", "fac_player_supporters_faction", dplmc_slot_faction_quality),#<- dplmc+ added

        (overlay_set_val, "$g_presentation_obj_sliders_1", ":centralization"),
        (overlay_set_val, "$g_presentation_obj_sliders_2", ":aristocratcy"),
        (overlay_set_val, "$g_presentation_obj_sliders_3", ":serfdom"),
        (overlay_set_val, "$g_presentation_obj_sliders_4", ":quality"),
		(overlay_set_val, "$g_presentation_obj_sliders_5", ":mercantilism"),#<- dplmc+ added
        (position_set_x, pos1, 200),

		##SLIDERS
		#dplmc start+ pushed all items by 150, then dropped all items by 75, then decreased the spacing from 150 to 100
        (position_set_y, pos1, 575),#750),
        (overlay_set_position, "$g_presentation_obj_sliders_1", pos1),
        (position_set_y, pos1, 450),#600),
        (overlay_set_position, "$g_presentation_obj_sliders_2", pos1),
        (position_set_y, pos1, 325),#450),
        (overlay_set_position, "$g_presentation_obj_sliders_3", pos1),
        (position_set_y, pos1, 200),#300),
        (overlay_set_position, "$g_presentation_obj_sliders_4", pos1),
		#dplmc end+ end pushed all items by 150
        (position_set_y, pos1, 75),#150), #<- dplmc+ added
        (overlay_set_position, "$g_presentation_obj_sliders_5", pos1),#<- dplmc+ added


		##HEADERS
        (position_set_x, pos1, 100),
		#dplmc+ start pushed all items by 150, then dropped all items by 75, then changed the spacing to 100
        (position_set_y, pos1, 625),#800),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (position_set_y, pos1, 500),#650),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        (position_set_y, pos1, 375),#500),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
        (position_set_y, pos1, 250),#350),
        (overlay_set_position, "$g_presentation_obj_4", pos1),
		#dplmc+ end pushed all items by 150
		(position_set_y, pos1, 125),#200), #<- dplmc+ added
        (overlay_set_position, "$g_presentation_obj_5", pos1), #<- dplmc+ added

		##SLIDER DESCRIPTIONS
        (position_set_x, pos1, 50),
		#dplmc+ start pushed all items by 150, and incremented obj by 1, then dropped all items by 75, then raised it 10, then changed the spacing to 100
        (position_set_y, pos1, 550),#700),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
        (position_set_y, pos1, 425),#550),
        (overlay_set_position, "$g_presentation_obj_7", pos1),
        (position_set_y, pos1, 300),#400),
        (overlay_set_position, "$g_presentation_obj_8", pos1),
        (position_set_y, pos1, 175),#250),
        (overlay_set_position, "$g_presentation_obj_9", pos1),
		#dplmc+ end pushed all items by 150, and incremented obj by 1
		(position_set_y, pos1, 50),#100), #<- dplmc+ added
        (overlay_set_position, "$g_presentation_obj_10", pos1), #<- dplmc+ added

        (position_set_x, pos1, 775),
        (position_set_y, pos1, 775),
		#dplmc+ start increment obj by 1
        (overlay_set_size, "$g_presentation_obj_6", pos1),
        (overlay_set_size, "$g_presentation_obj_7", pos1),
        (overlay_set_size, "$g_presentation_obj_8", pos1),
        (overlay_set_size, "$g_presentation_obj_9", pos1),
		#dplmc+ end increment obj by 1
		(overlay_set_size, "$g_presentation_obj_10", pos1),#<- dplmc+ added

		##SLIDER LEVEL TEXT
        (position_set_x, pos1, 400),#400),
		#dplmc+ start pushed all items by 150, and incremented sliders by 1, then dropped all items by 75, then changed the spacing to 100
        (position_set_y, pos1, 575),#750),
        (overlay_set_position, "$g_presentation_obj_sliders_6", pos1),
        (position_set_y, pos1, 450),#600),
        (overlay_set_position, "$g_presentation_obj_sliders_7", pos1),
        (position_set_y, pos1, 325),#450),
        (overlay_set_position, "$g_presentation_obj_sliders_8", pos1),
        (position_set_y, pos1, 200),#300),
        (overlay_set_position, "$g_presentation_obj_sliders_9", pos1),
		#dplmc+ end pushed all items by 150, and incremented sliders by 1
		(position_set_y, pos1, 75),#150),#<- dplmc+ added
        (overlay_set_position, "$g_presentation_obj_sliders_10", pos1),#<- dplmc+ added

        (position_set_x, pos1, 925),
        (position_set_y, pos1, 925),
		#dplmc+ start incremented sliders by 1
        (overlay_set_size, "$g_presentation_obj_sliders_6", pos1),
        (overlay_set_size, "$g_presentation_obj_sliders_7", pos1),
        (overlay_set_size, "$g_presentation_obj_sliders_8", pos1),
        (overlay_set_size, "$g_presentation_obj_sliders_9", pos1),
		#dplmc+ end incremented sliders by 1
		(overlay_set_size, "$g_presentation_obj_sliders_10", pos1),#<- dplmc+ added
        ]),
      (ti_on_presentation_run,
       [
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        ##nested diplomacy start+
		#Added new option, so had to increment some sliders
        (try_begin),
          (eq, ":object", "$g_presentation_obj_sliders_1"),
          (faction_set_slot,  "fac_player_supporters_faction", dplmc_slot_faction_centralization, ":value"),
          (val_add, ":value", "str_dplmc_neither_centralize_nor_decentralized"),
          (overlay_set_text, "$g_presentation_obj_sliders_6", ":value"),#dplmc+ incremented "sliders"
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_2"),
          (faction_set_slot,  "fac_player_supporters_faction", dplmc_slot_faction_aristocracy, ":value"),
          (val_add, ":value", "str_dplmc_neither_aristocratic_nor_plutocratic"),
          (overlay_set_text, "$g_presentation_obj_sliders_7", ":value"),#dplmc+ incremented "sliders"
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_3"),
          (faction_set_slot,  "fac_player_supporters_faction", dplmc_slot_faction_serfdom, ":value"),
          (val_add, ":value", "str_dplmc_mixture_serfs"),
          (overlay_set_text, "$g_presentation_obj_sliders_8", ":value"),#dplmc+ incremented "sliders"
        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_4"),
          (faction_set_slot,  "fac_player_supporters_faction", dplmc_slot_faction_quality, ":value"),
          (val_add, ":value", "str_dplmc_mediocre_quality"),
          (overlay_set_text, "$g_presentation_obj_sliders_9", ":value"),#dplmc+ incremented "sliders"
		#Finished incremented sliders.
		(else_try),
		  #dplmc+ new option: mercantilism
		  (eq, ":object", "$g_presentation_obj_sliders_5"),
          (faction_set_slot,  "fac_player_supporters_faction", dplmc_slot_faction_mercantilism, ":value"),
          (val_add, ":value", "str_dplmc_neither_mercantilist_nor_laissez_faire"),
          (overlay_set_text, "$g_presentation_obj_sliders_10", ":value"),
		#Change variable associated with "Done" button.
        (else_try),
          (eq, ":object", "$g_presentation_obj_12"),#dplmc+ changed 10 to 12
          (assign, "$g_players_policy_set", 1),
          (presentation_set_duration, 0),
        (try_end),
		##nested diplomacy end+
    ]),
  ]),

  ##nested diplomacy start+
  #
  #Make it slightly harder to abuse the AI.
  #For example, some players report randomly starting wars with a faction and
  #demanding a hard-to-take castle until the AI concedes.
  #
  #See changes in logic below for specifics.
  #
  ##nested diplomacy end+
    ("dplmc_peace_terms",0,mesh_load_window,[
      (ti_on_presentation_load,
       [
        (set_fixed_point_multiplier, 1000),
        (presentation_set_duration, 999999),

        # done
        (create_game_button_overlay, "$g_presentation_obj_10", "@Done"),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_10", pos1),

        #cancel
        (create_game_button_overlay, "$g_presentation_obj_9", "@Cancel"),
        (position_set_x, pos1, 100),
        (overlay_set_position, "$g_presentation_obj_9", pos1),

        # title
        (create_text_overlay, reg1, "@Dictate the peace terms", tf_center_justify|tf_vertical_align_center),
        (position_set_x, pos1, 445),
        (position_set_y, pos1, 700),
        (overlay_set_position, reg1, pos1),

        (position_set_y, pos1, 550),
        (create_text_overlay, "$g_presentation_obj_2", "@Select the castle and the amount of money and check the boxes to activate the demand. The demands are combined if both boxes are checked."),
        (position_set_x, pos1, 50),
        (overlay_set_position, "$g_presentation_obj_2", pos1),

        (create_slider_overlay, "$g_presentation_obj_sliders_1", 1, 10),
        (overlay_set_val, "$g_presentation_obj_sliders_1", 1),
        (position_set_x, pos1, 300),
        (position_set_y, pos1, 350),
        (overlay_set_position, "$g_presentation_obj_sliders_1", pos1),
        (assign, "$demanded_money", 1000),
        (assign, "$diplomacy_var", 1),

        (create_text_overlay, "$g_presentation_obj_sliders_2", "@1000 denars"),
        (position_set_x, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_sliders_2", pos1),

        (create_check_box_overlay, "$g_presentation_obj_battle_check0", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 700),
        (overlay_set_position, "$g_presentation_obj_battle_check0", pos1),
        (overlay_set_val, "$g_presentation_obj_battle_check0", 1),

        (assign, "$demanded_castle", 0),
        (assign, ":castle_count", 0),
        (create_combo_button_overlay, "$g_presentation_obj_1"),
        (try_for_range, ":castle", castles_begin, castles_end),
		  ##diplomacy start+
		  (party_slot_eq, ":castle", slot_party_type, spt_castle),
		  ##diplomacy end+
          (store_faction_of_party, ":castle_faction", ":castle"),
          (eq, ":castle_faction", "$g_notification_menu_var1"),
          (str_store_party_name, s2, ":castle"),
          (overlay_add_item, "$g_presentation_obj_1", s2),
          (assign, "$demanded_castle", ":castle"),
          (val_add, ":castle_count", 1),
        (end_try),
        (assign, "$diplomacy_var2", 0),
        (position_set_x, pos1, 300),
        (position_set_y, pos1, 250),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        (overlay_set_val, "$g_presentation_obj_1", ":castle_count"),

        (create_check_box_overlay, "$g_presentation_obj_battle_check1", "mesh_checkbox_off", "mesh_checkbox_on"),
        (position_set_x, pos1, 700),
        (overlay_set_position, "$g_presentation_obj_battle_check1", pos1),

        ]),
      (ti_on_presentation_run,
       [
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),

        (try_begin),
          (eq, ":object", "$g_presentation_obj_1"),

          (assign, ":cur", 0),
          (try_for_range, ":castle", castles_begin, castles_end),
            (store_faction_of_party, ":castle_faction", ":castle"),
            (eq, ":castle_faction", "$g_notification_menu_var1"),
            (try_begin),
              (eq, ":cur", ":value"),
              (assign, "$demanded_castle", ":castle"),
            (try_end),
            (val_add, ":cur", 1),
          (try_end),

        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_check0"),
          (assign, "$diplomacy_var", ":value"),

        (else_try),
          (eq, ":object", "$g_presentation_obj_battle_check1"),
          (assign, "$diplomacy_var2", ":value"),

        (else_try),
          (eq, ":object", "$g_presentation_obj_sliders_1"),
          (store_mul, "$demanded_money",":value", 1000),
		  ##diplomacy start+
		  ##OLD:
          #(assign, reg0, "$demanded_money"),
          #(overlay_set_text, "$g_presentation_obj_sliders_2", "@{reg0} denars"),
		  ##NEW:
		  (assign, reg1, "$demanded_money"),
		  (overlay_set_text, "$g_presentation_obj_sliders_2", "str_reg1_denars"),
		  ##diplomacy end+

        (else_try),
          (eq, ":object", "$g_presentation_obj_9"),
          (presentation_set_duration, 0),
        (else_try),
          (eq, ":object", "$g_presentation_obj_10"),
          (presentation_set_duration, 0),

          (try_begin),
            (eq, "$diplomacy_var", 0),
            (assign, "$demanded_money", 0),
          (try_end),

          (try_begin),
            (eq, "$diplomacy_var2", 0),
            (assign, "$demanded_castle", 0),
          (try_end),

          (assign, ":demand", 0),
          (try_begin),
            (gt, "$demanded_money", 0),
            (store_div, ":demand", "$demanded_money", 1000),
          (try_end),
		  ##nested diplomacy start+
		  #OLD:
		  #(try_begin),
          #   (is_between, "$demanded_castle", castles_begin, castles_end),
          #   (val_add, ":demand", 12),
          #(try_end),
		  #NEW:
		  #
		  #Not all castles are created equal.
		  (assign, ":npc_faction", "$g_notification_menu_var1"),

		  (assign, ":player_faction", "fac_player_supporters_faction"),
		  (try_begin),
		     (neg|faction_slot_eq, ":player_faction", slot_faction_state, sfs_active),
			 (is_between, "$players_kingdom", npc_kingdoms_begin, npc_kingdoms_end),
			 (assign, ":player_faction", "$players_kingdom"),
		  (try_end),

		  #(assign, ":castle_value", 0),
		  (assign, ":was_taken_recently", 0),
		  (assign, ":would_make_lord_fiefless", 0),
		  (assign, ":distance_factor", 100),#If positive, 100 times the ratio of distance of closest friendly center to closest enemy center; if negative, 100 times the ratio of the distance of the closest enemy center to the closest friendly center.
		  (try_begin),
			(is_between, "$demanded_castle", castles_begin, castles_end),
			## (1) Determine whether or not the demanded castle was taken recently.
			(try_begin),
				#This version of Diplomacy+ saves transfer times, so we can check directly.
				(neg|party_slot_eq, "$demanded_castle", dplmc_slot_center_last_transfer_time, 0),
				(store_current_hours, ":hours_since_capture"),
				(party_get_slot, reg0, "$demanded_castle", dplmc_slot_center_last_transfer_time),
				(val_sub, ":hours_since_capture", reg0),
				(try_begin),
					#In the last month (i.e. about a war)
					(lt, ":hours_since_capture", 31 * 24),
					(assign, ":was_taken_recently", 1),
				(else_try),
					#For non-core castles, extend the definition of recent to the last three months
					(neg|party_slot_eq, "$demanded_castle", slot_center_original_faction, ":npc_faction"),
					(lt, ":hours_since_capture", 91 * 24),
					(assign, ":was_taken_recently", 1),
				(else_try),
					(assign, ":was_taken_recently", 0),
				(try_end),
			(else_try),
				#This is an old saved game, so use some rules of thumb.
				#If the player faction is the original or previous owner, it might have been taken recently.
				(this_or_next|party_slot_eq, "$demanded_castle", slot_center_original_faction, "$players_kingdom"),
				(this_or_next|party_slot_eq, "$demanded_castle", slot_center_ex_faction, "$players_kingdom"),
					(party_slot_eq, "$demanded_castle", slot_center_ex_faction, "fac_player_supporters_faction"),
				(assign, ":was_taken_recently", 1),
			(else_try),
				#If the original owner is at war with the current owner, it might have been taken recently.
				(neg|party_slot_eq, "$demanded_castle", slot_center_original_faction, ":npc_faction"),
				(party_get_slot, ":third_faction", "$demanded_castle", slot_center_original_faction),
				(is_between, ":third_faction", kingdoms_begin, kingdoms_end),
				(faction_slot_eq, ":third_faction", slot_faction_state, sfs_active),
				(store_relation, reg0, ":npc_faction", ":third_faction"),
				(lt, reg0, 0),
				(assign, ":was_taken_recently", 1),
			(else_try),
				#If the ex-owner is at war with the current owner, it might have been taken recently.
				(neg|party_slot_eq, "$demanded_castle", slot_center_ex_faction, ":npc_faction"),
				(party_get_slot, ":third_faction", "$demanded_castle", slot_center_ex_faction),
				(is_between, ":third_faction", kingdoms_begin, kingdoms_end),
				(faction_slot_eq, ":third_faction", slot_faction_state, sfs_active),
				(store_relation, reg0, ":npc_faction", ":third_faction"),
				(lt, reg0, 0),
				(assign, ":was_taken_recently", 1),
			(else_try),
				#If there is no assigned lord, it was taken recently.
				(neg|party_slot_ge, "$demanded_castle", slot_town_lord, 0),
				(assign, ":was_taken_recently", 1),
			(try_end),##End "Was taken recently?"
			## (2) Determine whether handing over the demanded castle would cost any lord his last fief.
			## (2a: At the same time, calculate the closest friendly & enemy walled centers)
			(party_slot_ge, "$demanded_castle", slot_town_lord, 1),
			(party_get_slot, ":lord_a", "$demanded_castle", slot_town_lord),
			(assign, ":lord_b", -1),
			(assign, ":would_make_lord_fiefless", 1),
			(assign, ":distance_to_friendly_fortress", 10000),
			(assign, ":distance_to_enemy_fortress", 10000),
			(try_for_range, ":center_no", centers_begin, centers_end),
				(neq, ":center_no", "$demanded_castle"),
				#Check for fieflessness
				(try_begin),
					(party_slot_eq, ":center_no", slot_village_bound_center, "$demanded_castle"),
					(neg|party_slot_eq, ":center_no", slot_town_lord, ":lord_a"),
					(party_slot_ge, ":center_no", slot_town_lord, 1),
					(party_get_slot, ":lord_b", ":center_no", slot_town_lord),
				(else_try),
					(party_slot_eq, ":center_no", slot_town_lord, ":lord_a"),
					(neg|party_slot_eq, ":center_no", slot_village_bound_center, "$demanded_castle"),
					(assign, ":would_make_lord_fiefless", 0),
				(try_end),
				#For walled centers check distance
				(this_or_next|party_slot_eq, ":center_no", slot_party_type, spt_town),
					(this_or_next|party_slot_eq, ":center_no", slot_party_type, spt_castle),

				(store_faction_of_party, ":center_faction", ":center_no"),
				(store_distance_to_party_from_party, ":cur_distance", ":center_no", "$demanded_castle"),

				(call_script, "script_dplmc_get_faction_truce_length_with_faction", ":center_faction", ":npc_faction"),
				(try_begin),
					(this_or_next|gt, reg0, dplmc_treaty_defense_days_expire),
					(eq, ":center_faction", ":npc_faction"),
					(val_min, ":distance_to_friendly_fortress", ":cur_distance"),
				(else_try),
					(store_relation, reg0, ":center_faction", ":npc_faction"),
					(val_min, ":distance_to_enemy_fortress", ":cur_distance"),
				(try_end),
			(try_end),
			#(2a, set distance factor based on closest other fortress)
			(assign, ":distance_factor", 100),
			(try_begin),
				(this_or_next|ge, ":distance_to_friendly_fortress", 10000),
					(ge, ":distance_to_enemy_fortress", 10000),
				#No fortress found for one or both
			(else_try),
				#Friendly is closer
				(lt, ":distance_to_friendly_fortress", ":distance_to_enemy_fortress"),
				(gt, ":distance_to_enemy_fortress", 25),#Within 25 ignore differences
				(val_max, ":distance_to_friendly_fortress", 1),
				(store_mul, ":distance_factor", ":distance_to_enemy_fortress", 100),
				(val_div, ":distance_factor", ":distance_to_friendly_fortress"),
				(try_begin),
					(le, ":distance_to_enemy_fortress", 50),
					(val_min, ":distance_factor", 200),
				(try_end),
			(else_try),
				#Enemy is closer
				(lt, ":distance_to_enemy_fortress", ":distance_to_friendly_fortress"),
				(gt, ":distance_to_friendly_fortress", 25),#Within 25 ignore differences
				(val_max, ":distance_to_enemy_fortress", 1),
				(store_mul, ":distance_factor", ":distance_to_friendly_fortress", 100),
				(val_div, ":distance_factor", ":distance_to_enemy_fortress"),
				(try_begin),
					(le, ":distance_to_friendly_fortress", 50),
					(val_min, ":distance_factor", 200),
				(try_end),
				(val_mul, ":distance_factor", -1),
			(try_end),##end 2a: distance factor

			(neq, ":would_make_lord_fiefless", 1),#If we already know it would make the castle owner fiefless, stop.
			(ge, ":lord_b", 1),
			(assign, ":would_make_lord_fiefless", 1),
			(try_for_range, ":center_no", centers_begin, centers_end),
				(party_slot_eq, ":center_no", slot_town_lord, ":lord_b"),
				(this_or_next|neg|is_between, ":center_no", villages_begin, villages_end),
					(neg|party_slot_eq, ":center_no", slot_village_bound_center, "$demanded_castle"),
					(assign, ":would_make_lord_fiefless", 0),
			(try_end),
		  (try_end),##end 2: would make lord fiefless?
		  (assign, ":castle_strength_ratio", 100),
		  (assign, ":high_ratio", 150),
		  (try_begin),
			(is_between, "$demanded_castle", castles_begin, castles_end),
			#(3) Determine typical castle strength
			(assign, ":typical_strength", 0),
			(assign, ":high_ratio", 0),#<- for now, store max strength seen
			(try_for_range, ":center_no", castles_begin, castles_end),
				(try_begin),
					(eq, "$g_dplmc_terrain_advantage", DPLMC_TERRAIN_ADVANTAGE_ENABLE),
					(call_script, "script_dplmc_party_calculate_strength_in_terrain", ":center_no", dplmc_terrain_code_siege, 0, 1),
					#Outputs to reg0 (using terrain) and reg1 (not using terrain).  We'll be using reg1,
					#but the function will be updating the cached strength using the terrain version (as I want).
					(assign, reg0, reg1),
				(else_try),
					#Use the non-terrain-modified strength script.
					(call_script, "script_party_calculate_strength", ":center_no", dplmc_terrain_code_siege, 0),
				(try_end),

				(val_max, reg0, 250),#A certain minimum scale is assumed
				(val_add, ":typical_strength", reg0),
				(val_max, ":high_ratio", reg0),#keep track of max
				(eq, ":center_no", "$demanded_castle"),
				(assign, ":castle_strength_ratio", reg0),
			(try_end),
			(try_begin),
				(gt, castles_end, castles_begin),
				(store_sub, reg0, castles_end, castles_begin),
				(val_div, ":typical_strength", reg0),
			(try_end),
			(val_max, ":typical_strength", 300),#<- A certain minimum scale is assumed
			(val_mul, ":castle_strength_ratio", 100),
			(val_mul, ":high_ratio", 100),

			(store_div, reg0, ":typical_strength", 2),

			(val_add, ":castle_strength_ratio", reg0),
			(val_add, ":high_ratio", reg0),

			(val_div, ":castle_strength_ratio", ":typical_strength"),
			(val_div, ":high_ratio", ":typical_strength"),

			(assign, reg0, ":castle_strength_ratio"),
			(val_max, reg0, 100),
			(val_mul, reg0, 12),#Scale so that 100 is 12, 200 is 24, etc.
			(val_add, reg0, 50),
			(val_div, reg0, 100),
			(val_add, ":demand", reg0),

			(val_sub, ":high_ratio", 100),
			(val_div, ":high_ratio", 2),
			(val_add, ":high_ratio", 100),
			(val_clamp, ":high_ratio", 110, 400),
		  (try_end),##end (3) determine typical castle strength

		  ##Next line: replace fac_player_supporters_faction with :player_faction
          (call_script, "script_npc_decision_checklist_peace_or_war", "$g_notification_menu_var1", ":player_faction", -1),

		  ##Save the unmodified numbers for later
		  (assign, ":check_peace_war_result", reg0),
		  #(assign, ":original_demand", ":demand"),
		  ##diplomacy end+
          (assign, ":goodwill", reg0),
          (val_mul, ":goodwill", 2),
          (store_random_in_range, ":random", 0, ":demand"),

          (val_div, ":demand", -2),

          (call_script, "script_change_player_relation_with_faction", "$g_notification_menu_var1", ":demand"),
		  ##diplomacy start+
		  #Count "third party" kingdoms: kingdoms that aren't either the player's kingdom
		  #or the other kingdom in the negotiations, and that aren't allied to either.
		  #(faction_get_slot, ":npc_faction_leader", ":npc_faction", slot_faction_leader),
		  (assign, ":other_players", 0),
		  (try_for_range, ":third_faction", kingdoms_begin, kingdoms_end),
			 #Active faction
		     (faction_slot_eq, ":third_faction", slot_faction_state, sfs_active),
			 (neq, ":third_faction", ":npc_faction"),
			 (neq, ":third_faction", "fac_player_supporters_faction"),
			 (neq, ":third_faction", "$players_kingdom"),
			 #Not allied (full alliance or defensive alliance) to either faction
			 (call_script, "script_dplmc_get_faction_truce_length_with_faction", ":third_faction", ":npc_faction"),
			 (le, reg0, dplmc_treaty_defense_days_expire),
			 (call_script, "script_dplmc_get_faction_truce_length_with_faction", ":third_faction", "$players_kingdom"),
			 (le, reg0, dplmc_treaty_defense_days_expire),
			 (val_add, ":other_players", 1),
		  (try_end),
		  #Improve the AI's decision-making somewhat.
		  (game_get_reduce_campaign_ai, ":reduce_campaign_ai"),
		  (val_clamp, ":reduce_campaign_ai", 0, 3),#0 is hard, 1 is medium, 2 is easy
		  (try_begin),
            #This should never be reached.
				(lt, ":check_peace_war_result", 0),
            (this_or_next|is_between, "$demanded_castle", castles_begin, castles_end),
               (gt, "$demanded_money", 0),
			(jump_to_menu,"mnu_dplmc_deny_terms"),
        (else_try),
            (is_between, "$demanded_castle", castles_begin, castles_end),
				(lt, ":check_peace_war_result", 2),
            #Don't enable "fishing" for fiefs, hoping to get a lucky
            #result.  Make the chance of giving a fief zero.
            (this_or_next|party_slot_eq,"$demanded_castle",slot_center_original_faction,":npc_faction"),
            (this_or_next|eq, ":would_make_lord_fiefless", 1),
            (this_or_next|ge, ":castle_strength_ratio", ":high_ratio"),
				(this_or_next|eq, ":was_taken_recently", 0),
               (eq, ":other_players", 0),
			(jump_to_menu,"mnu_dplmc_deny_terms"),
        (else_try),
            (is_between, "$demanded_castle", castles_begin, castles_end),
            #Some things will just never be agreed to.
				#If three or more of the following are true, reject:
				#- The demanded castle was not taken recently
				#- The demanded castle is one of the faction's original castles
				#- Giving the castle would make some lords fiefless
				#- The castle has an especially large garrison
				#- Aside from the player's faction and the NPC faction (and their allies),
				#  there are no other kingdoms.
				#- The demanded castle is significantly deeper within the NPC kingdom's territory
				#  than it is close to enemy territory
            (assign, reg0, 1),
			(val_sub, reg0, ":was_taken_recently"),
			(val_max, reg0, 0),
            (try_begin),#Check: is the castle part of the faction's original territory?
               (party_slot_eq,"$demanded_castle",slot_center_original_faction,":npc_faction"),
			   (val_add, reg0, 1),
            (try_end),
			(val_max, ":would_make_lord_fiefless", 0),
			(val_add, reg0, ":would_make_lord_fiefless"),
			(try_begin),#Check: castle has high strength compared to average?
				 (ge, ":castle_strength_ratio", ":high_ratio"),
				 (val_add, reg0, 1),
			(try_end),
			(try_begin),#Check: no one else remaining?
				 (eq, ":other_players", 0),
				 (val_add, reg0, 1),
			(try_end),
			(try_begin),#Check: is it much closer to friendly centers than enemy centers?
				(ge, ":distance_factor", 190),
				(val_add, reg0, 1),
			(try_end),
			(val_add, ":random", reg0),#Even if less than 3 are met, other factors will still decrease likelihood of acceptance.

			(ge, reg0, 3),
			(jump_to_menu,"mnu_dplmc_deny_terms"),
        (else_try),
			#SPECIAL CASE: Two Kingdoms Remain
			(eq, ":other_players", 0),
			(this_or_next|is_between, "$demanded_castle", castles_begin, castles_end),
				(gt, "$demanded_money", 0),
			(is_between, ":npc_faction", kingdoms_begin, kingdoms_end),
			(assign, ":minimum_peace_war_result", 2),
			(try_begin),
				#Hard: never accept.
				(eq, ":reduce_campaign_ai", 0),
				(store_add, ":minimum_peace_war_result", ":check_peace_war_result", 1),
				(val_max, ":minimum_peace_war_result", 4),
			(else_try),
				#Medium: never give up fiefs, sometimes accept other deals.
				(eq, ":reduce_campaign_ai", 1),
				(is_between, "$demanded_castle", castles_begin, castles_end),
				(store_add, ":minimum_peace_war_result", ":check_peace_war_result", 1),
				(val_max, ":minimum_peace_war_result", 4),
			(else_try),
				#Easy: sometimes accept.
				(eq, ":reduce_campaign_ai", 2),
			(try_end),
			(lt, ":check_peace_war_result", ":minimum_peace_war_result"),
			(jump_to_menu,"mnu_dplmc_deny_terms"),
		  (else_try),
		  #fall through to other behavior
		  ##diplomacy end+
            (le, ":random", ":goodwill"),
            (try_begin),
              (is_between, "$demanded_castle", castles_begin, castles_end),
				  ##diplomacy start+
				  #Relation hit with the owner of the surrendered castle and its village,
				  #if there was a valid owner.
				  (try_begin),
					(party_slot_ge, "$demanded_castle", slot_town_lord, 1),
					(party_get_slot, reg0, ":center_no", slot_town_lord),
					(call_script, "script_change_player_relation_with_troop", reg0, -1),
				  (try_end),
				  (try_for_range, ":center_no", villages_begin, villages_end),
					(party_slot_eq, ":center_no", slot_village_bound_center, "$demanded_castle"),
					(party_slot_ge, ":center_no", slot_town_lord, 1),
					(party_get_slot, reg0, ":center_no", slot_town_lord),
					(call_script, "script_change_player_relation_with_troop", reg0, -1),
				  (try_end),
			  ##Change next to use :player_faction instead of fac_player_supporters_faction
              (call_script, "script_give_center_to_faction", "$demanded_castle", ":player_faction"),
			  ##diplomacy end+
            (try_end),
            (try_begin),
              (gt, "$demanded_money", 0),
              (call_script, "script_dplmc_pay_into_treasury", "$demanded_money"),
			  ##diplomacy start+ other faction loses money
			  #Since setting terms for surrender is a non-native feature, there is no need to make this optional.
			  (faction_get_slot, ":faction_leader", "$g_notification_menu_var1", slot_faction_leader),
			  (try_begin),
				(ge, ":faction_leader", 1),
				(neq, "$g_notification_menu_var1", "$players_kingdom"),
				(neq, "$g_notification_menu_var1", "fac_player_supporters_faction"),
				(ge, "$demanded_money", 1),
				(assign, ":cost_to_leader", "$demanded_money"),
				#(try_begin),
				#	 (faction_get_slot, ":marshall", "$g_notification_menu_var1", slot_faction_marshall),
				#	 (neq, ":marshall", "trp_player"),
				#	 (neq, ":marshall", ":faction_leader"),
				#	 (ge, ":marshall", 0),
				#	 (store_troop_gold, reg0, ":marshall"),
				#	 (store_troop_gold, reg1, ":faction_leader"),
				#	 (val_add, reg1, reg0),
				#	 (gt, reg1, 0),
				#	 (store_mul, ":cost_to_marshall", "$demanded_money", reg0),
				#	 (val_div, ":cost_to_marshall", reg1),
				#	 (store_div, reg0, "$demanded_money", 2),
				#	 (val_min, ":cost_to_marshall", reg0),#no more than 1/2
				#	 (store_mul, reg0, "$demanded_money", 3),
				#	 (val_div, reg0, 13),#no less than 3/13 (6/26 marshall, 20/26 leader)
				#	 (val_max, ":cost_to_marshall", reg0),
				#	 (gt, ":cost_to_marshall", 0),
				#	 (call_script, "script_dplmc_remove_gold_from_lord_and_holdings", ":cost_to_marshall", ":marshall"),
				#	 (val_sub, ":cost_to_leader", ":cost_to_marshall"),
				#	 (store_random_in_range, reg0, 0, 1000),
				#	 (val_add, reg0, ":cost_to_marshall"),
				#	 (val_div, reg0, 1000),
				#	 (ge, reg0, 1),
				#	 (val_mul, reg0, -1),
				#	 (call_script, "script_change_player_relation_with_troop", ":marshall", reg0),
				#(try_end),
				(ge, ":cost_to_leader", 1),
				(call_script, "script_dplmc_remove_gold_from_lord_and_holdings", ":cost_to_leader", ":faction_leader"),
				(store_random_in_range, reg0, 0, 1000),
				(val_add, reg0, ":cost_to_leader"),
				(val_div, reg0, 1000),
				(ge, reg0, 1),
				(val_mul, reg0, -1),
				(call_script, "script_change_player_relation_with_troop", ":faction_leader", reg0),
			  (try_end),
			  ##diplomacy end+
            (try_end),
			##diplomacy start+
            (call_script, "script_diplomacy_start_peace_between_kingdoms", "$g_notification_menu_var1", ":player_faction", 1),
			##diplomacy end+
            (presentation_set_duration, 0),
            (change_screen_return),
          (else_try),
            (jump_to_menu,"mnu_dplmc_deny_terms"),
          (try_end),

        (try_end),
    ]),
  ]),

  # Jrider +
  # REPORTS PRESENTATIONS 1.2 :
  # Factions relations presentation report
  ("jrider_faction_relations_report", 0,
   mesh_message_window,
   [
     (ti_on_presentation_load,
      [
    (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        # Embed picture upper right
        (create_mesh_overlay, reg1, "mesh_pic_castledes"),
        (position_set_x, pos1, 180),
        (position_set_y, pos1, 180),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, 795),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),

        # Embed picture upper left
        (create_mesh_overlay, reg1, "mesh_pic_looted_village"),
        (position_set_x, pos1, 170),
        (position_set_y, pos1, 170),
        (overlay_set_size, reg1, pos1),
        (position_set_x, pos1, -15),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg1, pos1),

    # Presentation title, centered at the top
        (create_text_overlay, reg1, "@_Faction Relations Report_", tf_center_justify),
    (position_set_x, pos1, 500), # Higher, means more toward the right
        (position_set_y, pos1, 670), # Higher, means more toward the top
        (overlay_set_position, reg1, pos1),
    (position_set_x, pos1, 1500),
        (position_set_y, pos1, 1500),
    (overlay_set_size, reg1, pos1),

    # Back to menu - graphical button
    (create_game_button_overlay, reg1, "@_Return to menu_"),
    (position_set_x, pos1, 500),
        (position_set_y, pos1, 23),
        (overlay_set_position, reg1, pos1),
        (assign, "$g_jrider_faction_report_Return_to_menu", reg1),

    # Set Headlines
#set column title
          (assign, ":x_poshl", 250),
          (assign, ":y_pos", 620),
          (position_set_y, pos1, ":y_pos"),
    (try_for_range, ":faction", kingdoms_begin, kingdoms_end),
            (faction_slot_eq, ":faction", slot_faction_state, sfs_active), # continue if active
            (try_begin),
              (is_between, ":faction", npc_kingdoms_begin, npc_kingdoms_end),
              (store_sub, ":offset", ":faction", "fac_kingdom_1"),
              (val_add, ":offset", "str_swadians"),
              (str_store_string, s1, ":offset"),
            (else_try),
              (str_store_string, s1, "@Your Faction"),
            (try_end),

            (str_store_string, s11, ":offset"),
            (create_text_overlay, reg10, s1, tf_left_align|tf_with_outline),
            (faction_get_color, ":faction_color", ":faction"),
            (overlay_set_color, reg10, ":faction_color"),

            (position_set_x, pos3, 650),
            (position_set_y, pos3, 800),
            (overlay_set_size, reg10, pos3),

            (position_set_x, pos1, ":x_poshl"),
            (overlay_set_position, reg10, pos1),
            (val_add, ":x_poshl", 90),
    (try_end),


    (assign, ":x_poshl", 215),
     (assign, ":y_pos", 597),
     (assign, ":headline_size", 0),
    (position_set_x, ":headline_size", 720),
        (position_set_y, ":headline_size", 775),

        (assign, ":hl_columnsep_size", 50),
        (position_set_x, ":hl_columnsep_size", 60),
        (position_set_y, ":hl_columnsep_size", 28000),

        (create_text_overlay, reg2, "@Player^Relation", tf_center_justify),
        (overlay_set_size, reg2, ":headline_size"),
        (position_set_x, pos1, ":x_poshl"),
        (position_set_y, pos1, ":y_pos"),
        (overlay_set_position, reg2, pos1),

        (val_add, ":x_poshl", 45),
        (try_for_range, ":count", 0, 7),
          # create a separator column
          (create_mesh_overlay, reg1, "mesh_white_plane"),
          (overlay_set_color, reg1, 0x000000),
          (overlay_set_size, reg1, ":hl_columnsep_size"),
          (store_sub, ":line_x", ":x_poshl", 15), # set it 21 pix left of current column start
          (store_sub, ":y_pos2", ":y_pos", 500), # set it 21 pix left of current column start
          (position_set_x, pos2, ":line_x"),
          (position_set_y, pos2, ":y_pos2"),
          (overlay_set_position, reg1, pos2),
          (val_add, ":x_poshl", 90),

          (try_begin),
            (eq, "$cheat_mode", 1),
            (assign, reg20, ":count"),
            (display_message, "@{!}DEBUG - Drawing line {reg20}"),
          (try_end),
        (try_end),

        # clear the string globals that we'll use
         (str_clear, s9),
    (str_clear, s8),
    (str_clear, s3),
    (str_clear, s60),
    (str_clear, s61),
    (str_clear, s0),

        # Scrollable area (all the next overlay will be contained in this, s0 sets the scrollbar)
        (create_text_overlay, reg1, s0, tf_scrollable_style_2),
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 70),
        (overlay_set_position, reg1, pos1),
        (position_set_x, pos1, 860),
        (position_set_y, pos1, 527),
        (overlay_set_area_size, reg1, pos1),
        (set_container_overlay, reg1),

        # set base position and size for lines
        (assign, ":line_size", 0),
        (assign, ":y_pos", 0),

        # set base color for line
    (assign, ":line_color", 0x000000),

        # Line faction loop begins here - fetching corresponding informations and printing the line title
        (try_for_range_backwards, ":faction_line", kingdoms_begin, kingdoms_end),
            (faction_slot_eq, ":faction_line", slot_faction_state, sfs_active), # continue if active

            # Base position for subheaders
            (assign, ":x_posfhl", 220),

            # Loop other factions (columns)
            (try_for_range, ":faction_column", kingdoms_begin, kingdoms_end),
                (faction_slot_eq, ":faction_column", slot_faction_state, sfs_active), # continue if active

                (try_begin), # not same faction
                  (neq, ":faction_column", ":faction_line"),

                  (str_store_faction_name, s8, ":faction_column"),

                  # sub-faction excluding current faction line
                  (try_begin),
                      # different from faction line, display status and relation with faction line
                      (neq, ":faction_column", ":faction_line"),
                      (call_script, "script_diplomacy_faction_get_diplomatic_status_with_faction", ":faction_line", ":faction_column"),
                      (assign, ":global_diplomatic_status", reg0),
                      (assign, ":extended_diplomatic_status", reg1),

                      (try_begin), # War
                          (eq, ":global_diplomatic_status", -2),
                          (str_store_string, s60, "@War"),
                          (assign, reg60, 0xDD0000),
                          (assign, reg59, 0),
                      (else_try), # Border incident
                          (eq, ":global_diplomatic_status", -1),
                          (str_store_string, s60, "@Casus Belli"),
                          (assign, reg60, 0xDD8000),
                          (assign, reg59, ":extended_diplomatic_status"),
                      (else_try), # Peace
                          (eq, ":global_diplomatic_status", 0),
                          (str_store_string, s60, "@Peace"),
                          (assign, reg60, 0xFFFFFF),
                          (assign, reg59, 0),
                      (else_try), # Truce (non aggression)
                          (eq, ":global_diplomatic_status", 1),
                          (str_store_string, s60, "@Truce"),
                          (assign, reg60, 0xDDDDDD),
                          (assign, reg59, ":extended_diplomatic_status"),

                          # for Diplomacy, comment if not using
                          (try_begin),
                              (ge, ":extended_diplomatic_status", 61),
                              (str_store_string, s60, "@Alliance"),
                              (assign, reg60, 0x00FF00),
                              (store_sub, reg59, ":extended_diplomatic_status", 60),
                          (else_try),
                              (ge, ":extended_diplomatic_status", 41),
                              (str_store_string, s60, "@Defense"),
                              (assign, reg60, 0x00FFAA),
                              (store_sub, reg59, ":extended_diplomatic_status", 40),
                          (else_try),
                              (ge, ":extended_diplomatic_status", 21),
                              (str_store_string, s60, "@Trade"),
                              (assign, reg60, 0x00FFCC),
                              (store_sub, reg59, ":extended_diplomatic_status", 20),
                          (try_end),
                      (try_end),

                      (val_add, ":x_poshl", 50),

                      # diplomatic status and duration block (set at current line)
                      (create_text_overlay, reg10, s60, tf_left_align|tf_with_outline),
                      (overlay_set_size, reg10, ":line_size"),
                      (overlay_set_color, reg10, reg60),
                      (store_sub, ":line_x", ":x_posfhl", 20),
                      (store_add, ":line_y", ":y_pos", 54),
                      (position_set_x, pos3, ":line_x"),
                      (position_set_y, pos3, ":line_y"),
                      (overlay_set_position, reg10, pos3),

                      (create_text_overlay, reg10, "@{reg59?{reg59} days:}", tf_center_justify),
                      (overlay_set_size, reg10, ":line_size"),
                      (store_add, ":line_y", ":y_pos", 36),
                      (store_add, ":line_x", ":x_posfhl", 10),
                      (position_set_x, pos3, ":line_x"),
                      (position_set_y, pos3, ":line_y"),
                      (overlay_set_position, reg10, pos3),


                      # add diplomatic status
                      (store_relation, ":kingdom_relation", ":faction_line", ":faction_column"),

                      # kingdom relation (same line as faction name)
                      (assign, reg61, ":kingdom_relation"),
                      (create_text_overlay, reg10, "@{reg61}", tf_center_justify),
                      (overlay_set_size, reg10, ":line_size"),

                      (store_add, ":line_y", ":y_pos", 18),
                      (store_add, ":line_x", ":x_posfhl", 10),
                      (position_set_x, pos3, ":line_x"),
                      (position_set_y, pos3, ":line_y"),
                      (overlay_set_position, reg10, pos3),
                  (try_end), # end select alternate display
                (try_end),

                # increase column x position
                (val_add, ":x_posfhl", 90), # valid values 220, 385, 550, 715
            (try_end), # end of column faction loop

            # Faction line information, this is a 4 line block
            # reset x postion for next beginning column and decrease y position according to line count
            (assign, ":x_poshl", 165),

            (val_add, ":y_pos", 54), # linebreak

            # create a separator for faction line
            (create_mesh_overlay, reg1, "mesh_white_plane"),
            (overlay_set_color, reg1, 0x000000),
            (position_set_x, pos1, 42000),
            (position_set_y, pos1, 60),
            (overlay_set_size, reg1, pos1),
            (position_set_x, pos1, 17),
            (store_add, ":line_y", ":y_pos", 20), # set it 20 pix above current line
            (position_set_y, pos1, ":line_y"),
            (overlay_set_position, reg1, pos1),

            # Set line title
            (str_store_faction_name, s9, ":faction_line"),
            (str_store_string, s1, "@{s9}"),
            (create_text_overlay, reg10, s1, tf_left_align|tf_with_outline),
            (faction_get_color, ":faction_color", ":faction_line"),
            (overlay_set_color, reg10, ":faction_color"),

            (position_set_x, pos3, 750),
            (position_set_y, pos3, 850),
            (overlay_set_size, reg10, pos3),

            (position_set_x, pos3, 10),
            (position_set_y, pos3, ":y_pos"),
            (overlay_set_position, reg10, pos3),

            # set position for columns
            (assign, ":x_poshl", 165),
            (assign, ":line_size", 0),
            (position_set_x, ":line_size", 700),
            (position_set_y, ":line_size", 800),

            ## Player relation (first column)
            (store_relation, reg1, "fac_player_supporters_faction", ":faction_line"),

            # no clean strings existing, doing it the same way it's done in game_menu
            (try_begin),
                (ge, reg1, 90),
                (str_store_string, s3, "@Loyal"),
            (else_try),
                (ge, reg1, 80),
                (str_store_string, s3, "@Devoted"),
            (else_try),
                (ge, reg1, 70),
                (str_store_string, s3, "@Fond"),
            (else_try),
                (ge, reg1, 60),
                (str_store_string, s3, "@Gracious"),
            (else_try),
                (ge, reg1, 50),
                (str_store_string, s3, "@Friendly"),
            (else_try),
                (ge, reg1, 40),
                (str_store_string, s3, "@Supportive"),
            (else_try),
                (ge, reg1, 30),
                (str_store_string, s3, "@Favorable"),
            (else_try),
                (ge, reg1, 20),
                (str_store_string, s3, "@Cooperative"),
            (else_try),
                (ge, reg1, 10),
                (str_store_string, s3, "@Accepting"),
            (else_try),
                (ge, reg1, 0),
                (str_store_string, s3, "@Indifferent"),
            (else_try),
                (ge, reg1, -10),
                (str_store_string, s3, "@Suspicious"),
            (else_try),
                (ge, reg1, -20),
                (str_store_string, s3, "@Grumbling"),
            (else_try),
                (ge, reg1, -30),
                (str_store_string, s3, "@Hostile"),
            (else_try),
                (ge, reg1, -40),
                (str_store_string, s3, "@Resentful"),
            (else_try),
                (ge, reg1, -50),
                (str_store_string, s3, "@Angry"),
            (else_try),
                (ge, reg1, -60),
                (str_store_string, s3, "@Hateful"),
            (else_try),
                (ge, reg1, -70),
                (str_store_string, s3, "@Revengeful"),
            (else_try),
                (str_store_string, s3, "@Vengeful"),
            (try_end),

            # Set relation to player numerical value (same line)
            (create_text_overlay, reg10, "@{reg1}", tf_right_align),
            (overlay_set_size, reg10, ":line_size"),
            (store_add, ":line_x", ":x_poshl", 20),
            (position_set_x, pos1, ":line_x"),
            (position_set_y, pos1, ":y_pos"),
            (overlay_set_position, reg10, pos1),
            (overlay_set_color, reg10, ":line_color"),

            # Set relation to player string value (second line)
            (create_text_overlay, reg10, "@{s3}", tf_right_align),
            (overlay_set_size, reg10, ":line_size"),
            (position_set_x, pos1, ":line_x"),
            (store_sub, ":line_y", ":y_pos", 20),
            (position_set_y, pos1, ":line_y"),
            (overlay_set_position, reg10, pos1),
            (overlay_set_color, reg10, ":line_color"),

            # Set Faction Coat of Arm for standard faction (left of relation string)
            (try_begin),
                (neq, ":faction_line", "fac_player_supporters_faction"),
                (store_sub, ":mesh_index", ":faction_line", kingdoms_begin),
                (val_add, ":mesh_index", "mesh_pic_recruits"),
                (create_mesh_overlay, reg10, ":mesh_index"),
                (position_set_x, pos1, 75),
                (position_set_y, pos1, 75),
                (overlay_set_size, reg10, pos1),
                (position_set_x, pos1, 165),
                (store_sub, ":line_y", ":y_pos", 37),
                (position_set_y, pos1, ":line_y"),
                (overlay_set_position, reg10, pos1),
            (try_end),

            # for current line_faction count lords and centers
            (assign, ":num_lords", 0),
            (assign, ":num_caravans", 0),
            (assign, ":num_centers", 0),
            (assign, ":unassigned_centers", 0),
            (try_for_parties, ":cur_party"),
                (store_faction_of_party, ":cur_faction", ":cur_party"),
                (eq, ":cur_faction", ":faction_line"),

                (try_begin),
                    (party_slot_eq, ":cur_party", slot_party_type, spt_kingdom_hero_party),
                    (val_add, ":num_lords", 1),
                (else_try),
                    (party_slot_eq, ":cur_party", slot_party_type, spt_kingdom_caravan),
                    (val_add, ":num_caravans", 1),
                (else_try),
                    (this_or_next|party_slot_eq, ":cur_party", slot_party_type, spt_town),
                    (this_or_next|party_slot_eq, ":cur_party", slot_party_type, spt_castle),
                    (party_slot_eq, ":cur_party", slot_party_type, spt_village),
                    (val_add, ":num_centers", 1),

                    (try_begin),
                        (party_slot_eq, ":cur_party", slot_town_lord, stl_unassigned),
                        (val_add, ":unassigned_centers", 1),
                    (try_end),
                (try_end),
            (try_end), # end of parties loop

            # Count prisoners
            (assign, ":prisoners", 0),
            (try_for_range, ":lord_id", active_npcs_begin, active_npcs_end),
                (troop_slot_eq, ":lord_id", slot_troop_occupation, slto_kingdom_hero),
                (troop_slot_ge, ":lord_id", slot_troop_prisoner_of_party, 0),
                (store_troop_faction, ":lord_faction", ":lord_id"),
                (eq, ":lord_faction", ":faction_line"),
                (val_add, ":prisoners", 1),
            (try_end),

            # add count to last line for faction line report (second, third and fourth line)
            (assign, reg61, ":num_centers"),
            (assign, reg58, ":unassigned_centers"),
            (create_text_overlay, reg10, "@{reg61} {reg58?({reg58} U) :}Centers", tf_left_align),
            (overlay_set_size, reg10, ":line_size"),
            (position_set_x, pos1, 15),
            (store_sub, ":line_y", ":y_pos", 17),
            (position_set_y, pos1, ":line_y"),
            (overlay_set_position, reg10, pos1),
            (overlay_set_color, reg10, 0x000000),

            (assign, reg62, ":num_caravans"),
            (create_text_overlay, reg10, "@{reg62} Caravans", tf_left_align),
            (overlay_set_size, reg10, ":line_size"),
            (position_set_x, pos1, 15),
            (val_sub, ":line_y", 17),
            (position_set_y, pos1, ":line_y"),
            (overlay_set_position, reg10, pos1),
            (overlay_set_color, reg10, 0x000000),

            (assign, reg60, ":num_lords"),
            (assign, reg59, ":prisoners"),
            (create_text_overlay, reg10, "@{reg60} {reg59?({reg59} P) :}Lords", tf_left_align),
            (overlay_set_size, reg10, ":line_size"),
            (position_set_x, pos1, 15),
            (val_sub, ":line_y", 17),
            (position_set_y, pos1, ":line_y"),
            (overlay_set_position, reg10, pos1),
            (overlay_set_color, reg10, 0x000000),

            # increase line for next faction block
            (val_add, ":y_pos", 18),#linebreak

        (try_end), # end of faction loop
        (set_container_overlay, -1),
   ]),
   ## END on load trigger

   ## Check for buttonpress
   (ti_on_presentation_event_state_change,
    [
        (store_trigger_param_1, ":button_pressed_id"),
        (try_begin),
             (eq, ":button_pressed_id", "$g_jrider_faction_report_Return_to_menu"), # pressed  (Return to menu)
        (presentation_set_duration, 0),
    (try_end),
    ]),
   ## END presentation event state change trigger

   ## Event to process when running the presentation
   (ti_on_presentation_run,
    [
        (try_begin),
      (this_or_next|key_clicked, key_escape),
      (key_clicked, key_right_mouse_button),
      (presentation_set_duration, 0),
      (jump_to_menu, "mnu_reports"),
        (try_end),

        ]),
   ]),
  # END presentation run trigger
  # END Faction relation presentation
  # Jrider -
  # Jrider +
  ##############################################################################
  # REPORT PRESENTATIONS v1.2 
  ## Character relations report
  ("jrider_character_relation_report", 0,
   mesh_message_window,
   [
     ## Load Presentation
     (ti_on_presentation_load,
      # generic_ti_on_load +
      [
    (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        (str_clear, s0),
        (str_clear, s1),

        # Character presentation type variations
        (try_begin),
            ###############################
            ## Courtship Relations presentation
            (eq, "$g_character_presentation_type", 0),

            # Set presentation title string
            (str_store_string, s0, "@_Courtships in progress_"),

            # Set size of listbox
            (assign, ":base_scroll_y", 160),
            (assign, ":base_scroll_size_y", 480),
            (assign, ":base_candidates_y", 0), # scrollable area size minus (one line size + 2) 430

            # Set storage index
            (assign, "$g_base_character_presentation_storage_index", 1000),

            # presentation specific extra overlays
            (call_script, "script_generate_knonwn_poems_string"),

            # Extra text area for knowns poems (filling once so we use a register), filled from s1 generated in script call
            (create_text_overlay, reg1, s1, tf_left_align),
            (position_set_x, pos1, 590), # position
            (position_set_y, pos1, 55),
            (overlay_set_position, reg1, pos1),
            (position_set_x, pos1, 750), # size
            (position_set_y, pos1, 850),
            (overlay_set_size, reg1, pos1),
            (overlay_set_color, reg1, 0xFF66CC), # color
        (else_try),
            ###############################
            ## Lord Relations presentation
            (eq, "$g_character_presentation_type", 1),

            # Set presentation title string
            (str_store_string, s0, "@_Known Lords by Relation_"),

            # Set size of listbox
            (assign, ":base_scroll_y", 110),
            (assign, ":base_scroll_size_y", 550), 
            (assign, ":base_candidates_y", 0), # scrollable area size minus 530

            # Set storage index
            (assign, "$g_base_character_presentation_storage_index", 2000),
        (else_try),
            ###############################
            ## Player and Companions presentation
            (eq, "$g_character_presentation_type", 2),

            # Set presentation title string
            (str_store_string, s0, "@_Character & Companions_"),

            # Set size of listbox
            (assign, ":base_scroll_y", 110),
            (assign, ":base_scroll_size_y", 550),
            (assign, ":base_candidates_y", 0), # scrollable area size minus (one line size + 2) 530

            # Set storage index
            (assign, "$g_base_character_presentation_storage_index", 3000),

            # Extra area for equipment display
            (assign, ":inv_bar_size", 0),
            (position_set_x, ":inv_bar_size", 400),
            (position_set_y, ":inv_bar_size", 400),

            (create_mesh_overlay, reg1, "mesh_mp_inventory_left"),
            (position_set_x, pos1, 67),
            (position_set_y, pos1, 300),
            (overlay_set_position, reg1, pos1),
            (overlay_set_size, reg1, ":inv_bar_size"),

            (create_mesh_overlay, reg1, "mesh_mp_inventory_right"),
            (position_set_x, pos1, 450),
            (position_set_y, pos1, 330),
            (overlay_set_position, reg1, pos1),
            (overlay_set_size, reg1, ":inv_bar_size"),
        (try_end),
        # END of presentation type specific init and static overlay

        ###############################
        # Create common overlays
        # set foreground mesh overlay (has some transparency in it, so can't use it directly)
        (create_mesh_overlay, reg1, "mesh_face_gen_window"),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, 0),
        (overlay_set_position, reg1, pos1),
    (position_set_x, pos1, 1000),
        (position_set_y, pos1, 1000),
    (overlay_set_size, reg1, pos1),

    # Presentation title overlay, centered at the top of right pane (from s0, presentation type specific)
        (create_text_overlay, reg1, s0, tf_center_justify),
        (overlay_set_color, reg1, 0xDDDDDD),
    (position_set_x, pos1, 740), # Higher, means more toward the right
        (position_set_y, pos1, 680), # Higher, means more toward the top
        (overlay_set_position, reg1, pos1),
    (position_set_x, pos1, 1200),
        (position_set_y, pos1, 1200),
    (overlay_set_size, reg1, pos1),

    # Done button
        (create_game_button_overlay, "$g_jrider_character_report_Return_to_menu", "@_Done_"),
    (position_set_x, pos1, 290),
        (position_set_y, pos1, 10),
        (overlay_set_position, "$g_jrider_character_report_Return_to_menu", pos1),


        # Character Information text to fill when an entry is clicked in the list
        (create_text_overlay, "$g_jrider_character_information_text", "str_space", tf_left_align),
        (overlay_set_color, "$g_jrider_character_information_text", 0x000000), #0xFFFFFF
        (position_set_x, pos1, 55), # Higher, means more toward the right
        (position_set_y, pos1, 60), # Higher, means more toward the top
        (overlay_set_position, "$g_jrider_character_information_text", pos1),
        (position_set_x, pos1, 700), # smaller means smaller font
        (position_set_y, pos1, 800),
        (overlay_set_size, "$g_jrider_character_information_text", pos1),

        # Character selection listbox overlay
        # use scrollable text area with global reference so objects can be put inside using overlay_set_container
        (create_text_overlay, "$g_jrider_character_relation_listbox", "str_empty_string", tf_scrollable_style_2),
        (position_set_x, pos1, 590),
        (position_set_y, pos1, ":base_scroll_y"),
        (overlay_set_position, "$g_jrider_character_relation_listbox", pos1),
        (position_set_x, pos1, 335),
        (position_set_y, pos1, ":base_scroll_size_y"),
        (overlay_set_area_size, "$g_jrider_character_relation_listbox", pos1),

        # Faction filter
        (create_combo_button_overlay, "$g_jrider_character_faction_filter", "str_empty_string",0),
        (position_set_x, pos1, 507),
        (position_set_y, pos1, 709),
        (overlay_set_position, "$g_jrider_character_faction_filter", pos1),
        (position_set_x, pos1, 550),
        (position_set_y, pos1, 650),
        (overlay_set_size, "$g_jrider_character_faction_filter", pos1),

        # add elements to filter button
		(try_begin), #Hispania 1200, hablar con todos, rey, bug
			(eq, "$jugador_rey",1),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",2),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",3),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",4),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",5),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",6),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),			
		
		 (else_try),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(try_end),
		
		
        # (overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
        # (overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
        # (overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
        # (overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
        # (overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
        # (overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
        # (overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
        # (overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),

        # Set initial value for selection box
        (try_begin),
            (this_or_next|eq, "$g_jrider_pres_called_from_menu", 1),
            (eq, "$g_jrider_faction_filter", -1),

            (assign, "$g_jrider_faction_filter", -1),
            (overlay_set_val, "$g_jrider_character_faction_filter", 7),
        (else_try),
            (overlay_set_val, "$g_jrider_character_faction_filter", "$g_jrider_faction_filter"),
        (try_end),

        ###############################
        # Populate lists
        # Init presentation common global variables
        (assign, "$num_charinfo_candidates", 0),

        # Fill listbox (overlay_add_item and extra storage)
        (call_script, "script_fill_relation_canditate_list_for_presentation", "$g_character_presentation_type", ":base_candidates_y"),
        (assign, "$g_jrider_reset_selected_on_faction", 0),
        # stop if there's no candidate
        (gt, "$num_charinfo_candidates", 0),

        # get extra information from storage
        (store_add, ":current_storage_index", "$g_base_character_presentation_storage_index", "$g_latest_character_relation_entry"),
        (troop_get_slot, "$character_info_id", "trp_temp_array_c", ":current_storage_index"),

        # Fill text information for current entry and update text information overlay
        (call_script, "script_generate_extended_troop_relation_information_string", "$character_info_id"),
        (overlay_set_text, "$g_jrider_character_information_text", s1),

        # color selected entry
        (overlay_set_color, "$g_jrider_last_checked_indicator", 0xFF6666FF),
        (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0x44),

        # Begin common dynamic overlay
        # mesh Overlay for character portrait (global not needed)
        (create_image_button_overlay_with_tableau_material, "$g_jrider_character_portrait", -1, "tableau_troop_note_mesh", "$character_info_id"),
        (position_set_x, pos2, 100),
        (position_set_y, pos2, 280),
        (overlay_set_position, "$g_jrider_character_portrait", pos2),
        (position_set_x, pos2, 1100), #1150
        (position_set_y, pos2, 1100), #1150
        (overlay_set_size, "$g_jrider_character_portrait", pos2),

        # mesh Overlay for faction coat of arms
        (try_begin),
            (store_troop_faction, ":troop_faction", "$character_info_id"),
            (neq, ":troop_faction", "fac_player_supporters_faction"),
            (is_between, ":troop_faction", kingdoms_begin, kingdoms_end),
            (store_sub, ":faction_mesh_index", ":troop_faction", kingdoms_begin),
            (val_add, ":faction_mesh_index", "mesh_pic_recruits"),

            (create_mesh_overlay, "$g_jrider_faction_coat_of_arms", ":faction_mesh_index"),
            (position_set_x, pos3, 150),
            (position_set_y, pos3, 600),
            (overlay_set_position, "$g_jrider_faction_coat_of_arms", pos3),
            (position_set_x, pos3, 250),
            (position_set_y, pos3, 250),
            (overlay_set_size, "$g_jrider_faction_coat_of_arms", pos3),
        (try_end),

        # Begin presentation type specific dynamic overlay
        # equipement meshes for character/companions
        (try_begin),
            (eq, "$g_character_presentation_type", 2),

            (assign, ":base_inv_slot_x", 452),
            (assign, ":base_inv_slot_y", 536),

            (try_for_range, ":item_eq", 0, 9),
            # loop equipment slots
                (troop_get_inventory_slot, reg1, "$character_info_id", ":item_eq"),
        
                (try_begin),
                    (eq, ":item_eq", 4),
                    (assign, ":base_inv_slot_x", 68),
                    (assign, ":base_inv_slot_y", 557),
                (try_end),
                (try_begin),
                    (lt, reg1, 1),
                    # empty... assign default mesh
                   (try_begin),
                       (lt, ":item_eq", 4),
                       (assign, ":mesh_id", "mesh_mp_inventory_slot_equip"),
                   (else_try),
                       (eq, ":item_eq", 4),
                       (assign, ":mesh_id", "mesh_mp_inventory_slot_helmet"),
                   (else_try),
                       (eq, ":item_eq", 5),
                       (assign, ":mesh_id", "mesh_mp_inventory_slot_armor"),
                   (else_try),
                       (eq, ":item_eq", 6),
                       (assign, ":mesh_id", "mesh_mp_inventory_slot_boot"),
                   (else_try),
                       (eq, ":item_eq", 7),
                       (assign, ":mesh_id", "mesh_mp_inventory_slot_glove"),
                   (else_try),
                       (eq, ":item_eq", 8),
                       (assign, ":mesh_id", "mesh_mp_inventory_slot_horse"),
                   (try_end),
        
                   (create_mesh_overlay, reg11, ":mesh_id"),
                   (overlay_set_size, reg11, ":inv_bar_size"),

                   (position_set_x, pos1, ":base_inv_slot_x"),
                   (position_set_y, pos1, ":base_inv_slot_y"),
                   (overlay_set_position, reg11, pos1),
        
                   (troop_set_slot, "trp_temp_array_a", ":item_eq", -1),
                   (store_add, ":item_eq_id", ":item_eq", 10),
                   (troop_set_slot, "trp_temp_array_a", ":item_eq_id", -1),
                # end missing item
                (else_try),
                    (create_mesh_overlay_with_item_id, reg10, reg1),
                    (position_set_x, pos1, 450),
                    (position_set_y, pos1, 450),
                    (overlay_set_size, reg10, pos1),

                    (store_add, ":item_inv_slot_x", ":base_inv_slot_x", 25),
                    (store_add, ":item_inv_slot_y", ":base_inv_slot_y", 25),

                    (position_set_x, pos1, ":item_inv_slot_x"),
                    (position_set_y, pos1, ":item_inv_slot_y"),
                    (overlay_set_position, reg10, pos1),

                    # save id for reuse
                    (troop_set_slot, "trp_temp_array_a", ":item_eq", reg10),
                    (store_add, ":item_eq_id", ":item_eq", 10),
                    (troop_set_slot, "trp_temp_array_a", ":item_eq_id", reg1),
                # real items
                (try_end),
                (val_sub, ":base_inv_slot_y", 51),
            (try_end),
            # end loop equipments slots
        (try_end),

        # do an update if called from menu and reset init variable
        (try_begin),
            (eq, "$g_jrider_pres_called_from_menu", 1),
            (assign, "$g_jrider_pres_called_from_menu", 0),
        (try_end),
    ]),
    # end presentation load

    ## Mouse-over
    (ti_on_presentation_mouse_enter_leave,
      [
      (store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":enter_leave"),

      (try_begin),
          (eq, "$g_character_presentation_type", 2),
          (try_begin),
              (eq, ":enter_leave", 0),
              (try_for_range, ":slot_no", 0, 9),
                  (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
                  (store_add, ":slot_no_eq", ":slot_no", 10),
                  (troop_get_slot, ":item_no", "trp_temp_array_a", ":slot_no_eq"),

                  (set_fixed_point_multiplier, 1000),

                  (position_set_x,pos0,740),
                  (position_set_y,pos0,235),
                  (show_item_details, ":item_no", pos0, 100),
              (try_end),
          (else_try),
              (try_for_range, ":slot_no", 0, 9),
                (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
                (close_item_details),
              (try_end),
          (try_end),
      (try_end),
    ]),
    # end mouseover

    ## Check for buttonpress
    (ti_on_presentation_event_state_change,
     [
        (store_trigger_param_1, ":object"), # object
        (store_trigger_param_2, ":value"),  # value

        (try_begin),
            # pressed  (Return to menu)
            (eq, ":object", "$g_jrider_character_report_Return_to_menu"),

            (try_begin),
                (neq, "$num_charinfo_candidates", 0),
                (overlay_set_text, "$g_jrider_character_information_text", "str_empty_string"),
                (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0),
            (try_end),
            (presentation_set_duration, 0),

        (else_try),
            # Faction filter
            (eq, ":object", "$g_jrider_character_faction_filter"),
            (try_begin),
                (eq, ":value", 7),
                (assign, "$g_jrider_faction_filter", -1),
            (else_try),
                (assign, "$g_jrider_faction_filter", ":value"),
            (try_end),

            # reset selected to first
            (assign, "$g_jrider_reset_selected_on_faction", 1000),

            # restart presentation to take filters into account
            (start_presentation, "prsnt_jrider_character_relation_report"),

        (else_try),
            (neq, ":object", "$g_jrider_character_information_text"),
            (neq, ":object", "$g_jrider_character_portrait"),
            (neq, ":object", "$g_jrider_character_relation_listbox"),
            #(neq, ":object", "$g_jrider_faction_coat_of_arms"),
            # clicked on list entry
            # get storage index + base storage index
            (store_add, ":storage_button_id", ":object", "$g_base_character_presentation_storage_index"),
            (troop_get_slot, ":character_number", "trp_temp_array_b", ":storage_button_id"),

            (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0),
            (overlay_set_color, "$g_jrider_last_checked_indicator", 0xDDDDDD),

            # update last entry and check variables
            (assign, "$g_latest_character_relation_entry", ":character_number"),
            (assign, "$g_jrider_last_checked_indicator", ":object"),

            # color selected entry
            (overlay_set_color, "$g_jrider_last_checked_indicator", 0xFF6666FF),
            (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0x44),

            # get troop information from storage to update text
            (val_add, ":character_number", "$g_base_character_presentation_storage_index"),
            (troop_get_slot, "$character_info_id", "trp_temp_array_c", ":character_number"),

            # restart presentation to update picture and text
            (start_presentation, "prsnt_jrider_character_relation_report"),
    (try_end),
     ] # + generic_ti_on_presentation_event_state_change
     ),
     # end event state change

    ## Event to process when running the presentation
    (ti_on_presentation_run,
     # generic_ti_on_presentation_run +
     [
        (try_begin),
      (this_or_next|key_clicked, key_escape),
      (key_clicked, key_right_mouse_button),
      (presentation_set_duration, 0),
      (jump_to_menu, "mnu_reports"),
        (try_end),

        ]),
     # end presentation run
     ]),
    ###################################
    # Character relation presentation end
  #######################################################################################################################
  ########################################################################################
  #HISPANIA 1200 HABLAR CON TODOS
   ##############################################################################
  # talk_to_start
  ("jrider_character_dialog_report", 0,
   mesh_message_window,
   [
     ## Load Presentation
     (ti_on_presentation_load,
      # generic_ti_on_load +
      [
    (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),

        (str_clear, s0),
        (str_clear, s1),

        # Character presentation type variations
        (try_begin),
            ###############################
            ## Lord Relations presentation
            (eq, "$g_character_presentation_type", 1),

            # Set presentation title string
            (str_store_string, s0, "@_List of active Lords_"),

            # Set size of listbox
            (assign, ":base_scroll_y", 110),
            (assign, ":base_scroll_size_y", 550),
            (assign, ":base_candidates_y", 0), # scrollable area size minus 530

            # Set storage index
            (assign, "$g_base_character_presentation_storage_index", 2000),
        (try_end),
        # END of presentation type specific init and static overlay

        ###############################
        # Create common overlays
        # set foreground mesh overlay (has some transparency in it, so can't use it directly)
        (create_mesh_overlay, reg1, "mesh_face_gen_window"),
        (position_set_x, pos1, 0),
        (position_set_y, pos1, 0),
        (overlay_set_position, reg1, pos1),
    (position_set_x, pos1, 1000),
        (position_set_y, pos1, 1000),
    (overlay_set_size, reg1, pos1),

    # Presentation title overlay, centered at the top of right pane (from s0, presentation type specific)
        (create_text_overlay, reg1, s0, tf_center_justify),
        (overlay_set_color, reg1,  0xDDDDDD), # 0xDDDDDD
    (position_set_x, pos1, 740), # Higher, means more toward the right
        (position_set_y, pos1, 680), # Higher, means more toward the top
        (overlay_set_position, reg1, pos1),
    (position_set_x, pos1, 1200),
        (position_set_y, pos1, 1200),
    (overlay_set_size, reg1, pos1),

    # Done button
        (create_game_button_overlay, "$g_jrider_character_report_Return_to_menu", "@_Done_"),
    (position_set_x, pos1, 187),
        (position_set_y, pos1, 10),
        (overlay_set_position, "$g_jrider_character_report_Return_to_menu", pos1),
		
    # Talk button
        (create_game_button_overlay, "$g_jrider_character_report_talk_to_npc", "@_Talk_"),
    (position_set_x, pos1, 387),
        (position_set_y, pos1, 10),
        (overlay_set_position, "$g_jrider_character_report_talk_to_npc", pos1),

        # Character Information text to fill when an entry is clicked in the list
        (create_text_overlay, "$g_jrider_character_information_text", "str_space", tf_left_align),
        (overlay_set_color, "$g_jrider_character_information_text", 0x000000), #0xFFFFFF
        (position_set_x, pos1, 55), # Higher, means more toward the right
        (position_set_y, pos1, 60), # Higher, means more toward the top
        (overlay_set_position, "$g_jrider_character_information_text", pos1),
        (position_set_x, pos1, 700), # smaller means smaller font
        (position_set_y, pos1, 800),
        (overlay_set_size, "$g_jrider_character_information_text", pos1),

        # Character selection listbox overlay
        # use scrollable text area with global reference so objects can be put inside using overlay_set_container
        (create_text_overlay, "$g_jrider_character_relation_listbox", "str_empty_string", tf_scrollable_style_2),
        (position_set_x, pos1, 590),
        (position_set_y, pos1, ":base_scroll_y"),
        (overlay_set_position, "$g_jrider_character_relation_listbox", pos1),
        (position_set_x, pos1, 335),
        (position_set_y, pos1, ":base_scroll_size_y"),
        (overlay_set_area_size, "$g_jrider_character_relation_listbox", pos1),

        # Faction filter
        (create_combo_button_overlay, "$g_jrider_character_faction_filter", "str_empty_string",0),
        (position_set_x, pos1, 507),
        (position_set_y, pos1, 709),
        (overlay_set_position, "$g_jrider_character_faction_filter", pos1),
        (position_set_x, pos1, 550),
        (position_set_y, pos1, 650),
        (overlay_set_size, "$g_jrider_character_faction_filter", pos1),

        # add elements to filter button
		
		(try_begin), #Hispania 1200, hablar con todos, rey, bug
			(eq, "$jugador_rey",1),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",2),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",3),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",4),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",5),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(else_try),
			(eq, "$jugador_rey",6),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Rebels"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),			
		
		 (else_try),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Your supporters"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Aragon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Leon"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Navarra"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Castilla"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Kingdom of Portugal"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@Empire Almohade"),
			(overlay_add_item, "$g_jrider_character_faction_filter", "@All Factions"),
		(try_end),
		
		
		


        # Set initial value for selection box
        (try_begin),
            (this_or_next|eq, "$g_jrider_pres_called_from_menu", 1),
            (eq, "$g_jrider_faction_filter", -1),

            (assign, "$g_jrider_faction_filter", -1),
			#gekokujo 3.0 "all factions" is now index 21
            #(overlay_set_val, "$g_jrider_character_faction_filter", 7),
            (overlay_set_val, "$g_jrider_character_faction_filter", 21),
        (else_try),
            (overlay_set_val, "$g_jrider_character_faction_filter", "$g_jrider_faction_filter"),
        (try_end),

        ###############################
        # Populate lists
        # Init presentation common global variables
        (assign, "$num_charinfo_candidates", 0),

        # Fill listbox (overlay_add_item and extra storage)
        (call_script, "script_fill_dialog_canditate_list_for_presentation", "$g_character_presentation_type", ":base_candidates_y"),
        (assign, "$g_jrider_reset_selected_on_faction", 0),
        # stop if there's no candidate
        (gt, "$num_charinfo_candidates", 0),

        # get extra information from storage
        (store_add, ":current_storage_index", "$g_base_character_presentation_storage_index", "$g_latest_character_relation_entry"),
        (troop_get_slot, "$character_info_id", "trp_temp_array_c", ":current_storage_index"),

        # Fill text information for current entry and update text information overlay
        (call_script, "script_generate_extended_troop_relation_information_string", "$character_info_id"),
        (overlay_set_text, "$g_jrider_character_information_text", s1),

        # color selected entry
        (overlay_set_color, "$g_jrider_last_checked_indicator", 0xFF6666FF),
        (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0x44),

        # Begin common dynamic overlay
        # mesh Overlay for character portrait (global not needed)
        (create_image_button_overlay_with_tableau_material, "$g_jrider_character_portrait", -1, "tableau_troop_note_mesh", "$character_info_id"),
        (position_set_x, pos2, 100),
        (position_set_y, pos2, 280),
        (overlay_set_position, "$g_jrider_character_portrait", pos2),
        (position_set_x, pos2, 1100), #1150
        (position_set_y, pos2, 1100), #1150
        (overlay_set_size, "$g_jrider_character_portrait", pos2),

        # mesh Overlay for faction coat of arms
        (try_begin),
            (store_troop_faction, ":troop_faction", "$character_info_id"),
            (neq, ":troop_faction", "fac_player_supporters_faction"),
            (is_between, ":troop_faction", kingdoms_begin, kingdoms_end),
            (store_sub, ":faction_mesh_index", ":troop_faction", kingdoms_begin),
            (val_add, ":faction_mesh_index", "mesh_pic_recruits"),

            (create_mesh_overlay, "$g_jrider_faction_coat_of_arms", ":faction_mesh_index"),
            (position_set_x, pos3, 150),
            (position_set_y, pos3, 600),
            (overlay_set_position, "$g_jrider_faction_coat_of_arms", pos3),
            (position_set_x, pos3, 250),
            (position_set_y, pos3, 250),
            (overlay_set_size, "$g_jrider_faction_coat_of_arms", pos3),
        (try_end),

        # Begin presentation type specific dynamic overlay
        # equipement meshes for character/companions

        # do an update if called from menu and reset init variable
        (try_begin),
            (eq, "$g_jrider_pres_called_from_menu", 1),
            (assign, "$g_jrider_pres_called_from_menu", 0),
        (try_end),
    ]),
    # end presentation load

    ## Mouse-over
    (ti_on_presentation_mouse_enter_leave,
      [
      (store_trigger_param_1, ":object"),
      (store_trigger_param_2, ":enter_leave"),

      (try_begin),
          (eq, "$g_character_presentation_type", 2),
          (try_begin),
              (eq, ":enter_leave", 0),
              (try_for_range, ":slot_no", 0, 9),
                  (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
                  (store_add, ":slot_no_eq", ":slot_no", 10),
                  (troop_get_slot, ":item_no", "trp_temp_array_a", ":slot_no_eq"),

                  (set_fixed_point_multiplier, 1000),

                  (position_set_x,pos0,740),
                  (position_set_y,pos0,235),
                  (show_item_details, ":item_no", pos0, 100),
              (try_end),
          (else_try),
              (try_for_range, ":slot_no", 0, 9),
                (troop_slot_eq, "trp_temp_array_a", ":slot_no", ":object"),
                (close_item_details),
              (try_end),
          (try_end),
      (try_end),
    ]),
    # end mouseover

    ## Check for buttonpress
    (ti_on_presentation_event_state_change,
     [
        (store_trigger_param_1, ":object"), # object
        (store_trigger_param_2, ":value"),  # value

        (try_begin),
            # pressed  (Return to menu)
            (eq, ":object", "$g_jrider_character_report_Return_to_menu"),

            (try_begin),
                (neq, "$num_charinfo_candidates", 0),
                (overlay_set_text, "$g_jrider_character_information_text", "str_empty_string"),
                (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0),
            (try_end),
            (presentation_set_duration, 0),
			
        (else_try),
            # pressed  (talk_to_npc)
			# talk_to_start
            (eq, ":object", "$g_jrider_character_report_talk_to_npc"),

            (try_begin),
                (neq, "$num_charinfo_candidates", 0),
                (overlay_set_text, "$g_jrider_character_information_text", "str_empty_string"),
                (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0),
            (try_end),
			 # (try_begin),
				# (troop_get_slot, "$enlisted_party", "$character_info_id", slot_troop_leaded_party),
				# (neq, "$enlisted_party", "trp_player"),
				# #Fake that it is a party encounter when enlisted party in a town (lines taken from script_game_event_party_encounter)
				# (assign, "$g_encountered_party", "$enlisted_party"),
				# (store_faction_of_party, "$g_encountered_party_faction","$g_encountered_party"),
				# (store_relation, "$g_encountered_party_relation", "$g_encountered_party_faction", "fac_player_faction"),
				# (party_get_slot, "$g_encountered_party_type", "$g_encountered_party", slot_party_type),
				# (party_get_template_id,"$g_encountered_party_template","$g_encountered_party"),
				# (assign, "$talk_context", tc_party_encounter),
				# (call_script, "script_setup_party_meeting", "$g_encountered_party"),
			 # (else_try),
			 	(store_troop_faction, "$g_encountered_party_faction", "$character_info_id"),
				(store_relation, "$g_encountered_party_relation", "$g_encountered_party_faction", "fac_player_faction"),
				(call_script, "script_setup_troop_meeting", "$character_info_id", -1),
			 # (try_end),
        (else_try),
            # Faction filter
            (eq, ":object", "$g_jrider_character_faction_filter"),
            (try_begin),
				#gekokujo 3.0 "all factions" is now index 21
                #(eq, ":value", 7),
                (eq, ":value", 21),
                (assign, "$g_jrider_faction_filter", -1),
            (else_try),
                (assign, "$g_jrider_faction_filter", ":value"),
            (try_end),

            # reset selected to first
            (assign, "$g_jrider_reset_selected_on_faction", 1000),

            # restart presentation to take filters into account
            (start_presentation, "prsnt_jrider_character_dialog_report"),

        (else_try),
            (neq, ":object", "$g_jrider_character_information_text"),
            (neq, ":object", "$g_jrider_character_portrait"),
            (neq, ":object", "$g_jrider_character_relation_listbox"),
            #(neq, ":object", "$g_jrider_faction_coat_of_arms"),
            # clicked on list entry
            # get storage index + base storage index
            (store_add, ":storage_button_id", ":object", "$g_base_character_presentation_storage_index"),
            (troop_get_slot, ":character_number", "trp_temp_array_b", ":storage_button_id"),

            (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0),
            (overlay_set_color, "$g_jrider_last_checked_indicator", 0xDDDDDD), #0xDDDDDD

            # update last entry and check variables
            (assign, "$g_latest_character_relation_entry", ":character_number"),
            (assign, "$g_jrider_last_checked_indicator", ":object"),

            # color selected entry
            (overlay_set_color, "$g_jrider_last_checked_indicator", 0xFF6666FF),
            (overlay_set_alpha, "$g_jrider_last_checked_indicator", 0x44),

            # get troop information from storage to update text
            (val_add, ":character_number", "$g_base_character_presentation_storage_index"),
            (troop_get_slot, "$character_info_id", "trp_temp_array_c", ":character_number"),

            # restart presentation to update picture and text
            (start_presentation, "prsnt_jrider_character_dialog_report"),
			
    (try_end),
     ] # + generic_ti_on_presentation_event_state_change
     ),
     # end event state change

    ## Event to process when running the presentation
    (ti_on_presentation_run,
     # generic_ti_on_presentation_run +
     [
        (try_begin),
      (this_or_next|key_clicked, key_escape),
      (key_clicked, key_right_mouse_button),
      (presentation_set_duration, 0),
      (jump_to_menu, "mnu_camp"),
        (try_end),

        ]),
     # end presentation run
     ]),
 # talk_to_end
    # Character relation presentation end
  #FIN HISPANIA 1200 HABLAR CON TODOS
# Jrider -

##diplomacy end
##diplomacy start+
##Custom player kingdom vassal titles, credit Caba`drin start
#(Updated 2011-04-24, to use Caba`drin's 2011-04-20 bug-fix and update)
# See http://forums.taleworlds.com/index.php/topic,148259.0.html
("dplmc_set_vassal_title",0,mesh_load_window,[
      (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (str_clear, s1),
        (str_clear, s2),

        (create_text_overlay, reg0, "@How will your male vassals be known?", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg0, pos1),
        (create_text_overlay, reg0, "@How will your female vassals be known?", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 400),
        (overlay_set_position, reg0, pos1),

        (create_simple_text_box_overlay, "$g_presentation_obj_name_kingdom_1"),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 500),
        (overlay_set_position, "$g_presentation_obj_name_kingdom_1", pos1),
        (try_begin),
          (troop_slot_eq, "trp_heroes_end", 0, 1), #Pick a slot
          (str_store_troop_name, s0, "trp_heroes_end"),
        (else_try),
          (str_store_string, s0, "@{!}"),
          (str_store_string, s0, "str_faction_title_male_player"),
        (try_end),
        (overlay_set_text, "$g_presentation_obj_name_kingdom_1", s0),

        (create_simple_text_box_overlay, reg0),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 300),
        (overlay_set_position, reg0, pos1),
        (try_begin),
          (troop_slot_eq, "trp_heroes_end", 1, 1), #Pick a slot
          (str_store_troop_name_plural, s0, "trp_heroes_end"),
        (else_try),
          (str_store_string, s0, "@{!}"),
          (str_store_string, s0, "str_faction_title_female_player"),
        (try_end),
        (overlay_set_text, reg0, s0),

        (create_button_overlay, reg0, "@Use the Titles Entered Above.", tf_center_justify),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 150),
        (overlay_set_position, reg0, pos1),

        (create_button_overlay, reg0, "@Use Default Titles (Lord/Lady).", tf_center_justify),
        (position_set_x, pos1, 600),
        (position_set_y, pos1, 100),
        (overlay_set_position, reg0, pos1),

        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_name_kingdom_1"),
          (str_store_string, s1, s0), #Male Title
        (else_try),
          (store_add, ":overlay", "$g_presentation_obj_name_kingdom_1", 1),
          (eq, ":object", ":overlay"),
          (str_store_string, s2, s0), ##Female Title
        (else_try),
          (val_add, ":overlay", 1),
          (eq, ":object", ":overlay"), #Custom
          (try_begin),
            (neg|str_is_empty, s1),
            (troop_set_name, "trp_heroes_end", s1),
            (troop_set_slot, "trp_heroes_end", 0, 1),
            (try_for_range, ":lord_lady", lords_begin, lords_end),
                (store_troop_faction, ":faction", ":lord_lady"),
                (eq, ":faction", "fac_player_supporters_faction"),
                (call_script, "script_troop_set_title_according_to_faction", ":lord_lady", ":faction"),
            (try_end),
          (try_end),
          (try_begin),
            (neg|str_is_empty, s2),
            (troop_set_plural_name, "trp_heroes_end", s2),
            (troop_set_slot, "trp_heroes_end", 1, 1),
            (try_for_range, ":lord_lady", kingdom_ladies_begin, kingdom_ladies_end),
                (store_troop_faction, ":faction", ":lord_lady"),
                (eq, ":faction", "fac_player_supporters_faction"),
                (call_script, "script_troop_set_title_according_to_faction", ":lord_lady", ":faction"),
            (try_end),
          (try_end),
          (try_begin),
            (this_or_next|neg|str_is_empty, s1),
            (neg|str_is_empty, s2),
            (try_for_range, ":lord_lady", companions_begin, companions_end),
                (store_troop_faction, ":faction", ":lord_lady"),
                (eq, ":faction", "fac_player_supporters_faction"),
                (troop_slot_eq, ":lord_lady", slot_troop_occupation, slto_kingdom_hero),
                (call_script, "script_troop_set_title_according_to_faction", ":lord_lady", ":faction"),
            (try_end),
          (try_end),
          (presentation_set_duration, 0),
        (else_try),
          (val_add, ":overlay", 1),
          (eq, ":object", ":overlay"), #Default
          (troop_set_slot, "trp_heroes_end", 0, 0),
          (troop_set_slot, "trp_heroes_end", 1, 0),
          (try_for_range, ":lord_lady", lords_begin, kingdom_ladies_end),
            (neg|is_between, ":lord_lady", pretenders_begin, pretenders_end),
            (store_troop_faction, ":faction", ":lord_lady"),
            (eq, ":faction", "fac_player_supporters_faction"),
            (call_script, "script_troop_set_title_according_to_faction", ":lord_lady", ":faction"),
          (try_end),
          (try_for_range, ":lord_lady", companions_begin, companions_end),
            (store_troop_faction, ":faction", ":lord_lady"),
            (eq, ":faction", "fac_player_supporters_faction"),
            (troop_slot_eq, ":lord_lady", slot_troop_occupation, slto_kingdom_hero),
            (call_script, "script_troop_set_title_according_to_faction", ":lord_lady", ":faction"),
          (try_end),
          (presentation_set_duration, 0),
        (try_end),
        ]),
      ]),
##Custom player kingdom vassal titles, credit Caba`drin end

## Floris Bank System begin
   ("bank", 0, mesh_load_window, [ 													#	Floris Overhaul
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
 
		(try_begin),
			(party_get_slot, ":assets", "$current_town", slot_town_bank_assets),
			(troop_add_gold, "trp_player", ":assets"),
			(party_set_slot, "$current_town", slot_town_bank_assets, 0),
		(try_end),
 
		(str_store_party_name, s1, "$current_town"),
 
 
	    (create_text_overlay, reg0, 
"@This area of {s1} can best be described as the very core of the town.^^\
 You can almost see the strings that are being pulled from here, the money that comes and goes at seemingly endless rates. \
 Here you can buy the land that is cultivated outside the towns gates and benefit from the ones working hard.\
 Of course you might not have the denars required to do so, but the moneylenders are known to have some spare change.",tf_center_justify),
        (position_set_x, pos1, 475),
        (position_set_y, pos1, 600),
        (overlay_set_position, reg0, pos1),
 
        (position_set_x, pos2, 800),
        (position_set_y, pos2, 900),		
		(overlay_set_size, reg0, pos2),
 
		(party_get_slot, ":population", "$current_town", slot_center_population),
		(party_get_slot, ":land_town", "$current_town", slot_town_acres),
		(party_get_slot, ":land_player", "$current_town", slot_town_player_acres),
		(store_add, ":land_total", ":land_town", ":land_player"),
		(assign, reg1, ":population"),
		(assign, reg2, ":land_total"),
		(assign, reg3, ":land_player"),
 
		(party_get_slot, ":debt", "$current_town", slot_town_bank_debt),
		(assign, reg4, ":debt"),
 
		(assign, reg5, 0),														#Slider storage / acres		Buy
		(assign, reg6, 0),														#Slider storage / money		Borrow
		(assign, reg7, 0),														#Slider storage / acres		Build
		(assign, reg8, 0),														#Slider storage / money		Pay back
 
		(party_get_slot, ":prosp_mod", "$current_town", slot_town_prosperity),
		(store_mul, ":price_mod", ":prosp_mod", 10),
		(val_sub, ":price_mod", 500),
		(store_add, reg9, 1000, ":price_mod"),									#Buy Price 
		(store_add, reg10, 750, ":price_mod"),									#Sell Price 
		(store_add, reg11, 2000, ":price_mod"),									#Build Price
		#reg12 used for buy/sell switch
		(store_sub, ":rent_mod", ":prosp_mod", 50),
		(store_add, reg13, ":rent_mod", 100),									#Rent Revenue
 
		(create_text_overlay, "$g_presentation_obj_19", "@{reg1} people live in {s1}. There are currently {reg2} acres of land available for cultivation to provide them with \
 food and other goods. You own {reg3} acres of land in this town. You currently owe the moneylenders of {s1} {reg4} denars. The interest rate is 20% and the contract period amounts \
 to 2 weeks. If you dont manage to pay off your debt until the deadline, the interest is raised to 40%. Buying an existing acre costs {reg9} denars, while it sells for {reg10} denars. Building a new one requires {reg11} denars.\
 The rent paid to landowners currently accumulates to {reg13} denars per acre every 2 weeks and has to be collected in the town. Land wont be rented if a town is already well supplied.",tf_center_justify),
        (position_set_x, pos1, 475),
        (position_set_y, pos1, 450),
        (overlay_set_position, "$g_presentation_obj_19", pos1),
 
        (position_set_x, pos2, 900),
        (position_set_y, pos2, 1000),		
		(overlay_set_size, "$g_presentation_obj_19", pos2),	
 
		(try_begin),
			(eq, reg12, 2222),	
			(str_store_string, s2, "@Choose how many acres you wish to sell :"),
		(else_try),
			(str_store_string, s2, "@Choose how many acres you wish to buy :"),
		(try_end),
 
	(create_button_overlay, "$g_presentation_obj_16", "@{s2}",tf_center_justify),				#	Landlords buy
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 350),
        (overlay_set_position, "$g_presentation_obj_16", pos1),
 
		(store_troop_gold, ":funds", "trp_player"),
		(store_div, ":funds_build", ":funds", reg11),
		(val_div, ":funds", reg9),
		(val_min, ":funds", ":land_town"),
 
		(try_begin),
			(eq, reg12, 2222),
			(party_get_slot, ":sell_no", "$current_town", slot_town_player_acres),
			(assign, ":funds", ":sell_no"),
		(try_end),
 
	(create_slider_overlay, "$g_presentation_obj_1", 0, ":funds"),
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 310),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
 
	(create_text_overlay, "$g_presentation_obj_2", "@0"),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_2", pos1),			
 
	(create_button_overlay, "$g_presentation_obj_3", "@Verify",tf_center_justify),		
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 275),
        (overlay_set_position, "$g_presentation_obj_3", pos1),	
 
 
 
	(create_text_overlay, reg0, "@Choose how much money you wish to borrow :",tf_center_justify),			#	Moneylenders borrow
        (position_set_x, pos1, 725),
        (position_set_y, pos1, 350),
        (overlay_set_position, reg0, pos1),
 
		(assign, ":fief_count", 0),																				#	Money = 250*Prosperity + Relationship*100 - Debt, IF Player owns fief or is renowned,
		(try_for_range, ":cur_center", centers_begin, centers_end),												#	otherwise not more than 5000 + Relationship*100 - Debt
			(party_slot_eq, ":cur_center", slot_town_lord, "trp_player"),
			(val_add, ":fief_count", 1),
		(try_end),
		(troop_get_slot, ":renown", "trp_player", slot_troop_renown),
		(party_get_slot, ":prosperity", "$current_town", slot_town_prosperity),
		(store_mul, ":money", ":prosperity", 250),
		(try_begin),
			(lt, ":fief_count", 1),
			(lt, ":renown", 500),
			(gt, ":money", 5000),
			(assign, ":money", 5000),
		(try_end),
		(party_get_slot, ":player_relation", "$current_town", slot_center_player_relation),
		(store_mul, ":trust", ":player_relation", 100),
		(val_add, ":money", ":trust"),
		(val_sub, ":money", ":debt"),
		(try_begin),																							#	Money lending cant turn negative
			(lt, ":money", 0),	
			(assign, ":money", 0),
		(try_end),
 
		(try_begin),
			(assign, reg25, 0),
			(try_for_range, ":town_no", towns_begin, towns_end),													#	Too much debt overall or in a single bank will stop banks from lending you money
				(party_get_slot, ":debt_all", ":town_no", slot_town_bank_debt),
				(val_add, reg25, ":debt_all"),
			(try_end),
			(ge, reg25, 50000),
			(assign, ":money", 0),
		(try_end),
 
	(create_slider_overlay, "$g_presentation_obj_4", 0, ":money"),
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 310),
        (overlay_set_position, "$g_presentation_obj_4", pos1),
 
	(create_text_overlay, "$g_presentation_obj_5", "@0"),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
 
	(create_button_overlay, "$g_presentation_obj_6", "@Verify",tf_center_justify),		
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 275),
        (overlay_set_position, "$g_presentation_obj_6", pos1),
 
 
 
	(create_text_overlay, "$g_presentation_obj_7", "@Buy and prepare uncultivated land :",tf_center_justify),		#	Landlord / Buy and Build
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_7", pos1),
 
 
	(create_slider_overlay, "$g_presentation_obj_8", 0, ":funds_build"),											#	Choose acres to build 
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 160),
        (overlay_set_position, "$g_presentation_obj_8", pos1),		
 
	(create_text_overlay, "$g_presentation_obj_9", "@0"),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 150),
        (overlay_set_position, "$g_presentation_obj_9", pos1),			
 
	(create_button_overlay, "$g_presentation_obj_10", "@Verify",tf_center_justify),		
        (position_set_x, pos1, 250),
        (position_set_y, pos1, 125),
        (overlay_set_position, "$g_presentation_obj_10", pos1),	
 
 
	(create_text_overlay, "$g_presentation_obj_11", "@Pay off your debt :",tf_center_justify),		#	Pay off your debt
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 200),
        (overlay_set_position, "$g_presentation_obj_11", pos1),		
 
		(store_troop_gold, ":funds", "trp_player"),
		(try_begin),
			(lt, ":debt", ":funds"),
			(assign, ":funds", ":debt"),
		(try_end),
 
	(create_slider_overlay, "$g_presentation_obj_12", 0, ":funds"),
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 160),
        (overlay_set_position, "$g_presentation_obj_12", pos1),		
 
	(create_text_overlay, "$g_presentation_obj_13", "@0"),
        (position_set_x, pos1, 850),
        (position_set_y, pos1, 150),
        (overlay_set_position, "$g_presentation_obj_13", pos1),			
 
	(create_button_overlay, "$g_presentation_obj_14", "@Verify",tf_center_justify),		
        (position_set_x, pos1, 700),
        (position_set_y, pos1, 125),
        (overlay_set_position, "$g_presentation_obj_14", pos1),	
 
 
 
	(create_game_button_overlay, "$g_presentation_obj_15", "@Done", 0),										#	Leave
        (position_set_x, pos1, 880),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_15", pos1),		
 
        ]),
 
	(ti_on_presentation_event_state_change, 
		[
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
 
		(try_begin),
			(eq, ":object", "$g_presentation_obj_1"),															#	Show chosen amount of land
			(assign, reg5, ":value"),
			(overlay_set_text, "$g_presentation_obj_2", "@{reg5}"),
		(else_try),
			(eq, ":object", "$g_presentation_obj_3"),															#	Sell/Buy chosen amount of land
			(try_begin),
				(eq, reg12, 2222),
				(try_begin),
					(gt, reg5, 0),
					(store_mul, ":price", reg5, reg10),
					(troop_add_gold, "trp_player", ":price"),					
					(party_get_slot, ":land_town", "$current_town", slot_town_acres),
					(val_add, ":land_town", reg5),
					(party_set_slot, "$current_town", slot_town_acres, ":land_town"),
					(party_get_slot, ":land_player", "$current_town", slot_town_player_acres),
					(val_sub, ":land_player", reg5),
					(party_set_slot, "$current_town", slot_town_player_acres, ":land_player"),
					(start_presentation, "prsnt_bank"),					
				(else_try),	
					(display_message, "@You cant sell 0 acres of land."),
				(try_end),
			(else_try),
				(try_begin),
					(gt, reg5, 0),
					(store_mul, ":cost", reg5, reg9),
					(troop_remove_gold, "trp_player", ":cost"),
					(party_get_slot, ":land_town", "$current_town", slot_town_acres),
					(val_sub, ":land_town", reg5),
					(party_set_slot, "$current_town", slot_town_acres, ":land_town"),
					(party_get_slot, ":land_player", "$current_town", slot_town_player_acres),
					(val_add, ":land_player", reg5),
					(party_set_slot, "$current_town", slot_town_player_acres, ":land_player"),
					(start_presentation, "prsnt_bank"),
				(else_try),
					(display_message, "@You cant buy 0 acres of land."),
				(try_end),
			(try_end),
		(else_try),
			(eq, ":object", "$g_presentation_obj_4"),															#	Show chosen amount of money
			(assign, reg6, ":value"),
			(overlay_set_text, "$g_presentation_obj_5", "@{reg6}"),
		(else_try),		
			(eq, ":object", "$g_presentation_obj_6"),															#	Borrow chosen amount of money
			(try_begin),
				(gt, reg6, 0),
				(party_get_slot, ":debt", "$current_town", slot_town_bank_debt),
				(try_begin),
					(le, ":debt", 0),
					(store_current_hours, ":date"),
					(val_add, ":date", 24*14*2), 								#	First Deadline / 4 weeks / then 2 weeks (see simple_triggers)
					(party_set_slot, "$current_town", slot_town_bank_deadline, ":date"),
				(try_end),
				(troop_add_gold, "trp_player", reg6),
				(val_mul, reg6, 120),
				(val_div, reg6, 100),
				(val_add, ":debt", reg6),
				(party_set_slot, "$current_town", slot_town_bank_debt, ":debt"),
				(start_presentation, "prsnt_bank"),
			(else_try),
				(display_message, "@You cant borrow 0 denars."),
			(try_end),
		(else_try),
			(eq, ":object", "$g_presentation_obj_8"),															#	Show chosen amount of land	//	2nd Option
			(assign, reg7, ":value"),
			(overlay_set_text, "$g_presentation_obj_9", "@{reg7}"),			
		(else_try),
			(eq, ":object", "$g_presentation_obj_10"),															#	Buy chosen amount of land	//	2nd Option
			(try_begin),
				(gt, reg7, 0),
				(store_mul, ":cost", reg7, reg11),
				(troop_remove_gold, "trp_player", ":cost"),
				(party_get_slot, ":land_player", "$current_town", slot_town_player_acres),
				(val_add, ":land_player", reg7),
				(party_set_slot, "$current_town", slot_town_player_acres, ":land_player"),
				(start_presentation, "prsnt_bank"),
			(else_try),
				(display_message, "@You cant buy 0 acres of land."),
			(try_end),		
		(else_try),
			(eq, ":object", "$g_presentation_obj_12"),															#	Show chosen amount of money
			(assign, reg8, ":value"),
			(overlay_set_text, "$g_presentation_obj_13", "@{reg8}"),
		(else_try),
			(eq, ":object", "$g_presentation_obj_14"),															#	Pay back chosen amount of money
			(try_begin),
				(gt, reg8, 0),
				(troop_remove_gold, "trp_player", reg8),
				(party_get_slot, ":debt", "$current_town", slot_town_bank_debt),
				(val_sub, ":debt", reg8),
				(party_set_slot, "$current_town", slot_town_bank_debt, ":debt"),
				(try_begin),
					(le, ":debt", 0),
					(party_set_slot, "$current_town", slot_town_bank_deadline, 0),
				(try_end),
				(start_presentation, "prsnt_bank"),
			(else_try),
				(display_message, "@You cant pay back 0 denars."),
			(try_end),
		(else_try),																								#	Switch Buy/Sell
			(eq, ":object", "$g_presentation_obj_16"),
			(try_begin),
				(neq, reg12, 2222),
				(assign, reg12, 2222),
				(start_presentation, "prsnt_bank"),
			(else_try),
				(assign, reg12, 0),
				(start_presentation, "prsnt_bank"),
			(try_end),
		(else_try),
			(eq, ":object", "$g_presentation_obj_15"),															#	Leave
			(presentation_set_duration, 0),
		(try_end),
		]),
      ]),



	 #	Floris Bank
  ("bank_quickview", 0, mesh_load_window, #mesh_companion_overview doesn't exist!
   [
     (ti_on_presentation_load,
      [
	    (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
 
#		(str_clear, s0),
 #       (create_text_overlay, reg0, "@Hello, {s0}", tf_scrollable),
 #       (position_set_x, pos1, 50),
  #      (position_set_y, pos1, 50),
 ###       (overlay_set_position, reg0, pos1),
 #       (position_set_x, pos1, 550),
 #       (position_set_y, pos1, 630),
  #      (overlay_set_area_size, reg0, pos1),
 #       (set_container_overlay, reg0),

		###HEADLINES###
		(assign, ":x_poshl", 155),
		(assign, ":y_pos", 581),
		(assign, ":jq_size", pos0),
		(position_set_x, ":jq_size", 720),
		(position_set_y, ":jq_size", 775),
 
        (create_text_overlay, reg1, "@Town", tf_center_justify),
    	(overlay_set_size, reg1, ":jq_size"),
 		(position_set_x, pos1, ":x_poshl"),
        (position_set_y, pos1, ":y_pos"),
        (overlay_set_position, reg1, pos1),
 
        (create_text_overlay, reg1, "@Acres", tf_center_justify),
       	(overlay_set_size, reg1, ":jq_size"),
		(val_add, ":x_poshl", 120),
 		(position_set_x, pos1, ":x_poshl"),
        (overlay_set_position, reg1, pos1),	
 
        (create_text_overlay, reg1, "@Owned", tf_center_justify),
       	(overlay_set_size, reg1, ":jq_size"),
		(val_add, ":x_poshl", 108),
 		(position_set_x, pos1, ":x_poshl"),
        (overlay_set_position, reg1, pos1),
 
        (create_text_overlay, reg1, "@Balance", tf_center_justify),
       	(overlay_set_size, reg1, ":jq_size"),
		(val_add, ":x_poshl", 112),
 		(position_set_x, pos1, ":x_poshl"),
        (overlay_set_position, reg1, pos1),
 
		(create_text_overlay, reg1, "@Assets", tf_center_justify),
       	(overlay_set_size, reg1, ":jq_size"),
		(val_add, ":x_poshl", 105),
 		(position_set_x, pos1, ":x_poshl"),
        (overlay_set_position, reg1, pos1),
 
        (create_text_overlay, reg1, "@Debt", tf_center_justify),
       	(overlay_set_size, reg1, ":jq_size"),
		(val_add, ":x_poshl", 105),
 		(position_set_x, pos1, ":x_poshl"),
        (overlay_set_position, reg1, pos1),	
 
        (create_text_overlay, reg1, "@Deadline", tf_center_justify),
       	(overlay_set_size, reg1, ":jq_size"),
		(val_add, ":x_poshl", 120),
 		(position_set_x, pos1, ":x_poshl"),
        (overlay_set_position, reg1, pos1),			
 
 
		(str_clear, s0),
		(create_text_overlay, reg0, s0, tf_scrollable),
        (position_set_x, pos1, 10),
        (position_set_y, pos1, 100),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 900),
        (position_set_y, pos1, 450),
        (overlay_set_area_size, reg0, pos1),
		(set_container_overlay, reg0),		
 
		(assign, ":jq_value", 100),
		(assign, ":jq_size", 0),
		(assign, ":x_pos", 0),
		(assign, ":y_pos", 547),
		(str_clear, s9),	
		(str_clear, s8),
 
 
        (assign, reg2, 0),#total_acres
        (assign, reg3, 0),#player_acres
        (assign, reg4, 0),#balance
        (assign, reg5, 0),#assets
		(assign, reg6, 0),#debt
		(assign, reg7, 0),#deadline
 
		(try_for_range, ":center_no", towns_begin, towns_end),
			(party_get_slot, ":land_town", ":center_no", slot_town_acres),
			(party_get_slot, ":land_player", ":center_no", slot_town_player_acres),
			(party_get_slot, ":assets", ":center_no", slot_town_bank_assets),
			(party_get_slot,":debt",":center_no",slot_town_bank_debt),
			(party_get_slot, ":deadline", ":center_no", slot_town_bank_deadline),
			(party_get_slot, ":population", ":center_no", slot_center_population),
			(party_get_slot, ":prosperity", ":center_no", slot_town_prosperity),
 
			(store_add, ":land_total", ":land_town", ":land_player"),
 
			(store_div, ":acres_needed", ":population", 200),
			(store_sub, ":surplus", ":land_total", ":acres_needed"),
			(store_sub, ":revenue", ":prosperity", 50),
			(val_add, ":revenue", 100),
			(assign, ":rent_player", 0),			
			(assign, ":upkeep_player", 0),
			(try_begin),
				(gt, ":land_player", 0),												# 	Fix 
			(try_begin),															#	Player Balance
				(le, ":land_total", ":acres_needed"),
				(store_mul, ":rent_player", ":land_player", ":revenue"),										
			(else_try),
				(store_mul, ":penalty", ":surplus", -1),
				(val_add, ":penalty", ":revenue"),
				(try_begin),
					(ge, ":penalty", 85),
					(store_mul, ":rent_player", ":land_player", ":penalty"),
				(else_try),
					(store_sub, ":non_rented", ":surplus", 15),
						(store_sub, ":land_rented", ":land_player", ":non_rented"),					# Fixed, wrong display # if player owned too much land due to val_sub usage
						(store_mul, ":rent_player", ":land_rented", 85),
					(store_mul, ":upkeep_player", ":non_rented", -50),
				(try_end),
			(try_end),
			(try_end),
 
			(store_add, ":balance", ":rent_player", ":upkeep_player"),
 
			(val_add, ":jq_value", 1),   
 
			#center center name
			(val_add, ":x_pos", 118), 
			(str_store_party_name,s9, ":center_no"),
			(str_store_string, s1, "@{s9}"),
			(create_text_overlay, reg1, s1, tf_left_align),
			(position_set_x, pos3, ":x_pos"),
			(position_set_y, pos3, ":y_pos"),
			(overlay_set_position, reg1, pos3),
			(position_set_x, pos3, 750),
			(position_set_y, pos3, 850),
			(overlay_set_size, reg1, pos3),
 
			#center land in acres
			(val_add, ":x_pos", 135),  
			(assign, reg2, ":land_total"),
			(create_text_overlay, reg1, "@{reg2}", tf_left_align),
			(position_set_x, pos3, ":x_pos"),
			(position_set_y, pos3, ":y_pos"),
			(overlay_set_position, reg1, pos3),
			(position_set_x, pos3, 750),
			(position_set_y, pos3, 850),
			(overlay_set_size, reg1, pos3),
 
			#Player land in city
			(val_add, ":x_pos", 113),  
			(assign, reg3, ":land_player"),
			(str_store_string, s1, "@{reg3}"),
			(create_text_overlay, reg1, s1, tf_left_align),
			(position_set_x, pos3, ":x_pos"),
			(position_set_y, pos3, ":y_pos"),
			(overlay_set_position, reg1, pos3),
			(position_set_x, pos3, 750),
			(position_set_y, pos3, 850),
			(overlay_set_size, reg1, pos3),
 
			#city Balance
			(val_add, ":x_pos", 110),  
			(assign, reg4, ":balance"),
			(str_store_string, s1, "@{reg4}"),
			(create_text_overlay, reg1, s1, tf_left_align),
			(position_set_x, pos3, ":x_pos"),
			(position_set_y, pos3, ":y_pos"),
			(overlay_set_position, reg1, pos3),
			(position_set_x, pos3, 750),
			(position_set_y, pos3, 850),
			(overlay_set_size, reg1, pos3),
 
			#Player assets in city
			(val_add, ":x_pos", 110),  
			(assign, reg4, ":assets"),
			(str_store_string, s1, "@{reg4}"),
			(create_text_overlay, reg1, s1, tf_left_align),
			(position_set_x, pos3, ":x_pos"),
			(position_set_y, pos3, ":y_pos"),
			(overlay_set_position, reg1, pos3),
			(position_set_x, pos3, 750),
			(position_set_y, pos3, 850),
			(overlay_set_size, reg1, pos3),
 
			#city Debt
			(val_add, ":x_pos", 105),  
			(assign, reg5, ":debt"),
			(str_store_string, s1, "@{reg5}"),
			(create_text_overlay, reg1, s1, tf_left_align),
			(position_set_x, pos3, ":x_pos"),
			(position_set_y, pos3, ":y_pos"),
			(overlay_set_position, reg1, pos3),
			(position_set_x, pos3, 750),
			(position_set_y, pos3, 850),
			(overlay_set_size, reg1, pos3),
 
			#city Deadline
			(val_add, ":x_pos", 105),
			(try_begin),
				(gt, ":deadline", 0),
				(call_script, "script_game_get_date_text", 1, ":deadline"),
			(else_try),
				(str_store_string, s1, "@None"),
			(try_end),
			(create_text_overlay, reg1, s1, tf_left_align),
			(position_set_x, pos3, ":x_pos"),
			(position_set_y, pos3, ":y_pos"),
			(overlay_set_position, reg1, pos3),
			(position_set_x, pos3, 750),
			(position_set_y, pos3, 850),
			(overlay_set_size, reg1, pos3),
 
			(assign, ":x_pos", 0),
			(assign, ":x_poshl", 165),
			(val_sub, ":y_pos", 23),#linebreak 
			(ge, ":x_pos", 950),
			(assign, ":x_pos", 0),
			(val_sub, ":y_pos", 23),
		(try_end), #Center-Bank Loop End
 
	  (set_container_overlay, -1),
 
	  		 #Back to menu - graphical button
	    (create_game_button_overlay, "$g_jq_Return_to_menu", "@_Return to menu_"),	 
	    (position_set_x, pos1, 500),
        (position_set_y, pos1, 23),
        (overlay_set_position, "$g_jq_Return_to_menu", pos1),
		#(assign, "$g_jq_Back_to_shop", 0), ##BUGFIX - savegame compatability ???
		#(assign, "$jq_nr", 0), ##BUGFIX - savegame compatability ???
 
	  ]),
	 (ti_on_presentation_event_state_change,
     [
        (store_trigger_param_1, ":object"),
		(try_begin), 
			(eq, ":object", "$g_jq_Return_to_menu"),
			(presentation_set_duration, 0),
		(try_end),
		]),
	]),
## Floris Bank System end



## Merchant's Trade Ledger begin
  ("trade_ledger_basic", 0, mesh_game_log_window, [ 
    (ti_on_presentation_load,
     [(set_fixed_point_multiplier, 1000),      

	  (assign, ":pref_date", "$g_date"), #Floris Date fix
	  (assign, "$g_date",  1), #Floris Date fix
      (create_text_overlay, reg0, "@Merchant Ledger", tf_center_justify|tf_single_line|tf_with_outline),
      (overlay_set_color, reg0, 0xFFFFFFFF),
      (position_set_x, pos1, 1500),
      (position_set_y, pos1, 1500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 680),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "@____Accessed Profit by Subtitle Here", tf_center_justify|tf_single_line), #Subtitle
      (position_set_x, pos1, 500),
      (position_set_y, pos1, 650),
      (overlay_set_position, reg0, pos1),
      
      ##Ledger Pane
      (str_clear, s0),
      (create_text_overlay, "$g_presentation_obj_bugdet_report_container", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 50),
      (position_set_y, pos1, 100),
      (overlay_set_position, "$g_presentation_obj_bugdet_report_container", pos1),
      (position_set_x, pos1, 600),
      (position_set_y, pos1, 500), 
      (overlay_set_area_size, "$g_presentation_obj_bugdet_report_container", pos1),
      (set_container_overlay, "$g_presentation_obj_bugdet_report_container"),
      
      (troop_get_slot, ":ledger", "trp_player", slot_troop_trade_ledger),
      (ge, ":ledger", 1),
      (call_script, "script_cf_array_is_array", ":ledger"),
      (call_script, "script_array_get_element", ":ledger", date_array),
      (assign, ":date_array", reg0),
      (call_script, "script_array_get_element", ":ledger", town_array),
      (assign, ":town_array", reg0),
      (call_script, "script_array_get_element", ":ledger", item_array),
      (assign, ":item_array", reg0),
      (call_script, "script_array_get_element", ":ledger", destination_array),
      (assign, ":destination_array", reg0),
      (call_script, "script_array_get_element", ":ledger", profit_array),
      (assign, ":profit_array", reg0),
        
      (call_script, "script_array_get_size", ":date_array"),
      (assign, ":ledger_length", reg0),
      (store_mul, ":cur_y", ":ledger_length", 30),

      (try_begin),
          (eq, reg60, 0), #Default (Chronological) View
          (assign, ":next_entry", 0),
          (try_for_range, ":i", 0, ":ledger_length"),
            (eq, ":i", ":next_entry"),
            
            (call_script, "script_cf_array_get_element", ":date_array", ":i"),
            (assign, ":date", reg0),
            (str_store_date, s0, ":date"),
            (call_script, "script_cf_array_get_element", ":town_array", ":i"),
            (assign, ":town", reg0),
            (str_store_party_name, s1, ":town"),
            #DISPLAY DAY, TOWN in one overlay
            (create_text_overlay, reg0, "@{s0}, products from {s1}:"),
            (position_set_x, pos1, 1000),
            (position_set_y, pos1, 1000),
            (overlay_set_size, reg0, pos1),
            (position_set_x, pos1, 25),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),
            
            (assign, ":end", ":ledger_length"),
            (assign, ":end_index", ":end"), #Should get overwritten in below loop
            #(store_add, ":next_entry", ":i", 1), #Should get overwritten in below loop #necessary fail-safe?
            (try_for_range, ":n", ":i", ":end"), #This loop finds the end of the current set of entries
                (call_script, "script_cf_array_get_element", ":date_array", ":n"),
                (assign, ":test_date", reg0),
                (call_script, "script_cf_array_get_element", ":town_array", ":n"),
                (this_or_next|neq, ":town", reg0), #Once the date OR the town change, it is a new entry
                (neq, ":date", ":test_date"),
                (assign, ":end_index", ":n"),
                (assign, ":next_entry", ":n"),
                (assign, ":end", 0), #Break
            (try_end),

            (assign, ":line_count", 0),
            (str_clear, s3),
            (try_for_range, ":n", ":i", ":end_index"),
                (val_add, ":line_count", 1),
                (call_script, "script_cf_array_get_element", ":item_array", ":n"),
                (str_store_item_name, s1, reg0),
                (call_script, "script_cf_array_get_element", ":destination_array", ":n"),
                (str_store_party_name, s2, reg0),
                (call_script, "script_cf_array_get_element", ":profit_array", ":n"),
                (str_store_string, s3, "@^{s1} sold in {s2} would earn {reg0} denars.{s3}"),    
            (try_end), #Item Loop    
            
            (val_mul, ":line_count", 14),
            (val_sub, ":cur_y", ":line_count"),
            #CREATE ITEM, DEST, PROFIT for all items in one overlay
            (create_text_overlay, reg0, s3),
            (position_set_x, pos1, 800),
            (position_set_y, pos1, 800),
            (overlay_set_size, reg0, pos1),
            (position_set_x, pos1, 50),
            (position_set_y, pos1, ":cur_y"),
            (overlay_set_position, reg0, pos1),
            (val_sub, ":cur_y", 30),            
          (try_end), #Town Entry Loop
          (store_sub, reg0, "$g_presentation_obj_bugdet_report_container", 1),
          (overlay_set_text, reg0, "@__Accessed Profit by Log Entry Date"),
        (else_try),
          (eq, reg60, 1), #Origin View
          (try_for_range, ":cur_town", towns_begin, towns_end),
            (assign, ":line_count", 0),
            (assign, ":profit", 0),
            (try_for_range, ":i", 0, ":ledger_length"),
                (call_script, "script_cf_array_get_element", ":town_array", ":i"),
                (eq, ":cur_town", reg0),
                (call_script, "script_cf_array_get_element", ":profit_array", ":i"),
                (val_add, ":profit", reg0),    
                (val_add, ":line_count", 1),
            (try_end),
            (val_max, ":line_count", 1), #Ensure no Div-by-0
            (val_div, ":profit", ":line_count"),
            (troop_set_slot, "trp_temp_array_b", ":cur_town", ":profit"),
          (try_end),
          (assign, ":max_profit", 0),
          (try_for_range, ":i", towns_begin, towns_end),
            (troop_get_slot, reg0, "trp_temp_array_b", ":i"),
            (lt, ":max_profit", reg0),
            (assign, ":max_profit", reg0),
          (try_end),
          (val_add, ":max_profit", 1),
          (try_for_range_backwards, ":profit", 0, ":max_profit"),
            (try_for_range, ":cur_town", towns_begin, towns_end),
                (troop_slot_eq, "trp_temp_array_b", ":cur_town", ":profit"),

                (assign, ":line_count", 0),
                (str_clear, s3),
                (try_for_range, ":i", 0, ":ledger_length"),
                    (call_script, "script_cf_array_get_element", ":town_array", ":i"),
                    (eq, ":cur_town", reg0),
                    (val_add, ":line_count", 1),

                    (call_script, "script_cf_array_get_element", ":date_array", ":i"),
                    (str_store_date, s0, reg0),
                    (call_script, "script_cf_array_get_element", ":item_array", ":i"),
                    (str_store_item_name, s1, reg0),
                    (call_script, "script_cf_array_get_element", ":destination_array", ":i"),
                    (str_store_party_name, s2, reg0),
                    (call_script, "script_cf_array_get_element", ":profit_array", ":i"),
                    (str_store_string, s3, "@^{s1} sold in {s2} would earn {reg0} denars (as of {s0}).{s3}"),            
                (try_end), #Entry Loop
                (ge, ":line_count", 1),
                
                #DISPLAY TOWN header in one overlay
                (str_store_party_name, s1, ":cur_town"),
                (str_store_string, s1, "@Production in {s1}"),
                (create_text_overlay, reg0, s1),
                (position_set_x, pos1, 1000),
                (position_set_y, pos1, 1000),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, 25),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),

                
                (val_mul, ":line_count", 14),
                (val_sub, ":cur_y", ":line_count"),
                
                #ITEM, DEST, PROFIT, and DATE for all items in one overlay
                (create_text_overlay, reg0, s3),
                (position_set_x, pos1, 800),
                (position_set_y, pos1, 800),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, 50),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),
                (val_sub, ":cur_y", 30),    
              (try_end), #Town-Profit Loop
          (try_end), #Profit Values Loop
          
          (store_sub, reg0, "$g_presentation_obj_bugdet_report_container", 1),
          (overlay_set_text, reg0, "@Accessed Profit by Town of Production"),
        (else_try),
          (eq, reg60, 2), #Destination View
          (try_for_range, ":cur_town", towns_begin, towns_end),
            (assign, ":line_count", 0),
            (assign, ":profit", 0),
            (try_for_range, ":i", 0, ":ledger_length"),
                (call_script, "script_cf_array_get_element", ":destination_array", ":i"),
                (eq, ":cur_town", reg0),
                (call_script, "script_cf_array_get_element", ":profit_array", ":i"),
                (val_add, ":profit", reg0),    
                (val_add, ":line_count", 1),
            (try_end),
            (val_max, ":line_count", 1), #Ensure no Div-by-0
            (val_div, ":profit", ":line_count"),
            (troop_set_slot, "trp_temp_array_b", ":cur_town", ":profit"),
          (try_end),
          (assign, ":max_profit", 0),
          (try_for_range, ":i", towns_begin, towns_end),
            (troop_get_slot, reg0, "trp_temp_array_b", ":i"),
            (lt, ":max_profit", reg0),
            (assign, ":max_profit", reg0),
          (try_end),
          (val_add, ":max_profit", 1),
          (try_for_range_backwards, ":profit", 0, ":max_profit"),
            (try_for_range, ":cur_town", towns_begin, towns_end),
                (troop_slot_eq, "trp_temp_array_b", ":cur_town", ":profit"),

                (assign, ":line_count", 0),
                (str_clear, s3),
                (try_for_range, ":i", 0, ":ledger_length"),
                    (call_script, "script_cf_array_get_element", ":destination_array", ":i"),
                    (eq, ":cur_town", reg0),
                    (val_add, ":line_count", 1),

                    (call_script, "script_cf_array_get_element", ":date_array", ":i"),
                    (str_store_date, s0, reg0),
                    (call_script, "script_cf_array_get_element", ":item_array", ":i"),
                    (str_store_item_name, s1, reg0),
                    (call_script, "script_cf_array_get_element", ":town_array", ":i"),
                    (str_store_party_name, s2, reg0),
                    (call_script, "script_cf_array_get_element", ":profit_array", ":i"),
                    (str_store_string, s3, "@^{s1} purchased in {s2} would earn {reg0} denars (as of {s0}).{s3}"),            
                (try_end), #Entry Loop
                (ge, ":line_count", 1),
                
                #DISPLAY TOWN header in one overlay
                (str_store_party_name, s1, ":cur_town"),
                (str_store_string, s1, "@Demand in {s1}"),
                (create_text_overlay, reg0, s1),
                (position_set_x, pos1, 1000),
                (position_set_y, pos1, 1000),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, 25),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),

                (val_mul, ":line_count", 14),
                (val_sub, ":cur_y", ":line_count"),
                
                #ITEM, DEST, PROFIT, and DATE for all items in one overlay
                (create_text_overlay, reg0, s3),
                (position_set_x, pos1, 800),
                (position_set_y, pos1, 800),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, 50),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),
                (val_sub, ":cur_y", 30),    
              (try_end), #Town-Profit Loop
          (try_end), #Profit Values Loop
          (store_sub, reg0, "$g_presentation_obj_bugdet_report_container", 1),
          (overlay_set_text, reg0, "@Accessed Profit by Town of Demand"),
        (else_try),
          (eq, reg60, 3), #Item View
          (try_for_range, ":cur_item", trade_goods_begin, trade_goods_end),
            (assign, ":line_count", 0),
            (assign, ":profit", 0),
            (try_for_range, ":i", 0, ":ledger_length"),
                (call_script, "script_cf_array_get_element", ":item_array", ":i"), 
                (eq, ":cur_item", reg0),
                (call_script, "script_cf_array_get_element", ":profit_array", ":i"),
                (val_add, ":profit", reg0),    
                (val_add, ":line_count", 1),
            (try_end),
            (val_max, ":line_count", 1), #Ensure no Div-by-0
            (val_div, ":profit", ":line_count"),
            (troop_set_slot, "trp_temp_array_b", ":cur_item", ":profit"),
          (try_end),
          (assign, ":max_profit", 0),
          (try_for_range, ":i", trade_goods_begin, trade_goods_end),
            (troop_get_slot, reg0, "trp_temp_array_b", ":i"),
            (lt, ":max_profit", reg0),
            (assign, ":max_profit", reg0),
          (try_end),
          (val_add, ":max_profit", 1),
          (try_for_range_backwards, ":profit", 0, ":max_profit"),
            (try_for_range, ":cur_item", trade_goods_begin, trade_goods_end),
                (troop_slot_eq, "trp_temp_array_b", ":cur_item", ":profit"),

                (assign, ":line_count", 0),
                (str_clear, s3),
                (try_for_range, ":i", 0, ":ledger_length"),
                    (call_script, "script_cf_array_get_element", ":item_array", ":i"),
                    (eq, ":cur_item", reg0),
                    (val_add, ":line_count", 1),

                    (call_script, "script_cf_array_get_element", ":date_array", ":i"),
                    (str_store_date, s0, reg0),
                    (call_script, "script_cf_array_get_element", ":town_array", ":i"),
                    (str_store_party_name, s1, reg0),
                    (call_script, "script_cf_array_get_element", ":destination_array", ":i"),
                    (str_store_party_name, s2, reg0),
                    (call_script, "script_cf_array_get_element", ":profit_array", ":i"),
                    (str_store_string, s3, "@^Buy in: {s1} - sell in: {s2} for {reg0} denars profit (as of {s0}).{s3}"),            
                (try_end), #Entry Loop
                (ge, ":line_count", 1),
                
                #DISPLAY ITEM header in one overlay
                (str_store_item_name, s1, ":cur_item"),
                (str_store_string, s1, "@Supply and Demand of {s1}"),
                (create_text_overlay, reg0, s1),
                (position_set_x, pos1, 1000),
                (position_set_y, pos1, 1000),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, 25),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),

                (val_mul, ":line_count", 14),
                (val_sub, ":cur_y", ":line_count"),
                
                #Origin, DEST, PROFIT, and DATE for all towns in one overlay
                (create_text_overlay, reg0, s3),
                (position_set_x, pos1, 800),
                (position_set_y, pos1, 800),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, 50),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),
                (val_sub, ":cur_y", 30),    
              (try_end), #Item-Profit Loop
          (try_end), #Profit Values Loop
          (store_sub, reg0, "$g_presentation_obj_bugdet_report_container", 1),
          (overlay_set_text, reg0, "@____Accessed Profit by Trade Good"),
        (else_try),
          (eq, reg60, 4),
          (assign, ":cur_y", 750),
          
          (create_text_overlay, reg0, "@Trim ledger entries older than:______________days:"),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          
          (create_number_box_overlay, "$g_presentation_obj_custom_battle_designer_17", 3, 1001),
          (position_set_x, pos1, 285),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, "$g_presentation_obj_custom_battle_designer_17", pos1),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_17", 3),
          (val_sub, ":cur_y", 30),
          
          (create_button_overlay, reg0, "@Remove entries."),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 290),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 40),
          
          (create_text_overlay, reg0, "@Trim ledger entries covering the following trade good:"),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 40),
          
          (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_16", trade_goods_begin, trade_goods_end),
          (position_set_x, pos1, 200),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, "$g_presentation_obj_custom_battle_designer_16", pos1),
                
          (create_text_overlay, reg0, "@Use slider to choose item"),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 350),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 30),
          
          (create_button_overlay, reg0, "@Remove entries."),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 290),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 40),
          
          (create_text_overlay, reg0, "@Trim ledger entries for goods tied to this town:"),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 40),
          
          (create_slider_overlay, "$g_presentation_obj_custom_battle_designer_15", towns_begin, towns_end),
          (position_set_x, pos1, 200),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, "$g_presentation_obj_custom_battle_designer_15", pos1),
                
          (create_text_overlay, reg0, "@Use slider to choose town"),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 350),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 30),
                    
          (create_button_overlay, reg0, "@Remove entries (Production)."),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 290),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 20),
          
          (create_button_overlay, reg0, "@Remove entries (Demand)."),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 290),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 40),
          
          (create_text_overlay, reg0, "@Trim ledger entries with less than:______________denar profit:"),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          
          (create_number_box_overlay, "$g_presentation_obj_custom_battle_designer_14", 10, 1001),
          (position_set_x, pos1, 305),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, "$g_presentation_obj_custom_battle_designer_14", pos1),
          (overlay_set_val, "$g_presentation_obj_custom_battle_designer_14", 10),
          (val_sub, ":cur_y", 30),
          
          (create_button_overlay, reg0, "@Remove entries."),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 290),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 60),
                    
          (create_text_overlay, reg0, "@Ask about the potential profit of the following items^____every time you access prices in a marketplace:"),
          (position_set_x, pos1, 900),
          (position_set_y, pos1, 900),
          (overlay_set_size, reg0, pos1),
          (position_set_x, pos1, 50),
          (position_set_y, pos1, ":cur_y"),
          (overlay_set_position, reg0, pos1),
          (val_sub, ":cur_y", 40),
          
          (call_script, "script_get_max_skill_of_player_party", "skl_trade"),
          (assign, ":max_skill", reg0),
          (val_max, ":max_skill", 1), #at least 1
          (store_add, ":array_size", ":max_skill", custom_assess_begin),
          (assign, ":ledger_length", ":array_size"),
          (try_begin),
            (call_script, "script_array_get_size", ":ledger"),
            (lt, reg0, ":array_size"), #array not big enough
            (val_sub, ":array_size", reg0),
            (try_for_range, ":unused", 0, ":array_size"),
                (call_script, "script_array_pushback", ":ledger", -1), #Increase array's size
            (try_end),          
          (try_end),
          
          (try_for_range, ":i", custom_assess_begin, ":ledger_length"),
                (create_slider_overlay, ":overlay", trade_goods_begin, trade_goods_end),
                (position_set_x, pos1, 200),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, ":overlay", pos1),
                
                (create_text_overlay, reg0, s0),
                (position_set_x, pos1, 900),
                (position_set_y, pos1, 900),
                (overlay_set_size, reg0, pos1),
                (position_set_x, pos1, 350),
                (position_set_y, pos1, ":cur_y"),
                (overlay_set_position, reg0, pos1),
                (val_sub, ":cur_y", 40),
                
                (troop_set_slot, "trp_temp_array_c", ":i", ":overlay"),
                (try_begin),
                    (call_script, "script_cf_array_get_element", ":ledger", ":i"),
                    (is_between, reg0, trade_goods_begin, trade_goods_end),
                    (str_store_item_name, s0, reg0),
                    (overlay_set_val, ":overlay", reg0),
                (else_try),
                    (str_store_string, s0, "@Use slider to choose item"),
                (try_end),
                (val_add, ":overlay", 1),
                (overlay_set_text, ":overlay", s0),
          (try_end),
           
          (store_sub, reg0, "$g_presentation_obj_bugdet_report_container", 1),
          (overlay_set_text, reg0, "@___________Log Entry Options"),
      (try_end),      
      (set_container_overlay, -1),
      
      ##Note Pad Pane
      (create_mesh_overlay, reg0, "mesh_white_plane"),
      (overlay_set_alpha, reg0, 0x30),
      (position_set_x, pos1, 11550),
      (position_set_y, pos1, 19500),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 210),
      (overlay_set_position, reg0, pos1),      
      
      (str_store_party_name, s0, ":date_array"),
      (create_text_overlay, "$g_presentation_obj_custom_battle_designer_18", s0, tf_scrollable_style_2),
      (position_set_x, pos1, 800),
      (position_set_y, pos1, 800),
      (overlay_set_size, "$g_presentation_obj_custom_battle_designer_18", pos1),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 210),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_18", pos1),
      (position_set_x, pos1, 230),
      (position_set_y, pos1, 390),
      (overlay_set_area_size, "$g_presentation_obj_custom_battle_designer_18", pos1),
      
      (create_button_overlay, reg0, "@Add Note"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 150),
      (overlay_set_position, reg0, pos1),    
      
      (create_button_overlay, reg0, "@Clear Notes"),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 900),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 830),
      (position_set_y, pos1, 150),
      (overlay_set_position, reg0, pos1),
    
      (create_simple_text_box_overlay, reg0),
      (position_set_x, pos1, 228),
      (position_set_y, pos1, 800),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 180),
      (overlay_set_position, reg0, pos1),

      (create_text_overlay, reg0, "@Use a /\ (caret) for a line break."), # \%^
      (position_set_x, pos1, 700),
      (position_set_y, pos1, 700),
      (overlay_set_size, reg0, pos1),
      (position_set_x, pos1, 730),
      (position_set_y, pos1, 120),
      (overlay_set_position, reg0, pos1),      
      
      ##Bottom Row Buttons      
      (create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_19", "@Chronological Log", 0),
      (position_set_x, pos1, 260),
      (position_set_y, pos1, 10),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_19", pos1),
      
      (create_game_button_overlay, reg0, "@Production Towns", 0),
      (position_set_x, pos1, 420),
      (position_set_y, pos1, 10),
      (overlay_set_position, reg0, pos1),      
            
      (create_game_button_overlay, reg0, "@Purchasing Towns", 0),
      (position_set_x, pos1, 580),
      (position_set_y, pos1, 10),
      (overlay_set_position, reg0, pos1),          
            
      (create_game_button_overlay, reg0, "@Trade Goods", 0),
      (position_set_x, pos1, 740),
      (position_set_y, pos1, 10),
      (overlay_set_position, reg0, pos1),    
      
      (create_game_button_overlay, reg0, "@Manage Ledger", 0), #On Far Left
      (position_set_x, pos1, 100),
      (position_set_y, pos1, 10),
      (overlay_set_position, reg0, pos1),

      (create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_20", "@Done", 0),
      (position_set_x, pos1, 900),
      (position_set_y, pos1, 10),
      (overlay_set_position, "$g_presentation_obj_custom_battle_designer_20", pos1),
      
      (str_clear, s0),
      (assign, reg56, 10),
      (assign, reg57, -1),
      (assign, reg58, -1),
      (assign, reg59, 3),
      (assign, "$g_date", ":pref_date"), #Floris Date fix
      (presentation_set_duration, 999999),
      ]),
    (ti_on_presentation_run,
      [    
        (key_clicked, key_escape),
        (try_begin),
            (eq, reg60, 4),#Leaving Config/Options Page
            (call_script, "script_cf_trade_ledger_custom_assess_duplicates"),
        (try_end),
        (presentation_set_duration, 0),
      ]),
    (ti_on_presentation_event_state_change,
     [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
        (try_begin),
           (eq, ":object", "$g_presentation_obj_custom_battle_designer_20"),
           (try_begin),
                (eq, reg60, 4),#Leaving Config/Options Page
                (call_script, "script_cf_trade_ledger_custom_assess_duplicates"),
           (try_end),
           (presentation_set_duration, 0),
        (else_try),  #Add Note
            (store_add, ":overlay", "$g_presentation_obj_custom_battle_designer_18", 1),
            (eq, ":object", ":overlay"),
            (neg|str_is_empty, s0),
            (troop_get_slot, ":ledger", "trp_player", slot_troop_trade_ledger),
            (ge, ":ledger", 1),
            (call_script, "script_array_get_element", ":ledger", 0),
            (str_store_party_name, s1, reg0),
            (str_store_string, s1, "@{s1}^+{s0}"),
            (party_set_name, reg0, s1),
            (overlay_set_text, "$g_presentation_obj_custom_battle_designer_18", s1),
            (str_clear, s0),
            (val_add, ":overlay", 2),
            (overlay_set_text, ":overlay", s0),
        (else_try), #Clear Notes
            (store_add, ":overlay", "$g_presentation_obj_custom_battle_designer_18", 2),
            (eq, ":object", ":overlay"),
            (troop_get_slot, ":ledger", "trp_player", slot_troop_trade_ledger),
            (ge, ":ledger", 1),
            (call_script, "script_array_get_element", ":ledger", 0),
            (str_clear, s0),
            (party_set_name, reg0, s0),
            (overlay_set_text, "$g_presentation_obj_custom_battle_designer_18", s0),
        (else_try), #Log View Changes
            (is_between, ":object", "$g_presentation_obj_custom_battle_designer_19", "$g_presentation_obj_custom_battle_designer_20"),
            (store_sub, ":view", ":object", "$g_presentation_obj_custom_battle_designer_19"), #Results in a value 0-4
            (try_begin),
                (eq, reg60, 4), #Leaving Config/Options Page
                (call_script, "script_cf_trade_ledger_custom_assess_duplicates"),
            (try_end),
            (assign, reg60, ":view"),
            (start_presentation, "prsnt_trade_ledger_basic"),
        (else_try), #Set Date Threshold for Removal
            (eq, ":object", "$g_presentation_obj_custom_battle_designer_17"),
            (assign, reg59, ":value"),
        (else_try), #Remove Entries - Date
            (store_add, ":overlay", "$g_presentation_obj_custom_battle_designer_17", 1),
            (eq, ":object", ":overlay"),
            (gt, reg59, 0),
            (call_script, "script_cf_trade_ledger_trim_entries", "trp_player", reg59, date_array),
            (display_message, "@{reg0} entries removed from ledger."),
        (else_try), #Set Item for Removal
            (eq, ":object", "$g_presentation_obj_custom_battle_designer_16"),
            (is_between, ":value", trade_goods_begin, trade_goods_end),
            (assign, reg58, ":value"),
            (str_store_item_name, s0, ":value"),
            (overlay_set_val, ":object", ":value"), #looks cleaner
            (val_add, ":object", 1),
            (overlay_set_text, ":object", s0),
        (else_try), #Remove Entries - Item
            (store_add, ":overlay", "$g_presentation_obj_custom_battle_designer_16", 2),
            (eq, ":object", ":overlay"),
            (is_between, reg58, trade_goods_begin, trade_goods_end),
            (call_script, "script_cf_trade_ledger_trim_entries", "trp_player", reg58, item_array),
            (display_message, "@{reg0} entries removed from ledger."),
        (else_try), #Set Town for Removal
            (eq, ":object", "$g_presentation_obj_custom_battle_designer_15"),
            (is_between, ":value", towns_begin, towns_end),
            (assign, reg57, ":value"),
            (str_store_party_name, s0, ":value"),
            (overlay_set_val, ":object", ":value"), #looks cleaner
            (val_add, ":object", 1),
            (overlay_set_text, ":object", s0),
        (else_try), #Remove Entries - Production Town
            (store_add, ":overlay", "$g_presentation_obj_custom_battle_designer_15", 2),
            (eq, ":object", ":overlay"), 
            (is_between, reg57, towns_begin, towns_end),
            (store_sub, ":overlay", ":object", "$g_presentation_obj_custom_battle_designer_15"),
            (call_script, "script_cf_trade_ledger_trim_entries", "trp_player", reg57, town_array),
            (display_message, "@{reg0} entries removed from ledger."),    
        (else_try), #Remove Entries - Demand Town
            (val_add, ":overlay", 1),
            (eq, ":object", ":overlay"), 
            (is_between, reg57, towns_begin, towns_end),
            (store_sub, ":overlay", ":object", "$g_presentation_obj_custom_battle_designer_15"),
            (call_script, "script_cf_trade_ledger_trim_entries", "trp_player", reg57, destination_array),
            (display_message, "@{reg0} entries removed from ledger."),    
        (else_try), #Set Profit Level for Removal
            (eq, ":object", "$g_presentation_obj_custom_battle_designer_14"),
            (assign, reg56, ":value"),
        (else_try), #Remove Entries - Proft Level
            (store_add, ":overlay", "$g_presentation_obj_custom_battle_designer_14", 1),
            (eq, ":object", ":overlay"),
            (gt, reg56, 0),
            (call_script, "script_cf_trade_ledger_trim_entries", "trp_player", reg56, profit_array),
            (display_message, "@{reg0} entries removed from ledger."),            
        (else_try), #Assess Custom Item        
            (troop_get_slot, ":slider_1", "trp_temp_array_c", 5),
            (is_between, ":object", ":slider_1", "$g_presentation_obj_custom_battle_designer_18"),
            (is_between, ":value", trade_goods_begin, trade_goods_end),
            (troop_get_slot, ":ledger", "trp_player", slot_troop_trade_ledger),
            (call_script, "script_array_get_size", ":ledger"),
            (val_add, reg0, 1),
            (try_for_range, ":i", custom_assess_begin, reg0),
                (troop_slot_eq, "trp_temp_array_c", ":i", ":object"),
                (assign, ":index", ":i"),
                (assign, reg0, 0), #break
            (try_end),
            (call_script, "script_cf_trade_ledger_custom_assess_item", ":value", ":index"),
            (str_store_item_name, s0, ":value"),
            (overlay_set_val, ":object", ":value"), #looks cleaner
            (val_add, ":object", 1),
            (overlay_set_text, ":object", s0),
        (try_end),
     ]),
    ]),
## Merchant's Trade Ledger end



## NMC begin
# Set your party's name - by Caba'Drin
  ("set_party_name",0,mesh_load_window,[
     (ti_on_presentation_load,
       [(set_fixed_point_multiplier, 1000),
        (str_store_string, s1, "@What will your party be known as?"),
        (create_text_overlay, reg1, s1, tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 500),
        (overlay_set_position, reg1, pos1),
        (overlay_set_text, reg1, s1),
        (create_simple_text_box_overlay, "$g_presentation_obj_name_kingdom_1"),
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_name_kingdom_1", pos1),        
        (str_store_party_name, s7, "p_main_party"),
        (overlay_set_text, "$g_presentation_obj_name_kingdom_1", s7),
        
        (create_button_overlay, "$g_presentation_obj_name_kingdom_2", "@By the name entered above."),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 300),
        (overlay_set_position, "$g_presentation_obj_name_kingdom_2", pos1),
          
        (str_store_troop_name, s5, "trp_player"),
        (create_button_overlay, reg1, "@Simply by my name: {s5}."),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 275),
        (overlay_set_position, reg1, pos1),  
          
        (presentation_set_duration, 999999),
        ]),
      (ti_on_presentation_event_state_change,
       [(store_trigger_param_1, ":object"),
        (try_begin),
          (eq, ":object", "$g_presentation_obj_name_kingdom_1"),
          (str_store_string, s7, s0),
        (else_try),
          (eq, ":object", "$g_presentation_obj_name_kingdom_2"),
          (party_set_name, "p_main_party", s7),
          (party_set_slot, 0, 1, 1),
          (presentation_set_duration, 0),
        (else_try),
          (store_add, ":overlay", "$g_presentation_obj_name_kingdom_2", 1),
          (eq, ":overlay", ":object"),
          (party_set_name, "p_main_party", s5),
          (party_set_slot, 0, 1, 0),
          (presentation_set_duration, 0),
        (try_end),
        ]),
      ]),
## NMC end



##TEMPERED scene picker siege camps, castles, towns                                                                                                                                                                                                          ############ skirmisher slider##################
   ("scene_picker",0,mesh_game_log_window,[
      (ti_on_presentation_load,
       [	(presentation_set_duration,99999),
			(set_fixed_point_multiplier, 1000),
			(assign,"$g_presentation_obj_15_val","p_town_1"),
			(str_store_party_name,s2,"$g_presentation_obj_15_val"),
#hero slider        
			(create_slider_overlay, "$g_presentation_obj_15", "p_town_1", "p_castle_48"),               
			(position_set_x, pos1, 500),
			(position_set_y, pos1, 500),
			(overlay_set_position, "$g_presentation_obj_15", pos1),
			(overlay_set_val, "$g_presentation_obj_15",  "$g_presentation_obj_15_val"),

			(create_text_overlay, "$g_presentation_obj_17","@ {s2} siege camp.",tf_center_justify),
			(position_set_x, pos1, 500),
			(position_set_y, pos1, 600),
			(overlay_set_position, "$g_presentation_obj_17", pos1),
			(position_set_x, pos2,1000),
			(position_set_y, pos2,1000),
			(overlay_set_size,"$g_presentation_obj_17",pos2),

			#CONTINUE BUTTON
			(create_game_button_overlay,"$g_presentation_obj_19","@_Continue_",tf_center_justify),
			(position_set_x, pos1, 500),
			(position_set_y, pos1, 30),
			(overlay_set_position, "$g_presentation_obj_19", pos1),			

		]),
		
      (ti_on_presentation_event_state_change,
       [	(store_trigger_param_1, ":object"),
			(store_trigger_param_2, ":value"),
			(try_begin),
				(eq,"$g_presentation_obj_19",":object"),
				(assign,"$temp_presentation_shown",1),				
				(presentation_set_duration,0),
			(else_try),
				(eq,":object","$g_presentation_obj_15"),
				(assign,"$g_presentation_obj_15_val",":value"),
				(str_store_party_name, s2,":value"),
				(overlay_set_text,"$g_presentation_obj_17", "@ {s2} siege camp.",tf_center_justify),
			(try_end),
        ]),		
	]),
##
## Tocan  
##Floris Sea Trade - Name your ship
 
 ("manage_ships", 0, mesh_load_window, [ #Ultra Important#
    (ti_on_presentation_load,
      [
        (presentation_set_duration, 999999),
        (set_fixed_point_multiplier, 1000),
 
		(str_clear, s0), #just in case
		(try_for_range, ":i", 0, 100), #be sure the temp slots are empty
		    (troop_set_slot, "trp_temp_array_a", ":i", 0),
			(troop_set_slot, "trp_temp_array_b", ":i", 0),
		(try_end),
 
		(create_text_overlay, reg0, "@Manage Ship", tf_center_justify),
        (position_set_x, pos1, 500),
        (position_set_y, pos1, 680),
        (overlay_set_position, reg0, pos1),
		(position_set_x, pos1, 1500),
        (position_set_y, pos1, 1500),
        (overlay_set_size, reg0, pos1),
 
		(str_store_string, s11, "@{s12}\
Cogs are large sailing ships with their bows and sterns built at a higher level than the rest of the ship in order to form a castle like structure,\
which is used to defend the ship from enemies using archers. The Cog was the first type of boat that used the new idea of a rudder mounted on the stern\
for steering purpose. However as this is still a rather new idea, many cogs are still equipped with steering oars, which were also known as side rudders.\
The early cogs, weren't very large and had open hulls which didnt offer much sailing capability.^^\
Nowadays the cogs are used for sailing through rough waters and their hull is made from clinker construction, which provides them with\
added strength and robustness. Their hulls also grew in size as they evolved into large cargo carriers.^^\
Cog are ships with flat bottoms. They have a ridge or keel that runs along the lower side of the ship. On both sides of the keel, there\
is lapstrake planking, firmly fixed by iron nails. The stern and stern posts are both straight in shape and attached to the keel plate\
by means of hooks. The plank of the keel is thicker than the lapstrake and planking at the sites and moreover, the stern mounted central\
rudder is an integral part of the cog construction. It is this design, that makes cogs more stable than any other type of ship.^^\
Generally built from oak wood, cogs have only a single long mast, which carries a massive square sail. The size of the sail depends \
on the size of the hull. This means that as the size of cog hull became bigger, the size of sails also increased. The only drawback of this construction\
was that it prevented sailing directly into the wind. However it facilitated the yacht so far, that it could be handled by a small crew,\
reducing the overall operational cost."),
 
		(create_text_overlay, reg0, s11, tf_double_space|tf_scrollable),  ##Describes the ship
        (position_set_x, pos1, 400),
        (position_set_y, pos1, 80),
        (overlay_set_position, reg0, pos1),
        (position_set_x, pos1, 550),
        (position_set_y, pos1, 500),
        (overlay_set_area_size, reg0, pos1),
 
 
        (create_text_overlay, reg0, "@Select ship:", tf_center_justify),
        (position_set_x, pos1, 150),
        (position_set_y, pos1, 550),
        (overlay_set_position, reg0, pos1),
 
		(position_set_x, pos1, 160),
		(position_set_y, pos1, 510),
        (create_combo_button_overlay, "$g_presentation_obj_11"),	#Combo Button for ships
        (overlay_set_position, "$g_presentation_obj_11", pos1),
 
		(assign, ":slot", 0),
		(try_for_parties, ":ship_no"),
			(party_slot_eq, ":ship_no", slot_ship_center, "$current_town"),
			(str_store_party_name, s1, ":ship_no"),
			(overlay_add_item, "$g_presentation_obj_11", s1),
			(overlay_set_val, "$g_presentation_obj_11", reg6),
			(troop_set_slot, "trp_temp_array_a", ":slot", ":ship_no"), #this way the troop slot # = overlay combo box index #
			(val_add, ":slot", 1),
		(try_end),
 
	    (create_text_overlay, reg0, "@Name your ship:", tf_center_justify),
        (position_set_x, pos1, 150),
        (position_set_y, pos1, 475),
        (overlay_set_position, reg0, pos1),
 
		(create_simple_text_box_overlay, "$g_presentation_obj_name_kingdom_1"), #Text box
        (position_set_x, pos1, 50),
        (position_set_y, pos1, 440),
        (overlay_set_position, "$g_presentation_obj_name_kingdom_1", pos1),	
 
        (create_button_overlay, "$g_presentation_obj_13", "@Rename Ship."),
        (position_set_x, pos1, 75),
        (position_set_y, pos1, 400),
        (overlay_set_position, "$g_presentation_obj_13", pos1),
 
 
		(create_text_overlay, reg0, "@Send ship to port:", tf_center_justify),
        (position_set_x, pos1, 150),
        (position_set_y, pos1, 250),
        (overlay_set_position, reg0, pos1),
 
		(position_set_x, pos1, 160),
		(position_set_y, pos1, 210),
        (create_combo_button_overlay, "$g_presentation_obj_12"),	#Combo Button for ships
        (overlay_set_position, "$g_presentation_obj_12", pos1),
 
		(assign, ":slot", 0),
		(try_for_range, ":town_no", towns_begin, towns_end),
			(neq, ":town_no", "$current_town"),
			(party_slot_ge, ":town_no", slot_town_is_coastal, 1),
			(store_faction_of_party, ":faction_1", "p_main_party"),
			(store_faction_of_party, ":faction_2", ":town_no"),
			(store_relation, ":relation", ":faction_1", ":faction_2"), #Cant send to enemy ports
			(ge, ":relation", 0),
			(str_store_party_name, s1, ":town_no"),
			(overlay_add_item, "$g_presentation_obj_12", s1),
			(troop_set_slot, "trp_temp_array_b", ":slot", ":town_no"), #this way the troop slot # = overlay combo box index #
			(val_add, ":slot", 1),
		(try_end),   	
 
		(try_begin), 
         (neq, reg6, -1),
         (overlay_set_val, "$g_presentation_obj_11", reg6),
		 (troop_get_slot, ":ship_no", "trp_temp_array_a", reg6),
		 (str_store_party_name, s13, ":ship_no"),
         (overlay_set_text, "$g_presentation_obj_name_kingdom_1", s13),	
        (try_end),	
		(try_begin),
         (neq, reg8, -1),
         (overlay_set_val, "$g_presentation_obj_12", reg8),
        (try_end),	
##TO MAKE THIS WORK, add:
# (assign, reg6, -1),
# (assign, reg8, -1),
##right before the presentation call in the menu		
 
 
		(create_button_overlay, "$g_presentation_obj_14", "@Verify."), ##Duh - renamed
        (position_set_x, pos1, 75),
        (position_set_y, pos1, 175),
        (overlay_set_position, "$g_presentation_obj_14", pos1),
 
		(create_button_overlay, "$g_presentation_obj_2", "@Manage the crew."),
        (position_set_x, pos1, 75),
        (position_set_y, pos1, 365),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
 
		(create_button_overlay, "$g_presentation_obj_15", "@View the ship registry."),
        (position_set_x, pos1, 75),
        (position_set_y, pos1, 330),
        (overlay_set_position, "$g_presentation_obj_15", pos1),		
 
 
		(create_game_button_overlay, "$g_presentation_obj_custom_battle_designer_19", "@Done", 0),
        (position_set_x, pos1, 880),
        (position_set_y, pos1, 25),
        (overlay_set_position, "$g_presentation_obj_custom_battle_designer_19", pos1),
        ]),
 
	(ti_on_presentation_event_state_change,
      [
        (store_trigger_param_1, ":object"),
        (store_trigger_param_2, ":value"),
 
        (try_begin),
			(eq, ":object", "$g_presentation_obj_11"), #Combo Box - Ship Select
			(assign, reg6, ":value"),
			(troop_get_slot, ":ship_no", "trp_temp_array_a", reg6),
			(str_store_party_name, s13, ":ship_no"),
			(party_get_num_companions, reg7, ":ship_no"),
			(str_store_string, s12, "@This is your ship '{s13}'. The crew is currently made up of {reg7} men.^^"),
            (overlay_set_text, "$g_presentation_obj_name_kingdom_1", s13),
			(start_presentation, "prsnt_manage_ships"),
        (else_try),
			(eq, ":object", "$g_presentation_obj_name_kingdom_1"), #Text Box - Ship Name
			(str_store_string, s14, s0),
		(else_try),
		    (eq, ":object", "$g_presentation_obj_13"), # Rename Ship
			(neq, reg6, -1),
			(troop_get_slot, ":ship_no", "trp_temp_array_a", reg6),
			(party_set_name, ":ship_no", s14),
			(str_store_party_name, s13, ":ship_no"),
			(party_get_num_companions, reg7, ":ship_no"),
			(str_store_string, s12, "@This is your ship '{s13}'. The crew is currently made up of {reg7} men.^^"),
			(start_presentation, "prsnt_manage_ships"),
		(else_try),
			(eq, ":object", "$g_presentation_obj_2"), #Manage crew
			(try_begin),
				(party_get_slot, ":num_ships_current", "$current_town", slot_town_has_ship),
				(ge, ":num_ships_current", 1),	
				(troop_get_slot, ":ship_no", "trp_temp_array_a", reg6),
				(party_get_slot, ":loc_no", ":ship_no", slot_ship_center),
				(eq, ":loc_no", "$current_town"),
				(assign, "$ship", ":ship_no"),
				(assign, "$crew_screen_state", 1),
				(presentation_set_duration, 0),
			(else_try),
				(display_message, "@Make sure you selected a ship"),
			(try_end),
		(else_try),
			(eq, ":object", "$g_presentation_obj_15"), #Registry
			(assign, "$crew_screen_state", 3),
			(presentation_set_duration, 0),
		(else_try),
			(eq, ":object", "$g_presentation_obj_12"), #Combo Box - Port to Send
			(assign, reg8, ":value"),
		(else_try),
			(eq, ":object", "$g_presentation_obj_14"), # Send Ship
			(neq, reg6, -1),
			(neq, reg8, -1),
			(troop_get_slot, ":town_no", "trp_temp_array_b", reg8),
			(troop_get_slot, ":ship_no", "trp_temp_array_a", reg6),
			(try_begin),
				(party_get_num_companions, reg7, ":ship_no"),
				#(ge, reg7, 30),
				#(le, reg7, 90),
				(is_between, reg7, 30, 91),
				(party_get_slot, ":num_ships_current", "$current_town", slot_town_has_ship),
				(ge, ":num_ships_current", 1),												#Making sure there is a ship to send
				(party_get_slot, ":num_ships_target", ":town_no", slot_town_has_ship),
				(lt, ":num_ships_target", 5),												#Making sure the target town has space for another ship
				(val_add, ":num_ships_target", 1),	
				(val_sub, ":num_ships_current", 1),
				(party_set_slot, "$current_town", slot_town_has_ship, ":num_ships_current"),
				(party_set_slot, ":town_no", slot_town_has_ship, ":num_ships_target"),
				(party_set_slot, ":ship_no", slot_ship_center, ":town_no"),
				(str_store_party_name, s15, ":ship_no"),
				(str_store_party_name, s16, ":town_no"),
				(start_presentation, "prsnt_manage_ships"),
				(str_clear, s12),
				(display_message, "@Your ship {s15} succesfully set sail for {s16}."),
			(else_try),
				(display_message, "@Make sure a ship is selected, it has a sufficient crew and there is room for another ship in the target town."),
			(try_end),			
		(else_try),
		    (eq, ":object", "$g_presentation_obj_custom_battle_designer_19"),
			(presentation_set_duration, 0),
		(try_end),       
 
		]),
      ]),
## Tocan   end

  ##################################################
##### troop_ratio_bar 
##################################################
  ("troop_ratio_bar",prsntf_read_only,0,[
      (ti_on_presentation_load,
       [
        (assign, "$presentation_troop_ratio_bar_active", 1),
        (set_fixed_point_multiplier, 1000),
        
        (create_mesh_overlay, "$g_presentation_obj_1", "mesh_status_troop_ratio_bar"),
        (position_set_x, pos1, 30),
        (position_set_y, pos1, 700),
        (overlay_set_position, "$g_presentation_obj_1", pos1),
        
        (position_set_x, pos1, 35),
        (position_set_y, pos1, 713),
        
        (create_mesh_overlay, "$g_presentation_obj_2", "mesh_white_plane"),
        (overlay_set_color, "$g_presentation_obj_2", 0xAA1F1F),
        (overlay_set_position, "$g_presentation_obj_2", pos1),
        
        (create_mesh_overlay, "$g_presentation_obj_3", "mesh_white_plane"),
        (overlay_set_color, "$g_presentation_obj_3", 0x1F1FAA),
        (overlay_set_position, "$g_presentation_obj_3", pos1),
     
        (create_mesh_overlay, "$g_presentation_obj_4", "mesh_white_plane"),
        (overlay_set_color, "$g_presentation_obj_4", 0x1FAA1F),
        (overlay_set_position, "$g_presentation_obj_4", pos1),
        
        (create_mesh_overlay, "$g_presentation_obj_5", "mesh_status_troop_ratio_bar_button"),
        (position_set_x, pos1, 35),
        (position_set_y, pos1, 700),
        (overlay_set_position, "$g_presentation_obj_5", pos1),
        
        (create_mesh_overlay, "$g_presentation_obj_6", "mesh_status_troop_ratio_bar_button"),
        (position_set_x, pos1, 275),
        (position_set_y, pos1, 700),
        (overlay_set_position, "$g_presentation_obj_6", pos1),

        (create_mesh_overlay, "$g_presentation_obj_7", "mesh_status_troop_ratio_bar_button"),
        (create_mesh_overlay, "$g_presentation_obj_8", "mesh_status_troop_ratio_bar_button"),
        
        (presentation_set_duration, 999999),
       ]),
      (ti_on_presentation_run,
       [
        (store_trigger_param_1, ":cur_time"),
        
        (set_fixed_point_multiplier, 1000),
        (assign, ":player_count", 0),
        (assign, ":ally_count", 0),
        (assign, ":enemy_count", 0),
        (assign, ":total_count", 0),
        
        (try_for_agents, ":cur_agent"),
          (agent_is_human, ":cur_agent"),
          (agent_is_alive, ":cur_agent"),
          (agent_get_party_id, ":agent_party", ":cur_agent"),
          (try_begin),
            (eq, ":agent_party", "p_main_party"),
            (val_add, ":player_count", 1),
          (else_try),
            (agent_is_ally, ":cur_agent"),
            (val_add, ":ally_count", 1),
          (else_try),
            (val_add, ":enemy_count", 1),
          (try_end),
        (try_end),
        (val_add, ":total_count", ":player_count"),
        (val_add, ":total_count", ":ally_count"),
        (val_add, ":total_count", ":enemy_count"),

        (position_set_x, pos1, 12000),
        (position_set_y, pos1, 300),
        (overlay_set_size, "$g_presentation_obj_2", pos1),
     
        (store_add, ":ally_percent", ":player_count", ":ally_count"),
        (val_mul, ":ally_percent", 12000),
        (val_div, ":ally_percent", ":total_count"),
        (posi